/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity.ai;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.farm_and_charm.core.block.PetBowlBlock;
import net.satisfy.farm_and_charm.core.block.entity.PetBowlBlockEntity;
import net.satisfy.farm_and_charm.core.entity.BowlAccessor;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.joml.Vector3f;

public class DogEatFromBowlGoal
extends Goal {
    private final Wolf dog;
    private BlockPos targetBowl;
    private Vector3f targetVec;
    private int eatTicks;
    private ItemStack foodStack;

    public DogEatFromBowlGoal(Wolf dog) {
        this.dog = dog;
    }

    public boolean canUse() {
        if (!this.dog.isTame() || this.dog.isOrderedToSit()) {
            return false;
        }
        Level level = this.dog.level();
        BlockPos dogPos = this.dog.blockPosition();
        double closestDist = Double.MAX_VALUE;
        BlockPos closest = null;
        ItemStack candidateFood = ItemStack.EMPTY;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)dogPos.offset(-16, -4, -16), (BlockPos)dogPos.offset(16, 4, 16))) {
            double dist;
            PetBowlBlockEntity bowl;
            BlockEntity be;
            BlockState state = level.getBlockState(pos);
            if (!state.is((Block)ObjectRegistry.PET_BOWL.get()) || !state.hasProperty(PetBowlBlock.FOOD_TYPE) || state.getValue(PetBowlBlock.FOOD_TYPE) != GeneralUtil.FoodType.DOG || !((be = level.getBlockEntity(pos)) instanceof PetBowlBlockEntity) || (bowl = (PetBowlBlockEntity)be).isEmpty() || !bowl.canBeUsedBy((Animal)this.dog) || !((dist = pos.distSqr((Vec3i)dogPos)) < closestDist)) continue;
            closestDist = dist;
            closest = pos.immutable();
            candidateFood = bowl.getItem(0).copy();
        }
        if (closest != null) {
            this.targetBowl = closest;
            this.targetVec = new Vector3f((float)closest.getX() + 0.5f, (float)closest.getY(), (float)closest.getZ() + 0.5f);
            this.foodStack = candidateFood;
            return true;
        }
        return false;
    }

    public void start() {
        this.dog.getNavigation().moveTo((double)this.targetVec.x(), (double)this.targetVec.y(), (double)this.targetVec.z(), 1.0);
        this.eatTicks = 0;
    }

    public boolean canContinueToUse() {
        PetBowlBlockEntity bowl;
        if (this.targetBowl == null) {
            return false;
        }
        Level level = this.dog.level();
        BlockState state = level.getBlockState(this.targetBowl);
        if (!(state.getBlock() instanceof PetBowlBlock) || !state.hasProperty(PetBowlBlock.FOOD_TYPE)) {
            return false;
        }
        BlockEntity be = level.getBlockEntity(this.targetBowl);
        if (!(be instanceof PetBowlBlockEntity) || (bowl = (PetBowlBlockEntity)be).isEmpty() || !bowl.canBeUsedBy((Animal)this.dog)) {
            return false;
        }
        float distSqr = this.targetVec.distanceSquared((float)this.dog.getX(), (float)this.dog.getY(), (float)this.dog.getZ());
        return distSqr > 4.0f || this.eatTicks < 60;
    }

    public void tick() {
        PetBowlBlockEntity bowl;
        if (this.targetBowl == null) {
            this.stop();
            return;
        }
        Level level = this.dog.level();
        BlockEntity be = level.getBlockEntity(this.targetBowl);
        if (!(be instanceof PetBowlBlockEntity) || (bowl = (PetBowlBlockEntity)be).isEmpty()) {
            this.stop();
            return;
        }
        float distSqr = this.targetVec.distanceSquared((float)this.dog.getX(), (float)this.dog.getY(), (float)this.dog.getZ());
        if (distSqr <= 4.0f) {
            ++this.eatTicks;
            this.dog.setOrderedToSit(true);
            this.dog.getLookControl().setLookAt((double)this.targetVec.x(), (double)this.targetVec.y(), (double)this.targetVec.z());
            if (!level.isClientSide && this.eatTicks <= 40) {
                ParticleOptions particle = this.getParticleFromFood();
                if (particle != null) {
                    ((ServerLevel)level).sendParticles(particle, (double)this.targetVec.x(), (double)(this.targetVec.y() + 0.09375f), (double)this.targetVec.z(), 3, 0.2, 0.2, 0.2, 0.05);
                }
                if (this.eatTicks % 10 == 0) {
                    level.playSound(null, this.dog.blockPosition(), SoundEvents.WOLF_GROWL, SoundSource.NEUTRAL, 0.4f, 0.4f);
                }
            }
            if (this.eatTicks == 40) {
                bowl.decreaseFood();
                ((BowlAccessor.StayNearBowl)this.dog).farmAndCharm$setStayCenter(this.targetBowl);
                if (!level.isClientSide) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.HEART, this.dog.getX(), this.dog.getY() + 0.5, this.dog.getZ(), 3, 0.3, 0.3, 0.3, 0.01);
                    level.playSound(null, this.dog.blockPosition(), SoundEvents.WOLF_HOWL, this.dog.getSoundSource(), 0.4f, 0.4f);
                    BlockState old = level.getBlockState(this.targetBowl);
                    if (old.getBlock() instanceof PetBowlBlock && old.hasProperty(PetBowlBlock.FOOD_TYPE)) {
                        level.setBlockAndUpdate(this.targetBowl, (BlockState)old.setValue(PetBowlBlock.FOOD_TYPE, (Comparable)((Object)GeneralUtil.FoodType.NONE)));
                    }
                }
            }
        }
    }

    public void stop() {
        this.targetBowl = null;
        this.targetVec = null;
        this.eatTicks = 0;
        this.foodStack = null;
        this.dog.setOrderedToSit(false);
    }

    private ParticleOptions getParticleFromFood() {
        if (this.foodStack == null || this.foodStack.isEmpty()) {
            return null;
        }
        return new ItemParticleOption(ParticleTypes.ITEM, this.foodStack);
    }
}

