/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.client.renderer.entity;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1452;
import net.minecraft.class_1472;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.util.SaturationTracker;

public class SaturationOverlayRenderer {
    public static void renderIfApplicable(class_4587 poseStack, class_4597 buffer, class_1309 entity) {
        if (!(entity instanceof SaturationTracker.SaturatedAnimal)) {
            return;
        }
        SaturationTracker.SaturatedAnimal saturated = (SaturationTracker.SaturatedAnimal)entity;
        SaturationTracker tracker = saturated.farm_and_charm$getSaturationTracker();
        SaturationOverlayRenderer.render(poseStack, buffer, entity, tracker.level(), tracker.foodCounter());
    }

    public static void render(class_4587 poseStack, class_4597 buffer, class_1309 entity, int level, int foodCounter) {
        if (entity.method_6109()) {
            return;
        }
        class_1299 type = entity.method_5864();
        if (type != class_1299.field_6085 && type != class_1299.field_6093 && type != class_1299.field_6115 && type != class_1299.field_6132) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_918 itemRenderer = mc.method_1480();
        double yOffset = (double)entity.method_17682() + 0.6;
        if (entity.method_16914()) {
            yOffset += 0.3;
        }
        poseStack.method_22903();
        poseStack.method_22904(0.0, yOffset, 0.0);
        poseStack.method_22907(mc.method_1561().method_24197());
        poseStack.method_22905(0.4f, 0.4f, 0.4f);
        class_1799 icon = SaturationOverlayRenderer.resolveIcon(entity);
        int[] thresholds = new int[]{5, 10, 15, 20};
        for (int i = 0; i < 3; ++i) {
            float alpha;
            poseStack.method_22903();
            poseStack.method_22904((double)(1 - i) * 1.1, 0.0, 0.0);
            if (level > 0) {
                if (i < level) {
                    alpha = 0.9f;
                } else if (i == level) {
                    float progress = (float)foodCounter / (float)thresholds[level];
                    alpha = class_3532.method_15363((float)(0.4f + 0.5f * progress), (float)0.4f, (float)0.9f);
                } else {
                    alpha = 0.4f;
                }
            } else {
                float progress = SaturationOverlayRenderer.getProgress(foodCounter, i, thresholds);
                alpha = 0.4f + 0.5f * progress;
            }
            int light = class_3532.method_15375((float)(240.0f * alpha));
            itemRenderer.method_23178(icon, class_811.field_4319, light, class_4608.field_21444, poseStack, buffer, entity.method_37908(), 1);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    private static float getProgress(int foodCounter, int i, int[] thresholds) {
        int start = switch (i) {
            case 1 -> thresholds[0];
            case 2 -> thresholds[0] + thresholds[1];
            default -> 0;
        };
        int end = switch (i) {
            case 0 -> thresholds[0];
            case 1 -> thresholds[0] + thresholds[1];
            case 2 -> thresholds[0] + thresholds[1] + thresholds[2];
            default -> 1;
        };
        return class_3532.method_15363((float)((float)(foodCounter - start) / (float)(end - start)), (float)0.0f, (float)1.0f);
    }

    private static class_1799 resolveIcon(class_1309 entity) {
        if (entity instanceof class_1430) {
            return new class_1799((class_1935)class_1802.field_8861);
        }
        if (entity instanceof class_1452) {
            return new class_1799((class_1935)class_1802.field_8279);
        }
        if (entity instanceof class_1472) {
            return new class_1799((class_1935)class_1802.field_8861);
        }
        if (entity instanceof class_1428) {
            return new class_1799((class_1935)class_1802.field_8317);
        }
        return new class_1799((class_1935)ObjectRegistry.HORSE_FODDER.get());
    }
}

