/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1428;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.satisfy.farm_and_charm.core.entity.ChickenCoopAccess;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;

public class ChickenCoopBlockEntity
extends class_2586 {
    private static final int MAX_CHICKENS = 3;
    private static final int MAX_EGGS = 9;
    private final List<class_2487> storedChickens = new ArrayList<class_2487>();
    private int eggCount = 0;

    public ChickenCoopBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.CHICKEN_COOP_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(class_1937 level, class_2338 pos, ChickenCoopBlockEntity coop) {
        if (level.field_9236) {
            return;
        }
        Iterator<class_2487> iterator = coop.storedChickens.iterator();
        while (iterator.hasNext()) {
            class_2487 chickenTag = iterator.next();
            int ticks = chickenTag.method_10550("CoopTime") - 1;
            if (ticks <= 0) {
                chickenTag.method_10551("CoopTime");
                class_1297 chicken = class_1299.field_6132.method_5883(level);
                if (!(chicken instanceof class_1428)) continue;
                class_1428 spawned = (class_1428)chicken;
                int coopCooldown = 1200 * (4 + level.method_8409().method_43048(2));
                spawned.method_5651(chickenTag);
                spawned.method_6033(spawned.method_6063());
                spawned.method_5648(false);
                spawned.method_5977(false);
                spawned.method_5803(false);
                if (spawned instanceof ChickenCoopAccess) {
                    ChickenCoopAccess coopChicken = (ChickenCoopAccess)spawned;
                    coopChicken.farmAndCharm$setCoopCooldown(coopCooldown);
                }
                class_2338 spawnPos = ChickenCoopBlockEntity.findSafeSpawnPosition(level, pos);
                spawned.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, spawned.method_36454(), spawned.method_36455());
                level.method_8649((class_1297)spawned);
                iterator.remove();
                coop.method_5431();
                level.method_8413(pos, coop.method_11010(), coop.method_11010(), 3);
                continue;
            }
            chickenTag.method_10569("CoopTime", ticks);
        }
    }

    private static class_2338 findSafeSpawnPosition(class_1937 level, class_2338 center) {
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            class_2338 offset = center.method_10093(dir);
            if (!level.method_8320(offset).method_26215() || !level.method_8320(offset.method_10084()).method_26215()) continue;
            return offset;
        }
        return center.method_10084();
    }

    public boolean hasSpaceForChicken() {
        return this.storedChickens.size() < 3;
    }

    public void addChicken(class_1428 chicken) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (!this.hasSpaceForChicken()) {
            return;
        }
        class_2487 tag = new class_2487();
        chicken.method_5662(tag);
        tag.method_10551("Leash");
        tag.method_10569("CoopTime", 200 + chicken.method_6051().method_43048(200));
        this.storedChickens.add(tag);
        if (chicken.method_5933() != null) {
            chicken.method_5932(true, false);
            chicken.method_5706((class_1935)class_1802.field_8719);
        }
        chicken.method_5848();
        chicken.method_5772();
        chicken.method_5977(true);
        chicken.method_5803(true);
        chicken.method_5648(true);
        chicken.method_31472();
        this.addEgg();
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    public void releaseAllChickens() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        for (class_2487 tag : new ArrayList<class_2487>(this.storedChickens)) {
            tag.method_10551("CoopTime");
            class_1297 chicken = class_1299.field_6132.method_5883(this.field_11863);
            if (!(chicken instanceof class_1428)) continue;
            class_1428 spawned = (class_1428)chicken;
            int coopCooldown = 1200 * (4 + this.field_11863.method_8409().method_43048(2));
            spawned.method_5651(tag);
            spawned.method_6033(spawned.method_6063());
            spawned.method_5648(false);
            spawned.method_5977(false);
            spawned.method_5803(false);
            if (spawned instanceof ChickenCoopAccess) {
                ChickenCoopAccess coopChicken = (ChickenCoopAccess)spawned;
                coopChicken.farmAndCharm$setCoopCooldown(coopCooldown);
            }
            class_2338 spawnPos = ChickenCoopBlockEntity.findSafeSpawnPosition(this.field_11863, this.field_11867);
            spawned.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, spawned.method_36454(), spawned.method_36455());
            this.field_11863.method_8649((class_1297)spawned);
        }
        this.storedChickens.clear();
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    public boolean containsChicken(class_1428 chicken) {
        for (class_2487 tag : this.storedChickens) {
            if (!tag.method_10573("UUID", 11) || !tag.method_25926("UUID").equals(chicken.method_5667())) continue;
            return true;
        }
        return false;
    }

    public void addEgg() {
        if (this.eggCount < 9) {
            ++this.eggCount;
            this.method_5431();
        }
    }

    public int getEggCount() {
        return this.eggCount;
    }

    public void clearEggs() {
        this.eggCount = 0;
        this.method_5431();
    }

    public List<class_2487> getStoredChickens() {
        return this.storedChickens;
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2499 chickenList = new class_2499();
        for (class_2487 chickenTag : this.storedChickens) {
            chickenList.add((Object)chickenTag.method_10553());
        }
        tag.method_10566("Chickens", (class_2520)chickenList);
        tag.method_10569("EggCount", this.eggCount);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.storedChickens.clear();
        class_2499 chickenList = tag.method_10554("Chickens", 10);
        for (int i = 0; i < chickenList.size(); ++i) {
            class_2487 chickenTag = chickenList.method_10602(i);
            this.storedChickens.add(chickenTag);
        }
        this.eggCount = tag.method_10550("EggCount");
    }
}

