/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2609;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.satisfy.farm_and_charm.client.gui.handler.StoveGuiHandler;
import net.satisfy.farm_and_charm.core.block.StoveBlock;
import net.satisfy.farm_and_charm.core.item.food.EffectBlockItem;
import net.satisfy.farm_and_charm.core.item.food.EffectFood;
import net.satisfy.farm_and_charm.core.item.food.EffectFoodBlockItem;
import net.satisfy.farm_and_charm.core.item.food.EffectFoodHelper;
import net.satisfy.farm_and_charm.core.recipe.RecipeUnlockManager;
import net.satisfy.farm_and_charm.core.recipe.StoveRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoveBlockEntity
extends class_2586
implements class_5558<StoveBlockEntity>,
ImplementedInventory,
class_3908 {
    public static final int TOTAL_COOKING_TIME = 240;
    protected static final int[] INGREDIENT_SLOTS = new int[]{1, 2, 3};
    protected int burnTime;
    protected int burnTimeTotal;
    protected int cookTime;
    protected int cookTimeTotal;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> StoveBlockEntity.this.burnTime;
                case 1 -> StoveBlockEntity.this.burnTimeTotal;
                case 2 -> StoveBlockEntity.this.cookTime;
                case 3 -> StoveBlockEntity.this.cookTimeTotal;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    StoveBlockEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    StoveBlockEntity.this.burnTimeTotal = value;
                    break;
                }
                case 2: {
                    StoveBlockEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    StoveBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };
    protected float experience;
    private class_2371<class_1799> inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private UUID ownerUuid;

    public StoveBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.STOVE_BLOCK_ENTITY.get(), pos, state);
    }

    public int[] getIngredientSlots() {
        return INGREDIENT_SLOTS;
    }

    public int getOutputSlot() {
        return 0;
    }

    public void dropExperience(class_3218 world, class_243 pos) {
        class_1303.method_31493((class_3218)world, (class_243)pos, (int)((int)this.experience));
    }

    @Override
    public int @NotNull [] method_5494(class_2350 side) {
        if (side.equals((Object)class_2350.field_11036)) {
            return INGREDIENT_SLOTS;
        }
        if (side.equals((Object)class_2350.field_11033)) {
            return new int[]{0};
        }
        return new int[]{4};
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.burnTime = nbt.method_10568("BurnTime");
        this.cookTime = nbt.method_10568("CookTime");
        this.cookTimeTotal = nbt.method_10568("CookTimeTotal");
        this.burnTimeTotal = this.getTotalBurnTime(this.method_5438(4));
        this.experience = nbt.method_10583("Experience");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10575("BurnTime", (short)this.burnTime);
        nbt.method_10575("CookTime", (short)this.cookTime);
        nbt.method_10575("CookTimeTotal", (short)this.cookTimeTotal);
        nbt.method_10548("Experience", this.experience);
        class_1262.method_5426((class_2487)nbt, this.inventory);
    }

    protected boolean isBurning() {
        return this.burnTime > 0;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, StoveBlockEntity blockEntity) {
        class_3222 owner;
        if (world.field_9236) {
            return;
        }
        boolean initialBurningState = blockEntity.isBurning();
        boolean dirty = false;
        if (initialBurningState) {
            --this.burnTime;
        }
        StoveRecipe recipe = world.method_8433().method_8132((class_3956)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get(), (class_1263)blockEntity, world).orElse(null);
        assert (this.field_11863 != null);
        class_5455 access = this.field_11863.method_30349();
        if (recipe != null && recipe.requiresLearning() && ((owner = Objects.requireNonNull(world.method_8503()).method_3760().method_14602(this.ownerUuid)) == null || RecipeUnlockManager.isRecipeLocked(owner, recipe.method_8114()))) {
            this.cookTime = 0;
            if (((Boolean)state.method_11654((class_2769)StoveBlock.LIT)).booleanValue()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)StoveBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
            return;
        }
        if (!initialBurningState && this.canCraft(recipe, access)) {
            this.burnTime = this.burnTimeTotal = this.getTotalBurnTime(this.method_5438(4));
            if (this.burnTime > 0) {
                dirty = true;
                class_1799 fuelStack = this.method_5438(4);
                if (fuelStack.method_7909().method_7857()) {
                    this.method_5447(4, new class_1799((class_1935)Objects.requireNonNull(fuelStack.method_7909().method_7858())));
                } else if (fuelStack.method_7947() > 1) {
                    this.method_5434(4, 1);
                } else if (fuelStack.method_7947() == 1) {
                    this.method_5447(4, class_1799.field_8037);
                }
            }
        }
        if ((this.isBurning() || initialBurningState) && this.canCraft(recipe, access)) {
            ++this.cookTime;
            if (this.cookTime == this.cookTimeTotal) {
                this.cookTime = 0;
                this.craft(recipe, access);
                dirty = true;
            }
        } else if (!this.canCraft(recipe, access)) {
            this.cookTime = 0;
        }
        if (initialBurningState != this.isBurning() || (Boolean)state.method_11654((class_2769)StoveBlock.LIT) != (this.burnTime > 0 || this.burnTime == 0 && this.burnTimeTotal > 0)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)StoveBlock.LIT, (Comparable)Boolean.valueOf(this.burnTime > 0 || this.burnTime == 0 && this.burnTimeTotal > 0)), 3);
            dirty = true;
        }
        if (dirty) {
            this.method_5431();
        }
    }

    protected boolean canCraft(StoveRecipe recipe, class_5455 access) {
        if (recipe == null || recipe.method_8110(access).method_7960()) {
            return false;
        }
        class_2371 temp = class_2371.method_10211();
        for (int slot : INGREDIENT_SLOTS) {
            temp.add((Object)this.method_5438(slot).method_7972());
        }
        Object object = recipe.method_8117().iterator();
        while (object.hasNext()) {
            class_1856 ingredient = (class_1856)object.next();
            boolean found = false;
            for (class_1799 stack : temp) {
                if (!ingredient.method_8093(stack) || stack.method_7960()) continue;
                stack.method_7934(1);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        class_1799 recipeOutput = recipe.method_8110(access);
        class_1799 outputSlotStack = this.method_5438(0);
        if (outputSlotStack.method_7960()) {
            return true;
        }
        if (!class_1799.method_31577((class_1799)outputSlotStack, (class_1799)recipeOutput)) {
            return false;
        }
        return outputSlotStack.method_7947() + recipeOutput.method_7947() <= outputSlotStack.method_7914();
    }

    protected void craft(StoveRecipe recipe, class_5455 access) {
        if (recipe == null || !this.canCraft(recipe, access)) {
            return;
        }
        class_1799 recipeOutput = recipe.method_8110(access).method_7972();
        class_1799 outputSlotStack = this.method_5438(0);
        for (int slot : INGREDIENT_SLOTS) {
            class_2487 ingredientTag;
            class_1799 ingredientStack = this.method_5438(slot);
            if (ingredientStack.method_7960() || !(ingredientStack.method_7909() instanceof EffectFood) && !(ingredientStack.method_7909() instanceof EffectBlockItem) || (ingredientTag = ingredientStack.method_7969()) == null || !ingredientTag.method_10545("StoredEffects")) continue;
            class_2487 resultTag = recipeOutput.method_7948();
            resultTag.method_10566("StoredEffects", ingredientTag.method_10580("StoredEffects"));
            recipeOutput.method_7980(resultTag);
        }
        if (recipeOutput.method_7909() instanceof EffectFood || recipeOutput.method_7909() instanceof EffectFoodBlockItem || recipeOutput.method_7909() instanceof EffectFoodBlockItem) {
            EffectFoodHelper.applyEffects(recipeOutput);
        }
        if (outputSlotStack.method_7960()) {
            this.method_5447(0, recipeOutput);
        } else if (class_1799.method_31577((class_1799)outputSlotStack, (class_1799)recipeOutput)) {
            outputSlotStack.method_7933(recipeOutput.method_7947());
        }
        Object object = recipe.method_8117().iterator();
        block1: while (object.hasNext()) {
            class_1856 ingredient = (class_1856)object.next();
            for (int slot : INGREDIENT_SLOTS) {
                class_1799 stackInSlot = this.method_5438(slot);
                if (!ingredient.method_8093(stackInSlot) || stackInSlot.method_7960()) continue;
                class_1799 remainderStack = this.getRemainderItem(stackInSlot);
                stackInSlot.method_7934(1);
                if (remainderStack.method_7960()) continue block1;
                if (this.method_5438(slot).method_7960()) {
                    this.method_5447(slot, remainderStack);
                    continue block1;
                }
                boolean added = false;
                for (int i : INGREDIENT_SLOTS) {
                    class_1799 is = this.method_5438(i);
                    if (is.method_7960()) {
                        this.method_5447(i, remainderStack.method_7972());
                        added = true;
                        break;
                    }
                    if (!class_1799.method_31577((class_1799)is, (class_1799)remainderStack) || is.method_7947() >= is.method_7914()) continue;
                    is.method_7933(1);
                    added = true;
                    break;
                }
                if (added) continue block1;
                assert (this.field_11863 != null);
                class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)remainderStack);
                continue block1;
            }
        }
    }

    protected int getTotalBurnTime(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        return class_2609.method_11196().getOrDefault(fuel.method_7909(), 0);
    }

    private class_1799 getRemainderItem(class_1799 stack) {
        if (stack.method_7909().method_7857()) {
            return new class_1799((class_1935)Objects.requireNonNull(stack.method_7909().method_7858()));
        }
        return class_1799.field_8037;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        class_1799 stackInSlot = (class_1799)this.inventory.get(slot);
        boolean dirty = !stack.method_7960() && class_1799.method_7984((class_1799)stack, (class_1799)stackInSlot) && class_1799.method_7973((class_1799)stack, (class_1799)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        boolean hasIngredientChange = false;
        for (int ingredientSlot : INGREDIENT_SLOTS) {
            if (class_1799.method_31577((class_1799)this.method_5438(ingredientSlot), (class_1799)stackInSlot)) continue;
            hasIngredientChange = true;
            break;
        }
        if (hasIngredientChange && !dirty) {
            this.cookTimeTotal = 240;
            this.cookTime = 0;
            this.method_5431();
        }
    }

    @Override
    public boolean method_5443(class_1657 player) {
        assert (this.field_11863 != null);
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        this.ownerUuid = player.method_5667();
        return new StoveGuiHandler(syncId, inv, (class_1263)this, this.propertyDelegate);
    }

    @Override
    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 compoundTag = new class_2487();
        this.method_11007(compoundTag);
        return compoundTag;
    }
}

