/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item.food;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.satisfy.farm_and_charm.core.item.food.EffectFood;

public class EffectFoodHelper {
    public static final String STORED_EFFECTS_KEY = "StoredEffects";
    public static final String FOOD_STAGE = "CustomModelData";

    public static void addEffect(class_1799 stack, Pair<class_1293, Float> effect) {
        EffectFoodHelper.removeHungerEffect(stack);
        EffectFoodHelper.removeRawChickenEffects(stack);
        class_2499 nbtList = EffectFoodHelper.getEffectNbt(stack);
        boolean bl = true;
        int id = class_1291.method_5554((class_1291)((class_1293)effect.getFirst()).method_5579());
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            int idTemp = nbtCompound.method_10550("id");
            if (idTemp != id) continue;
            bl = false;
            break;
        }
        if (bl) {
            nbtList.add((Object)EffectFoodHelper.createNbt((short)id, effect));
        }
        stack.method_7948().method_10566(STORED_EFFECTS_KEY, (class_2520)nbtList);
    }

    private static class_2499 getEffectNbt(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        return nbtCompound != null ? nbtCompound.method_10554(STORED_EFFECTS_KEY, 10) : new class_2499();
    }

    public static class_2487 createNbt(short id, Pair<class_1293, Float> effect) {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10575("id", id);
        nbtCompound.method_10569("duration", ((class_1293)effect.getFirst()).method_5584());
        nbtCompound.method_10569("amplifier", ((class_1293)effect.getFirst()).method_5578());
        nbtCompound.method_10548("chance", ((Float)effect.getSecond()).floatValue());
        return nbtCompound;
    }

    public static List<Pair<class_1293, Float>> getEffects(class_1799 stack) {
        EffectFoodHelper.removeHungerEffect(stack);
        EffectFoodHelper.removeRawChickenEffects(stack);
        List<Object> effects = Lists.newArrayList();
        if (stack.method_7909() instanceof EffectFood) {
            effects = EffectFoodHelper.fromNbt(EffectFoodHelper.getEffectNbt(stack));
        } else if (stack.method_7909() instanceof class_1812) {
            List potionEffects = class_1844.method_8067((class_1799)stack);
            for (class_1293 effect : potionEffects) {
                effects.add(new Pair((Object)effect, (Object)Float.valueOf(1.0f)));
            }
        } else {
            class_4174 foodComponent = stack.method_7909().method_19264();
            if (foodComponent != null) {
                effects = foodComponent.method_19235();
            }
        }
        return effects;
    }

    private static void removeHungerEffect(class_1799 stack) {
        class_2499 nbtList = EffectFoodHelper.getEffectNbt(stack);
        class_2499 updatedList = new class_2499();
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            class_1291 effect = class_1291.method_5569((int)nbtCompound.method_10568("id"));
            if (effect == class_1294.field_5903) continue;
            updatedList.add((Object)nbtCompound);
        }
        stack.method_7948().method_10566(STORED_EFFECTS_KEY, (class_2520)updatedList);
    }

    private static void removeRawChickenEffects(class_1799 stack) {
        if (stack.method_7909() == class_1802.field_8726) {
            class_2499 nbtList = EffectFoodHelper.getEffectNbt(stack);
            class_2499 updatedList = new class_2499();
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound = nbtList.method_10602(i);
                class_1291 effect = class_1291.method_5569((int)nbtCompound.method_10568("id"));
                if (effect == class_1294.field_5903) continue;
                updatedList.add((Object)nbtCompound);
            }
            stack.method_7948().method_10566(STORED_EFFECTS_KEY, (class_2520)updatedList);
        }
    }

    public static void applyEffects(class_1799 stack) {
        class_4174 foodProperties;
        class_2487 tag = stack.method_7948();
        if (!tag.method_10545(STORED_EFFECTS_KEY) && (foodProperties = stack.method_7909().method_19264()) != null) {
            class_2499 nbtList = new class_2499();
            for (Pair effect : foodProperties.method_19235()) {
                int id = class_1291.method_5554((class_1291)((class_1293)effect.getFirst()).method_5579());
                class_2487 effectTag = new class_2487();
                effectTag.method_10575("id", (short)id);
                effectTag.method_10569("duration", ((class_1293)effect.getFirst()).method_5584());
                effectTag.method_10569("amplifier", ((class_1293)effect.getFirst()).method_5578());
                effectTag.method_10548("chance", ((Float)effect.getSecond()).floatValue());
                nbtList.add((Object)effectTag);
            }
            tag.method_10566(STORED_EFFECTS_KEY, (class_2520)nbtList);
        }
    }

    public static List<Pair<class_1293, Float>> fromNbt(class_2499 list) {
        ArrayList effects = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 nbtCompound = list.method_10602(i);
            class_1291 effect = class_1291.method_5569((int)nbtCompound.method_10568("id"));
            if (effect == null) continue;
            effects.add(new Pair((Object)new class_1293(effect, nbtCompound.method_10550("duration"), nbtCompound.method_10550("amplifier")), (Object)Float.valueOf(nbtCompound.method_10583("chance"))));
        }
        return effects;
    }

    public static class_1799 setStage(class_1799 stack, int stage) {
        class_2487 nbtCompound = stack.method_7969() != null ? stack.method_7969() : new class_2487();
        nbtCompound.method_10569(FOOD_STAGE, stage);
        stack.method_7980(nbtCompound);
        return stack;
    }

    public static int getStage(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        return nbtCompound != null ? nbtCompound.method_10550(FOOD_STAGE) : 0;
    }

    public static void getTooltip(class_1799 stack, List<class_2561> tooltip) {
        List<Pair<class_1293, Float>> effects = EffectFoodHelper.getEffects(stack);
        if (effects.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080));
        } else {
            for (Pair<class_1293, Float> effectPair : effects) {
                class_1293 statusEffect = (class_1293)effectPair.getFirst();
                class_5250 mutableText = class_2561.method_43471((String)statusEffect.method_5586());
                if (statusEffect.method_5578() > 0) {
                    mutableText = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, class_2561.method_43471((String)("potion.potency." + statusEffect.method_5578()))});
                }
                if (((class_1293)effectPair.getFirst()).method_5584() > 20) {
                    mutableText = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{mutableText, class_1292.method_5577((class_1293)statusEffect, (float)1.0f)});
                }
                tooltip.add((class_2561)mutableText.method_27692(statusEffect.method_5579().method_18792().method_18793()));
            }
        }
    }
}

