/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class CookingPotRecipe
implements class_1860<class_1263> {
    final class_2960 id;
    private final class_2371<class_1856> inputs;
    private final boolean containerRequired;
    private final class_1799 containerItem;
    private final class_1799 output;
    private final boolean requiresLearning;

    public CookingPotRecipe(class_2960 id, class_2371<class_1856> inputs, boolean containerRequired, class_1799 containerItem, class_1799 output, boolean requiresLearning) {
        this.id = id;
        this.inputs = inputs;
        this.containerRequired = containerRequired;
        this.containerItem = containerItem;
        this.output = output;
        this.requiresLearning = requiresLearning;
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        return GeneralUtil.matchesRecipe(inventory, this.inputs, 0, 5);
    }

    @NotNull
    public class_1799 method_8116(class_1263 container, class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryAccess) {
        return this.output.method_7972();
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)RecipeTypeRegistry.COOKING_POT_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return (class_3956)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get();
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.inputs;
    }

    public boolean isContainerRequired() {
        return this.containerRequired;
    }

    public class_1799 getContainerItem() {
        return this.containerItem;
    }

    public boolean requiresLearning() {
        return this.requiresLearning;
    }

    public boolean method_8118() {
        return true;
    }

    public static class Serializer
    implements class_1865<CookingPotRecipe> {
        @NotNull
        public CookingPotRecipe fromJson(class_2960 id, JsonObject json) {
            class_2371<class_1856> ingredients = GeneralUtil.deserializeIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for CookingPot Recipe");
            }
            if (ingredients.size() > 6) {
                throw new JsonParseException("Too many ingredients for CookingPot Recipe");
            }
            JsonObject containerObj = class_3518.method_15296((JsonObject)json, (String)"container");
            boolean required = class_3518.method_15258((JsonObject)containerObj, (String)"required", (boolean)false);
            class_1799 containerStack = class_1799.field_8037;
            if (required) {
                containerStack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)containerObj, (String)"item"));
            }
            class_1799 result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            boolean requiresLearning = class_3518.method_15258((JsonObject)json, (String)"requiresLearning", (boolean)false);
            return new CookingPotRecipe(id, ingredients, required, containerStack, result, requiresLearning);
        }

        @NotNull
        public CookingPotRecipe fromNetwork(class_2960 id, class_2540 buf) {
            class_2371 ingredients = class_2371.method_10213((int)buf.method_10816(), (Object)class_1856.field_9017);
            ingredients.replaceAll(ignored -> class_1856.method_8086((class_2540)buf));
            boolean required = buf.readBoolean();
            class_1799 containerStack = required ? buf.method_10819() : class_1799.field_8037;
            class_1799 output = buf.method_10819();
            boolean requiresLearning = buf.readBoolean();
            return new CookingPotRecipe(id, (class_2371<class_1856>)ingredients, required, containerStack, output, requiresLearning);
        }

        public void toNetwork(class_2540 buf, CookingPotRecipe recipe) {
            buf.method_10804(recipe.inputs.size());
            recipe.inputs.forEach(entry -> entry.method_8088(buf));
            buf.writeBoolean(recipe.containerRequired);
            if (recipe.containerRequired) {
                buf.method_10793(recipe.containerItem);
            }
            buf.method_10793(recipe.output);
            buf.writeBoolean(recipe.requiresLearning);
        }
    }
}

