/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class StoveRecipe
implements class_1860<class_1263> {
    private final class_2960 id;
    private final class_2371<class_1856> inputs;
    private final class_1799 output;
    private final float experience;
    private final boolean requiresLearning;

    public StoveRecipe(class_2960 id, class_2371<class_1856> inputs, class_1799 output, float experience, boolean requiresLearning) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.experience = experience;
        this.requiresLearning = requiresLearning;
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        return GeneralUtil.matchesRecipe(inventory, this.inputs, 1, 3);
    }

    @NotNull
    public class_1799 method_8116(class_1263 container, class_5455 registryAccess) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryAccess) {
        return this.output.method_7972();
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)RecipeTypeRegistry.STOVE_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return (class_3956)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get();
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.inputs;
    }

    public float getExperience() {
        return this.experience;
    }

    public boolean requiresLearning() {
        return this.requiresLearning;
    }

    public boolean method_8118() {
        return true;
    }

    public static class Serializer
    implements class_1865<StoveRecipe> {
        @NotNull
        public StoveRecipe fromJson(class_2960 id, JsonObject json) {
            class_2371<class_1856> ingredients = GeneralUtil.deserializeIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for Stove Recipe");
            }
            if (ingredients.size() > 3) {
                throw new JsonParseException("Too many ingredients for Stove Recipe");
            }
            boolean requiresLearning = class_3518.method_15258((JsonObject)json, (String)"requiresLearning", (boolean)false);
            return new StoveRecipe(id, ingredients, class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result")), class_3518.method_15277((JsonObject)json, (String)"experience", (float)0.0f), requiresLearning);
        }

        @NotNull
        public StoveRecipe fromNetwork(class_2960 id, class_2540 buf) {
            class_2371 ingredients = class_2371.method_10213((int)buf.method_10816(), (Object)class_1856.field_9017);
            ingredients.replaceAll(ignored -> class_1856.method_8086((class_2540)buf));
            class_1799 output = buf.method_10819();
            float xp = buf.readFloat();
            boolean requiresLearning = buf.readBoolean();
            return new StoveRecipe(id, (class_2371<class_1856>)ingredients, output, xp, requiresLearning);
        }

        public void toNetwork(class_2540 buf, StoveRecipe recipe) {
            buf.method_10804(recipe.inputs.size());
            recipe.inputs.forEach(entry -> entry.method_8088(buf));
            buf.method_10793(recipe.output);
            buf.writeFloat(recipe.experience);
            buf.writeBoolean(recipe.requiresLearning);
        }
    }
}

