/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.util;

import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.satisfy.farm_and_charm.core.entity.AbstractTowableEntity;

public final class CartWheel {
    private float rotation;
    private float rotationIncrement;
    private final float offsetX;
    private final float offsetZ;
    private final float circumference;
    private double posX;
    private double posZ;
    private double prevPosX;
    private double prevPosZ;
    private final AbstractTowableEntity cart;

    public CartWheel(AbstractTowableEntity cartIn, float offsetXIn, float offsetZIn, float circumferenceIn) {
        this.cart = cartIn;
        this.offsetX = offsetXIn;
        this.offsetZ = offsetZIn;
        this.circumference = circumferenceIn;
        this.posX = this.prevPosX = cartIn.method_23317();
        this.posZ = this.prevPosZ = cartIn.method_23321();
    }

    public CartWheel(AbstractTowableEntity cartIn, float offsetX) {
        this(cartIn, offsetX, 0.0f, 3.9269907f);
    }

    public void tick() {
        this.rotation += this.rotationIncrement;
        this.prevPosX = this.posX;
        this.prevPosZ = this.posZ;
        float yaw = (float)Math.toRadians(this.cart.method_36454());
        float nx = -class_3532.method_15374((float)yaw);
        float nz = class_3532.method_15362((float)yaw);
        this.posX = this.cart.method_23317() + (double)(nx * this.offsetZ) - (double)(nz * this.offsetX);
        this.posZ = this.cart.method_23321() + (double)(nz * this.offsetZ) + (double)(nx * this.offsetX);
        double dx = this.posX - this.prevPosX;
        double dz = this.posZ - this.prevPosZ;
        float distanceTravelled = (float)Math.sqrt(dx * dx + dz * dz);
        double dxNormalized = dx / (double)distanceTravelled;
        double dzNormalized = dz / (double)distanceTravelled;
        float travelledForward = class_3532.method_17822((double)(dxNormalized * (double)nx + dzNormalized * (double)nz));
        if ((double)distanceTravelled > 0.2) {
            class_2338 blockpos = new class_2338(class_3532.method_15357((double)this.posX), class_3532.method_15357((double)(this.cart.method_23318() - (double)0.2f)), class_3532.method_15357((double)this.posZ));
            class_2680 blockstate = this.cart.method_37908().method_8320(blockpos);
            if (blockstate.method_26217() != class_2464.field_11455) {
                int particleCount = 15;
                float zFactor = 0.5f;
                for (int i = 0; i < particleCount; ++i) {
                    double adjustedPosZ = class_3532.method_16436((double)zFactor, (double)this.cart.method_23321(), (double)this.posZ) + (Math.random() - 0.5) * 0.1;
                    double offsetX = this.posX + (Math.random() - 0.5) * 0.1;
                    this.cart.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockstate), offsetX, this.cart.method_23318() + (Math.random() - 0.5) * 0.1, adjustedPosZ, dx, (double)distanceTravelled, dz);
                }
            }
        }
        this.rotationIncrement = travelledForward * distanceTravelled * this.circumference * 0.2f;
    }

    public float getRotation() {
        return this.rotation;
    }
}

