/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_8567;

public class SaturationTracker {
    private static final int[] FEEDING_THRESHOLDS = new int[]{5, 10, 15, 20};
    private static final Map<class_2960, class_52> LOOT_CACHE = new ConcurrentHashMap<class_2960, class_52>();
    private int level = 0;
    private int foodCounter = 0;
    private long lastFedTick = -1L;
    private int decayDelay = -1;
    private int nextDecayTick = -1;
    private int nextTickCheck = 0;

    public void tryFeed(class_1429 animal, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!animal.method_6481(stack) || animal.method_6109()) {
            return;
        }
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        ++this.foodCounter;
        this.lastFedTick = animal.field_6012;
        this.decayDelay = 2400 + animal.method_6051().method_43048(2400);
        this.nextDecayTick = animal.field_6012 + this.decayDelay;
        if (this.level < 4 && this.foodCounter >= FEEDING_THRESHOLDS[this.level]) {
            ++this.level;
            this.foodCounter = 0;
        }
    }

    public void tick(class_1429 animal) {
        int now = animal.field_6012;
        if (now < this.nextTickCheck) {
            return;
        }
        this.nextTickCheck = now + 20;
        if (this.nextDecayTick == -1) {
            return;
        }
        if (now >= this.nextDecayTick) {
            if (this.foodCounter > 0) {
                --this.foodCounter;
            } else if (this.level > 0) {
                --this.level;
                this.foodCounter = FEEDING_THRESHOLDS[Math.max(0, this.level - 1)] - 1;
            }
            this.lastFedTick = now;
            this.decayDelay = 2400 + animal.method_6051().method_43048(2400);
            this.nextDecayTick = now + this.decayDelay;
        }
    }

    public void dropExtraLoot(class_1429 animal, class_1282 source) {
        int bonusRolls;
        class_1937 class_19372 = animal.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        int n = this.level == 1 ? 1 : (this.level == 2 ? 1 + animal.method_6051().method_43048(2) : (this.level == 3 ? 2 + animal.method_6051().method_43048(2) : (bonusRolls = this.level == 4 ? 3 : 0)));
        if (bonusRolls == 0) {
            return;
        }
        class_8567 params = new class_8567.class_8568(serverLevel).method_51874(class_181.field_1226, (Object)animal).method_51874(class_181.field_24424, (Object)animal.method_19538()).method_51874(class_181.field_1231, (Object)source).method_51875(class_173.field_1173);
        class_52 table = LOOT_CACHE.computeIfAbsent(animal.method_5989(), id -> serverLevel.method_8503().method_3857().getLootTable(id));
        Consumer<class_1799> spawn = stack -> serverLevel.method_8649((class_1297)new class_1542((class_1937)serverLevel, animal.method_23317(), animal.method_23318(), animal.method_23321(), stack));
        for (int i = 0; i < bonusRolls; ++i) {
            table.method_51882(params, spawn);
        }
    }

    public int level() {
        return this.level;
    }

    public int foodCounter() {
        return this.foodCounter;
    }

    public void feedDirectly(class_1429 animal, int currentTick, int amount) {
        this.foodCounter += amount;
        this.lastFedTick = currentTick;
        this.decayDelay = 2400 + animal.method_6051().method_43048(2400);
        this.nextDecayTick = currentTick + this.decayDelay;
        while (this.level < 4 && this.foodCounter >= FEEDING_THRESHOLDS[this.level]) {
            this.foodCounter -= FEEDING_THRESHOLDS[this.level];
            ++this.level;
        }
    }

    public int getDecayDelay() {
        return this.decayDelay;
    }

    public void setDecayDelay(int delay) {
        this.decayDelay = delay;
        this.nextDecayTick = (int)this.lastFedTick + delay;
    }

    public long getLastFedTick() {
        return this.lastFedTick;
    }

    public void setLastFedTick(long tick) {
        this.lastFedTick = tick;
        if (this.decayDelay > 0) {
            this.nextDecayTick = (int)tick + this.decayDelay;
        }
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setFoodCounter(int count) {
        this.foodCounter = count;
    }

    public void clientSync(int syncedLevel, int syncedFoodCounter) {
        this.level = syncedLevel;
        this.foodCounter = syncedFoodCounter;
    }

    public static interface SaturatedAnimal {
        public SaturationTracker farm_and_charm$getSaturationTracker();

        public void farm_and_charm$setSaturationTracker(SaturationTracker var1);
    }
}

