/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class FertilizedSoilBlock
extends Block {
    public static final IntegerProperty SIZE = IntegerProperty.create((String)"size", (int)0, (int)3);

    public FertilizedSoilBlock(BlockBehaviour.Properties properties) {
        super(properties.randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SIZE, (Comparable)Integer.valueOf(3)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)SIZE)) {
            case 0 -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
            case 1 -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
            case 2 -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
            default -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SIZE});
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        boolean hasSugarCaneAbove = level.getBlockState(pos.above()).is(Blocks.SUGAR_CANE);
        if (itemStack.getItem() == ObjectRegistry.PITCHFORK.get()) {
            if (hasSugarCaneAbove) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            int newSize = (Integer)state.getValue((Property)SIZE) - 1;
            if (newSize < 0) {
                level.removeBlock(pos, false);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)SIZE, (Comparable)Integer.valueOf(newSize)), 3);
                this.applyBoneMealEffect(level, pos);
            }
            this.spawnParticles(level, pos, state, false);
            level.playSound(null, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            itemStack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(itemStack));
            return ItemInteractionResult.SUCCESS;
        }
        if (itemStack.getItem() instanceof HoeItem) {
            if (hasSugarCaneAbove) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            int currentSize = (Integer)state.getValue((Property)SIZE);
            if (currentSize == 3) {
                level.setBlock(pos, ((Block)ObjectRegistry.FERTILIZED_FARM_BLOCK.get()).defaultBlockState(), 3);
                if (!player.isCreative()) {
                    itemStack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(itemStack));
                }
                level.playSound(null, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void spawnParticles(Level level, BlockPos pos, BlockState state, boolean happy) {
        if (!level.isClientSide) {
            ServerLevel server = (ServerLevel)level;
            server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 20, 0.5, 0.5, 0.5, 0.2);
            if (happy) {
                server.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5, 4, 0.25, 0.1, 0.25, 0.01);
            }
        }
    }

    private void applyBoneMealEffect(Level level, BlockPos centerPos) {
        if (!level.isClientSide) {
            ServerLevel serverLevel = (ServerLevel)level;
            int range = PlatformHelper.getFertilizedSoilRange();
            BlockPos.betweenClosedStream((BlockPos)centerPos.offset(-range, -1, -range), (BlockPos)centerPos.offset(range, 1, range)).forEach(pos -> {
                BonemealableBlock bonemealableBlock;
                BlockState blockState;
                Block block;
                if (serverLevel.random.nextInt(100) < 20 && (block = (blockState = serverLevel.getBlockState(pos)).getBlock()) instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)serverLevel, pos, blockState)) {
                    bonemealableBlock.performBonemeal(serverLevel, serverLevel.random, pos, blockState);
                }
            });
        }
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if ((Integer)state.getValue((Property)SIZE) != 3) {
            return;
        }
        if (random.nextInt(4) != 0) {
            return;
        }
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = 0; dy <= 1; ++dy) {
                    BlockPos above;
                    if (dx == 0 && dz == 0 && dy == 0) continue;
                    checkPos.set(pos.getX() + dx, pos.getY() + dy, pos.getZ() + dz);
                    BlockState targetState = level.getBlockState((BlockPos)checkPos);
                    if (!targetState.is(Blocks.SUGAR_CANE) || !level.isEmptyBlock(above = checkPos.above())) continue;
                    int height = 1;
                    while (level.getBlockState(checkPos.below(height)).is(Blocks.SUGAR_CANE)) {
                        ++height;
                    }
                    if (height >= 3) continue;
                    level.setBlock(above, Blocks.SUGAR_CANE.defaultBlockState(), 2);
                    this.spawnParticles((Level)level, above, Blocks.SUGAR_CANE.defaultBlockState(), true);
                }
            }
        }
    }
}

