/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class PackedDirtBlock
extends Block {
    public static final IntegerProperty WEAR = IntegerProperty.create((String)"wear", (int)0, (int)7);
    public static final BooleanProperty SEALED = BooleanProperty.create((String)"sealed");
    private Supplier<Block> trampled;

    public PackedDirtBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WEAR, (Comparable)Integer.valueOf(0))).setValue((Property)SEALED, (Comparable)Boolean.valueOf(false)));
    }

    public void setTrampled(Supplier<Block> target) {
        this.trampled = target;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{WEAR, SEALED});
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        RandomSource r;
        long t;
        if (!level.isClientSide && entity instanceof LivingEntity && this.trampled != null && !((Boolean)state.getValue((Property)SEALED)).booleanValue() && ((t = level.getGameTime()) + pos.asLong() & 7L) == 0L && (r = level.getRandom()).nextFloat() < 0.2f) {
            int w = (Integer)state.getValue((Property)WEAR);
            if (w >= 6) {
                level.playSound(null, pos, SoundEvents.MUD_STEP, SoundSource.BLOCKS, 0.6f, 1.0f);
                level.setBlock(pos, this.trampled.get().defaultBlockState(), 3);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)WEAR, (Comparable)Integer.valueOf(w + 1)), 2);
            }
        }
        super.stepOn(level, pos, state, entity);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!level.isClientSide && entity instanceof LivingEntity && this.trampled != null && !((Boolean)state.getValue((Property)SEALED)).booleanValue() && fallDistance > 0.9f) {
            int inc;
            int w = (Integer)state.getValue((Property)WEAR);
            int nw = Math.min(7, w + (inc = Math.min(2, 1 + (int)(fallDistance / 3.0f))));
            if (nw == 7) {
                level.playSound(null, pos, SoundEvents.MUD_STEP, SoundSource.BLOCKS, 0.8f, 0.9f);
                level.setBlock(pos, this.trampled.get().defaultBlockState(), 3);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)WEAR, (Comparable)Integer.valueOf(nw)), 2);
            }
        }
        super.fallOn(level, state, pos, entity, fallDistance);
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.getItem() instanceof ShovelItem || stack.getItem() instanceof HoeItem) {
            boolean sealed = (Boolean)state.getValue((Property)SEALED);
            if (!level.isClientSide) {
                level.playSound(null, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlock(pos, (BlockState)state.setValue((Property)SEALED, (Comparable)Boolean.valueOf(!sealed)), 3);
            } else {
                RandomSource r = level.getRandom();
                for (int i = 0; i < 12; ++i) {
                    double x = (double)pos.getX() + 0.5 + (r.nextDouble() - 0.5) * 0.4;
                    double y = (double)pos.getY() + 1.02;
                    double z = (double)pos.getZ() + 0.5 + (r.nextDouble() - 0.5) * 0.4;
                    double vx = (r.nextDouble() - 0.5) * 0.06;
                    double vy = 0.15 + r.nextDouble() * 0.2;
                    double vz = (r.nextDouble() - 0.5) * 0.06;
                    level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), x, y, z, vx, vy, vz);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

