/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TrampledPackedDirtBlock
extends Block {
    public static final MapCodec<TrampledPackedDirtBlock> CODEC = TrampledPackedDirtBlock.simpleCodec(TrampledPackedDirtBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private Supplier<Block> base;

    public TrampledPackedDirtBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setBase(Supplier<Block> supplier) {
        this.base = supplier;
    }

    @NotNull
    public MapCodec<? extends Block> codec() {
        return CODEC;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.base != null && !this.defaultBlockState().canSurvive((LevelReader)ctx.getLevel(), ctx.getClickedPos()) ? Block.pushEntitiesUp((BlockState)this.defaultBlockState(), (BlockState)this.base.get().defaultBlockState(), (LevelAccessor)ctx.getLevel(), (BlockPos)ctx.getClickedPos()) : super.getStateForPlacement(ctx);
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction dir, BlockState other, LevelAccessor level, BlockPos pos, BlockPos fromPos) {
        if (dir == Direction.UP && !state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, dir, other, level, pos, fromPos);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.base != null) {
            level.setBlockAndUpdate(pos, this.base.get().defaultBlockState());
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState above = level.getBlockState(pos.above());
        return !above.isSolid() || above.getBlock() instanceof FenceGateBlock;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.getItem() instanceof ShovelItem || stack.getItem() instanceof HoeItem) {
            if (!level.isClientSide) {
                level.playSound(null, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlock(pos, this.base.get().defaultBlockState(), 3);
            } else {
                RandomSource r = level.getRandom();
                for (int i = 0; i < 12; ++i) {
                    double x = (double)pos.getX() + 0.5 + (r.nextDouble() - 0.5) * 0.4;
                    double y = (double)pos.getY() + 1.02;
                    double z = (double)pos.getZ() + 0.5 + (r.nextDouble() - 0.5) * 0.4;
                    double vx = (r.nextDouble() - 0.5) * 0.08;
                    double vy = 0.25 + r.nextDouble() * 0.25;
                    double vz = (r.nextDouble() - 0.5) * 0.08;
                    level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), x, y, z, vx, vy, vz);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

