/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity.ai;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.core.block.FeedingTroughBlock;
import net.satisfy.farm_and_charm.core.block.entity.FeedingTroughBlockEntity;
import net.satisfy.farm_and_charm.platform.PlatformHelper;

public class ApproachFeedingTroughGoal
extends MoveToBlockGoal {
    protected final Animal animal;

    public ApproachFeedingTroughGoal(Animal animal, double speed) {
        super((PathfinderMob)animal, speed, PlatformHelper.getFeedingTroughRange());
        this.animal = animal;
    }

    public void tick() {
        BlockState blockState;
        Level world = this.animal.getCommandSenderWorld();
        if (!world.isClientSide() && this.animal.canFallInLove() && (blockState = world.getBlockState(this.blockPos)).getBlock() instanceof FeedingTroughBlock && (Integer)blockState.getValue((Property)FeedingTroughBlock.SIZE) > 0) {
            this.animal.getLookControl().setLookAt((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY(), (double)this.blockPos.getZ() + 0.5, 10.0f, (float)this.animal.getMaxHeadXRot());
            if (this.isReachedTarget()) {
                world.setBlock(this.blockPos, (BlockState)blockState.setValue((Property)FeedingTroughBlock.SIZE, (Comparable)Integer.valueOf((Integer)blockState.getValue((Property)FeedingTroughBlock.SIZE) - 1)), 3);
                this.animal.setInLove(null);
                BlockEntity be = world.getBlockEntity(this.blockPos);
                if (be instanceof FeedingTroughBlockEntity) {
                    FeedingTroughBlockEntity trough = (FeedingTroughBlockEntity)be;
                    trough.onAnimalFed(this.animal);
                }
            }
        }
        super.tick();
    }

    public boolean canUse() {
        return this.animal.canFallInLove() && this.animal.getAge() == 0 && super.canUse();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.animal.canFallInLove() && this.animal.getAge() == 0;
    }

    public double acceptedDistance() {
        return 2.25;
    }

    protected boolean isValidTarget(LevelReader levelReader, BlockPos blockPos) {
        BlockState blockState = levelReader.getBlockState(blockPos);
        return blockState.getBlock() instanceof FeedingTroughBlock && (Integer)blockState.getValue((Property)FeedingTroughBlock.SIZE) > 0;
    }
}

