/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.ChickenCoopBlockEntity;
import net.satisfy.farm_and_charm.core.entity.ChickenCoopAccess;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;

public class ChickenLocateCoopGoal
extends Goal {
    private final Chicken chicken;
    private BlockPos foundCoop;
    private final List<BlockPos> cachedCoops = new ArrayList<BlockPos>();
    private int searchCooldown = 0;

    public ChickenLocateCoopGoal(Chicken chicken) {
        this.chicken = chicken;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.chicken.isBaby()) {
            return false;
        }
        ChickenCoopAccess access = (ChickenCoopAccess)this.chicken;
        if (access.farmAndCharm$hasCoopTarget()) {
            return false;
        }
        if (access.farmAndCharm$searchedForCoop()) {
            return false;
        }
        if (access.farmAndCharm$getCoopCooldown() > 0) {
            return false;
        }
        if (this.searchCooldown > 0) {
            --this.searchCooldown;
            return false;
        }
        this.searchCooldown = 20 + this.chicken.getRandom().nextInt(20);
        ServerLevel level = (ServerLevel)this.chicken.level();
        Iterator<BlockPos> it = this.cachedCoops.iterator();
        while (it.hasNext()) {
            ChickenCoopBlockEntity coop;
            BlockPos cached = it.next();
            if (!level.getBlockState(cached).is((Block)ObjectRegistry.CHICKEN_COOP.get())) {
                it.remove();
                continue;
            }
            BlockEntity be = level.getBlockEntity(cached);
            if (!(be instanceof ChickenCoopBlockEntity) || !(coop = (ChickenCoopBlockEntity)be).hasSpaceForChicken()) {
                it.remove();
                continue;
            }
            if (this.chicken.getNavigation().createPath(cached, 0) == null) continue;
            this.foundCoop = cached;
            return true;
        }
        BlockPos pos = this.chicken.blockPosition();
        this.foundCoop = BlockPos.findClosestMatch((BlockPos)pos, (int)16, (int)4, check -> {
            ChickenCoopBlockEntity coop;
            if (!level.getBlockState(check).is((Block)ObjectRegistry.CHICKEN_COOP.get())) {
                return false;
            }
            BlockEntity be = level.getBlockEntity(check);
            if (!(be instanceof ChickenCoopBlockEntity) || !(coop = (ChickenCoopBlockEntity)be).hasSpaceForChicken()) {
                return false;
            }
            if (this.chicken.getNavigation().createPath(check, 0) == null) {
                return false;
            }
            if (!this.cachedCoops.contains(check)) {
                this.cachedCoops.add((BlockPos)check);
            }
            return true;
        }).orElse(null);
        return this.foundCoop != null;
    }

    public void start() {
        ((ChickenCoopAccess)this.chicken).farmAndCharm$setCoopTarget(this.foundCoop);
        ((ChickenCoopAccess)this.chicken).farmAndCharm$setSearchedForCoop(true);
        if (!this.chicken.getNavigation().isInProgress()) {
            this.chicken.getNavigation().moveTo((double)this.foundCoop.getX() + 0.5, (double)this.foundCoop.getY() + 0.5, (double)this.foundCoop.getZ() + 0.5, 1.0);
        }
    }
}

