/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.farm_and_charm.core.block.entity.RopeKnotBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class RopeItem
extends BlockItem {
    public RopeItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos;
        Level level = ctx.getLevel();
        BlockState clicked = level.getBlockState(pos = ctx.getClickedPos());
        if (clicked.getBlock() instanceof FenceBlock) {
            BlockState knot;
            if (!level.isClientSide && level.setBlock(pos, knot = ((Block)ObjectRegistry.ROPE_KNOT.get()).defaultBlockState(), 3)) {
                level.playSound(ctx.getPlayer(), pos, SoundEvents.LEASH_KNOT_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof RopeKnotBlockEntity) {
                    RopeKnotBlockEntity be = (RopeKnotBlockEntity)blockEntity;
                    be.setHeldBlock(clicked);
                    be.setChanged();
                }
                if (!Objects.requireNonNull(ctx.getPlayer()).getAbilities().instabuild) {
                    ctx.getItemInHand().shrink(1);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(ctx);
    }
}

