/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class TeaJugItem
extends BlockItem {
    public TeaJugItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        ArrayList list2 = itemStack.has(DataComponents.FOOD) ? ((FoodProperties)itemStack.get(DataComponents.FOOD)).effects() : Lists.newArrayList();
        ArrayList list3 = Lists.newArrayList();
        if (list2.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
        } else {
            for (FoodProperties.PossibleEffect statusEffectInstance : list2) {
                MutableComponent mutableText = Component.translatable((String)statusEffectInstance.effect().getDescriptionId());
                MobEffect statusEffect = (MobEffect)statusEffectInstance.effect().getEffect().value();
                statusEffect.createModifiers(statusEffectInstance.effect().getAmplifier(), (holderx, attributeModifierx) -> {
                    AttributeModifier entityAttributeModifier = new AttributeModifier(attributeModifierx.id(), attributeModifierx.amount() * (double)(statusEffectInstance.effect().getAmplifier() + 1), attributeModifierx.operation());
                    list3.add(new Pair(holderx, (Object)entityAttributeModifier));
                });
                if (statusEffectInstance.effect().getDuration() > 20) {
                    mutableText = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableText, MobEffectUtil.formatDuration((MobEffectInstance)statusEffectInstance.effect(), (float)statusEffectInstance.probability(), (float)tooltipContext.tickRate())});
                }
                tooltip.add((Component)mutableText.withStyle(statusEffect.getCategory().getTooltipFormatting()));
            }
        }
        if (!list3.isEmpty()) {
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list3) {
                AttributeModifier entityAttributeModifier3 = (AttributeModifier)pair.getSecond();
                double d = entityAttributeModifier3.amount();
                double e = entityAttributeModifier3.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && entityAttributeModifier3.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? entityAttributeModifier3.amount() : entityAttributeModifier3.amount() * 100.0;
                if (d > 0.0) {
                    tooltip.add((Component)Component.translatable((String)("attribute.modifier.plus." + entityAttributeModifier3.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(e), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d < 0.0)) continue;
                tooltip.add((Component)Component.translatable((String)("attribute.modifier.take." + entityAttributeModifier3.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(e *= -1.0), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
    }

    @NotNull
    public InteractionResult place(BlockPlaceContext context) {
        Player player = context.getPlayer();
        if (player != null && player.isShiftKeyDown()) {
            return super.place(context);
        }
        return InteractionResult.PASS;
    }
}

