/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.registry;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.satisfy.farm_and_charm.FarmAndCharm;
import net.satisfy.farm_and_charm.core.block.BonemealableFlowerBlock;
import net.satisfy.farm_and_charm.core.block.CattlegridBlock;
import net.satisfy.farm_and_charm.core.block.ChickenCoopBlock;
import net.satisfy.farm_and_charm.core.block.ChickenNestBlock;
import net.satisfy.farm_and_charm.core.block.CookingPotBlock;
import net.satisfy.farm_and_charm.core.block.CraftingBowlBlock;
import net.satisfy.farm_and_charm.core.block.FacingBlock;
import net.satisfy.farm_and_charm.core.block.FeedingTroughBlock;
import net.satisfy.farm_and_charm.core.block.FertilizedFarmlandBlock;
import net.satisfy.farm_and_charm.core.block.FertilizedSoilBlock;
import net.satisfy.farm_and_charm.core.block.FoodBlock;
import net.satisfy.farm_and_charm.core.block.MincerBlock;
import net.satisfy.farm_and_charm.core.block.PackedDirtBlock;
import net.satisfy.farm_and_charm.core.block.PenBlock;
import net.satisfy.farm_and_charm.core.block.PetBowlBlock;
import net.satisfy.farm_and_charm.core.block.RoasterBlock;
import net.satisfy.farm_and_charm.core.block.RopeBlock;
import net.satisfy.farm_and_charm.core.block.RopeKnotBlock;
import net.satisfy.farm_and_charm.core.block.ScarecrowBlock;
import net.satisfy.farm_and_charm.core.block.SiloBlock;
import net.satisfy.farm_and_charm.core.block.StableFloorBlock;
import net.satisfy.farm_and_charm.core.block.StackableBlock;
import net.satisfy.farm_and_charm.core.block.StackableEatableBlock;
import net.satisfy.farm_and_charm.core.block.StoveBlock;
import net.satisfy.farm_and_charm.core.block.StrawStableFloorBlock;
import net.satisfy.farm_and_charm.core.block.SturdyLadderBlock;
import net.satisfy.farm_and_charm.core.block.TeaJugBlock;
import net.satisfy.farm_and_charm.core.block.ToolRackBlock;
import net.satisfy.farm_and_charm.core.block.TrampledPackedDirtBlock;
import net.satisfy.farm_and_charm.core.block.TrampledStableFloorBlock;
import net.satisfy.farm_and_charm.core.block.WaterSprinklerBlock;
import net.satisfy.farm_and_charm.core.block.WindowSillBlock;
import net.satisfy.farm_and_charm.core.block.crops.BarleyCropBlock;
import net.satisfy.farm_and_charm.core.block.crops.CornCropBlock;
import net.satisfy.farm_and_charm.core.block.crops.LettuceCropBlock;
import net.satisfy.farm_and_charm.core.block.crops.OatCropBlock;
import net.satisfy.farm_and_charm.core.block.crops.OnionCropBlock;
import net.satisfy.farm_and_charm.core.block.crops.StrawberryCropBlock;
import net.satisfy.farm_and_charm.core.block.crops.TomatoCropBodyBlock;
import net.satisfy.farm_and_charm.core.block.crops.TomatoCropHeadBlock;
import net.satisfy.farm_and_charm.core.item.CartItem;
import net.satisfy.farm_and_charm.core.item.CatFoodItem;
import net.satisfy.farm_and_charm.core.item.ChickenCoopBlockItem;
import net.satisfy.farm_and_charm.core.item.ChickenFeedItem;
import net.satisfy.farm_and_charm.core.item.DogFoodItem;
import net.satisfy.farm_and_charm.core.item.DungareesItem;
import net.satisfy.farm_and_charm.core.item.FertilizerItem;
import net.satisfy.farm_and_charm.core.item.HorseFodderItem;
import net.satisfy.farm_and_charm.core.item.RopeItem;
import net.satisfy.farm_and_charm.core.item.RottenTomatoItem;
import net.satisfy.farm_and_charm.core.item.TeaJugItem;
import net.satisfy.farm_and_charm.core.item.food.EffectBlockItem;
import net.satisfy.farm_and_charm.core.item.food.EffectFoodItem;
import net.satisfy.farm_and_charm.core.item.food.EffectItem;
import net.satisfy.farm_and_charm.core.item.food.EffectJugItem;
import net.satisfy.farm_and_charm.core.registry.ArmorMaterialRegistry;
import net.satisfy.farm_and_charm.core.registry.MobEffectRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import net.satisfy.farm_and_charm.platform.PlatformHelper;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"farm_and_charm", (ResourceKey)Registries.ITEM);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"farm_and_charm", (ResourceKey)Registries.BLOCK);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Item> FERTILIZER = ObjectRegistry.registerItem("fertilizer", () -> new BoneMealItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> PITCHFORK = ObjectRegistry.registerItem("pitchfork", () -> new HoeItem((Tier)Tiers.WOOD, new Item.Properties()));
    public static final RegistrySupplier<Item> SUPPLY_CART = ObjectRegistry.registerItem("supply_cart", () -> new CartItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> PLOW = ObjectRegistry.registerItem("plow", () -> new CartItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> YEAST = ObjectRegistry.registerItem("yeast", () -> new Item(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> BUTTER = ObjectRegistry.registerItem("butter", () -> new Item(ObjectRegistry.getSettings().food(Foods.CHICKEN)));
    public static final RegistrySupplier<Item> DOUGH = ObjectRegistry.registerItem("dough", () -> new Item(ObjectRegistry.getSettings().food(Foods.SWEET_BERRIES)));
    public static final RegistrySupplier<Item> RAW_PASTA = ObjectRegistry.registerItem("raw_pasta", () -> new Item(ObjectRegistry.getSettings().food(Foods.SWEET_BERRIES)));
    public static final RegistrySupplier<Item> FLOUR = ObjectRegistry.registerItem("flour", () -> new Item(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> MINCED_BEEF = ObjectRegistry.registerItem("minced_beef", () -> new Item(ObjectRegistry.getSettings().food(Foods.BEEF)));
    public static final RegistrySupplier<Item> LAMB_HAM = ObjectRegistry.registerItem("lamb_ham", () -> new Item(ObjectRegistry.getSettings().food(Foods.MUTTON)));
    public static final RegistrySupplier<Item> BACON = ObjectRegistry.registerItem("bacon", () -> new Item(ObjectRegistry.getSettings().food(Foods.PORKCHOP)));
    public static final RegistrySupplier<Item> CHICKEN_PARTS = ObjectRegistry.registerItem("chicken_parts", () -> new Item(ObjectRegistry.getSettings().food(Foods.CHICKEN)));
    public static final RegistrySupplier<Item> CORN = ObjectRegistry.registerItem("corn", () -> new Item(ObjectRegistry.getSettings().food(Foods.SWEET_BERRIES)));
    public static final RegistrySupplier<Item> BARLEY = ObjectRegistry.registerItem("barley", () -> new Item(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> OAT = ObjectRegistry.registerItem("oat", () -> new Item(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> STRAWBERRY = ObjectRegistry.registerItem("strawberry", () -> new Item(ObjectRegistry.getSettings().food(Foods.BEETROOT)));
    public static final RegistrySupplier<Item> LETTUCE = ObjectRegistry.registerItem("lettuce", () -> new Item(ObjectRegistry.getSettings().food(Foods.CARROT)));
    public static final RegistrySupplier<Item> TOMATO = ObjectRegistry.registerItem("tomato", () -> new Item(ObjectRegistry.getSettings().food(Foods.APPLE)));
    public static final RegistrySupplier<Item> ROTTEN_TOMATO = ObjectRegistry.registerItem("rotten_tomato", () -> new RottenTomatoItem(ObjectRegistry.getSettings().food(Foods.POISONOUS_POTATO)));
    public static final RegistrySupplier<Item> COMPOST = ObjectRegistry.registerItem("compost", () -> new FertilizerItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> STRAWBERRY_TEA_CUP = ObjectRegistry.registerItem("strawberry_tea_cup", () -> new EffectJugItem(ObjectRegistry.getFoodItemSettings(1, 0.05f, (Holder<MobEffect>)MobEffects.DIG_SPEED, 120), 120, true));
    public static final RegistrySupplier<Item> NETTLE_TEA_CUP = ObjectRegistry.registerItem("nettle_tea_cup", () -> new EffectJugItem(ObjectRegistry.getFoodItemSettings(1, 0.05f, (Holder<MobEffect>)MobEffects.HEAL, 0), 0, true));
    public static final RegistrySupplier<Item> RIBWORT_TEA_CUP = ObjectRegistry.registerItem("ribwort_tea_cup", () -> new EffectJugItem(ObjectRegistry.getFoodItemSettings(1, 0.05f, (Holder<MobEffect>)MobEffects.REGENERATION, 60), 60, true));
    public static final RegistrySupplier<Item> CAT_FOOD = ObjectRegistry.registerItem("cat_food", () -> new CatFoodItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> HORSE_FODDER = ObjectRegistry.registerItem("horse_fodder", () -> new HorseFodderItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> DOG_FOOD = ObjectRegistry.registerItem("dog_food", () -> new DogFoodItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> CHICKEN_FEED = ObjectRegistry.registerItem("chicken_feed", () -> new ChickenFeedItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> TOMATO_CROP = ObjectRegistry.registerWithoutItem("tomato_crop", () -> new TomatoCropHeadBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH).randomTicks()));
    public static final RegistrySupplier<Item> TOMATO_SEEDS = ObjectRegistry.registerItem("tomato_seeds", () -> new ItemNameBlockItem((Block)TOMATO_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> TOMATO_CROP_BODY = ObjectRegistry.registerWithoutItem("tomato_crop_body", () -> new TomatoCropBodyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH).randomTicks()));
    public static final RegistrySupplier<Block> LETTUCE_CROP = ObjectRegistry.registerWithoutItem("lettuce_crop", () -> new LettuceCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT).randomTicks().instabreak()));
    public static final RegistrySupplier<Item> LETTUCE_SEEDS = ObjectRegistry.registerItem("lettuce_seeds", () -> new ItemNameBlockItem((Block)LETTUCE_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> STRAWBERRY_CROP = ObjectRegistry.registerWithoutItem("strawberry_crop", () -> new StrawberryCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH)));
    public static final RegistrySupplier<Item> STRAWBERRY_SEEDS = ObjectRegistry.registerItem("strawberry_seeds", () -> new ItemNameBlockItem((Block)STRAWBERRY_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> OAT_CROP = ObjectRegistry.registerWithoutItem("oat_crop", () -> new OatCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT)));
    public static final RegistrySupplier<Item> OAT_SEEDS = ObjectRegistry.registerItem("oat_seeds", () -> new ItemNameBlockItem((Block)OAT_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> BARLEY_CROP = ObjectRegistry.registerWithoutItem("barley_crop", () -> new BarleyCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH)));
    public static final RegistrySupplier<Item> BARLEY_SEEDS = ObjectRegistry.registerItem("barley_seeds", () -> new ItemNameBlockItem((Block)BARLEY_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> CORN_CROP = ObjectRegistry.registerWithoutItem("corn_crop", () -> new CornCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH)));
    public static final RegistrySupplier<Item> KERNELS = ObjectRegistry.registerItem("kernels", () -> new ItemNameBlockItem((Block)CORN_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> ONION_CROP = ObjectRegistry.registerWithoutItem("onion_crop", () -> new OnionCropBlock(BlockBehaviour.Properties.of().randomTicks().noCollission().instabreak().strength(0.2f)));
    public static final RegistrySupplier<Item> ONION = ObjectRegistry.registerItem("onion", () -> new ItemNameBlockItem((Block)ONION_CROP.get(), ObjectRegistry.getSettings().food(Foods.SWEET_BERRIES)));
    public static final RegistrySupplier<Block> WILD_RIBWORT = ObjectRegistry.registerWithItem("wild_ribwort", () -> new BonemealableFlowerBlock((Holder<MobEffect>)MobEffects.HEAL, 1, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> WILD_NETTLE = ObjectRegistry.registerWithItem("wild_nettle", () -> new BonemealableFlowerBlock((Holder<MobEffect>)MobEffects.REGENERATION, 1, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> WILD_EMMER = ObjectRegistry.registerWithItem("wild_emmer", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> WILD_CORN = ObjectRegistry.registerWithItem("wild_corn", () -> new TallFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ROSE_BUSH)));
    public static final RegistrySupplier<Block> WILD_BARLEY = ObjectRegistry.registerWithItem("wild_barley", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> WILD_OAT = ObjectRegistry.registerWithItem("wild_oat", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> WILD_CARROTS = ObjectRegistry.registerWithItem("wild_carrots", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> WILD_BEETROOTS = ObjectRegistry.registerWithItem("wild_beetroots", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> WILD_POTATOES = ObjectRegistry.registerWithItem("wild_potatoes", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> WILD_TOMATOES = ObjectRegistry.registerWithItem("wild_tomatoes", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> WILD_LETTUCE = ObjectRegistry.registerWithItem("wild_lettuce", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY)));
    public static final RegistrySupplier<Block> WILD_ONIONS = ObjectRegistry.registerWithItem("wild_onions", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_OF_THE_VALLEY)));
    public static final RegistrySupplier<Block> WILD_STRAWBERRIES = ObjectRegistry.registerWithItem("wild_strawberries", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AZURE_BLUET)));
    public static final RegistrySupplier<Block> STRAWBERRY_BAG = ObjectRegistry.registerWithItem("strawberry_bag", () -> new FacingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> CARROT_BAG = ObjectRegistry.registerWithItem("carrot_bag", () -> new FacingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> POTATO_BAG = ObjectRegistry.registerWithItem("potato_bag", () -> new FacingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> BEETROOT_BAG = ObjectRegistry.registerWithItem("beetroot_bag", () -> new FacingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> LETTUCE_BAG = ObjectRegistry.registerWithItem("lettuce_bag", () -> new FacingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> TOMATO_BAG = ObjectRegistry.registerWithItem("tomato_bag", () -> new FacingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> CORN_BAG = ObjectRegistry.registerWithItem("corn_bag", () -> new FacingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> ONION_BAG = ObjectRegistry.registerWithItem("onion_bag", () -> new FacingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> FLOUR_BAG = ObjectRegistry.registerWithItem("flour_bag", () -> new FacingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> OAT_BALL = ObjectRegistry.registerWithItem("oat_ball", () -> new HayBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK)));
    public static final RegistrySupplier<Block> BARLEY_BALL = ObjectRegistry.registerWithItem("barley_ball", () -> new HayBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK)));
    public static final RegistrySupplier<Block> FERTILIZED_SOIL_BLOCK = ObjectRegistry.registerWithItem("fertilized_soil", () -> new FertilizedSoilBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ROOTED_DIRT).strength(2.0f, 3.0f).sound(SoundType.GRASS).mapColor(MapColor.COLOR_BROWN)));
    public static final RegistrySupplier<Block> FERTILIZED_FARM_BLOCK = ObjectRegistry.registerWithItem("fertilized_farmland", () -> new FertilizedFarmlandBlock(BlockBehaviour.Properties.of().randomTicks().strength(0.6f).sound(SoundType.GRAVEL).mapColor(MapColor.COLOR_BROWN)));
    public static final RegistrySupplier<Block> FEEDING_TROUGH = ObjectRegistry.registerWithItem("feeding_trough", () -> new FeedingTroughBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> WATER_SPRINKLER = ObjectRegistry.registerWithItem("water_sprinkler", () -> new WaterSprinklerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).noOcclusion()));
    public static final RegistrySupplier<Block> SILO_WOOD = ObjectRegistry.registerWithItem("silo_wood", () -> new SiloBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).noOcclusion().pushReaction(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> SILO_COPPER = ObjectRegistry.registerWithItem("silo_copper", () -> new SiloBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).noOcclusion().pushReaction(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> STOVE = ObjectRegistry.registerWithItem("stove", () -> new StoveBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).lightLevel(state -> (Boolean)state.getValue((Property)StoveBlock.LIT) != false ? 13 : 0)));
    public static final RegistrySupplier<Block> MINCER = ObjectRegistry.registerWithItem("mincer", () -> new MincerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT).instabreak()));
    public static final RegistrySupplier<Block> CRAFTING_BOWL = ObjectRegistry.registerWithItem("crafting_bowl", () -> new CraftingBowlBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT).instabreak()));
    public static final RegistrySupplier<Block> COOKING_POT = ObjectRegistry.registerWithItem("cooking_pot", () -> new CookingPotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT).noOcclusion()));
    public static final RegistrySupplier<Block> ROASTER = ObjectRegistry.registerWithItem("roaster", () -> new RoasterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT).noOcclusion()));
    public static final RegistrySupplier<Block> WINDOW_SILL = ObjectRegistry.registerWithItem("window_sill", () -> new WindowSillBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT).noCollission()));
    public static final RegistrySupplier<Block> TOOL_RACK = ObjectRegistry.registerWithItem("tool_rack", () -> new ToolRackBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT).noCollission()));
    public static final RegistrySupplier<Block> SCARECROW = ObjectRegistry.registerWithItem("scarecrow", () -> new ScarecrowBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK)));
    public static final RegistrySupplier<Block> OAT_PANCAKE_BLOCK = ObjectRegistry.registerWithoutItem("oat_pancake_block", () -> new StackableEatableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 7));
    public static final RegistrySupplier<Block> ROASTED_CORN_BLOCK = ObjectRegistry.registerWithoutItem("roasted_corn_block", () -> new StackableEatableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 4));
    public static final RegistrySupplier<Block> POTATO_WITH_ROAST_MEAT = ObjectRegistry.registerWithoutItem("potato_with_roast_meat_block", () -> new FoodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 4, new FoodProperties.Builder().nutrition(7).saturationModifier(0.7f).build()));
    public static final RegistrySupplier<Block> BAKED_LAMB_HAM = ObjectRegistry.registerWithoutItem("baked_lamb_ham_block", () -> new FoodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 4, new FoodProperties.Builder().nutrition(8).saturationModifier(0.9f).build()));
    public static final RegistrySupplier<Block> FARMERS_BREAKFAST = ObjectRegistry.registerWithoutItem("farmers_breakfast_block", () -> new FoodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 4, new FoodProperties.Builder().nutrition(12).saturationModifier(1.2f).build()));
    public static final RegistrySupplier<Block> STUFFED_CHICKEN = ObjectRegistry.registerWithoutItem("stuffed_chicken_block", () -> new FoodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 4, new FoodProperties.Builder().nutrition(8).saturationModifier(0.8f).build()));
    public static final RegistrySupplier<Block> STUFFED_RABBIT = ObjectRegistry.registerWithoutItem("stuffed_rabbit_block", () -> new FoodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 4, new FoodProperties.Builder().nutrition(9).saturationModifier(0.9f).build()));
    public static final RegistrySupplier<Block> FARMERS_BREAD = ObjectRegistry.registerWithoutItem("farmers_bread_block", () -> new FoodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 4, new FoodProperties.Builder().nutrition(6).saturationModifier(0.8f).build()));
    public static final RegistrySupplier<Block> STRAWBERRY_TEA = ObjectRegistry.registerTea("strawberry_tea", () -> new TeaJugBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)), (Holder<MobEffect>)MobEffects.DIG_SPEED, 240);
    public static final RegistrySupplier<Block> NETTLE_TEA = ObjectRegistry.registerTea("nettle_tea", () -> new TeaJugBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)), (Holder<MobEffect>)MobEffects.HEAL, 0);
    public static final RegistrySupplier<Block> RIBWORT_TEA = ObjectRegistry.registerTea("ribwort_tea", () -> new TeaJugBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)), (Holder<MobEffect>)MobEffects.REGENERATION, 120);
    public static final RegistrySupplier<Block> PET_BOWL = ObjectRegistry.registerWithItem("pet_bowl", () -> new PetBowlBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).strength(1.0f).sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> DOG_FOOD_BAG = ObjectRegistry.registerWithItem("dog_food_bag", () -> new StackableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CYAN_CARPET), 3));
    public static final RegistrySupplier<Block> CAT_FOOD_BAG = ObjectRegistry.registerWithItem("cat_food_bag", () -> new StackableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_CARPET), 3));
    public static final RegistrySupplier<Block> CHICKEN_NEST = ObjectRegistry.registerWithItem("chicken_nest", () -> new ChickenNestBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK).noCollission().instabreak()));
    public static final RegistrySupplier<Item> DUNGAREES = ObjectRegistry.registerItem("dungarees", () -> new DungareesItem(ArmorMaterialRegistry.withTextureNoOverlay(ArmorMaterialRegistry.CLOTH, FarmAndCharm.identifier("models/armor/dungarees")), ArmorItem.Type.LEGGINGS, ObjectRegistry.getSettings().rarity(Rarity.EPIC), FarmAndCharm.identifier("models/armor/dungarees")));
    public static final RegistrySupplier<Block> CHICKEN_COOP = ObjectRegistry.registerWithoutItem("chicken_coop", () -> new ChickenCoopBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).strength(1.0f).sound(SoundType.WOOD)));
    public static final RegistrySupplier<Item> CHICKEN_COOP_ITEM = ObjectRegistry.registerItem("chicken_coop", () -> new ChickenCoopBlockItem((Block)CHICKEN_COOP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> OAT_PANCAKE = ObjectRegistry.registerItem("oat_pancake", () -> new EffectBlockItem((Block)OAT_PANCAKE_BLOCK.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("oat_pancake"), PlatformHelper.getSaturationMod("oat_pancake"), MobEffectRegistry.SATIATION, 2400)));
    public static final RegistrySupplier<Item> ROASTED_CORN = ObjectRegistry.registerItem("roasted_corn", () -> new EffectBlockItem((Block)ROASTED_CORN_BLOCK.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("roasted_corn"), PlatformHelper.getSaturationMod("roasted_corn"), MobEffectRegistry.FEAST, 3600)));
    public static final RegistrySupplier<Item> POTATO_WITH_ROAST_MEAT_ITEM = ObjectRegistry.registerItem("potato_with_roast_meat", () -> new EffectBlockItem((Block)POTATO_WITH_ROAST_MEAT.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("potato_with_roast_meat"), PlatformHelper.getSaturationMod("potato_with_roast_meat"), MobEffectRegistry.SUSTENANCE, 3600)));
    public static final RegistrySupplier<Item> BAKED_LAMB_HAM_ITEM = ObjectRegistry.registerItem("baked_lamb_ham", () -> new EffectBlockItem((Block)BAKED_LAMB_HAM.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("baked_lamb_ham"), PlatformHelper.getSaturationMod("baked_lamb_ham"), MobEffectRegistry.FEAST, 4800)));
    public static final RegistrySupplier<Item> FARMERS_BREAKFAST_ITEM = ObjectRegistry.registerItem("farmers_breakfast", () -> new EffectBlockItem((Block)FARMERS_BREAKFAST.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("farmers_breakfast"), PlatformHelper.getSaturationMod("farmers_breakfast"), MobEffectRegistry.FARMERS_BLESSING, 9600)));
    public static final RegistrySupplier<Item> STUFFED_CHICKEN_ITEM = ObjectRegistry.registerItem("stuffed_chicken", () -> new EffectBlockItem((Block)STUFFED_CHICKEN.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("stuffed_chicken"), PlatformHelper.getSaturationMod("stuffed_chicken"), MobEffectRegistry.FEAST, 9600)));
    public static final RegistrySupplier<Item> STUFFED_RABBIT_ITEM = ObjectRegistry.registerItem("stuffed_rabbit", () -> new EffectBlockItem((Block)STUFFED_RABBIT.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("stuffed_rabbit"), PlatformHelper.getSaturationMod("stuffed_rabbit"), MobEffectRegistry.FEAST, 9600)));
    public static final RegistrySupplier<Block> GRANDMOTHERS_STRAWBERRY_CAKE = ObjectRegistry.registerWithoutItem("grandmothers_strawberry_cake_block", () -> new FoodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 4, new FoodProperties.Builder().nutrition(7).saturationModifier(0.6f).effect(MobEffectRegistry.inst(MobEffectRegistry.GRANDMAS_BLESSING, 2400), 1.0f).build()));
    public static final RegistrySupplier<Item> GRANDMOTHERS_STRAWBERRY_CAKE_ITEM = ObjectRegistry.registerItem("grandmothers_strawberry_cake", () -> new EffectBlockItem((Block)GRANDMOTHERS_STRAWBERRY_CAKE.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("grandmothers_strawberry_cake"), PlatformHelper.getSaturationMod("grandmothers_strawberry_cake"), MobEffectRegistry.GRANDMAS_BLESSING, 2400)));
    public static final RegistrySupplier<Item> FARMERS_BREAD_ITEM = ObjectRegistry.registerItem("farmers_bread", () -> new EffectBlockItem((Block)FARMERS_BREAD.get(), ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("farmers_bread"), PlatformHelper.getSaturationMod("farmers_bread"), MobEffectRegistry.FARMERS_BLESSING, 3600)));
    public static final RegistrySupplier<Item> FARMER_SALAD = ObjectRegistry.registerItem("farmer_salad", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("farmer_salad"), PlatformHelper.getSaturationMod("farmer_salad"), MobEffectRegistry.SATIATION, 4800, false, false), 4800, false));
    public static final RegistrySupplier<Item> GOULASH = ObjectRegistry.registerItem("goulash", () -> new EffectFoodItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("goulash"), PlatformHelper.getSaturationMod("goulash"), null, 0, true, false), 0));
    public static final RegistrySupplier<Item> SIMPLE_TOMATO_SOUP = ObjectRegistry.registerItem("simple_tomato_soup", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("simple_tomato_soup"), PlatformHelper.getSaturationMod("simple_tomato_soup"), MobEffectRegistry.RESTED, 1800, true, false), 1800, true));
    public static final RegistrySupplier<Item> BARLEY_SOUP = ObjectRegistry.registerItem("barley_soup", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("barley_soup"), PlatformHelper.getSaturationMod("barley_soup"), MobEffectRegistry.RESTED, 3000, true, false), 3000, true));
    public static final RegistrySupplier<Item> ONION_SOUP = ObjectRegistry.registerItem("onion_soup", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("onion_soup"), PlatformHelper.getSaturationMod("onion_soup"), MobEffectRegistry.RESTED, 2400, true, false), 2400, true));
    public static final RegistrySupplier<Item> POTATO_SOUP = ObjectRegistry.registerItem("potato_soup", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("potato_soup"), PlatformHelper.getSaturationMod("potato_soup"), MobEffectRegistry.RESTED, 2400, true, false), 2400, true));
    public static final RegistrySupplier<Item> PASTA_WITH_ONION_SAUCE = ObjectRegistry.registerItem("pasta_with_onion_sauce", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("pasta_with_onion_sauce"), PlatformHelper.getSaturationMod("pasta_with_onion_sauce"), MobEffectRegistry.SATIATION, 3600, false, false), 3600, false));
    public static final RegistrySupplier<Item> CORN_GRITS = ObjectRegistry.registerItem("corn_grits", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("corn_grits"), PlatformHelper.getSaturationMod("corn_grits"), MobEffectRegistry.SATIATION, 2400, true, false), 2400, true));
    public static final RegistrySupplier<Item> OATMEAL_WITH_STRAWBERRIES = ObjectRegistry.registerItem("oatmeal_with_strawberries", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("oatmeal_with_strawberries"), PlatformHelper.getSaturationMod("oatmeal_with_strawberries"), MobEffectRegistry.FARMERS_BLESSING, 900, false, false), 6000, false));
    public static final RegistrySupplier<Item> SAUSAGE_WITH_OAT_PATTY = ObjectRegistry.registerItem("sausage_with_oat_patty", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("sausage_with_oat_patty"), PlatformHelper.getSaturationMod("sausage_with_oat_patty"), MobEffectRegistry.SWEETS, 2400, true, false), 2400, true));
    public static final RegistrySupplier<Item> LAMB_WITH_CORN = ObjectRegistry.registerItem("lamb_with_corn", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("lamb_with_corn"), PlatformHelper.getSaturationMod("lamb_with_corn"), MobEffectRegistry.SATIATION, 3600, true, false), 3600, true));
    public static final RegistrySupplier<Item> BEEF_PATTY_WITH_VEGETABLES = ObjectRegistry.registerItem("beef_patty_with_vegetables", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("beef_patty_with_vegetables"), PlatformHelper.getSaturationMod("beef_patty_with_vegetables"), MobEffectRegistry.SUSTENANCE, 4800, true, false), 6000, true));
    public static final RegistrySupplier<Item> BARLEY_PATTIES_WITH_POTATOES = ObjectRegistry.registerItem("barley_patties_with_potatoes", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("barley_patties_with_potatoes"), PlatformHelper.getSaturationMod("barley_patties_with_potatoes"), MobEffectRegistry.SATIATION, 4800, true, false), 4800, true));
    public static final RegistrySupplier<Item> BACON_WITH_EGGS = ObjectRegistry.registerItem("bacon_with_eggs", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("bacon_with_eggs"), PlatformHelper.getSaturationMod("bacon_with_eggs"), MobEffectRegistry.SUSTENANCE, 3600, true, false), 3600, true));
    public static final RegistrySupplier<Item> CHICKEN_WRAPPED_IN_BACON = ObjectRegistry.registerItem("chicken_wrapped_in_bacon", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("chicken_wrapped_in_bacon"), PlatformHelper.getSaturationMod("chicken_wrapped_in_bacon"), MobEffectRegistry.SUSTENANCE, 6000, true, false), 6000, true));
    public static final RegistrySupplier<Item> COOKED_SALMON = ObjectRegistry.registerItem("cooked_salmon", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("cooked_salmon"), PlatformHelper.getSaturationMod("cooked_salmon"), MobEffectRegistry.SATIATION, 4800, true, false), 4800, true));
    public static final RegistrySupplier<Item> COOKED_COD = ObjectRegistry.registerItem("cooked_cod", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("cooked_cod"), PlatformHelper.getSaturationMod("cooked_cod"), MobEffectRegistry.SUSTENANCE, 4800, true, false), 4800, true));
    public static final RegistrySupplier<Item> ROASTED_CHICKEN = ObjectRegistry.registerItem("roasted_chicken", () -> new EffectItem(ObjectRegistry.getFoodItemSettings(PlatformHelper.getNutrition("roasted_chicken"), PlatformHelper.getSaturationMod("roasted_chicken"), MobEffectRegistry.SATIATION, 4800, false, false), 4800, false));
    public static final RegistrySupplier<Block> ROPE_BLOCK = ObjectRegistry.registerWithoutItem("rope", () -> new RopeBlock(BlockBehaviour.Properties.of().noOcclusion().strength(0.5f).sound(SoundType.WOOL)));
    public static final RegistrySupplier<Block> ROPE_KNOT = ObjectRegistry.registerWithoutItem("rope_knot", () -> new RopeKnotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE).noOcclusion()));
    public static final RegistrySupplier<Item> ROPE = ObjectRegistry.registerItem("rope", () -> new RopeItem((Block)ROPE_BLOCK.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> STURDY_LADDER = ObjectRegistry.registerWithItem("sturdy_ladder", () -> new SturdyLadderBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER)));
    public static final RegistrySupplier<Block> IRON_DIVIDER = ObjectRegistry.registerWithItem("iron_divider", () -> new PenBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops().noOcclusion()));
    public static final RegistrySupplier<Block> CHICKEN_FENCE = ObjectRegistry.registerWithItem("chicken_fence", () -> new PenBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(1.5f, 3.0f).requiresCorrectToolForDrops().noOcclusion()));
    public static final RegistrySupplier<Block> CATTLEGRID = ObjectRegistry.registerWithItem("cattlegrid", () -> new CattlegridBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.0f, 6.0f).noOcclusion()));
    public static final RegistrySupplier<Block> PACKED_DIRT = ObjectRegistry.registerWithItem("packed_dirt", () -> new PackedDirtBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(1.5f, 3.0f).sound(SoundType.PACKED_MUD)));
    public static final RegistrySupplier<Block> TRAMPLED_PACKED_DIRT = ObjectRegistry.registerWithItem("trampled_packed_dirt", () -> new TrampledPackedDirtBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(1.0f, 3.0f).sound(SoundType.PACKED_MUD)));
    public static final RegistrySupplier<Block> STABLE_FLOOR = ObjectRegistry.registerWithItem("stable_floor", () -> new StableFloorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).sound(SoundType.WOOD).strength(1.5f, 3.0f)));
    public static final RegistrySupplier<Block> TRAMPLED_STABLE_FLOOR = ObjectRegistry.registerWithItem("trampled_stable_floor", () -> new TrampledStableFloorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).sound(SoundType.WOOD).strength(1.2f, 2.5f)));
    public static final RegistrySupplier<Block> STRAW_STABLE_FLOOR = ObjectRegistry.registerWithItem("straw_stable_floor", () -> new StrawStableFloorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).sound(SoundType.GRASS).strength(0.8f, 1.0f)));

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
        LifecycleEvent.SETUP.register(() -> {
            ((PackedDirtBlock)((Object)((Object)PACKED_DIRT.get()))).setTrampled((Supplier<Block>)TRAMPLED_PACKED_DIRT);
            ((TrampledPackedDirtBlock)((Object)((Object)TRAMPLED_PACKED_DIRT.get()))).setBase((Supplier<Block>)PACKED_DIRT);
            ((StableFloorBlock)((Object)((Object)STABLE_FLOOR.get()))).setTrampled((Supplier<Block>)TRAMPLED_STABLE_FLOOR);
            ((StableFloorBlock)((Object)((Object)STABLE_FLOOR.get()))).setStraw((Supplier<Block>)STRAW_STABLE_FLOOR);
            ((StrawStableFloorBlock)((Object)((Object)STRAW_STABLE_FLOOR.get()))).setBase((Supplier<Block>)STABLE_FLOOR);
            ((StrawStableFloorBlock)((Object)((Object)STRAW_STABLE_FLOOR.get()))).setStrawItem(() -> Items.WHEAT);
        });
    }

    public static BlockBehaviour.Properties properties(float strength) {
        return ObjectRegistry.properties(strength, strength);
    }

    public static BlockBehaviour.Properties properties(float breakSpeed, float explosionResist) {
        return BlockBehaviour.Properties.of().strength(breakSpeed, explosionResist);
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(s -> {});
    }

    private static Item.Properties getFoodItemSettings(int nutrition, float saturationMod, Holder<MobEffect> effect, int duration) {
        return new Item.Properties().food(new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturationMod).effect(new MobEffectInstance(effect, duration), 1.0f).build());
    }

    private static Item.Properties getFoodItemSettings(int nutrition, float saturationMod, RegistrySupplier<MobEffect> effect, int duration) {
        return new Item.Properties().food(new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturationMod).effect(MobEffectRegistry.inst(effect, duration), 1.0f).build());
    }

    private static RegistrySupplier<Block> registerBlockWithItem(String blockName, String itemName, Supplier<Block> blockSupplier) {
        RegistrySupplier<Block> block = ObjectRegistry.registerWithoutItem(blockName, blockSupplier);
        ObjectRegistry.registerItem(itemName, () -> new EffectBlockItem((Block)block.get(), ObjectRegistry.getFoodItemSettings(7, 0.7f, MobEffectRegistry.SUSTENANCE, 3600)));
        return block;
    }

    private static Item.Properties getFoodItemSettings(int nutrition, float saturationMod, Holder<MobEffect> effect, int duration, boolean alwaysEat, boolean fast) {
        return ObjectRegistry.getSettings().food(ObjectRegistry.createFood(nutrition, saturationMod, effect, duration, alwaysEat, fast));
    }

    private static Item.Properties getFoodItemSettings(int nutrition, float saturationMod, RegistrySupplier<MobEffect> effect, int duration, boolean alwaysEat, boolean fast) {
        return ObjectRegistry.getSettings().food(ObjectRegistry.createFood(nutrition, saturationMod, effect, duration, alwaysEat, fast));
    }

    private static FoodProperties createFood(int nutrition, float saturationMod, Holder<MobEffect> effect, int duration, boolean alwaysEat, boolean fast) {
        FoodProperties.Builder food = new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturationMod);
        if (alwaysEat) {
            food.alwaysEdible();
        }
        if (fast) {
            food.fast();
        }
        if (effect != null) {
            food.effect(new MobEffectInstance(effect, duration), 1.0f);
        }
        return food.build();
    }

    private static FoodProperties createFood(int nutrition, float saturationMod, RegistrySupplier<MobEffect> effect, int duration, boolean alwaysEat, boolean fast) {
        FoodProperties.Builder food = new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturationMod);
        if (alwaysEat) {
            food.alwaysEdible();
        }
        if (fast) {
            food.fast();
        }
        if (effect != null) {
            food.effect(MobEffectRegistry.inst(effect, duration), 1.0f);
        }
        return food.build();
    }

    private static FoodProperties teaFoodComponent(Holder<MobEffect> effect, int duration) {
        FoodProperties.Builder component = new FoodProperties.Builder().nutrition(1).saturationModifier(1.0f).alwaysEdible();
        if (effect != null) {
            component.effect(new MobEffectInstance(effect, duration), 1.0f);
        }
        return component.build();
    }

    private static RegistrySupplier<Block> registerTea(String name, Supplier<Block> blockSupplier, Holder<MobEffect> effect, int duration) {
        RegistrySupplier<Block> toReturn = ObjectRegistry.registerWithoutItem(name, blockSupplier);
        ObjectRegistry.registerItem(name, () -> new TeaJugItem((Block)toReturn.get(), ObjectRegistry.getSettings().food(ObjectRegistry.teaFoodComponent(effect, duration))));
        return toReturn;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return GeneralUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, FarmAndCharm.identifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return GeneralUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, FarmAndCharm.identifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return GeneralUtil.registerItem(ITEMS, ITEM_REGISTRAR, FarmAndCharm.identifier(path), itemSupplier);
    }
}

