package dev.lieonlion.mcv.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.lieonlion.mcv.MoreChestVariants;
import dev.lieonlion.mcv.block.MoreChestBlock;
import dev.lieonlion.mcv.block.MoreTrappedChestBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Calendar;
import net.minecraft.class_2586;
import net.minecraft.class_2745;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_826;

@Mixin(class_826.class)
public class FabricChestRendererMixin {
    @Unique
    private final boolean lolmcv$starwars = lolmcv$starwars();

    @Unique
    private boolean lolmcv$starwars() {
        Calendar calendar = Calendar.getInstance();
        return (calendar.get(2) + 1 == 5 && calendar.get(5) >= 3 && calendar.get(5) <= 5);
    }

    @WrapOperation(method = "render(Lnet/minecraft/world/level/block/entity/BlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/world/phys/Vec3;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/Sheets;chooseMaterial(Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/level/block/state/properties/ChestType;Z)Lnet/minecraft/client/resources/model/Material;"))
    private class_4730 lolmcv$getChestMaterial(class_2586 blockEntity, class_2745 type, boolean xmas, Operation<class_4730> original) {
        if (!xmas && blockEntity.method_11010().method_26204() instanceof MoreChestBlock moreChestBlock) {
            if (lolmcv$starwars && MoreChestVariants.CONFIG.displayStarWarsTextures()) {
                return lolmcv$chooseMaterial(type, "starwars");
            } else if (moreChestBlock instanceof MoreTrappedChestBlock) {
                return lolmcv$chooseMaterial(type, "trapped/" + moreChestBlock.woodType);
            } return lolmcv$chooseMaterial(type, moreChestBlock.woodType);
        } return original.call(blockEntity, type, xmas);
    }

    @Unique
    private static class_4730 lolmcv$getChestPath(String path) {
        return new class_4730(class_4722.field_21709, MoreChestVariants.location("entity/chest/" + path));
    }

    @Unique
    private static class_4730 lolmcv$chooseMaterial(class_2745 type, String path) {
        return switch (type) {
            case field_12574 -> lolmcv$getChestPath(path + "_left");
            case field_12571 -> lolmcv$getChestPath(path + "_right");
            default -> lolmcv$getChestPath(path);
        };
    }
}
