/*
 * Decompiled with CFR 0.152.
 */
package dev.lieonlion.mcv.block;

import dev.lieonlion.mcv.MoreChestVariants;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class MoreChestBlock
extends ChestBlock {
    public DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>> NAME_RETRIEVER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>>(){

        @NotNull
        public Optional<MenuProvider> acceptDouble(final @NotNull ChestBlockEntity chestBlockEntity, final @NotNull ChestBlockEntity chestBlockEntity2) {
            CompoundContainer container = new CompoundContainer((Container)chestBlockEntity, (Container)chestBlockEntity2);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$container;
                {
                    this.val$container = container;
                }

                public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
                    if (chestBlockEntity.canOpen(player) && chestBlockEntity2.canOpen(player)) {
                        chestBlockEntity.unpackLootTable(inventory.player);
                        chestBlockEntity2.unpackLootTable(inventory.player);
                        return ChestMenu.sixRows((int)id, (Inventory)inventory, (Container)this.val$container);
                    }
                    return null;
                }

                @NotNull
                public Component getDisplayName() {
                    if (chestBlockEntity.hasCustomName()) {
                        return chestBlockEntity.getDisplayName();
                    }
                    return chestBlockEntity2.hasCustomName() ? chestBlockEntity2.getDisplayName() : Component.translatable((String)("container.lolmcv." + MoreChestBlock.this.woodType + "_chestDouble"));
                }
            });
        }

        @NotNull
        public Optional<MenuProvider> acceptSingle(@NotNull ChestBlockEntity chestBlockEntity) {
            return Optional.of(chestBlockEntity);
        }

        @NotNull
        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };
    public final String woodType;

    public MoreChestBlock(Supplier<BlockEntityType<? extends ChestBlockEntity>> blockEntityType, BlockBehaviour.Properties properties, String woodType) {
        super(blockEntityType, SoundEvents.CHEST_OPEN, SoundEvents.CHEST_CLOSE, properties);
        this.woodType = woodType;
    }

    public MoreChestBlock(Supplier<BlockEntityType<? extends ChestBlockEntity>> blockEntityType, MapColor colour, String woodType) {
        this(blockEntityType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHEST).mapColor(colour).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreChestVariants.location(woodType + "_chest"))), woodType);
    }

    public MoreChestBlock(Supplier<BlockEntityType<? extends ChestBlockEntity>> blockEntityType, MapColor colour, SoundType sound, String woodType) {
        this(blockEntityType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHEST).mapColor(colour).sound(sound).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreChestVariants.location(woodType + "_chest"))), woodType);
    }

    public MenuProvider getMenuProvider(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return ((Optional)this.combine(state, level, pos, false).apply(this.NAME_RETRIEVER)).orElse(null);
    }
}

