/*
 * Decompiled with CFR 0.152.
 */
package dev.lieonlion.mcv.block;

import dev.lieonlion.mcv.MoreChestVariants;
import dev.lieonlion.mcv.block.MoreChestBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class MoreTrappedChestBlock
extends MoreChestBlock {
    protected MoreTrappedChestBlock(Supplier<BlockEntityType<? extends ChestBlockEntity>> blockEntityType, BlockBehaviour.Properties properties, String woodType) {
        super(blockEntityType, properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreChestVariants.location(woodType + "_trapped_chest"))), woodType);
    }

    public MoreTrappedChestBlock(Supplier<BlockEntityType<? extends ChestBlockEntity>> blockEntityType, MapColor colour, String woodType) {
        this(blockEntityType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHEST).mapColor(colour), woodType);
    }

    public MoreTrappedChestBlock(Supplier<BlockEntityType<? extends ChestBlockEntity>> blockEntityType, MapColor colour, SoundType sound, String woodType) {
        this(blockEntityType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHEST).mapColor(colour).sound(sound), woodType);
    }

    @NotNull
    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.CUSTOM.get((Object)Stats.TRIGGER_TRAPPED_CHEST);
    }

    public boolean isSignalSource(@NotNull BlockState state) {
        return true;
    }

    public int getSignal(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull Direction direction) {
        return Mth.clamp((int)ChestBlockEntity.getOpenCount((BlockGetter)getter, (BlockPos)pos), (int)0, (int)15);
    }

    public int getDirectSignal(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull Direction direction) {
        return direction == Direction.UP ? state.getSignal(getter, pos, direction) : 0;
    }
}

