package dev.lieonlion.mcv.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.lieonlion.mcv.MoreChestVariants;
import dev.lieonlion.mcv.access.ChestRenderStateAccess;
import dev.lieonlion.mcv.block.MoreChestBlock;
import dev.lieonlion.mcv.block.MoreTrappedChestBlock;
import dev.lieonlion.mcv.block.entity.MoreChestBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Calendar;
import net.minecraft.class_11683;
import net.minecraft.class_11959;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2618;
import net.minecraft.class_2745;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_826;

@Mixin(class_826.class)
public class FabricChestRendererMixin {
    @Unique
    private final boolean lolmcv$starwars = lolmcv$starwars();

    @Unique
    private boolean lolmcv$starwars() {
        Calendar calendar = Calendar.getInstance();
        return (calendar.get(2) + 1 == 5 && calendar.get(5) >= 3 && calendar.get(5) <= 5);
    }

    @WrapOperation(method = "submit(Lnet/minecraft/client/renderer/blockentity/state/ChestRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/Sheets;chooseMaterial(Lnet/minecraft/client/renderer/blockentity/state/ChestRenderState$ChestMaterialType;Lnet/minecraft/world/level/block/state/properties/ChestType;)Lnet/minecraft/client/resources/model/Material;"))
    private class_4730 lolmcv$getChestMaterial(class_11959.class_11960 chestMaterialType, class_2745 type, Operation<class_4730> original, @Local class_11959 chestRenderState) {
        if (!class_826.method_65559() && chestRenderState instanceof ChestRenderStateAccess moreChestBlock && moreChestBlock.lolmcv$isMoreChest()) {
            if (lolmcv$starwars && MoreChestVariants.CONFIG.displayStarWarsTextures()) {
                return lolmcv$chooseMaterial(type, "starwars");
            } else if (moreChestBlock.lolmcv$isTrapped()) {
                return lolmcv$chooseMaterial(type, "trapped/" + moreChestBlock.lolmcv$woodVariant());
            } return lolmcv$chooseMaterial(type, moreChestBlock.lolmcv$woodVariant());
        } return original.call(chestMaterialType, type);
    }

    @Inject(method = "extractRenderState(Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/client/renderer/blockentity/state/ChestRenderState;FLnet/minecraft/world/phys/Vec3;Lnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;)V", at = @At(value = "RETURN"))
    private <T extends class_2586 & class_2618> void mixin(T blockEntity, class_11959 chestRenderState, float f, class_243 vec3, class_11683.class_11792 crumblingOverlay, CallbackInfo ci) {
        var access = ((ChestRenderStateAccess) chestRenderState);
        if (blockEntity.method_11010().method_26204() instanceof MoreChestBlock moreChestBlock) {
            access.lolmcv$setMoreChest(true);
            access.lolmcv$setTrapped(blockEntity.method_11010().method_26204() instanceof MoreTrappedChestBlock);
            access.lolmcv$setWoodVariant(moreChestBlock.woodType);
        }
    }

    @Unique
    private static class_4730 lolmcv$getChestPath(String path) {
        return new class_4730(class_4722.field_21709, MoreChestVariants.location("entity/chest/" + path));
    }

    @Unique
    private static class_4730 lolmcv$chooseMaterial(class_2745 type, String path) {
        return switch (type) {
            case field_12574 -> lolmcv$getChestPath(path + "_left");
            case field_12571 -> lolmcv$getChestPath(path + "_right");
            default -> lolmcv$getChestPath(path);
        };
    }
}
