/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier;

import com.google.gson.Gson;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mod.arcomit.emberthral.client.filter.Filter;
import mod.arcomit.emberthral.client.filter.FilterManager;
import net.exmo.exmodifier.Config;
import net.exmo.exmodifier.content.attributeEffect.modern.EffectSyncPacket;
import net.exmo.exmodifier.content.event.MainEvent;
import net.exmo.exmodifier.content.modifier.EntryItem;
import net.exmo.exmodifier.content.modifier.EntryItemEmpty;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.content.type.ExTypeHandle;
import net.exmo.exmodifier.content.type.ItemType;
import net.exmo.exmodifier.events.ExCustomTabEvent;
import net.exmo.exmodifier.init.RegisterOther;
import net.exmo.exmodifier.network.AskSyncEntityElementMessage;
import net.exmo.exmodifier.network.ChangeRefreshMenuTextListMessage;
import net.exmo.exmodifier.network.DamageNumberColorCompatMessage;
import net.exmo.exmodifier.network.DamageNumberCompatMessage;
import net.exmo.exmodifier.network.PlayerRefreshScreenOverMessageMessage;
import net.exmo.exmodifier.network.RefineItemMessage;
import net.exmo.exmodifier.network.RefreshCraftContentMessage;
import net.exmo.exmodifier.network.RefreshItemMessage;
import net.exmo.exmodifier.network.SyncEntityElementMessage;
import net.exmo.exmodifier.network.SyncEntityElementRemovedMessage;
import net.exmo.exmodifier.network.sync.defaultEntityElement.ClearDefaultItemElementMessage;
import net.exmo.exmodifier.network.sync.defaultEntityElement.SyncDefaultItemElementMessage;
import net.exmo.exmodifier.network.sync.defaultItemElement.ClearDefaultEntityElementMessage;
import net.exmo.exmodifier.network.sync.defaultItemElement.SyncDefaultEntityElementMessage;
import net.exmo.exmodifier.network.sync.element.ClearElementMessage;
import net.exmo.exmodifier.network.sync.element.SyncElementMessage;
import net.exmo.exmodifier.network.sync.lang.LangMessage;
import net.exmo.exmodifier.network.sync.modifier.ClearModifierEntryMessage;
import net.exmo.exmodifier.network.sync.modifier.SyncModifierEntryMessage;
import net.exmo.exmodifier.network.sync.suit.ClearExSuitMessage;
import net.exmo.exmodifier.network.sync.suit.SyncExSuitMessage;
import net.exmo.exmodifier.util.WeightedUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="exmodifier")
public class Exmodifier {
    public static final Gson GSON = new Gson();
    public static final String MODID = "exmodifier";
    public static Random random = new Random();
    public static List<Filter> itemGroups = new ArrayList<Filter>();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("exmodifier", "exmodifier"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"exmodifier");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"exmodifier");
    public static final RegistryObject<Item> ENTRY_ITEM = ITEMS.register("entry_item", () -> new EntryItem(new Item.Properties()));
    public static final RegistryObject<Item> ENTRY_ITEM_EMPTY = ITEMS.register("entry_item_empty", () -> new EntryItemEmpty(new Item.Properties()));
    public static ItemStack TabIcon;
    private static Map<String, Item> itemIconMap;
    public static final RegistryObject<CreativeModeTab> ExModifierTab;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue;

    public static ItemStack getTabIcon() {
        TabIcon = ((Item)ENTRY_ITEM.get()).m_7968_();
        TabIcon.m_41714_((Component)Component.m_237115_((String)"modifier.entry.example"));
        TabIcon.m_41784_().m_128359_("modifier_id", "example");
        return TabIcon;
    }

    public static <MSG> void registerMessage(Class<MSG> messageClass) {
        try {
            Method encodeMethod = messageClass.getMethod("encode", messageClass, FriendlyByteBuf.class);
            Method decodeMethod = messageClass.getMethod("decode", FriendlyByteBuf.class);
            Method handleMethod = messageClass.getMethod("handle", messageClass, Supplier.class);
            BiConsumer<Object, FriendlyByteBuf> encoder = (msg, buffer) -> {
                try {
                    encodeMethod.invoke(null, msg, buffer);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to encode message", e);
                }
            };
            Function<FriendlyByteBuf, Object> decoder = buffer -> {
                try {
                    return decodeMethod.invoke(null, buffer);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to decode message", e);
                }
            };
            BiConsumer<Object, Supplier> messageConsumer = (msg, ctx) -> {
                try {
                    handleMethod.invoke(null, msg, ctx);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to handle message", e);
                }
            };
            PACKET_HANDLER.registerMessage(messageID++, messageClass, encoder, decoder, messageConsumer);
            LOGGER.Logger.debug("Registered message: " + messageClass.getSimpleName() + " with ID: " + messageID);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find required methods in message class", e);
        }
    }

    public Exmodifier() throws Exception {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC, String.valueOf(FMLPaths.CONFIGDIR.get().resolve("exmo/exmodifier.toml")));
        long time_start = System.currentTimeMillis();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Exmodifier.registerMessage(SyncModifierEntryMessage.class);
        Exmodifier.registerMessage(ClearModifierEntryMessage.class);
        Exmodifier.registerMessage(RefreshItemMessage.class);
        Exmodifier.registerMessage(ChangeRefreshMenuTextListMessage.class);
        Exmodifier.registerMessage(PlayerRefreshScreenOverMessageMessage.class);
        Exmodifier.registerMessage(RefreshCraftContentMessage.class);
        Exmodifier.registerMessage(DamageNumberCompatMessage.class);
        Exmodifier.registerMessage(DamageNumberColorCompatMessage.class);
        Exmodifier.registerMessage(SyncEntityElementMessage.class);
        Exmodifier.registerMessage(SyncEntityElementRemovedMessage.class);
        Exmodifier.registerMessage(AskSyncEntityElementMessage.class);
        Exmodifier.registerMessage(RefineItemMessage.class);
        PACKET_HANDLER.registerMessage(messageID++, EffectSyncPacket.class, EffectSyncPacket::encode, EffectSyncPacket::new, EffectSyncPacket::handle);
        Exmodifier.registerMessage(SyncElementMessage.class);
        Exmodifier.registerMessage(ClearElementMessage.class);
        Exmodifier.registerMessage(SyncDefaultEntityElementMessage.class);
        Exmodifier.registerMessage(ClearDefaultEntityElementMessage.class);
        Exmodifier.registerMessage(SyncDefaultItemElementMessage.class);
        Exmodifier.registerMessage(ClearDefaultItemElementMessage.class);
        Exmodifier.registerMessage(ClearExSuitMessage.class);
        Exmodifier.registerMessage(SyncExSuitMessage.class);
        Exmodifier.registerMessage(ClearDefaultEntityElementMessage.class);
        Exmodifier.registerMessage(LangMessage.class);
        ITEMS.register(modEventBus);
        try {
            MainEvent.CommonEvent.init(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::processIMC);
        RegisterOther.EffectAbout.REGISTRY.register(modEventBus);
        RegisterOther.BlockAbout.REGISTRY.register(modEventBus);
        RegisterOther.ItemAbout.REGISTRY.register(modEventBus);
        modEventBus.addListener(EventPriority.HIGH, this::AddToTab);
        RegisterOther.MenuAbout.REGISTRY.register(modEventBus);
        RegisterOther.BlockEntityAbout.REGISTRY.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        long time_end = System.currentTimeMillis();
        RegisterOther.EventAbout.init();
        LOGGER.info("Mod loaded in " + (time_end - time_start) + "ms");
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        LOGGER.debug("ExGatherData");
    }

    private void setup(FMLCommonSetupEvent event) {
        ExCustomTabEvent event1 = new ExCustomTabEvent();
        MinecraftForge.EVENT_BUS.post((Event)event1);
        event1.addTab("exmodifier_tab", Exmodifier.getTabIcon());
    }

    private void AddToTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.accept(RegisterOther.ItemAbout.Refresh_Table);
            event.accept(RegisterOther.ItemAbout.Embedded_Table);
        }
        if (event.getTab().equals(ExModifierTab.get())) {
            List<ItemStack> list = Exmodifier.generateModifierItemStacks();
            list.forEach(e -> {
                ModifierEntry entry = ModifierHandle.findModifierEntry(EntryItem.getModifierID(e));
                if (entry != null) {
                    // empty if block
                }
            });
        }
        if (event.getTab() == ExModifierTab.get()) {
            event.accept(RegisterOther.ItemAbout.Refresh_Table);
            event.accept(RegisterOther.ItemAbout.Embedded_Table);
            LinkedHashSet filters = (LinkedHashSet)FilterManager.filterTabMap.get(ExModifierTab.get());
            if (filters != null) {
                filters.clear();
            }
            FilterManager.filterTabMap.put((CreativeModeTab)ExModifierTab.get(), filters);
            AtomicReference<List<ItemStack>> modifierItemStacks = new AtomicReference<List<ItemStack>>(Exmodifier.generateModifierItemStacks());
            modifierItemStacks.get().forEach(e -> {
                ModifierEntry modifierEntry = ModifierHandle.findModifierEntry(EntryItem.getModifierID(e));
                if (modifierEntry != null) {
                    String group = modifierEntry.group;
                    event.m_246342_(e);
                    if (itemGroups.stream().noneMatch(itemGroup -> itemGroup.getName().equals(group))) {
                        Item item = itemIconMap.get(group);
                        if (item == null) {
                            item = (Item)ENTRY_ITEM.get();
                        }
                        ItemStack defaultInstance = item.m_7968_();
                        Filter e1 = new Filter(group, defaultInstance, null, ExModifierTab.getId());
                        e1.getFilteredItems().add(e);
                        itemGroups.add(e1);
                    } else {
                        List<Filter> itemGroupList = itemGroups.stream().filter(itemGroup -> itemGroup.getName().equals(group)).toList();
                        itemGroupList.forEach(a -> a.getFilteredItems().add(e));
                    }
                }
            });
            FilterManager.filterTabMap.put((CreativeModeTab)ExModifierTab.get(), new LinkedHashSet<Filter>(itemGroups));
        }
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    public static List<ItemStack> generateModifierItemStacks() {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        HashMap<String, WeightedUtil<String>> weights = new HashMap<String, WeightedUtil<String>>();
        for (ItemType type2 : ExTypeHandle.itemTypes.values()) {
            weights.put(type2.name(), new WeightedUtil<String>(ModifierHandle.modifierEntryMap.entrySet().stream().filter(e -> ((ModifierEntry)e.getValue()).types.contains(type2) && !((ModifierEntry)e.getValue()).cantSelect).collect(Collectors.toMap(Map.Entry::getKey, e -> Float.valueOf(((ModifierEntry)e.getValue()).weight)))));
        }
        ModifierHandle.modifierEntryMap.forEach((entry, modifierEntry) -> {
            ItemStack stack = ((Item)ENTRY_ITEM.get()).m_7968_();
            stack.m_41784_().m_128359_("modifier_id", entry);
            ListTag listTag = new ListTag();
            for (ItemType type3 : modifierEntry.types) {
                listTag.add((Object)StringTag.m_129297_((String)type3.name()));
            }
            stack.m_41784_().m_128365_("modifier_types", (Tag)listTag);
            double probability = modifierEntry.types.stream().mapToDouble(type2 -> ((WeightedUtil)weights.get(type2.name())).getProbability(entry)).sum();
            stack.m_41784_().m_128347_("modifier_possibility", probability);
            if (modifierEntry.maxLevel <= 1) {
                stack.m_41784_().m_128405_("modifier_level", 1);
                itemStacks.add(stack);
            } else {
                for (int i = 1; i <= modifierEntry.maxLevel; ++i) {
                    ItemStack stack1 = stack.m_41777_();
                    stack1.m_41784_().m_128405_("modifier_level", i);
                    itemStacks.add(stack1);
                }
            }
        });
        return itemStacks;
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    static {
        itemIconMap = new HashMap<String, Item>();
        ExModifierTab = CREATIVE_MODE_TABS.register("exmodifier_tab", () -> CreativeModeTab.builder().m_257737_(Exmodifier::getTabIcon).withSearchBar().m_257941_((Component)Component.m_237115_((String)"itemGroup.exmodifier_tab")).m_257501_((parameters, output) -> {}).m_257652_());
        workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();
    }

    public static class LOGGER {
        public static Logger Logger = LogUtils.getLogger();

        public static void info(String msg) {
            Logger.info(msg);
        }

        public static void debug(String msg) {
            if (Config.DebugInInfo) {
                Logger.info(msg);
            }
            if (Config.Debug) {
                Logger.debug(msg);
            }
        }

        public static void error(String s, Exception e) {
            Logger.error(s, (Throwable)e);
        }
    }
}

