/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.attributeEffect;

import com.google.gson.JsonObject;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.exmo.exmodifier.content.attributeEffect.AttriGetherEffect;
import net.exmo.exmodifier.content.attributeEffect.AttriGetherEffectInstance;
import net.exmo.exmodifier.network.ExModifiervaV;
import net.exmo.exmodifier.util.EntityAttrUtil;
import net.exmo.exmodifier.util.gether.AttrGether;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AttriGetherEffectHandle {
    private static Map<ResourceLocation, AttriGetherEffect> attriGetherMap = new HashMap<ResourceLocation, AttriGetherEffect>();
    private static List<ServerBossEvent> bossBars = new ArrayList<ServerBossEvent>();

    public static Map<ResourceLocation, AttriGetherEffect> getAttriGetherMap() {
        return attriGetherMap;
    }

    public static AttriGetherEffect getById(ResourceLocation id) {
        return attriGetherMap.get(id);
    }

    public static void registerEffect(AttriGetherEffect effect) {
        attriGetherMap.put(effect.getId(), effect);
    }

    public static ServerBossEvent findBossBar(UUID uuid) {
        for (Map.Entry<ServerBossEvent, UUID> entry : ExModifiervaV.MapVariables.bossBarList) {
            if (!entry.getValue().equals(uuid)) continue;
            return entry.getKey();
        }
        return null;
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        AttriGetherEffectHandle.registerEffect(new AttriGetherEffect(BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS, "\u00a76\u7761\u7720\u4e4b\u529b", true, new ResourceLocation("exmodifier", "sleep"), List.of(new AttrGether(Attributes.f_22276_, new AttributeModifier(UUID.fromString("7f7f7f7f-7f7f-7f7f-7f7f-7f7f7f7f7f7f"), "sleep", 10.0, AttributeModifier.Operation.ADDITION)))).setRandomAttrUUID(true));
        AttriGetherEffectHandle.registerEffect(new AttriGetherEffect(BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_6, "\u00a74\u66b4\u6012", true, new ResourceLocation("exmodifier", "angry"), List.of(new AttrGether(Attributes.f_22276_, new AttributeModifier(UUID.fromString("7f7f7f7f-7f7f-7f7f-7f7f-7f7f7f7f7f6f"), "angry", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL)), new AttrGether(Attributes.f_22281_, new AttributeModifier(UUID.fromString("7f7f7f7f-7f7f-7f7f-7f7f-7f7f7f7f7f5f"), "angry1", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL)), new AttrGether(Attributes.f_22279_, new AttributeModifier(UUID.fromString("7f7f7f7f-7f7f-7f7f-7f7f-7f7f7f7f7f7f"), "angry2", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL)))).setRandomAttrUUID(true));
    }

    public static ServerBossEvent genBossBar(JsonObject jsonObject) {
        return new ServerBossEvent((Component)Component.m_237115_((String)jsonObject.get("localDescription").getAsString()), BossEvent.BossBarColor.m_18884_((String)jsonObject.get("bossBarColor").getAsString()), BossEvent.BossBarOverlay.m_18903_((String)jsonObject.get("bossBarOverlay").getAsString()));
    }

    public static void addOrReplaceAttriGetherEffect(AttriGetherEffectInstance attriGetherEffectInstance, Player player) {
        AttriGetherEffect attriGetherEffect = attriGetherEffectInstance.attriGetherEffect;
        player.getCapability(ExModifiervaV.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            List<AttriGetherEffectInstance> attriGetherEffectInstances = capability.attriGetherEffectInstances;
            attriGetherEffectInstances.removeIf(attriGetherEffectInstance1 -> {
                if (attriGetherEffectInstance1.getAttriGetherEffect().equals(attriGetherEffectInstance.getAttriGetherEffect())) {
                    AttriGetherEffectHandle.removeAttriGetherEffect(attriGetherEffectInstance1, player);
                    AttriGetherEffectHandle.removeBossBar(attriGetherEffectInstance1.getUuid());
                    return true;
                }
                return false;
            });
            attriGetherEffectInstances.add(attriGetherEffectInstance);
            AttriGetherEffectHandle.addAttriGetherEffect(attriGetherEffectInstance, player);
            capability.attriGetherEffectInstances = attriGetherEffectInstances;
            capability.syncPlayerVariables((Entity)player);
        });
    }

    public static void removeBossBar(UUID uuid) {
        ExModifiervaV.MapVariables.bossBarList.removeIf(entry -> {
            if (((UUID)entry.getValue()).equals(uuid)) {
                ((ServerBossEvent)entry.getKey()).m_7706_();
                ((ServerBossEvent)entry.getKey()).m_8321_(false);
                return true;
            }
            return false;
        });
    }

    public static UUID GenEffectModifierUUID(AttriGetherEffectInstance attriGetherEffectInstance, UUID uuid) {
        return UUID.nameUUIDFromBytes((attriGetherEffectInstance.getUuid().toString() + uuid.toString()).getBytes());
    }

    public static void removeAttriGetherEffect(AttriGetherEffectInstance attriGetherEffectInstance, Player player) {
        for (AttrGether attriGether : attriGetherEffectInstance.getAttriGetherEffect().getAttriGethers()) {
            if (attriGetherEffectInstance.randomAttrUUID) {
                EntityAttrUtil.entityAddAttrTF(new AttrGether(attriGether.getAttribute(), attriGether.getModifier()).setModifierUUID(AttriGetherEffectHandle.GenEffectModifierUUID(attriGetherEffectInstance, attriGether.getModifier().m_22209_())), (LivingEntity)player, EntityAttrUtil.WearOrTake.TAKE);
                continue;
            }
            EntityAttrUtil.entityAddAttrTF(attriGether, (LivingEntity)player, EntityAttrUtil.WearOrTake.TAKE);
        }
    }

    public static void addEffectAttriGether(AttriGetherEffectInstance attriGetherEffectInstance, Player player) {
        for (AttrGether attriGether : attriGetherEffectInstance.getAttriGetherEffect().getAttriGethers()) {
            if (attriGetherEffectInstance.randomAttrUUID) {
                EntityAttrUtil.entityAddAttrTF(new AttrGether(attriGether.getAttribute(), attriGether.getModifier()).setModifierUUID(AttriGetherEffectHandle.GenEffectModifierUUID(attriGetherEffectInstance, attriGether.getModifier().m_22209_())), (LivingEntity)player, EntityAttrUtil.WearOrTake.WEAR);
                continue;
            }
            EntityAttrUtil.entityAddAttrTF(attriGether, (LivingEntity)player, EntityAttrUtil.WearOrTake.WEAR);
        }
    }

    public static int getPlayerAttriGetherAmplifier(Player player, AttriGetherEffect attriGetherEffect) {
        return player.getCapability(ExModifiervaV.PLAYER_VARIABLES_CAPABILITY, null).map(data -> data.attriGetherEffectInstances.stream().filter(attriGetherEffectInstance -> attriGetherEffectInstance.getAttriGetherEffect().equals(attriGetherEffect)).mapToInt(attriGetherEffectInstance -> attriGetherEffectInstance.getAmplifier() + 1).sum()).orElse(0);
    }

    public static void addAttriGetherEffect(AttriGetherEffectInstance attriGetherEffectInstance, Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        AttriGetherEffect attriGetherEffect = attriGetherEffectInstance.attriGetherEffect;
        ServerBossEvent bossBar = new ServerBossEvent((Component)Component.m_237115_((String)attriGetherEffect.getBossBarName()), attriGetherEffect.getBossBarColor(), attriGetherEffect.getBossBarOverlay());
        player.getCapability(ExModifiervaV.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            List<AttriGetherEffectInstance> attriGetherEffectInstances = capability.attriGetherEffectInstances;
            attriGetherEffectInstances.add(attriGetherEffectInstance);
            capability.attriGetherEffectInstances = attriGetherEffectInstances;
            capability.syncPlayerVariables((Entity)player);
        });
        bossBar.m_8321_(attriGetherEffectInstance.showBossBar);
        bossBar.m_6543_((ServerPlayer)player);
        ExModifiervaV.MapVariables.bossBarList.add(new AbstractMap.SimpleEntry<ServerBossEvent, UUID>(bossBar, attriGetherEffectInstance.uuid));
        AttriGetherEffectHandle.addEffectAttriGether(attriGetherEffectInstance, player);
    }

    @Mod.EventBusSubscriber
    public static class CommonEvents {
        private static final Map<UUID, ServerBossEvent> BOSS_BAR_CACHE = new HashMap<UUID, ServerBossEvent>();

        @SubscribeEvent
        public static void ResetBossBars(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            player.getCapability(ExModifiervaV.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                List<AttriGetherEffectInstance> attriGetherEffectInstances = capability.attriGetherEffectInstances;
                for (AttriGetherEffectInstance attriGetherEffectInstance : attriGetherEffectInstances) {
                    AttriGetherEffect attriGetherEffect = attriGetherEffectInstance.attriGetherEffect;
                    AttriGetherEffectHandle.removeBossBar(attriGetherEffectInstance.getUuid());
                    ServerBossEvent bossBar = new ServerBossEvent((Component)Component.m_237115_((String)attriGetherEffect.getBossBarName()), attriGetherEffect.getBossBarColor(), attriGetherEffect.getBossBarOverlay());
                    bossBar.m_8321_(attriGetherEffectInstance.showBossBar);
                    bossBar.m_6543_((ServerPlayer)player);
                    ExModifiervaV.MapVariables.bossBarList.add(new AbstractMap.SimpleEntry<ServerBossEvent, UUID>(bossBar, attriGetherEffectInstance.uuid));
                }
            });
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        }

        @SubscribeEvent
        public static void onPlayerDig(PlayerSleepInBedEvent event) {
        }

        @SubscribeEvent
        public static void onPlayerKill(LivingDeathEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.getCapability(ExModifiervaV.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                    for (AttriGetherEffectInstance attriGetherEffectInstance : capability.attriGetherEffectInstances) {
                        AttriGetherEffectHandle.removeBossBar(attriGetherEffectInstance.getUuid());
                    }
                });
            }
            if ((livingEntity = event.getSource().m_7639_()) instanceof Player) {
                Player player = (Player)livingEntity;
            }
        }

        @SubscribeEvent
        public static void PlayerTick(TickEvent.PlayerTickEvent event) {
            Player player = event.player;
            if (player.m_9236_().f_46443_) {
                return;
            }
            player.getCapability(ExModifiervaV.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                List<AttriGetherEffectInstance> effects = capability.attriGetherEffectInstances;
                if (effects.isEmpty()) {
                    return;
                }
                boolean needsSync = false;
                Iterator<AttriGetherEffectInstance> iterator = effects.iterator();
                while (iterator.hasNext()) {
                    AttriGetherEffectInstance effect = iterator.next();
                    int newDuration = effect.getDuration() - 1;
                    effect.setDuration(newDuration);
                    ServerBossEvent bossBar = BOSS_BAR_CACHE.get(effect.getUuid());
                    if (bossBar != null) {
                        float newProgress = (float)newDuration / (float)effect.getStartDuration();
                        if (Math.abs(bossBar.m_142717_() - newProgress) > 0.01f) {
                            bossBar.m_142711_(newProgress);
                        }
                    }
                    if (newDuration > 0) continue;
                    if (bossBar != null) {
                        bossBar.m_8321_(false);
                        bossBar.m_7706_();
                        BOSS_BAR_CACHE.remove(effect.getUuid());
                    }
                    AttriGetherEffectHandle.removeAttriGetherEffect(effect, player);
                    iterator.remove();
                    needsSync = true;
                }
                if (needsSync || !effects.isEmpty()) {
                    capability.syncPlayerVariables((Entity)player);
                }
            });
        }
    }
}

