/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.attributeEffect.modern;

import java.util.List;
import java.util.UUID;
import net.exmo.exmodifier.content.attributeEffect.modern.CapabilityRegistration;
import net.exmo.exmodifier.content.attributeEffect.modern.CustomEffectInstance;
import net.exmo.exmodifier.content.attributeEffect.modern.CustomEffectsCapImpl;
import net.exmo.exmodifier.content.attributeEffect.modern.ICustomEffectsCap;
import net.exmo.exmodifier.util.gether.AttrGether;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class CapabilityAttachHandler {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("exmodifier", "custom_effects"), (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                final ICustomEffectsCap cap = new CustomEffectsCapImpl();

                public CompoundTag serializeNBT() {
                    CompoundTag tag = new CompoundTag();
                    ListTag effectsList = new ListTag();
                    this.cap.getEffects().forEach(effect -> {
                        CompoundTag effectTag = new CompoundTag();
                        effectTag.m_128359_("Id", effect.getEffectId().toString());
                        effectTag.m_128405_("Duration", effect.getDuration());
                        effectTag.m_128405_("Amplifier", effect.getAmplifier());
                        effectTag.m_128359_("Icon", effect.getIcon().toString());
                        effectTag.m_128359_("UUID", effect.getUuid().toString());
                        if (!effect.getAttributes().isEmpty()) {
                            ListTag specialTagsArray = new ListTag();
                            for (AttrGether ts : effect.getAttributes()) {
                                specialTagsArray.add((Object)AttrGether.exSerialize.toNbt(ts));
                            }
                            effectTag.m_128365_("Attributes", (Tag)specialTagsArray);
                        }
                        effectsList.add((Object)effectTag);
                    });
                    tag.m_128365_("Effects", (Tag)effectsList);
                    return tag;
                }

                public void deserializeNBT(CompoundTag nbt) {
                    ListTag effectsList = nbt.m_128437_("Effects", 10);
                    for (Tag tag : effectsList) {
                        CompoundTag effectTag = (CompoundTag)tag;
                        ResourceLocation id = new ResourceLocation(effectTag.m_128461_("Id"));
                        UUID uuid = UUID.fromString(effectTag.m_128461_("UUID"));
                        int duration = effectTag.m_128451_("Duration");
                        int amplifier = effectTag.m_128451_("Amplifier");
                        ResourceLocation icon = new ResourceLocation(effectTag.m_128461_("Icon"));
                        ListTag specialTagsArray = effectTag.m_128437_("Attributes", 10);
                        List<AttrGether> attrGet = specialTagsArray.stream().map(e -> AttrGether.exSerialize.fromNbt((CompoundTag)e)).toList();
                        this.cap.addEffect(new CustomEffectInstance(id, duration, amplifier, icon, attrGet, uuid));
                    }
                }

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return CapabilityRegistration.CUSTOM_EFFECTS_CAP.orEmpty(cap, LazyOptional.of(() -> this.cap));
                }
            });
        }
    }
}

