/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.attributeEffect.modern;

import java.util.List;
import java.util.UUID;
import net.exmo.exmodifier.util.gether.AttrGether;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;

public class CustomEffectInstance {
    private final ResourceLocation effectId;
    private int duration;
    private UUID uuid;
    private int amplifier;
    private final ResourceLocation icon;
    private final List<AttrGether> attributes;
    private boolean needsSync = true;

    public UUID getUuid() {
        return this.uuid;
    }

    public CustomEffectInstance setUuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public CustomEffectInstance setAmplifier(int amplifier) {
        this.amplifier = amplifier;
        return this;
    }

    public List<AttrGether> getAttributes() {
        return this.attributes;
    }

    public CustomEffectInstance setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public boolean isNeedsSync() {
        return this.needsSync;
    }

    public CustomEffectInstance(ResourceLocation id, int duration, int amplifier, ResourceLocation icon, List<AttrGether> attributes, UUID uuid) {
        this.effectId = id;
        this.duration = duration;
        this.amplifier = amplifier;
        this.icon = icon;
        this.attributes = attributes;
        this.uuid = uuid;
    }

    public void tick(LivingEntity entity) {
        if (this.duration > 0) {
            --this.duration;
        }
    }

    public boolean isExpired() {
        return this.duration <= 0;
    }

    public void applyAttributes(LivingEntity entity) {
        this.attributes.forEach(ag -> {
            AttributeInstance attr = entity.m_21051_(ag.attribute);
            if (attr != null) {
                attr.m_22118_(ag.attributeModifier);
            }
        });
    }

    public void removeAttributes(LivingEntity entity) {
        this.attributes.forEach(ag -> {
            AttributeInstance attr = entity.m_21051_(ag.attribute);
            if (attr != null) {
                attr.m_22120_(ag.attributeModifier.m_22209_());
            }
        });
    }

    public ResourceLocation getEffectId() {
        return this.effectId;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public boolean needsSync() {
        return this.needsSync;
    }

    public void setNeedsSync(boolean needsSync) {
        this.needsSync = needsSync;
    }
}

