/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.attributeEffect.modern;

import java.util.ArrayList;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.attributeEffect.modern.CapabilityRegistration;
import net.exmo.exmodifier.content.attributeEffect.modern.CustomEffectInstance;
import net.exmo.exmodifier.content.attributeEffect.modern.EffectSyncPacket;
import net.exmo.exmodifier.util.gether.AttrGether;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class EffectEventHandler {
    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().f_46443_) {
            entity.getCapability(CapabilityRegistration.CUSTOM_EFFECTS_CAP).ifPresent(cap -> {
                ArrayList<CustomEffectInstance> toRemove = new ArrayList<CustomEffectInstance>();
                for (CustomEffectInstance effect : cap.getEffects()) {
                    effect.tick(entity);
                    if (effect.isExpired()) {
                        effect.removeAttributes(entity);
                        toRemove.add(effect);
                        Exmodifier.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new EffectSyncPacket(entity.m_19879_(), EffectEventHandler.serializeNBT(effect), false));
                        continue;
                    }
                    if (!effect.needsSync()) continue;
                    Exmodifier.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new EffectSyncPacket(entity.m_19879_(), EffectEventHandler.serializeNBT(effect), true));
                    effect.setNeedsSync(false);
                }
                toRemove.forEach(e -> cap.removeEffect(e.getEffectId()));
            });
        }
    }

    public static CompoundTag serializeNBT(CustomEffectInstance effect) {
        CompoundTag tag = new CompoundTag();
        ListTag effectsList = new ListTag();
        CompoundTag effectTag = new CompoundTag();
        effectTag.m_128359_("Id", effect.getEffectId().toString());
        effectTag.m_128405_("Duration", effect.getDuration());
        effectTag.m_128405_("Amplifier", effect.getAmplifier());
        effectTag.m_128359_("Icon", effect.getIcon().toString());
        if (!effect.getAttributes().isEmpty()) {
            ListTag specialTagsArray = new ListTag();
            for (AttrGether ts : effect.getAttributes()) {
                specialTagsArray.add((Object)AttrGether.exSerialize.toNbt(ts));
            }
            effectTag.m_128365_("Attributes", (Tag)specialTagsArray);
        }
        effectsList.add((Object)effectTag);
        tag.m_128365_("Effects", (Tag)effectsList);
        return tag;
    }
}

