/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.attributeEffect.modern;

import java.util.function.Supplier;
import net.exmo.exmodifier.content.attributeEffect.modern.CapabilityRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class EffectSyncPacket {
    private int entityId;
    private CompoundTag effectData;
    private boolean add;

    public EffectSyncPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.effectData = buf.m_130260_();
        this.add = buf.readBoolean();
    }

    public EffectSyncPacket(int entityId, CompoundTag effectData, boolean add) {
        this.entityId = entityId;
        this.effectData = effectData;
        this.add = add;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130079_(this.effectData);
        buf.writeBoolean(this.add);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(this.entityId)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.getCapability(CapabilityRegistration.CUSTOM_EFFECTS_CAP).ifPresent(cap -> {
                    if (!this.add) {
                        cap.removeEffect(new ResourceLocation(this.effectData.m_128461_("Id")));
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

