/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.exmo.exmodifier.content.modifier.EntryItem;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.IItemDecorator;

public class EntryItemRender
implements IItemDecorator {
    public static final ResourceLocation bookIcon = new ResourceLocation("exmodifier", "textures/item/entry_item.png");
    private static final int CYCLE_INTERVAL = 500;
    private final Map<String, TextAnimState> textAnimStates = new HashMap<String, TextAnimState>();

    private static String getStyledSubstring(String text, int visibleStart, int length) {
        StringBuilder result = new StringBuilder();
        int totalVisible = (int)text.chars().filter(c -> c != 167).count() / 2;
        if (totalVisible == 0) {
            return text;
        }
        ArrayList<String> activeStyles = new ArrayList<String>();
        int visibleCount = 0;
        int i = 0;
        while (i < text.length() && visibleCount <= visibleStart + length) {
            if (text.charAt(i) == '\u00a7') {
                if (i + 1 < text.length()) {
                    String styleCode = text.substring(i, i + 2);
                    activeStyles.add(styleCode);
                    i += 2;
                    continue;
                }
                ++i;
                continue;
            }
            if (visibleCount >= visibleStart) {
                for (String style : activeStyles) {
                    result.append(style);
                }
            }
            if (visibleCount >= visibleStart && visibleCount < visibleStart + length) {
                result.append(text.charAt(i));
            }
            ++i;
            ++visibleCount;
        }
        return result.toString();
    }

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        String id = stack.m_41784_().m_128461_("modifier_id");
        if (id.isEmpty()) {
            return false;
        }
        ModifierEntry modifierEntry = ModifierHandle.findModifierEntry(id);
        if (modifierEntry != null && !modifierEntry.icon.isEmpty()) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            if (modifierEntry.iconSize == 0) {
                guiGraphics.m_280411_(new ResourceLocation(modifierEntry.icon), xOffset, yOffset, 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
            } else {
                guiGraphics.m_280411_(new ResourceLocation(modifierEntry.icon), xOffset, yOffset, 0, 0, (float)modifierEntry.iconSize, (float)modifierEntry.iconSize, modifierEntry.iconSize, modifierEntry.iconSize, modifierEntry.iconSize, modifierEntry.iconSize);
            }
            guiGraphics.m_280168_().m_85849_();
        }
        if (Screen.m_96638_() && stack.m_41720_() instanceof EntryItem) {
            int totalVisible;
            if (id.length() <= 2) {
                return false;
            }
            MutableComponent c = modifierEntry != null ? Component.m_237115_((String)modifierEntry.getDescriptionId()) : Component.m_237115_((String)"tooltip.exmodifier.entry_book.none");
            String text = c.getString();
            TextAnimState state = this.textAnimStates.computeIfAbsent(text, k -> new TextAnimState());
            long now = System.currentTimeMillis();
            if (state.lastUpdate == 0L) {
                state.lastUpdate = now;
            }
            if ((totalVisible = text.replaceAll("\u00a7.", "").length()) < 2) {
                return false;
            }
            long elapsed = now - state.lastUpdate;
            if (elapsed >= 500L) {
                state.visibleStartIndex = (state.visibleStartIndex + 1) % (totalVisible - 1);
                state.lastUpdate = now;
            }
            String displayedString = EntryItemRender.getStyledSubstring(text, state.visibleStartIndex, 2);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            MutableComponent mutableComponent = Component.m_237113_((String)displayedString);
            int n = xOffset + 8 - font.m_92895_(displayedString) / 2;
            Objects.requireNonNull(font);
            guiGraphics.m_280614_(font, (Component)mutableComponent, n, yOffset + 8 - 9 / 2, 0xFFFFFF, true);
            guiGraphics.m_280168_().m_85849_();
            return true;
        }
        return false;
    }

    private static class TextAnimState {
        int visibleStartIndex;
        long lastUpdate;

        private TextAnimState() {
        }
    }
}

