/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.client;

import com.google.common.collect.Maps;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.network.sync.lang.LangMessage;
import net.minecraft.locale.Language;
import net.minecraftforge.fml.loading.FMLPaths;

public final class LanguageLoader {
    public static final Map<String, Map<String, String>> LANGUAGES = Maps.newHashMap();
    public static final Path LANGUAGES_FILE_PATH = FMLPaths.CONFIGDIR.get().resolve("exmo/lang");

    public static Map<String, String> handle(String toMap) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        if (toMap == null || toMap.trim().isEmpty()) {
            return map;
        }
        for (String pair : pairs = toMap.split(",,,")) {
            String[] keyValue = pair.split("=");
            if (keyValue.length != 2) continue;
            map.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return map;
    }

    public static String mapToString(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(",,,");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            joiner.add(entry.getKey() + "=" + entry.getValue());
        }
        return joiner.toString();
    }

    public static void sendToAllClient() {
        LangMessage langMessage = new LangMessage(new LangMessage.LangMessageHandler(LANGUAGES));
    }

    public static void load(Path filePath) {
        if (!Files.isDirectory(filePath, new LinkOption[0])) {
            return;
        }
        File[] subFiles = filePath.toFile().listFiles((dir, name) -> true);
        if (subFiles == null) {
            return;
        }
        for (File file : subFiles) {
            String name2 = file.getName();
            if (!name2.endsWith(".json")) continue;
            String languageCode = name2.substring(0, name2.length() - 5);
            try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                HashMap languages = Maps.newHashMap();
                Language.m_128108_((InputStream)inputStream, languages::put);
                LanguageLoader.putLanguage(languageCode, languages);
            }
            catch (JsonIOException | JsonSyntaxException | IOException exception) {
                Exmodifier.LOGGER.Logger.error("Failed to read language file: {}", (Object)file);
            }
        }
    }

    public static void putLanguage(String region, Map<String, String> lang) {
        Map<String, String> language = LANGUAGES.getOrDefault(region, Maps.newHashMap());
        language.putAll(lang);
        LANGUAGES.put(region, language);
    }

    public static Map<String, String> getLanguages(String region) {
        return LANGUAGES.get(region);
    }
}

