/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.difficult;

import java.util.List;
import net.exmo.exmodifier.Config;
import net.exmo.exmodifier.content.element.ExElementEntityData;
import net.exmo.exmodifier_compat.compat.L2HostilityCompat;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ExDifficultHelper {
    private static final double BALANCE_FACTOR = 5.0;
    private static final float BASE_HEALTH = 5.0f;
    private static final float BASE_ATTACK = 2.0f;
    private static final int HIGH_LEVEL_THRESHOLD = 20;
    private static final double HIGH_LEVEL_DECAY = 0.85;
    private static final double NEAR_DISTANCE = 64.0;
    private static final double TIER1_FACTOR = 12.0;
    private static final double TIER2_FACTOR = 1.2;
    private static final double TIER3_FACTOR = 0.8;

    public static int getEntityLevel(LivingEntity entity, boolean debug) {
        double rawLevel;
        double originalAttack;
        if (entity.m_9236_().f_46443_) {
            return 1;
        }
        ServerLevel level = (ServerLevel)entity.m_9236_();
        double health = entity.m_21051_(Attributes.f_22276_).m_22135_();
        ExElementEntityData.defAttribute defAttribute2 = ExElementEntityData.defaultEntityAttributes.get(entity.m_6095_());
        double baseHealth = entity instanceof Player ? (double)entity.m_21233_() : (defAttribute2 != null ? defAttribute2.MaxHealth() : (double)entity.m_21233_());
        double d = originalAttack = entity.m_21051_(Attributes.f_22281_) != null ? entity.m_21133_(Attributes.f_22281_) : 1.0;
        double baseAttack = entity instanceof Player ? entity.m_21133_(Attributes.f_22281_) : (defAttribute2 != null ? defAttribute2.AttackDamage() : (entity.m_21051_(Attributes.f_22281_) != null ? entity.m_21133_(Attributes.f_22281_) : 1.0));
        double adjustedAttack = Math.pow(originalAttack, 1.15);
        MinecraftServer server = level.m_7654_();
        if (Config.element_summon_debug && debug) {
            server.m_6846_().m_240416_((Component)Component.m_237113_((String)"[DEBUG] \u57fa\u7840\u8840\u91cf\uff1a%.1f | \u57fa\u7840\u653b\u51fb %.1f  | \u8840\u91cf: %.1f | \u539f\u59cb\u653b\u51fb: %.1f | \u8c03\u6574\u540e\u653b\u51fb: %.1f ".formatted(baseHealth, baseAttack, health, originalAttack, adjustedAttack)), false);
        }
        float healthFactor = (float)Math.max((double)0.1f, health / baseHealth);
        float attackFactor = Math.max(0.1f, (float)(adjustedAttack / baseAttack));
        double product = healthFactor * attackFactor;
        if (Config.element_summon_debug && debug) {
            server.m_6846_().m_240416_((Component)Component.m_237113_((String)"[DEBUG] \u6807\u51c6\u5316\u7cfb\u6570 | \u8840\u91cf\u7cfb\u6570: %.1f | \u653b\u51fb\u7cfb\u6570: %.1f | \u4e58\u79ef: %.1f".formatted(Float.valueOf(healthFactor), Float.valueOf(attackFactor), product)), false);
        }
        String stage = "";
        if (product <= 10000.0) {
            rawLevel = Math.pow(product, 0.7) * 12.0;
            stage = "\u5e38\u89c4\u9636\u6bb5";
        } else if (product <= 1000000.0) {
            rawLevel = Math.pow(product, 0.5) * 1.2;
            stage = "\u7cbe\u82f1\u9636\u6bb5";
        } else {
            rawLevel = Math.pow(product, 0.35) * 0.8;
            stage = "\u4e16\u754cBOSS\u9636\u6bb5";
        }
        if (Config.element_summon_debug && debug) {
            server.m_6846_().m_240416_((Component)Component.m_237113_((String)"[DEBUG] \u6210\u957f\u8ba1\u7b97 | \u9636\u6bb5: %s | \u57fa\u5e95\u503c: %.1f | \u589e\u5e45\u7cfb\u6570: %.1f".formatted(stage, Math.pow(product, ExDifficultHelper.getExponent(product)), ExDifficultHelper.getFactor(product))), false);
        }
        double preDecayLevel = rawLevel;
        if (rawLevel > 1000.0) {
            double over = rawLevel - 1000.0;
            rawLevel = 1000.0 + over * 0.6;
        }
        int finalLevel = (int)Math.max(1L, Math.min(50000L, Math.round(rawLevel)));
        if (Config.element_summon_debug && debug) {
            server.m_6846_().m_240416_((Component)Component.m_237113_((String)"[DEBUG] \u6700\u7ec8\u8ba1\u7b97 | \u8870\u51cf\u524d\u7b49\u7ea7: %.1f | \u8870\u51cf\u540e\u7b49\u7ea7: %.1f | \u6700\u7ec8\u7b49\u7ea7: %d".formatted(preDecayLevel, rawLevel, finalLevel)), false);
            server.m_213846_((Component)Component.m_237113_((String)"----------------------------------------"));
        }
        return finalLevel;
    }

    private static double getExponent(double product) {
        return product <= 10000.0 ? 0.7 : (product <= 1000000.0 ? 0.5 : 0.35);
    }

    private static double getFactor(double product) {
        return product <= 10000.0 ? 12.0 : (product <= 1000000.0 ? 1.2 : 0.8);
    }

    public static double getElementLevelMulti(LivingEntity livingEntity) {
        float difference;
        int modBoost = L2HostilityCompat.getDifficulty((LivingEntity)livingEntity);
        int mobLevel = modBoost != 0 ? modBoost : ExDifficultHelper.getEntityLevel(livingEntity, false);
        Level level = livingEntity.m_9236_();
        int playerCount = 0;
        int totalPlayerLevel = 0;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List nearbyPlayers = serverLevel.m_8795_(p -> p.m_20097_().m_252807_().m_82554_(livingEntity.m_20097_().m_252807_()) < 64.0);
            playerCount = nearbyPlayers.size();
            totalPlayerLevel = nearbyPlayers.stream().mapToInt(L2HostilityCompat::getPlayerDifficulty).sum();
        }
        int playerBoost = 0;
        if (playerCount > 0) {
            playerBoost = Math.round((float)totalPlayerLevel / (float)playerCount);
        }
        if (playerBoost > mobLevel) {
            gap = playerBoost - mobLevel;
            difference = 1.0f + gap / ((float)mobLevel + 10.0f);
        } else {
            gap = mobLevel - playerBoost;
            difference = 1.0f / (1.0f + gap / ((float)mobLevel + 10.0f));
        }
        double pow = Math.max(1.0, Math.pow(1.2, level.m_46791_().m_19028_() + 1));
        double finalMulti = pow * (double)difference;
        return finalMulti;
    }

    public static int getElementLevel(LivingEntity livingEntity) {
        int n;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            n = L2HostilityCompat.getPlayerDifficulty((Player)serverPlayer);
        } else {
            n = L2HostilityCompat.getDifficulty((LivingEntity)livingEntity);
        }
        int modBoost = n;
        int mobLevel = modBoost != 0 ? modBoost : ExDifficultHelper.getEntityLevel(livingEntity, true);
        int finalLevel = (int)Math.round((double)mobLevel * ExDifficultHelper.getElementLevelMulti(livingEntity));
        return Math.max(mobLevel / 2, Math.min(finalLevel, mobLevel * 2));
    }
}

