/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.dynamicAttributes;

import java.util.Objects;
import net.exmo.exmodifier.util.exSerialize.ExSerialize;
import net.minecraft.world.entity.ai.attributes.Attribute;

public final class DynamicAttribute
extends Attribute {
    public static final ExSerialize<DynamicAttribute> SERIALIZER = ExSerialize.create(() -> new DynamicAttribute("", new range(0.0, 0.0, 0.0))).withAutoId(dynamicAttribute -> dynamicAttribute.attributeId, (dynamicAttribute, attributeId) -> {
        dynamicAttribute.attributeId = attributeId;
    }).addStringField("attributeId", dynamicAttribute -> dynamicAttribute.attributeId, (dynamicAttribute, attributeId) -> {
        dynamicAttribute.attributeId = attributeId;
    }).addFloatMapField("range", (dynamicAttribute, range2) -> {
        dynamicAttribute.range = new range(((Float)range2.get("min")).floatValue(), ((Float)range2.get("max")).floatValue(), ((Float)range2.get("default")).floatValue());
    });
    private String attributeId;
    private range range;

    public DynamicAttribute(String attributeId, range range2) {
        super(attributeId, range2.defaultValue);
        this.attributeId = attributeId;
        this.range = range2;
    }

    public String translationID() {
        return "exmodifier.attribute." + this.attributeId;
    }

    public String attributeId() {
        return this.attributeId;
    }

    public range range() {
        return this.range;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        DynamicAttribute that = (DynamicAttribute)((Object)obj);
        return Objects.equals(this.attributeId, that.attributeId) && Objects.equals(this.range, that.range);
    }

    public int hashCode() {
        return Objects.hash(this.attributeId, this.range);
    }

    public String toString() {
        return "DynamicAttribute[attributeId=" + this.attributeId + ", range=" + String.valueOf(this.range) + "]";
    }

    public record range(double min, double max, double defaultValue) {
    }
}

