/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.element;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.exmo.exmodifier.content.element.ExElementInstant;
import net.exmo.exmodifier.util.exSerialize.ExSerialize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class DefaultEntityElement {
    public static final ExSerialize<DefaultEntityElement> SERIALIZER = ExSerialize.create(() -> new DefaultEntityElement(null, new ArrayList<ExElementInstant>())).withAutoId(DefaultEntityElement::getEntityTypeString, DefaultEntityElement::setEntityType).addStringField("entityType", DefaultEntityElement::getEntityTypeString, DefaultEntityElement::setEntityType).addJsonObjectList("entries", DefaultEntityElement::getExElementInstantsString, DefaultEntityElement::setExElementInstantsString);
    private EntityType<?> entityType;
    private List<ExElementInstant> exElementInstants;

    private List<JsonObject> getExElementInstantsString() {
        return this.exElementInstants.stream().map(ExElementInstant.EX_SERIALIZE::toSingleJson).toList();
    }

    private void setExElementInstantsString(List<JsonObject> configs) {
        configs.forEach(config -> {
            ExElementInstant instants = ExElementInstant.EX_SERIALIZE.fromJsonSingle((JsonObject)config);
            this.exElementInstants.add(instants);
        });
    }

    private void setEntityType(String s) {
        Optional entityType = EntityType.m_20632_((String)s);
        entityType.ifPresent(type2 -> {
            this.entityType = type2;
        });
    }

    public List<ExElementInstant> getExElementInstants() {
        return this.exElementInstants;
    }

    public DefaultEntityElement setExElementInstants(List<ExElementInstant> exElementInstants) {
        this.exElementInstants = exElementInstants;
        return this;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public String getEntityTypeString() {
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey(this.entityType);
        if (key == null) {
            return "";
        }
        return key.toString();
    }

    public DefaultEntityElement setEntityType(EntityType<?> entityType) {
        this.entityType = entityType;
        return this;
    }

    public DefaultEntityElement(EntityType<?> entityType, List<ExElementInstant> exElementInstants) {
        this.entityType = entityType;
        this.exElementInstants = exElementInstants;
    }

    public EntityType<?> entityType() {
        return this.entityType;
    }

    public List<ExElementInstant> exElementInstants() {
        return this.exElementInstants;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultEntityElement that = (DefaultEntityElement)obj;
        return Objects.equals(this.entityType, that.entityType) && Objects.equals(this.exElementInstants, that.exElementInstants);
    }

    public int hashCode() {
        return Objects.hash(this.entityType, this.exElementInstants);
    }

    public String toString() {
        return "DefaultEntityElement[entityType=" + String.valueOf(this.entityType) + ", exElementInstants=" + String.valueOf(this.exElementInstants) + "]";
    }
}

