/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.element;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonElement;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.exmo.exmodifier.Config;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.difficult.ExDifficultHelper;
import net.exmo.exmodifier.content.dynamicAttributes.DynamicAttribute;
import net.exmo.exmodifier.content.dynamicAttributes.DynamicAttributeRegister;
import net.exmo.exmodifier.content.element.DefaultEntityElement;
import net.exmo.exmodifier.content.element.DefaultItemElement;
import net.exmo.exmodifier.content.element.ExElement;
import net.exmo.exmodifier.content.element.ExElementInstant;
import net.exmo.exmodifier.content.helper.ExElementHelper;
import net.exmo.exmodifier.content.helper.entity.ExElementEntityHelper;
import net.exmo.exmodifier.content.modifier.MoConfig;
import net.exmo.exmodifier.events.ElementDamageEvent;
import net.exmo.exmodifier.events.OnElementRegisterEvent;
import net.exmo.exmodifier.init.ExAttribute;
import net.exmo.exmodifier.network.DamageNumberCompatMessage;
import net.exmo.exmodifier.util.ExConfigHandle;
import net.exmo.exmodifier.util.ItemSelector;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.PacketDistributor;

public class ExElementHandle {
    public static Map<ResourceLocation, ExElement> exElements = new HashMap<ResourceLocation, ExElement>();
    public static List<MoConfig> FoundElementConfigs = new ArrayList<MoConfig>();
    public static final Path ElementConfigPath = FMLPaths.CONFIGDIR.get().resolve("exmo/elements/");
    public static Cache<DamageSource, List<ExElementInstant>> cache = CacheBuilder.newBuilder().build();
    public static final Map<ItemSelector, DefaultItemElement> elementDefaultMap = new HashMap<ItemSelector, DefaultItemElement>();
    public static final Map<EntityType<?>, DefaultEntityElement> elementDefaultMap2 = new HashMap();
    public static final List<MoConfig> FoundDefaultElementConfigs = new ArrayList<MoConfig>();
    public static final List<MoConfig> FoundEntityDefaultElementConfigs = new ArrayList<MoConfig>();
    public static final Path DefaultElementConfigPath = FMLPaths.CONFIGDIR.get().resolve("exmo/default_elements/");
    public static final Path DefaultEntityElementConfigPath = FMLPaths.CONFIGDIR.get().resolve("exmo/default_entity_elements/");

    public static Optional<List<ExElementInstant>> getExElementInstant(DamageSource source) {
        return Optional.ofNullable((List)cache.getIfPresent((Object)source));
    }

    public static void registryExElement(ExElement exElement) {
        exElements.put(exElement.getResId(), exElement);
        for (ElementAttributeName elementAttributeName : ElementAttributeName.values()) {
            DynamicAttributeRegister.registerDynamicAttribute(new DynamicAttribute(new elementAttributeSer(exElement.getResId().toString(), elementAttributeName.name).gather(), new DynamicAttribute.range(0.0, Double.MAX_VALUE, 0.0)));
        }
        Exmodifier.LOGGER.info("Registry ExElement: " + String.valueOf(exElement.getResId()));
    }

    public static ExElement getExElement(ResourceLocation id) {
        return exElements.get(id);
    }

    public static ExElement getExElement(String id) {
        ExElement exElement = exElements.get(new ResourceLocation(id));
        return exElement;
    }

    public static Map<ResourceLocation, ExElement> getExElements() {
        return exElements;
    }

    public static void init() throws IOException {
        MinecraftForge.EVENT_BUS.post((Event)new OnElementRegisterEvent());
        if (Files.exists(ElementConfigPath, new LinkOption[0])) {
            long startTime = System.nanoTime();
            FoundElementConfigs = ExConfigHandle.listFiles(ElementConfigPath);
            for (MoConfig moconfig : FoundElementConfigs) {
                ExElementHandle.processMoConfigEntries(moconfig);
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            Exmodifier.LOGGER.debug("ReadConfig Quality Over time: " + duration / 1000000L + " ms");
        }
    }

    public static void processMoConfigEntries(MoConfig moconfig) throws FileNotFoundException {
        if (moconfig.readEntrys().isEmpty()) {
            Exmodifier.LOGGER.info("No Element Config Found");
            return;
        }
        List<ExElement> elements = ExElement.EX_SERIALIZE.fromJson(moconfig.jsonObject);
        elements.forEach(ExElementHandle::registryExElement);
    }

    public static void init2() throws IOException {
        if (Files.exists(DefaultElementConfigPath, new LinkOption[0])) {
            FoundDefaultElementConfigs.addAll(ExConfigHandle.listFiles(DefaultElementConfigPath));
            for (MoConfig config : FoundDefaultElementConfigs) {
                ExElementHandle.processMoConfigEntries2(config);
            }
        }
    }

    public static void init3() throws IOException {
        if (Files.exists(DefaultEntityElementConfigPath, new LinkOption[0])) {
            FoundEntityDefaultElementConfigs.addAll(ExConfigHandle.listFiles(DefaultEntityElementConfigPath));
            for (MoConfig config : FoundEntityDefaultElementConfigs) {
                ExElementHandle.processMoConfigEntries3(config);
            }
        }
    }

    public static void processMoConfigEntries2(MoConfig moconfig) throws FileNotFoundException {
        if (moconfig.readEntrys().isEmpty()) {
            Exmodifier.LOGGER.info("No Default Element Config Found: " + String.valueOf(moconfig.configFile));
            return;
        }
        for (DefaultItemElement read : DefaultItemElement.EX_SERIALIZE.fromJson(moconfig.jsonObject)) {
            if (read.getItemSelector() == null) continue;
            elementDefaultMap.put(read.getItemSelector(), read);
        }
    }

    public static void processMoConfigEntries3(MoConfig moconfig) throws FileNotFoundException {
        if (moconfig.readEntrys().isEmpty()) {
            Exmodifier.LOGGER.info("No Entity Default Element Config Found: " + String.valueOf(moconfig.configFile));
            return;
        }
        for (DefaultEntityElement read : DefaultEntityElement.SERIALIZER.fromJson(moconfig.jsonObject)) {
            if (read.getEntityTypeString().isEmpty()) continue;
            elementDefaultMap2.put(read.getEntityType(), read);
        }
    }

    private static void processEntityElementDefaultConfigEntry(Map.Entry<String, JsonElement> entry) {
    }

    private static void processElementDefaultConfigEntry(Map.Entry<String, JsonElement> entry) {
    }

    public static List<ExElementInstant> getDefaultElements(ItemStack stack) {
        return elementDefaultMap.entrySet().stream().filter(entry -> ((ItemSelector)entry.getKey()).compare(stack)).flatMap(entry -> ((DefaultItemElement)entry.getValue()).getExElementInstants().stream()).collect(Collectors.toList());
    }

    public static List<ItemSelector> getItemSelector(ItemStack stack) {
        return elementDefaultMap.keySet().stream().filter(entry -> entry != null && entry.compare(stack)).toList();
    }

    static enum ElementAttributeName {
        DAMAGE("damage"),
        ELEMENT_ATTRIBUTE("elementAttribute");

        String name;

        private ElementAttributeName(String name) {
            this.name = name;
        }
    }

    record elementAttributeSer(String elementName, String modifier) {
        public String gather() {
            return this.elementName + "::" + this.modifier;
        }

        public static elementAttributeSer fromString(String str) {
            String[] split = str.split("::");
            return new elementAttributeSer(split[0], split[1]);
        }
    }

    @Mod.EventBusSubscriber
    public static class CommonEvent {
        static final float LEVEL_FACTOR = 5000.0f;
        static final float POWER_SCALE = 0.85f;
        static final float MIN_EFFECT = 0.1f;

        @SubscribeEvent
        public static void registerNormal(OnElementRegisterEvent elementRegisterEvent) {
            ResourceLocation id = ResourceLocation.m_135820_((String)"exmodifier:normal");
            if (ExElementHandle.getExElement(id) == null) {
                elementRegisterEvent.registerElement(new ExElement(id).setColor(Color.WHITE.getRGB()).setRestrain(new HashMap<String, Float>()));
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onHurt(LivingDamageEvent event) {
            if (event.getSource().m_276093_(DamageTypes.f_286979_)) {
                return;
            }
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ItemStack mainHandItem = livingEntity.m_21205_();
                if (mainHandItem.m_41782_()) {
                    List<ExElementInstant> elements = ExElementHelper.of(mainHandItem).getElements();
                    if (!elements.isEmpty()) {
                        cache.put((Object)event.getSource(), elements);
                        if (livingEntity instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                            ExElementInstant exElementInstant = elements.get(0);
                            Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new DamageNumberCompatMessage(exElementInstant.getElement().getColor()));
                        }
                        MinecraftForge.EVENT_BUS.post((Event)new ElementDamageEvent(event.getEntity(), event.getSource(), event.getAmount(), elements));
                    } else if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                        Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new DamageNumberCompatMessage(-1));
                    }
                } else if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new DamageNumberCompatMessage(-1));
                }
            }
        }

        public static float getArmorResistance(LivingEntity entity, ExElementInstant attackElement) {
            float totalResistance = 0.0f;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ExElementHelper elementHelper;
                ItemStack itemStack = entity.m_6844_(slot);
                if (itemStack.m_41619_() || (elementHelper = ExElementHelper.of(itemStack)).getElements().isEmpty()) continue;
                for (ExElementInstant armorElement : elementHelper.getElements()) {
                    float elementResist = armorElement.getElement().getRestrain().getOrDefault(attackElement.getElement().getResId().toString(), Float.valueOf(1.0f)).floatValue();
                    float resistance = (float)(Math.log1p((double)armorElement.getLevel() / 500.0) * (double)elementResist * (double)0.12f);
                    totalResistance = Math.min(totalResistance + resistance, 0.75f);
                }
            }
            return totalResistance;
        }

        public static float calculateDominanceEffect(Float baseMultiplier, float dominancePower, int attackerLevel) {
            float levelBonus = (float)Math.log1p((float)attackerLevel / 5000.0f);
            float adjustedBase = baseMultiplier.floatValue() < 1.0f ? (float)Math.pow(baseMultiplier.floatValue(), 0.6f) : baseMultiplier.floatValue();
            float exponent = dominancePower * (1.0f + levelBonus * 0.3f);
            float rawEffect = (float)Math.pow(adjustedBase, exponent);
            float scaledEffect = (float)Math.pow(rawEffect, 1.15f);
            if (baseMultiplier.floatValue() < 1.0f) {
                float compensation = 0.5f * (1.0f + scaledEffect);
                scaledEffect = Math.max(scaledEffect, compensation);
            }
            return (float)Math.pow(Math.max(0.1f, scaledEffect * 0.85f), 1.2f);
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void onHurtOver(LivingDamageEvent event) {
            if (event.getSource().m_276093_(DamageTypes.f_286979_)) {
                return;
            }
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity) {
                ExElementInstant exElementInstant;
                LivingEntity livingEntity = (LivingEntity)entity;
                ItemStack mainHandItem = livingEntity.m_21205_();
                List<Object> elements = new ArrayList();
                if (mainHandItem.m_41782_()) {
                    elements = ExElementHelper.of(mainHandItem).getElements();
                } else {
                    List<ExElementInstant> exElementInstants1 = ExElementEntityHelper.of(livingEntity).getExElementInstants();
                    if (!exElementInstants1.isEmpty()) {
                        elements = exElementInstants1;
                    }
                }
                if (elements.isEmpty()) {
                    elements = List.of(new ExElementInstant(exElements.get(ResourceLocation.m_135820_((String)"exmodifier:normal")), ExDifficultHelper.getElementLevel(livingEntity)));
                }
                if ((exElementInstant = (ExElementInstant)elements.get(0)) == null) {
                    return;
                }
                LivingEntity target = event.getEntity();
                ExElementEntityHelper exElementEntityHelper = ExElementEntityHelper.of(target);
                List<ExElementInstant> exElementInstants = exElementEntityHelper.getExElementInstants();
                if (exElementInstants.isEmpty()) {
                    return;
                }
                Level level = livingEntity.m_9236_();
                if (level instanceof ServerLevel) {
                    ParticleType<?> simpleParticleType;
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (exElementInstant.getElement() != null && exElementInstant.getElement().getSimpleParticleType() != null && exElementInstant.getElement().getParticleScale() != 0.0f && (simpleParticleType = exElementInstant.getElement().getSimpleParticleType()) != null && simpleParticleType instanceof SimpleParticleType) {
                        SimpleParticleType simpleParticleType1 = (SimpleParticleType)simpleParticleType;
                        float particleScale = exElementInstant.getElement().getParticleScale();
                        serverLevel.m_8767_((ParticleOptions)simpleParticleType1, target.m_20185_(), target.m_20186_() + (double)target.m_20192_() * 0.5, target.m_20189_(), 5, (double)particleScale, (double)particleScale, (double)particleScale, 0.25);
                    }
                }
                float conversion_rate = 120.0f;
                float resistance_base = 300.0f;
                float dominance_power = 0.7f;
                float overkill_ratio = 0.25f;
                if (livingEntity.m_21204_().m_22171_((Attribute)ExAttribute.ELEMENT_CONVERSION_COEFFICIENT.get())) {
                    conversion_rate = Math.max((float)livingEntity.m_21133_((Attribute)ExAttribute.ELEMENT_CONVERSION_COEFFICIENT.get()) * 80.0f, 0.0f);
                }
                if (target.m_21204_().m_22171_((Attribute)ExAttribute.ELEMENT_RESISTANCE_COEFFICIENT.get())) {
                    resistance_base = Math.max((float)target.m_21133_((Attribute)ExAttribute.ELEMENT_RESISTANCE_COEFFICIENT.get()) * 80.0f, 0.0f);
                }
                if (!exElementInstants.isEmpty()) {
                    float attackFactor;
                    Map<Object, Object> restrain;
                    ExElementInstant el = exElementInstants.get(0);
                    int attackerLevel = exElementInstant.getLevel();
                    int targetLevel = el.getLevel();
                    float armorResistance = CommonEvent.getArmorResistance(target, exElementInstant);
                    if (exElementInstant.getElement() == null) {
                        return;
                    }
                    Map<Object, Object> map = restrain = exElementInstant.getElement() == null ? new HashMap() : exElementInstant.getElement().getRestrain();
                    if (el.getElement() == null) {
                        return;
                    }
                    if (restrain == null) {
                        restrain = new HashMap();
                    }
                    Float baseMultiplier = restrain.getOrDefault(el.getElement().getResId().toString(), Float.valueOf(1.0f));
                    float dominanceEffect = CommonEvent.calculateDominanceEffect(baseMultiplier, dominance_power, attackerLevel);
                    float conversion_ratio = conversion_rate / 120.0f;
                    float attackBase = (float)attackerLevel * conversion_ratio;
                    if (attackBase <= 800.0f) {
                        attackFactor = 1.0f + attackBase * 0.3f;
                    } else if (attackBase <= 8000.0f) {
                        float logGrowth = (float)Math.log1p(attackBase - 800.0f) * 1.5f;
                        attackFactor = 241.0f + logGrowth;
                    } else {
                        float baseValue = 241.0f + (float)Math.log(7200.0) * 1.5f;
                        float additional = (float)Math.pow(attackBase - 8000.0f, 0.5);
                        attackFactor = baseValue + additional;
                    }
                    if (attackerLevel > 50 * targetLevel) {
                        float overkill = (float)Math.log10((float)attackerLevel / ((float)targetLevel + 1.0f));
                        float overkillBoost = overkill_ratio * (1.0f + conversion_ratio * 0.08f);
                        attackFactor *= 1.0f + Math.min(overkill, 2.5f) * overkillBoost;
                    }
                    float defenseFactor = 1.0f + (float)Math.pow((float)targetLevel * resistance_base / 800.0f, 0.75);
                    ElementDamageCalculator.CalculationResult result = Config.useNewDamageFormula ? ElementDamageCalculator.calculateNewDamage(attackFactor, defenseFactor, dominanceEffect, armorResistance) : ElementDamageCalculator.calculateLegacyDamage(dominanceEffect, attackFactor, defenseFactor, armorResistance);
                    float amount = event.getAmount() * result.finalMultiplier;
                    if (Config.element_debug) {
                        String analysis = String.format("[\u5143\u7d20\u4f24\u5bb3\u5206\u6790][%s]\n\u538b\u5236\u7cfb\u7edf\uff1a\n\u21b3 \u514b\u5236\u5173\u7cfb: %s \u2192 %s \u57fa\u7840\u7cfb\u6570: %.2f\n\u21b3 \u6700\u7ec8\u538b\u5236\u6548\u679c: %.2f\n\u5f3a\u5ea6\u7cfb\u7edf\uff1a\n\u21b3 \u653b\u51fb\u5f3a\u5ea6: %.1f | \u9632\u5fa1\u5f3a\u5ea6: %.1f \u2192 \u5f3a\u5ea6\u6bd4: %.2f\n\u21b3 \u8ba1\u7b97\u516c\u5f0f: %s\n\u6297\u6027\u7cfb\u7edf\uff1a\n\u21b3 \u62a4\u7532\u51cf\u4f24: %.1f%%\n\u6700\u7ec8\u8ba1\u7b97\uff1a\n\u21b3 \u57fa\u7840\u500d\u7387: %.2f\n\u21b3 \u62a4\u7532\u51cf\u4f24\u7cfb\u6570: (1 - %.1f%%) \u2192 %.2f\n\u21b3 \u6700\u7ec8\u500d\u7387: %.2f \u00d7 %.2f = %.2f\n\u6700\u7ec8\u4f24\u5bb3: %.1f \u2192 %.1f\n", result.version, exElementInstant.getElement().getResId(), el.getElement().getResId(), baseMultiplier, Float.valueOf(result.dominanceEffect), Float.valueOf(result.attackIntensity), Float.valueOf(result.defenseIntensity), Float.valueOf(result.ratio), result.formulaDesc, Float.valueOf(result.armorResistance * 100.0f), Float.valueOf(result.dominanceEffect), Float.valueOf(result.armorResistance * 100.0f), Float.valueOf(1.0f - result.armorResistance), Float.valueOf(result.dominanceEffect), Float.valueOf(1.0f - result.armorResistance), Float.valueOf(result.finalMultiplier), Float.valueOf(event.getAmount()), Float.valueOf(amount));
                        livingEntity.m_213846_((Component)Component.m_237113_((String)analysis));
                    }
                    event.setAmount(amount);
                } else {
                    float armorResistance = CommonEvent.getArmorResistance(target, exElementInstant);
                    event.setAmount(event.getAmount() * Math.max(0.15f, 1.0f - armorResistance));
                }
                cache.invalidate((Object)event.getSource());
            }
        }

        public static class ElementDamageCalculator {
            public static CalculationResult calculateLegacyDamage(float dominanceEffect, float attackFactor, float defenseFactor, float armorResistance) {
                float baseMultiplier = dominanceEffect * attackFactor / defenseFactor;
                float finalMultiplier = baseMultiplier * (1.0f - armorResistance);
                finalMultiplier = Math.max(0.01f, finalMultiplier);
                return new CalculationResult(finalMultiplier, attackFactor, defenseFactor, attackFactor / defenseFactor, "\u65e7\u7248\u516c\u5f0f\uff1a\u538b\u5236\u7cfb\u6570\u00d7(\u653b\u51fb\u56e0\u5b50/\u9632\u5fa1\u56e0\u5b50)", dominanceEffect, armorResistance, "LEGACY");
            }

            public static CalculationResult calculateNewDamage(float attackFactor, float defenseFactor, float dominanceEffect, float armorResistance) {
                float baseMultiplier;
                float attackIntensity = attackFactor;
                float defenseIntensity = defenseFactor;
                float ratio = attackIntensity / defenseIntensity;
                String formulaUsed = "";
                if (ratio > 0.8f && ratio < 1.25f) {
                    baseMultiplier = dominanceEffect * ratio;
                    formulaUsed = "\u65b0\u7248-\u5e73\u8861\u533a\u95f4\uff1a\u538b\u5236\u7cfb\u6570\u00d7(\u653b\u51fb/\u9632\u5fa1)";
                } else if (ratio >= 0.6667f && ratio <= 0.8f) {
                    baseMultiplier = dominanceEffect * ((float)Math.pow(ratio, 2.0) + 0.16f);
                    formulaUsed = "\u65b0\u7248-\u5f31\u52bf\u533a\u95f4\uff1a\u538b\u5236\u7cfb\u6570\u00d7[(\u653b\u51fb/\u9632\u5fa1)^2+0.16]";
                } else if (ratio >= 1.25f && ratio <= 1.5f) {
                    baseMultiplier = dominanceEffect * ((float)Math.sqrt(ratio) + 0.132f);
                    formulaUsed = "\u65b0\u7248-\u4f18\u52bf\u533a\u95f4\uff1a\u538b\u5236\u7cfb\u6570\u00d7[\u221a(\u653b\u51fb/\u9632\u5fa1)+0.132]";
                } else if (ratio < 0.6667f) {
                    baseMultiplier = dominanceEffect * (0.15f * ratio + 0.5f);
                    formulaUsed = "\u65b0\u7248-\u7edd\u5bf9\u5f31\u52bf\uff1a\u538b\u5236\u7cfb\u6570\u00d7(0.15*(\u653b\u51fb/\u9632\u5fa1)+0.5)";
                } else {
                    baseMultiplier = dominanceEffect * 0.15f * (10.0f - 1.0f / ratio);
                    formulaUsed = "\u65b0\u7248-\u7edd\u5bf9\u4f18\u52bf\uff1a\u538b\u5236\u7cfb\u6570\u00d70.15\u00d7(10-1/(\u653b\u51fb/\u9632\u5fa1))";
                }
                float finalMultiplier = baseMultiplier * (1.0f - armorResistance);
                finalMultiplier = Math.max(0.01f, finalMultiplier);
                return new CalculationResult(finalMultiplier, attackFactor, defenseFactor, ratio, formulaUsed, dominanceEffect, armorResistance, "NEW");
            }

            public record CalculationResult(float finalMultiplier, float attackIntensity, float defenseIntensity, float ratio, String formulaDesc, float dominanceEffect, float armorResistance, String version) {
            }
        }
    }
}

