/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.event;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.script.ScriptException;
import net.exmo.exmodifier.Config;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.commands.ExModifierReloadCommand;
import net.exmo.exmodifier.content.client.LanguageLoader;
import net.exmo.exmodifier.content.element.DefaultEntityElement;
import net.exmo.exmodifier.content.element.DefaultEntityPreparableReloadListener;
import net.exmo.exmodifier.content.element.DefaultItemElement;
import net.exmo.exmodifier.content.element.DefaultItemPreparableReloadListener;
import net.exmo.exmodifier.content.element.ElementPreparableReloadListener;
import net.exmo.exmodifier.content.element.ExElement;
import net.exmo.exmodifier.content.element.ExElementEntityData;
import net.exmo.exmodifier.content.element.ExElementHandle;
import net.exmo.exmodifier.content.event.parameter.EventParameter;
import net.exmo.exmodifier.content.helper.ItemInfo;
import net.exmo.exmodifier.content.helper.ItemLevelHelper;
import net.exmo.exmodifier.content.helper.ModifierEntryHelper;
import net.exmo.exmodifier.content.helper.ModifierSlotHelper;
import net.exmo.exmodifier.content.level.ItemLevelHandle;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.content.modifier.ModifierInstant;
import net.exmo.exmodifier.content.modifier.ModifierPreparableReloadListener;
import net.exmo.exmodifier.content.modifier.RefreshContainItemHandle;
import net.exmo.exmodifier.content.modifier.RefreshContainTagHandle;
import net.exmo.exmodifier.content.modifier.WashingMaterialsPreparableReloadListener;
import net.exmo.exmodifier.content.quality.ItemQualityHandle;
import net.exmo.exmodifier.content.resources.ZipHandle;
import net.exmo.exmodifier.content.selected.BaseItemSelected;
import net.exmo.exmodifier.content.slot.ModifierSlotHandle;
import net.exmo.exmodifier.content.suit.ExSuit;
import net.exmo.exmodifier.content.suit.ExSuitHandle;
import net.exmo.exmodifier.content.suit.ExSuitPreparableReloadListener;
import net.exmo.exmodifier.content.type.ExType;
import net.exmo.exmodifier.content.type.ExTypeHandle;
import net.exmo.exmodifier.events.ExAfterArmorChange;
import net.exmo.exmodifier.events.ExApplyEntryAttrigetherEvent;
import net.exmo.exmodifier.events.ExApplySuitAttrigetherEvent;
import net.exmo.exmodifier.events.ExApplySuitEffectEvent;
import net.exmo.exmodifier.events.ExDodgeEvent;
import net.exmo.exmodifier.events.ExSuitApplyOnChangeEvent;
import net.exmo.exmodifier.events.LivingPlayerSwimEvent;
import net.exmo.exmodifier.events.LivingSwingEvent;
import net.exmo.exmodifier.network.ExModifiervaV;
import net.exmo.exmodifier.network.sync.lang.LangMessage;
import net.exmo.exmodifier.util.AttributeCuriosHandle;
import net.exmo.exmodifier.util.CuriosUtil;
import net.exmo.exmodifier.util.DynamicExpressionEvaluator;
import net.exmo.exmodifier.util.EntityAttrUtil;
import net.exmo.exmodifier.util.ExAttributeModifier;
import net.exmo.exmodifier.util.ExUtil;
import net.exmo.exmodifier.util.gether.AttriGetherNormal;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.GrindstoneEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;
import top.theillusivec4.curios.api.event.CurioChangeEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MainEvent {
    public static void sendExmoServerDataToServerPlayer(ServerPlayer entity, DataCache dataCache) {
        List<ExSuit> exSuits = dataCache.exSuits();
        for (ExSuit exSuit : exSuits) {
            ModifierHandle.sendExSuitToClient(exSuit, entity);
        }
        List<ModifierEntry> modifierEntries = dataCache.modifierEntries();
        for (ModifierEntry modifierEntry : modifierEntries) {
            ModifierHandle.sendModifierEntryToClient(modifierEntry, entity);
        }
        List<ExElement> list = dataCache.exElements();
        for (ExElement exElement : list) {
            ModifierHandle.sendElementToClient(exElement, entity);
        }
        List<DefaultItemElement> list2 = dataCache.defaultItemElements();
        for (DefaultItemElement defaultItemElement : list2) {
            ModifierHandle.sendDefaultItemElementToClient(defaultItemElement, entity);
        }
        List<DefaultEntityElement> list3 = dataCache.defaultEntityElements();
        for (DefaultEntityElement e : list3) {
            ModifierHandle.sendDefaultEntityElementToClient(e, entity);
        }
        LangMessage.LangMessageHandler langMessageHandler = dataCache.langMessageHandler;
        ModifierHandle.sendLangMessageToClient(langMessageHandler, entity);
    }

    public static void clearOldData() {
        ExSuitHandle.LoadExSuit.clear();
        ExElementEntityData.defaultEntityAttributes.clear();
        LanguageLoader.LANGUAGES.clear();
        ModifierHandle.modifierEntryMap.clear();
        ExTypeHandle.itemTypes.values().removeIf(e -> !ExType.defaultTypes.contains(e.name()));
        ItemLevelHandle.ItemLevels.clear();
        ModifierHandle.onlyCanRefreshPointEntryItemIds.clear();
        ModifierHandle.cantWashItemIds.clear();
        ExElementHandle.elementDefaultMap.clear();
        ExElementHandle.elementDefaultMap2.clear();
        ExElementHandle.exElements.clear();
        ModifierHandle.itemsDefaultEntry.clear();
        ModifierHandle.materialsList.clear();
        ModifierSlotHandle.registerSlots.clear();
        ModifierSlotHandle.unLockSlotItems.clear();
        ItemQualityHandle.itemQualityMap.clear();
        ItemQualityHandle.itemDefaultQualityMap.clear();
        MainEvent.clearReadTempData();
    }

    public static void clearReadTempData() {
        ModifierHandle.Foundmoconfigs.clear();
        ItemLevelHandle.Foundlvconfigs.clear();
        ExSuitHandle.FoundSuitConfigs.clear();
        ItemQualityHandle.FoundQualityConfigs.clear();
        ItemQualityHandle.FoundDefaultQualityConfigs.clear();
        ExTypeHandle.FoundTypeConfigs.clear();
        ExElementHandle.FoundElementConfigs.clear();
        ExElementHandle.FoundEntityDefaultElementConfigs.clear();
        ExElementHandle.FoundDefaultElementConfigs.clear();
    }

    public record DataCache(List<ExSuit> exSuits, List<ModifierEntry> modifierEntries, List<ExElement> exElements, List<DefaultItemElement> defaultItemElements, List<DefaultEntityElement> defaultEntityElements, LangMessage.LangMessageHandler langMessageHandler) {
        public static DataCache create() {
            return new DataCache(new ArrayList<ExSuit>(ExSuitHandle.LoadExSuit.values()), new ArrayList<ModifierEntry>(ModifierHandle.modifierEntryMap.values()), new ArrayList<ExElement>(ExElementHandle.exElements.values()), new ArrayList<DefaultItemElement>(ExElementHandle.elementDefaultMap.values()), new ArrayList<DefaultEntityElement>(ExElementHandle.elementDefaultMap2.values()), new LangMessage.LangMessageHandler(LanguageLoader.LANGUAGES));
        }
    }

    @Mod.EventBusSubscriber
    public static class CommonEvent {
        public static List<String> UnMatchingModIDs = new ArrayList<String>();
        public static float damageBoost;
        public static float damageNumber;
        public static boolean hasDamageBoost;
        public static boolean hasDamageNumber;

        @SubscribeEvent
        public static void CuriosChange(CurioChangeEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = event.getTo();
            for (String s : UnMatchingModIDs) {
                if (!ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString().startsWith(s)) continue;
                return;
            }
            ModifierEntryHelper modifierEntryHelper = ModifierEntryHelper.of(stack);
            if (stack.m_41783_() == null || modifierEntryHelper.getModifierEntriesSize() <= 0) {
                ModifierHandle.CommonEvent.RandomEntryCurios(stack, 0, Config.refresh_time, "none");
            }
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("modifier_refresh") && stack.m_41783_().m_128471_("modifier_refresh")) {
                stack.m_41783_().m_128473_("modifier_refresh");
                stack.m_41783_().m_128473_("UNKNOWN");
                ModifierHandle.CommonEvent.RandomEntryCurios(stack, stack.m_41784_().m_128451_("modifier_refresh_rarity"), stack.m_41784_().m_128451_("modifier_refresh_add"), stack.m_41783_().m_128461_("wash_item"));
                AttributeCuriosHandle.handleCurios(new CurioChangeEvent((LivingEntity)player, event.getIdentifier(), event.getSlotIndex(), event.getFrom(), stack));
            }
            CommonEvent.SuitOperate(player, event.getTo(), event.getFrom());
        }

        @SubscribeEvent
        public static void iLevelAttriGetherModifier(ExApplyEntryAttrigetherEvent event) {
            if (event.attriGether.Expression != null && !event.attriGether.Expression.isEmpty()) {
                ItemStack stack = event.stack;
                ExAttributeModifier modifier = event.attriGether.getModifier();
                int level = event.modifierInstant.getLevel();
                Exmodifier.LOGGER.debug("iLevelAttriGetherModifier: " + event.attriGether.Expression + " level: " + level);
                DynamicExpressionEvaluator dynamicExpressionEvaluator = new DynamicExpressionEvaluator();
                dynamicExpressionEvaluator.setVariable("level", level);
                dynamicExpressionEvaluator.setVariable("l", level);
                double amount = dynamicExpressionEvaluator.evaluate(event.attriGether.Expression);
                event.attriGether.modifier.setAmount(amount);
            }
        }

        public static Pair<List<Component>, Integer> EntryInfoTooltip(ItemStack stack, List<Component> tooltip, Player player) {
            if (stack.m_41783_() != null) {
                ModifierEntryHelper modifierEntryHelper = ModifierEntryHelper.of(stack);
                if (stack.m_41783_().m_128471_("UNKNOWN")) {
                    tooltip.add((Component)Component.m_237115_((String)"null"));
                    tooltip.add((Component)Component.m_237115_((String)"modifier.entry.UNKNOWN"));
                } else {
                    if (modifierEntryHelper.getModifierEntriesSize() > 0) {
                        for (ModifierInstant modifierEntry : new ItemInfo(stack).getModifierEntryHelper().getModifierEntries()) {
                            if (modifierEntry.getSlot().isPresent()) continue;
                            if (!Config.compact_tooltip) {
                                tooltip.add((Component)Component.m_237115_((String)"null"));
                            }
                            tooltip.addAll(ModifierHandle.CommonEvent.generateEntryTooltip(modifierEntry, player, stack, false));
                        }
                    }
                    if (stack.m_41783_().m_128471_("can_add_max")) {
                        tooltip.add((Component)Component.m_237115_((String)"modifier.entry.can_add_max"));
                    }
                }
            }
            return new Pair(tooltip, (Object)tooltip.size());
        }

        @SubscribeEvent
        public static void AtJoinGame(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            player.getCapability(ExModifiervaV.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                Map<String, Integer> map = capability.SuitsNum;
                capability.SuitsNum = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> 0));
                capability.syncPlayerVariables((Entity)player);
            });
        }

        @SubscribeEvent
        public static void OutGame(PlayerEvent.PlayerLoggedOutEvent event) {
        }

        public static void ApplySuitEffect(Player player, ExSuit.Trigger trigger) {
            if (player == null) {
                return;
            }
            if (player.m_9236_().f_46443_) {
                return;
            }
            player.getCapability(ExModifiervaV.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                CommandSourceStack commandSourceStack;
                ArrayList mobEffectsToAdd = new ArrayList();
                Level patt12860$temp = player.m_9236_();
                if (patt12860$temp instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt12860$temp;
                    commandSourceStack = new CommandSourceStack(CommandSource.f_80164_, player.m_20182_(), player.m_20155_(), serverLevel, 4, player.m_7755_().getString(), player.m_5446_(), serverLevel.m_7654_(), (Entity)player);
                } else {
                    commandSourceStack = null;
                }
                Map<String, Integer> suitsNum = capability.SuitsNum;
                for (Map.Entry<String, Integer> entry : suitsNum.entrySet()) {
                    String suitId = entry.getKey();
                    int suitLevel = entry.getValue();
                    ExSuit suit = ExSuitHandle.LoadExSuit.get(suitId);
                    if (suit == null) {
                        suitsNum.remove(suitId);
                        capability.SuitsNum = suitsNum;
                        capability.syncPlayerVariables((Entity)player);
                        continue;
                    }
                    for (int level = 1; level <= suitLevel; ++level) {
                        List<MobEffectInstance> effects;
                        if (suit.getTriggers().get(level) != trigger) continue;
                        List<String> commands = suit.getCommands().get(level);
                        if (commands != null && !player.m_9236_().m_5776_() && player.m_20194_() != null && commandSourceStack != null) {
                            int finalLevel = level;
                            commands.forEach(command -> {
                                String string;
                                if (!(trigger != ExSuit.Trigger.ATTACK && trigger != ExSuit.Trigger.PROJECTILE_HIT || (string = player.getPersistentData().m_128461_("hurtentity-uuid")).equals("null"))) {
                                    command = command.replace("$(hurtentity)", string);
                                }
                                if (cheekEvent.livingHurtEvent != null) {
                                    if (hasDamageBoost) {
                                        cheekEvent.livingHurtEvent.setAmount(cheekEvent.livingHurtEvent.getAmount() * damageBoost);
                                        damageBoost = 1.0f;
                                        hasDamageBoost = false;
                                    }
                                    if (hasDamageNumber) {
                                        cheekEvent.livingHurtEvent.setAmount(cheekEvent.livingHurtEvent.getAmount() + damageNumber);
                                        damageNumber = 0.0f;
                                        hasDamageBoost = false;
                                    }
                                }
                                command = command.replace("$(level)", "" + finalLevel);
                                player.m_20194_().m_129892_().m_230957_(commandSourceStack, command);
                            });
                        }
                        if ((effects = suit.getEffect().get(level)) == null) continue;
                        effects.stream().filter(Objects::nonNull).forEach(mobEffectInstance -> {
                            MobEffectInstance existingEffect = player.m_21124_(mobEffectInstance.m_19544_());
                            if (existingEffect == null || existingEffect.m_19564_() < mobEffectInstance.m_19564_()) {
                                mobEffectsToAdd.add(new MobEffectInstance(mobEffectInstance));
                            }
                        });
                    }
                }
                mobEffectsToAdd.forEach(mobEffectInstance -> {
                    ExApplySuitEffectEvent applySuitEffectEvent = new ExApplySuitEffectEvent(player, (MobEffectInstance)mobEffectInstance);
                    MinecraftForge.EVENT_BUS.post((Event)applySuitEffectEvent);
                    if (!applySuitEffectEvent.isCanceled()) {
                        player.m_7292_(applySuitEffectEvent.mobEffectInstance);
                    }
                });
            });
        }

        public static void addx(Player player, List<EventParameter<?>> eventParameters, String name) {
            ItemLevelHandle.ItemAddXpAuto((LivingEntity)player, eventParameters, name);
        }

        @SubscribeEvent
        public static void grind(GrindstoneEvent.OnPlaceItem event) {
            CommonEvent.handleArmorChangeExpectSuit(event.getOutput(), false);
        }

        public static boolean hasAttrOrBow(ItemStack stack) {
            if (stack.m_41720_() instanceof BowItem || stack.m_41720_() instanceof CrossbowItem) {
                return true;
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (stack.m_41638_(slot).isEmpty()) continue;
                return true;
            }
            return false;
        }

        public static boolean handleArmorChange(Player player, ItemStack fromStack, ItemStack toStack, boolean isClientSide) throws ScriptException {
            if (CommonEvent.handleArmorChangeExpectSuit(toStack, isClientSide)) {
                return false;
            }
            boolean isExSuitOperate = CommonEvent.SuitOperate(player, toStack, fromStack);
            return isExSuitOperate;
        }

        private static boolean handleArmorChangeExpectSuit(ItemStack toStack, boolean isClientSide) {
            if (!isClientSide) {
                ItemInfo itemInfo = ItemInfo.of(toStack);
                ModifierEntryHelper modifierEntryHelper = itemInfo.getModifierEntryHelper();
                ModifierEntryHelper.moveOldEntry(toStack);
                ItemLevelHelper.moveOldLevel(toStack);
                String string = ExUtil.getItemID(toStack);
                for (String s : UnMatchingModIDs) {
                    if (!string.startsWith(s)) continue;
                    return true;
                }
                if (CuriosUtil.isCuriosItem2(toStack)) {
                    if (toStack.m_41783_() == null || modifierEntryHelper.getModifierEntriesSize() <= 0) {
                        ModifierHandle.CommonEvent.RandomEntryCurios(toStack, 0, Config.refresh_time, "none");
                    }
                    if (toStack.m_41783_() != null && toStack.m_41783_().m_128441_("modifier_refresh") && toStack.m_41783_().m_128471_("modifier_refresh")) {
                        toStack.m_41783_().m_128473_("modifier_refresh");
                        toStack.m_41783_().m_128473_("UNKNOWN");
                        ModifierHandle.CommonEvent.RandomEntryCurios(toStack, toStack.m_41783_().m_128451_("modifier_refresh_rarity"), toStack.m_41783_().m_128451_("modifier_refresh_add"), toStack.m_41783_().m_128461_("wash_item"));
                    }
                } else if (!toStack.m_204131_().filter(e -> RefreshContainTagHandle.refreshContainTag.contains(e.toString())).toList().isEmpty() || RefreshContainItemHandle.refreshContainItem.contains(string) || CommonEvent.hasAttrOrBow(toStack) && !ModifierEntry.getType(toStack).stream().filter(e -> e != ExType.UNKNOWN.get()).toList().isEmpty() && toStack.m_41720_().getMaxStackSize(toStack) == 1) {
                    if (toStack.m_41783_() == null || modifierEntryHelper.getModifierEntriesSize() <= 0) {
                        ModifierSlotHelper modifierSlotHelper = ModifierSlotHelper.of(toStack);
                        if (Config.FirstAddSlots && !modifierSlotHelper.validList()) {
                            modifierSlotHelper.addSlot(ModifierSlotHandle.getSlot(ResourceLocation.m_135820_((String)"exmodifier:front")));
                            modifierSlotHelper.addSlot(ModifierSlotHandle.getSlot(ResourceLocation.m_135820_((String)"exmodifier:centre")));
                        }
                        ModifierHandle.CommonEvent.RandomEntry(toStack, 0, Config.refresh_time, "none", 0);
                    }
                    if (toStack.m_41783_() != null && toStack.m_41783_().m_128441_("modifier_refresh") && toStack.m_41783_().m_128471_("modifier_refresh")) {
                        toStack.m_41783_().m_128473_("modifier_refresh");
                        toStack.m_41783_().m_128473_("UNKNOWN");
                        ModifierHandle.CommonEvent.RandomEntry(toStack, toStack.m_41783_().m_128451_("modifier_refresh_rarity"), toStack.m_41783_().m_128451_("modifier_refresh_add"), toStack.m_41783_().m_128461_("wash_item"), 0);
                    }
                }
                int addLevelSystemCount = Config.add_level_system_count;
                if (Config.add_level_system_count != 0) {
                    ItemLevelHandle.ItemLevelRefresh(toStack, 0, addLevelSystemCount, "none");
                }
            }
            return false;
        }

        @SubscribeEvent
        public static void armorChange(LivingEquipmentChangeEvent event) throws ScriptException {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                boolean b = CommonEvent.handleArmorChange(player, event.getFrom(), event.getTo(), event.getEntity().m_9236_().m_5776_());
                MinecraftForge.EVENT_BUS.post((Event)new ExAfterArmorChange(event, b));
            }
        }

        public static boolean SuitOperate(@NotNull Player player, ItemStack stack1, ItemStack stack2) {
            if (player.m_9236_().f_46443_) {
                return false;
            }
            boolean flag = false;
            flag = CommonEvent.handleStack(player, stack1, EntityAttrUtil.WearOrTake.WEAR);
            if (CommonEvent.handleStack(player, stack2, EntityAttrUtil.WearOrTake.TAKE)) {
                flag = true;
            }
            return flag;
        }

        private static boolean handleStack(Player player, ItemStack stack, EntityAttrUtil.WearOrTake effectType) {
            if (player == null) {
                return false;
            }
            boolean flag = false;
            if (stack.m_41619_() && effectType == EntityAttrUtil.WearOrTake.WEAR) {
                return false;
            }
            CompoundTag tag = stack.m_41783_();
            ModifierEntryHelper modifierEntryHelper = ModifierEntryHelper.of(stack);
            if (tag == null || modifierEntryHelper.getModifierEntriesSize() <= 0) {
                return false;
            }
            List<ModifierEntry> modifierEntries = modifierEntryHelper.getModifierEntriesB();
            if (modifierEntries.isEmpty()) {
                return false;
            }
            for (int i = 0; i < modifierEntries.size(); ++i) {
                String modifier = modifierEntries.get((int)i).id;
                if (modifier.isEmpty()) continue;
                ArrayList<String> founds = new ArrayList<String>();
                List<ExSuit> suits = ExSuitHandle.FindExSuitFromEntry(modifier);
                for (ExSuit suit : suits) {
                    if (founds.contains(suit.id)) continue;
                    founds.add(suit.id);
                    if (effectType == EntityAttrUtil.WearOrTake.WEAR && suit.setting.getOrDefault("excludeArmorInHand", "false").equals("true") && stack.m_41720_() instanceof ArmorItem || effectType == EntityAttrUtil.WearOrTake.TAKE && suit.setting.getOrDefault("excludeArmorInHand", "false").equals("true") && stack.m_41720_() instanceof ArmorItem) continue;
                    if (effectType == EntityAttrUtil.WearOrTake.WEAR) {
                        ExSuitHandle.addSuitLevel(player, suit, 1);
                    } else {
                        ExSuitHandle.RemoveSuitLevel(player, suit, 1);
                    }
                    flag = true;
                    int suitLevel = ExSuitHandle.GetSuitLevel(player, suit);
                    List<AttriGetherNormal> attriGethers = suit.attriGether.get(effectType == EntityAttrUtil.WearOrTake.WEAR ? suitLevel : suitLevel + 1);
                    if (attriGethers != null) {
                        for (AttriGetherNormal attrGether2 : attriGethers.stream().filter(attrGether -> attrGether.getOnlyItems().isEmpty()).toList()) {
                            Exmodifier.LOGGER.debug("items : " + attrGether2.getOnlyItems().toString());
                            ExApplySuitAttrigetherEvent event1 = new ExApplySuitAttrigetherEvent(player, stack, effectType, attrGether2);
                            try {
                                Exmodifier.LOGGER.debug("Apply Suit AttriGether: " + attrGether2.attribute.m_22087_() + " " + attrGether2.attributeModifier.m_22217_().toString() + " " + attrGether2.attributeModifier.m_22218_());
                            }
                            catch (Exception e) {
                                System.out.println(e);
                            }
                            MinecraftForge.EVENT_BUS.post((Event)event1);
                            if (event1.isCanceled()) continue;
                            EntityAttrUtil.entityAddAttrTF(event1.attriGether.attribute, event1.attriGether.getModifier(), (LivingEntity)event1.player, event1.effectType);
                        }
                    }
                    ExSuitApplyOnChangeEvent event = new ExSuitApplyOnChangeEvent(player, suit, i, effectType);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                }
            }
            return flag;
        }

        public static Runnable init(Runnable runnable) throws IOException {
            MainEvent.clearOldData();
            BaseItemSelected.IDS = new HashMap<Integer, Object>();
            RefreshContainTagHandle.readConfig();
            RefreshContainItemHandle.readConfig();
            ModifierHandle.sendClearDataToAllClient();
            ExTypeHandle.readConfig();
            ItemQualityHandle.init();
            ExElementHandle.init();
            ZipHandle.ZipFunction init = ZipHandle.init();
            if (runnable != null) {
                runnable.run();
            }
            ItemQualityHandle.init2();
            ModifierHandle.readConfig();
            ExSuitHandle.readConfig();
            ModifierSlotHandle.reload();
            ExElementHandle.init2();
            ExElementHandle.init3();
            init.elementDefault().forEach(Runnable::run);
            init.defaultEntry().forEach(Runnable::run);
            init.suit().forEach(Runnable::run);
            ModifierHandle.EEMatchQueueHandle();
            LanguageLoader.load(LanguageLoader.LANGUAGES_FILE_PATH);
            MainEvent.clearReadTempData();
            MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
            if (currentServer != null) {
                if (runnable != null) {
                    return () -> ExModifierReloadCommand.sendUpdatedModifiersToClients(currentServer);
                }
                ExModifierReloadCommand.sendUpdatedModifiersToClients(currentServer);
            }
            return null;
        }

        @SubscribeEvent
        public static void atReload(AddReloadListenerEvent event) throws IOException {
            event.addListener((PreparableReloadListener)new ExSuitPreparableReloadListener());
            event.addListener((PreparableReloadListener)new WashingMaterialsPreparableReloadListener());
            event.addListener((PreparableReloadListener)new ModifierPreparableReloadListener());
            event.addListener((PreparableReloadListener)new ElementPreparableReloadListener());
            event.addListener((PreparableReloadListener)new DefaultEntityPreparableReloadListener());
            event.addListener((PreparableReloadListener)new DefaultItemPreparableReloadListener());
        }

        @SubscribeEvent
        public static void playJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
            Player entity = event.getEntity();
            if (!entity.m_9236_().m_5776_()) {
                DataCache dataCache = DataCache.create();
                ModifierHandle.sendClearDataToClient((ServerPlayer)entity);
                MainEvent.sendExmoServerDataToServerPlayer((ServerPlayer)entity, dataCache);
            }
        }

        static {
            UnMatchingModIDs.add("umapyoi");
            damageBoost = 1.0f;
            damageNumber = 0.0f;
            hasDamageBoost = false;
            hasDamageNumber = false;
        }

        @Mod.EventBusSubscriber
        public static class cheekEvent {
            private static LivingHurtEvent livingHurtEvent;

            @SubscribeEvent
            public static void PlayerHurtAndAttack(LivingHurtEvent event) {
                Object eventParameters;
                Player player;
                if (event.getSource().m_276093_(DamageTypes.f_286979_)) {
                    return;
                }
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof Player) {
                    player = (Player)livingEntity;
                    eventParameters = new ArrayList();
                    eventParameters.add(new EventParameter<Float>("amount", Float.valueOf(event.getAmount())));
                    eventParameters.add(new EventParameter<Double>("max_health", player.m_21133_(Attributes.f_22276_)));
                    CommonEvent.addx(player, eventParameters, "ON_HURT");
                    livingHurtEvent = event;
                    CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.ON_HURT);
                    livingHurtEvent = null;
                }
                if ((eventParameters = event.getSource().m_7639_()) instanceof Player) {
                    player = (Player)eventParameters;
                    eventParameters = new ArrayList();
                    eventParameters.add(new EventParameter<Float>("amount", Float.valueOf(event.getAmount())));
                    eventParameters.add(new EventParameter<Double>("max_health", player.m_21133_(Attributes.f_22276_)));
                    CommonEvent.addx(player, eventParameters, "ATTACK");
                    if (event.getEntity() != null) {
                        player.getPersistentData().m_128359_("hurtentity-uuid", event.getEntity().m_20148_().toString());
                    }
                    livingHurtEvent = event;
                    CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.ATTACK);
                    livingHurtEvent = null;
                    player.getPersistentData().m_128359_("hurtentity-uuid", "null");
                }
            }

            @SubscribeEvent
            public static void PlayerJump(LivingEvent.LivingJumpEvent event) {
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    ArrayList eventParameters = new ArrayList();
                    CommonEvent.addx(player, eventParameters, "JUMP");
                    CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.JUMP);
                }
            }

            @SubscribeEvent
            public static void Digger(BlockEvent.BreakEvent event) {
                Player player = event.getPlayer();
                ArrayList eventParameters = new ArrayList();
                CommonEvent.addx(player, eventParameters, "DIG");
                CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.DIG);
            }

            @SubscribeEvent
            public static void PlayerDeathAndKill(LivingDeathEvent event) {
                Object eventParameters;
                Player player;
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof Player) {
                    player = (Player)livingEntity;
                    eventParameters = new ArrayList();
                    CommonEvent.addx(player, eventParameters, "DIE");
                    CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.DIE);
                }
                if ((eventParameters = event.getSource().m_7639_()) instanceof Player) {
                    player = (Player)eventParameters;
                    eventParameters = new ArrayList();
                    CommonEvent.addx(player, eventParameters, "KILL");
                    CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.KILL);
                }
            }

            @SubscribeEvent
            public static void PlayerProjectile(ProjectileImpactEvent event) {
                Entity entity = event.getProjectile().m_19749_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    ArrayList eventParameters = new ArrayList();
                    if (event.getEntity() != null) {
                        player.getPersistentData().m_128359_("hurtentity-uuid", event.getEntity().m_20148_().toString());
                    }
                    CommonEvent.addx(player, eventParameters, "PROJECTILE_HIT");
                    CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.PROJECTILE_HIT);
                }
            }

            @SubscribeEvent
            public static void PlayerShoot(ArrowLooseEvent event) {
                ArrayList eventParameters = new ArrayList();
                CommonEvent.addx(event.getEntity(), eventParameters, "SHOOT");
                CommonEvent.ApplySuitEffect(event.getEntity(), ExSuit.Trigger.SHOOT);
            }

            @SubscribeEvent
            public static void PlayerSwing(LivingSwingEvent event) {
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    ArrayList eventParameters = new ArrayList();
                    CommonEvent.addx(player, eventParameters, "SWING");
                    CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.SWING);
                }
            }

            @SubscribeEvent
            public static void PlayerCrit(CriticalHitEvent event) {
                ArrayList eventParameters = new ArrayList();
                eventParameters.add(new EventParameter<Float>("amount", Float.valueOf(event.getDamageModifier())));
                Player player = event.getEntity();
                CommonEvent.addx(player, eventParameters, "CRIT");
                CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.CRIT);
            }

            @SubscribeEvent
            public static void PlayerDodge(ExDodgeEvent event) {
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (event.result == ExDodgeEvent.resultType.MISS) {
                        ArrayList eventParameters = new ArrayList();
                        CommonEvent.addx(player, eventParameters, "DODGE");
                        CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.DODGE);
                    }
                }
            }

            @SubscribeEvent
            public static void PlayerUseItem(LivingEntityUseItemEvent event) {
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    ArrayList eventParameters = new ArrayList();
                    CommonEvent.addx(player, eventParameters, "ON_USE");
                    CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.ON_USE);
                }
            }

            @SubscribeEvent
            public static void PlayerSwim(LivingPlayerSwimEvent event) {
                ArrayList eventParameters = new ArrayList();
                Player player = event.player;
                CommonEvent.addx(player, eventParameters, "SWIM");
                CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.SWIM);
            }

            @SubscribeEvent
            public static void PlayerLiving(TickEvent.PlayerTickEvent event) {
                Player player = event.player;
                if (player.m_9236_().f_46443_) {
                    return;
                }
                CommonEvent.ApplySuitEffect(player, ExSuit.Trigger.TICK);
            }
        }
    }
}

