/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.event;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.exmo.exmodifier.Config;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class Statistics {
    public static final String ingotPath = FMLPaths.CONFIGDIR.get().resolve("exmo/ingots.txt").toString();
    public static final String attackablesPath = FMLPaths.CONFIGDIR.get().resolve("exmo/attackables.txt").toString();
    public static final String armorsPath = FMLPaths.CONFIGDIR.get().resolve("exmo/armors.txt").toString();

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!Config.Statistics) {
            return;
        }
        if (!event.getEntity().m_9236_().f_46443_) {
            return;
        }
        HashMap<String, String> ingots = new HashMap<String, String>();
        HashMap<String, List<Component>> armors = new HashMap<String, List<Component>>();
        HashMap<String, List<Component>> attackables = new HashMap<String, List<Component>>();
        ForgeRegistries.ITEMS.getEntries().forEach(v -> {
            ItemStack defaultInstance;
            double sum;
            Item value = (Item)v.getValue();
            String key = I18n.m_118938_((String)value.m_5524_(), (Object[])new Object[0]);
            if (key.contains("\u952d") || key.contains("ingot") || key.contains("Ingot") || ((ResourceKey)v.getKey()).m_135782_().toString().contains("ingot")) {
                ingots.put(key, ((ResourceKey)v.getKey()).toString());
            }
            if ((sum = (defaultInstance = value.m_7968_()).m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().mapToDouble(AttributeModifier::m_22218_).sum()) > 0.0) {
                attackables.put(key + " | " + ((ResourceKey)v.getKey()).toString() + " | \u653b\u51fb\u4f24\u5bb3:" + sum + " | \u653b\u51fb\u901f\u5ea6:" + defaultInstance.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).stream().mapToDouble(AttributeModifier::m_22218_).sum(), defaultInstance.m_41651_(event.getEntity(), (TooltipFlag)TooltipFlag.f_256730_));
            }
            if (value instanceof ArmorItem) {
                armors.put(key + " | " + ((ResourceKey)v.getKey()).toString(), defaultInstance.m_41651_(event.getEntity(), (TooltipFlag)TooltipFlag.f_256730_));
            }
        });
        Statistics.write2(attackables, attackablesPath);
        Statistics.write2(armors, armorsPath);
        Statistics.write(ingots, ingotPath);
    }

    private static void write2(Map<String, List<Component>> armors, String armorsPath) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(armorsPath));){
            for (Map.Entry<String, List<Component>> entry : armors.entrySet()) {
                writer.write(entry.getKey());
                writer.newLine();
                for (Component component : entry.getValue()) {
                    writer.write(component.getString());
                    writer.newLine();
                }
                writer.newLine();
                writer.write("--------------------------------------------");
                writer.newLine();
            }
            System.out.println("Ingot data saved to " + armorsPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void write(Map<String, String> toWrite, String toWritePath) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(toWritePath));){
            for (Map.Entry<String, String> entry : toWrite.entrySet()) {
                writer.write(entry.getKey() + " | " + entry.getValue());
                writer.newLine();
            }
            System.out.println("Ingot data saved to " + toWritePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

