/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.exmo.exmodifier.content.element.ExElement;
import net.exmo.exmodifier.content.element.ExElementHandle;
import net.exmo.exmodifier.content.element.ExElementInstant;
import net.exmo.exmodifier.content.helper.ExHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ExElementHelper
extends ExHelper {
    public final String EEID = "elements";

    public ExElementHelper(ItemStack itemStack) {
        super(itemStack);
    }

    public static ExElementHelper of(ItemStack itemStack) {
        return new ExElementHelper(itemStack);
    }

    public boolean ValidElementEntry() {
        return this.ValidMainNbt() && this.getMainNbt().m_128441_("elements");
    }

    public ExElementHelper createElementNbt() {
        this.createNbt();
        if (this.ValidElementEntry()) {
            return this;
        }
        this.getMainNbt().m_128365_("elements", (Tag)new ListTag());
        return this;
    }

    public List<ExElementInstant> getElements() {
        CompoundTag tag;
        ArrayList<ExElementInstant> elementInstants = new ArrayList<ExElementInstant>();
        if (this.ValidMainNbt() && (tag = this.getMainNbt()).m_128441_("elements")) {
            ListTag elementList = tag.m_128437_("elements", 10);
            for (int i = 0; i < elementList.size(); ++i) {
                CompoundTag tag1 = elementList.m_128728_(i);
                ExElement exElement = ExElementHandle.getExElement(tag1.m_128461_("elements"));
                if (exElement == null) continue;
                int level = 1;
                if (tag1.m_128441_("Level")) {
                    level = tag1.m_128451_("Level");
                }
                CompoundTag tag2 = tag1.m_6426_();
                tag2.m_128473_("Level");
                elementInstants.add(ExElementInstant.of(exElement, level).setData(tag2));
            }
        }
        return elementInstants;
    }

    public boolean gatherElement(ExElementInstant exElementInstant) {
        List<ExElementInstant> elementInstants = this.getElements();
        AtomicInteger level = new AtomicInteger(exElementInstant.getLevel());
        elementInstants.forEach(x -> {
            if (x.getElement().getResId().equals((Object)exElementInstant.getElement().getResId())) {
                level.set(exElementInstant.getLevel() + x.getLevel());
            }
        });
        if (level.get() == exElementInstant.getLevel()) {
            return false;
        }
        this.removeExElementEntryUnLock(exElementInstant);
        this.addExElement(new ExElementInstant(exElementInstant.getElement(), level.get()), false);
        return level.get() != exElementInstant.getLevel();
    }

    public ListTag getElementsNbt() {
        return this.getMainNbt().m_128437_("elements", 10);
    }

    public ExElementHelper removeExElementEntryUnLock(ExElementInstant exElementInstant) {
        this.createNbt();
        if (!this.ValidMainNbt()) {
            return this;
        }
        ListTag elementsNbt = this.getElementsNbt();
        for (int i = 0; i < elementsNbt.size(); ++i) {
            CompoundTag tag1 = elementsNbt.m_128728_(i);
            if (!tag1.m_128461_("elements").equals(exElementInstant.getElement().getResId().toString())) continue;
            elementsNbt.remove(i);
            break;
        }
        return this;
    }

    public ExElementHelper addExElement(ExElementInstant exElementInstant, boolean gather) {
        if (exElementInstant.getElement() == null) {
            return this;
        }
        this.createNbt();
        if (!this.ValidMainNbt()) {
            this.createMainNbt();
        }
        this.createElementNbt();
        if (gather && this.gatherElement(exElementInstant)) {
            return this;
        }
        CompoundTag tag1 = new CompoundTag();
        tag1.m_128359_("elements", exElementInstant.getElement().getResId().toString());
        tag1.m_128405_("Level", exElementInstant.getLevel());
        ListTag modifiersList = this.getElementsNbt();
        modifiersList.add((Object)tag1);
        return this;
    }

    public int getElementEntriesSize() {
        CompoundTag mainNbt = this.getMainNbt();
        if (!this.ValidMainNbt()) {
            return 0;
        }
        return mainNbt.m_128437_("elements", 10).size();
    }
}

