/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.exmo.exmodifier.content.event.parameter.EventParameter;
import net.exmo.exmodifier.content.helper.ExHelper;
import net.exmo.exmodifier.content.level.ItemLevel;
import net.exmo.exmodifier.content.level.ItemLevelHandle;
import net.exmo.exmodifier.content.level.ItemLevelInstant;
import net.exmo.exmodifier.content.modifier.ModifierAttriGether;
import net.exmo.exmodifier.events.ExItemUpEvent;
import net.exmo.exmodifier.util.DynamicExpressionEvaluator;
import net.exmo.exmodifier.util.ItemAttrUtil;
import net.exmo.exmodifier.util.gether.AttriGether;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ItemLevelHelper
extends ExHelper {
    public CompoundTag nbt;
    public static final String ITEM_LEVEL = "itemLevel";
    public static final String ITEM_LEVEL_ID = "itemLevelId";

    public ItemLevelHelper(ItemStack itemStack) {
        super(itemStack);
    }

    public static ItemLevelHelper of(ItemStack itemStack) {
        return new ItemLevelHelper(itemStack);
    }

    public boolean ValidItemLevelNbt() {
        return this.ValidMainNbt() && this.getMainNbt().m_128441_(ITEM_LEVEL);
    }

    public ItemLevelHelper createModifierEntryNbt() {
        this.createNbt();
        if (this.ValidItemLevelNbt()) {
            return this;
        }
        this.getMainNbt().m_128365_(ITEM_LEVEL, (Tag)new ListTag());
        return this;
    }

    public ItemLevelHelper copyOtherHelper(ItemLevelHelper other) {
        if (!other.ValidItemLevelNbt()) {
            return this;
        }
        for (ItemLevelInstant itemLevelInstant : this.getItemLevelInstants()) {
            this.removeItemLevel(itemLevelInstant, true);
        }
        for (ItemLevelInstant itemLevelInstant : other.getItemLevelInstants()) {
            this.addItemLevelInstant(itemLevelInstant);
        }
        return this;
    }

    public ItemLevelHelper removeItemLevel(ItemLevelInstant itemLevelInstant, boolean removeAttribute) {
        if (itemLevelInstant.isLock()) {
            return this;
        }
        ListTag modifiersList = this.getItemLevelNbt();
        ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
        for (int i = 0; i < modifiersList.size(); ++i) {
            if (!modifiersList.m_128728_(i).m_128461_(ITEM_LEVEL_ID).equals(itemLevelInstant.getItemLevel().id)) continue;
            indicesToRemove.add(i);
            if (!removeAttribute) continue;
            for (ModifierAttriGether modifierAttriGether : itemLevelInstant.getItemLevel().attriGethers) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ItemAttrUtil.removeAttributeModifierNoAmout(this.itemStack, modifierAttriGether.attribute, modifierAttriGether.modifier, slot);
                }
            }
        }
        Iterator iterator = indicesToRemove.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            modifiersList.remove(index);
        }
        return this;
    }

    public ListTag getItemLevelNbt() {
        return this.getMainNbt().m_128437_(ITEM_LEVEL, 10);
    }

    public static void moveOldLevel(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128441_("exmodifier_level_modifier_applied")) {
            List<ItemLevel> itemLevels = oldFunc.getItemLevels(stack);
            for (ItemLevel itemLevel : itemLevels) {
                double xp = oldFunc.getLevelItemXp(stack, itemLevel.id);
                int level = oldFunc.getLevelItemLevel(stack, itemLevel.id);
                double needXp = oldFunc.getLevelItemNeedXpUp(stack, itemLevel.id);
                int maxLevel = oldFunc.getLevelItemMaxLevel(stack, itemLevel.id);
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    for (AttriGether attriGether : itemLevel.attriGethers) {
                        ItemAttrUtil.removeAttributeModifierNoAmout(stack, attriGether.attribute, attriGether.getModifier(), slot);
                    }
                }
                ItemLevelHelper.of(stack).addItemLevelInstant(new ItemLevelInstant(itemLevel, level, maxLevel, xp, needXp));
                ArrayList<String> keysToRemove = new ArrayList<String>();
                for (String key : tag.m_128431_()) {
                    if (!key.contains(itemLevel.id)) continue;
                    keysToRemove.add(key);
                }
                for (String key : keysToRemove) {
                    tag.m_128473_(key);
                }
            }
            tag.m_128473_("exmodifier_level_modifier_applied");
        }
    }

    public ItemLevelHelper addItemLevelInstant(ItemLevelInstant itemLevelInstant) {
        this.createNbt();
        if (!this.ValidMainNbt()) {
            this.createMainNbt();
        }
        this.createModifierEntryNbt();
        CompoundTag tag1 = new CompoundTag();
        tag1.m_128359_(ITEM_LEVEL_ID, itemLevelInstant.getItemLevel().id);
        tag1.m_128405_("Level", itemLevelInstant.getLevel());
        tag1.m_128379_("islock", itemLevelInstant.isLock());
        tag1.m_128347_("Xp", itemLevelInstant.xp);
        tag1.m_128347_("NeedXp", itemLevelInstant.needXp);
        tag1.m_128405_("MaxLevel", itemLevelInstant.getMaxLevel());
        ListTag modifiersList = this.getItemLevelNbt();
        modifiersList.add((Object)tag1);
        return this;
    }

    public int getItemLevelsSize() {
        return this.getItemLevelNbt().size();
    }

    public List<ItemLevel> getItemLevels() {
        ArrayList<ItemLevel> list = new ArrayList<ItemLevel>();
        for (int i = 0; i < this.getItemLevelNbt().size(); ++i) {
            list.add(ItemLevelHandle.ItemLevels.get(this.getItemLevelNbt().m_128728_(i).m_128461_(ITEM_LEVEL_ID)));
        }
        return list;
    }

    public List<ItemLevelInstant> getItemLevelInstants() {
        ArrayList<ItemLevelInstant> list = new ArrayList<ItemLevelInstant>();
        for (int i = 0; i < this.getItemLevelNbt().size(); ++i) {
            CompoundTag tag = this.getItemLevelNbt().m_128728_(i);
            int level = tag.m_128451_("Level");
            int maxLevel = tag.m_128451_("MaxLevel");
            double xp = tag.m_128459_("Xp");
            double needXp = tag.m_128459_("NeedXp");
            String itemLevelId = tag.m_128461_(ITEM_LEVEL_ID);
            list.add(new ItemLevelInstant(ItemLevelHandle.ItemLevels.get(itemLevelId), level, maxLevel, xp, needXp).setLock(tag.m_128441_("islock") && tag.m_128471_("islock")));
        }
        return list;
    }

    public ItemLevelHelper setXp(String itemLevelId, int xp) {
        ListTag itemLevelNbt = this.getItemLevelNbt();
        for (int i = 0; i < itemLevelNbt.size(); ++i) {
            if (!itemLevelNbt.m_128728_(i).m_128461_(ITEM_LEVEL_ID).equals(itemLevelId)) continue;
            itemLevelNbt.m_128728_(i).m_128347_("Xp", (double)xp);
            return this;
        }
        return this;
    }

    public double getXp(String itemLevelId) {
        for (int i = 0; i < this.getItemLevelNbt().size(); ++i) {
            if (!this.getItemLevelNbt().m_128728_(i).m_128461_(ITEM_LEVEL_ID).equals(itemLevelId)) continue;
            return this.getItemLevelNbt().m_128728_(i).m_128459_("Xp");
        }
        return 0.0;
    }

    public ItemLevelHelper setNeedXp(String itemLevelId, double needXp) {
        ListTag itemLevelNbt = this.getItemLevelNbt();
        for (int i = 0; i < itemLevelNbt.size(); ++i) {
            if (!itemLevelNbt.m_128728_(i).m_128461_(ITEM_LEVEL_ID).equals(itemLevelId)) continue;
            itemLevelNbt.m_128728_(i).m_128347_("NeedXp", needXp);
            return this;
        }
        return this;
    }

    public double getNeedXp(String itemLevelId) {
        for (int i = 0; i < this.getItemLevelNbt().size(); ++i) {
            if (!this.getItemLevelNbt().m_128728_(i).m_128461_(ITEM_LEVEL_ID).equals(itemLevelId)) continue;
            return this.getItemLevelNbt().m_128728_(i).m_128459_("NeedXp");
        }
        return 0.0;
    }

    public ItemLevelHelper setLevel(String itemLevelId, int level) {
        ListTag itemLevelNbt = this.getItemLevelNbt();
        for (int i = 0; i < itemLevelNbt.size(); ++i) {
            if (!itemLevelNbt.m_128728_(i).m_128461_(ITEM_LEVEL_ID).equals(itemLevelId)) continue;
            itemLevelNbt.m_128728_(i).m_128405_("Level", level);
            return this;
        }
        return this;
    }

    public int getLevel(String itemLevelId) {
        for (int i = 0; i < this.getItemLevelNbt().size(); ++i) {
            if (!this.getItemLevelNbt().m_128728_(i).m_128461_(ITEM_LEVEL_ID).equals(itemLevelId)) continue;
            return this.getItemLevelNbt().m_128728_(i).m_128451_("Level");
        }
        return 0;
    }

    public ItemLevelInstant getItemLevelInstant(String itemLevelId) {
        for (int i = 0; i < this.getItemLevelInstants().size(); ++i) {
            if (!this.getItemLevelInstants().get((int)i).itemLevel.id.equals(itemLevelId)) continue;
            return this.getItemLevelInstants().get(i);
        }
        return null;
    }

    public ItemLevelHelper setMaxLevel(String itemLevelId, int maxLevel) {
        ListTag itemLevelNbt = this.getItemLevelNbt();
        for (int i = 0; i < itemLevelNbt.size(); ++i) {
            if (!itemLevelNbt.m_128728_(i).m_128461_(ITEM_LEVEL_ID).equals(itemLevelId)) continue;
            itemLevelNbt.m_128728_(i).m_128405_("MaxLevel", maxLevel);
            return this;
        }
        return this;
    }

    public int getMaxLevel(String itemLevelId) {
        for (int i = 0; i < this.getItemLevelNbt().size(); ++i) {
            if (!this.getItemLevelNbt().m_128728_(i).m_128461_(ITEM_LEVEL_ID).equals(itemLevelId)) continue;
            return this.getItemLevelNbt().m_128728_(i).m_128451_("MaxLevel");
        }
        return 0;
    }

    public void ItemAddXpM(ItemStack stack, List<EventParameter<?>> params, ItemLevelInstant itemLevelInstant, LivingEntity entity) {
        if (stack.m_41783_() == null) {
            return;
        }
        DynamicExpressionEvaluator evaluator = new DynamicExpressionEvaluator();
        for (EventParameter<?> param : params) {
            evaluator.setVariable(param.getKey(), param.getDouble());
        }
        double addXp = evaluator.evaluate(itemLevelInstant.itemLevel.getXpAddExpression());
        double level = itemLevelInstant.level;
        double xp = itemLevelInstant.xp;
        double needXp = itemLevelInstant.needXp;
        double _level = level;
        double finalXp = xp + addXp;
        if (finalXp > 0.0) {
            while (finalXp > 0.0 && finalXp >= needXp) {
                if (level < (double)itemLevelInstant.maxLevel) {
                    level += 1.0;
                }
                finalXp -= needXp;
                needXp = ItemLevelHandle.generateLevelNeedXp(itemLevelInstant.itemLevel, (int)level);
            }
            this.setLevel(itemLevelInstant.itemLevel.id, (int)level);
            this.setXp(itemLevelInstant.itemLevel.id, (int)finalXp);
            this.setNeedXp(itemLevelInstant.itemLevel.id, needXp);
        }
        if (_level != level) {
            ExItemUpEvent event = new ExItemUpEvent(stack, (int)level, entity, (int)_level, (int)finalXp, itemLevelInstant);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    public static class oldFunc {
        private static void setLevelItemLevel(ItemStack stack, String id, int level2) {
            if (stack.m_41783_() == null) {
                return;
            }
            stack.m_41783_().m_128347_(id + "_level", (double)level2);
        }

        private static void setLevelItemXp(ItemStack stack, String id, int xp2) {
            if (stack.m_41783_() == null) {
                return;
            }
            stack.m_41783_().m_128347_(id + "_Xp", (double)xp2);
        }

        public static List<ItemLevel> getItemLevels(ItemStack stack) {
            String id;
            ArrayList<ItemLevel> itemLevels = new ArrayList<ItemLevel>();
            if (stack.m_41783_() == null) {
                return itemLevels;
            }
            int i = 0;
            while (!(id = stack.m_41783_().m_128461_("exmodifier_level_modifier_applied" + i)).isEmpty()) {
                itemLevels.add(ItemLevelHandle.ItemLevels.get(id));
                ++i;
            }
            return itemLevels;
        }

        public static void setItemNeedXpUp(ItemStack stack, String levelId, double xp) {
            if (stack.m_41783_() == null) {
                return;
            }
            stack.m_41783_().m_128347_(levelId + "_NeedXpUp", xp);
        }

        public static double getLevelItemXp(ItemStack stack, String levelId) {
            if (stack.m_41783_() == null) {
                return 0.0;
            }
            return stack.m_41783_().m_128459_(levelId + "_Xp");
        }

        public static double getLevelItemNeedXpUp(ItemStack stack, String levelId) {
            if (stack.m_41783_() == null) {
                return 0.0;
            }
            return stack.m_41783_().m_128459_(levelId + "_NeedXpUp");
        }

        public static int getLevelItemLevel(ItemStack stack, String levelId) {
            if (stack.m_41783_() == null) {
                return 0;
            }
            return stack.m_41783_().m_128451_(levelId + "_level");
        }

        public static int getLevelItemMaxLevel(ItemStack stack, String levelId) {
            if (stack.m_41783_() == null) {
                return 0;
            }
            return stack.m_41783_().m_128451_(levelId + "_MaxLevel");
        }
    }
}

