/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.helper;

import java.util.ArrayList;
import java.util.List;
import net.exmo.exmodifier.content.helper.ExHelper;
import net.exmo.exmodifier.content.helper.ModifierEntryHelper;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.modifier.ModifierInstant;
import net.exmo.exmodifier.content.quality.ItemQuality;
import net.exmo.exmodifier.content.quality.ItemQualityHandle;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ItemQualityHelper
extends ExHelper {
    public static final String IQT = "ItemQuality";
    public static final String IQID = "id";

    public ItemQualityHelper(ItemStack itemStack) {
        super(itemStack);
    }

    public static ItemQualityHelper of(ItemStack itemStack) {
        return new ItemQualityHelper(itemStack);
    }

    public int getQualityEntriesSize() {
        return this.getMainNbt().m_128437_(IQT, 10).size();
    }

    public boolean ValidModifierEntry() {
        return this.ValidMainNbt() && this.getMainNbt().m_128441_(IQT);
    }

    public ListTag getQualityEntriesNbt() {
        return this.getMainNbt().m_128437_(IQT, 10);
    }

    public ItemQualityHelper createQualityNbt() {
        this.createNbt();
        if (this.ValidModifierEntry()) {
            return this;
        }
        this.getMainNbt().m_128365_(IQT, (Tag)new ListTag());
        return this;
    }

    public ItemQualityHelper addQualityEntry(ItemQuality itemQuality, boolean addEntries, boolean addAttribute) {
        this.createNbt();
        if (!this.ValidMainNbt()) {
            this.createMainNbt();
        }
        this.createQualityNbt();
        CompoundTag tag1 = new CompoundTag();
        tag1.m_128359_(IQID, itemQuality.Id);
        ListTag modifiersList = this.getQualityEntriesNbt();
        modifiersList.add((Object)tag1);
        if (addEntries) {
            for (int i = 0; i < itemQuality.entries.size(); ++i) {
                ModifierEntryHelper.of(this.itemStack).addModifierEntry(ModifierInstant.of(itemQuality.entries.get(i)).setItemQualityLock(itemQuality.cantRemoveEntry), addAttribute, true);
            }
        }
        return this;
    }

    public ItemQualityHelper removeQualityEntry(ItemQuality itemQuality, boolean removeEntries, boolean removeAttribute) {
        ListTag modifiersList = this.getQualityEntriesNbt();
        for (int i = 0; i < modifiersList.size(); ++i) {
            CompoundTag tag = modifiersList.m_128728_(i);
            if (!tag.m_128461_(IQID).equals(itemQuality.Id)) continue;
            modifiersList.remove(i);
            if (!removeEntries) break;
            for (ModifierEntry modifierEntry : itemQuality.entries) {
                ModifierEntryHelper.of(this.itemStack).removeModifierEntryUnLock(ModifierInstant.of(modifierEntry), removeAttribute);
            }
            break;
        }
        return this;
    }

    public List<T2a> getQualityEntriesTooltip() {
        ArrayList<T2a> list = new ArrayList<T2a>();
        ItemQualityHelper itemQualityHelper = ItemQualityHelper.of(this.itemStack);
        for (ItemQuality itemQuality : itemQualityHelper.getQualityEntries()) {
            if (itemQuality == null) continue;
            list.add(new T2a(Component.m_237115_((String)("exmodifier.quality." + itemQuality.Id)), itemQuality.isShowInHeadTooltip(), itemQuality.ShowModifierComponent));
            if (itemQuality.LocalDescription.isEmpty()) continue;
            list.add(new T2a(Component.m_237115_((String)itemQuality.LocalDescription), false, false));
        }
        return list;
    }

    public List<ItemQuality> getQualityEntries() {
        ArrayList<ItemQuality> list = new ArrayList<ItemQuality>();
        ListTag qualityEntriesNbt = this.getQualityEntriesNbt();
        for (int i = 0; i < qualityEntriesNbt.size(); ++i) {
            list.add(ItemQualityHandle.itemQualityMap.get(qualityEntriesNbt.m_128728_(i).m_128461_(IQID)));
        }
        return list;
    }

    public static class T2a {
        public MutableComponent mutableComponent;
        public boolean isShowInHeadTooltip;
        public boolean showModifierComponent;

        public T2a(MutableComponent mutableComponent, boolean isShowInHeadTooltip, boolean showModifierComponent) {
            this.mutableComponent = mutableComponent;
            this.isShowInHeadTooltip = isShowInHeadTooltip;
            this.showModifierComponent = showModifierComponent;
        }
    }
}

