/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.helper;

import com.google.common.collect.Multimap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.exmo.exmodifier.Config;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.helper.ExHelper;
import net.exmo.exmodifier.content.level.ItemLevelHandle;
import net.exmo.exmodifier.content.modifier.EntryItem;
import net.exmo.exmodifier.content.modifier.ModifierAttriGether;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.content.modifier.ModifierInstant;
import net.exmo.exmodifier.content.modifier.WashingMaterials;
import net.exmo.exmodifier.content.modifier.menu.RefreshMenu;
import net.exmo.exmodifier.content.selected.ModifierItemSelector;
import net.exmo.exmodifier.content.type.ItemType;
import net.exmo.exmodifier.events.ExOnTableRefreshEntriesEvent;
import net.exmo.exmodifier.events.ExRefreshEvent;
import net.exmo.exmodifier.network.PlayerRefreshScreenOverMessageMessage;
import net.exmo.exmodifier.util.CuriosUtil;
import net.exmo.exmodifier.util.ExUtil;
import net.exmo.exmodifier.util.ItemAttrUtil;
import net.exmo.exmodifier.util.ModifierSelector;
import net.exmo.exmodifier.util.WeightedUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ModifierEntryHelper
extends ExHelper {
    public static final String MES = "ModifierEntry";
    public static final String MEID = "EntryID";
    public static final String SLOT = "slot";
    public static Map<String, Double> item_old_number_cache = new HashMap<String, Double>();

    public static ModifierEntryHelper of(ItemStack itemStack) {
        return new ModifierEntryHelper(itemStack);
    }

    public static void moveOldEntry(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128441_("exmodifier_armor_modifier_applied")) {
            ModifierEntryHelper modifierEntryHelper = new ModifierEntryHelper(itemStack);
            for (ModifierEntry modifierEntry : oldFunc.getEntrysFromItemStack_old(itemStack)) {
                modifierEntryHelper.addModifierEntry(new ModifierInstant(modifierEntry, 1), true, true);
            }
            oldFunc.clearEntry_old(itemStack);
            tag.m_128473_("exmodifier_armor_modifier_applied");
        }
    }

    public boolean ValidModifierEntry() {
        return this.ValidMainNbt() && this.getMainNbt().m_128441_(MES);
    }

    public ModifierEntryHelper createModifierEntryNbt() {
        this.createNbt();
        if (this.ValidModifierEntry()) {
            return this;
        }
        this.getMainNbt().m_128365_(MES, (Tag)new ListTag());
        return this;
    }

    public ModifierEntryHelper copyOtherHelper(ModifierEntryHelper other) {
        if (!other.ValidModifierEntry()) {
            return this;
        }
        other.getModifierEntriesB().forEach(modifierEntry -> modifierEntry.attriGether.forEach(attriGether -> item_old_number_cache.put(attriGether.modifier.getName(), ItemAttrUtil.getAmountFromAttributeName(other.itemStack, attriGether.attribute, attriGether.modifier.getName()))));
        for (ModifierInstant modifierEntry2 : other.getModifierEntries()) {
            this.addModifierEntry(modifierEntry2.lock(), true, false, modifierEntry2);
        }
        this.removeAllEntry(true);
        List<ModifierInstant> modifierEntries = this.getModifierEntries().stream().map(ModifierInstant::unlock).toList();
        this.removeAllEntrySkinLock(true, List.of());
        modifierEntries.forEach(e -> this.addModifierEntry((ModifierInstant)e, true, false));
        item_old_number_cache.clear();
        return this;
    }

    public ModifierEntryHelper removeAllEntry(boolean removeAttribute, List<TagKey<ModifierEntry>> onlyTags) {
        for (ModifierInstant modifierInstant : this.getModifierEntries()) {
            if (modifierInstant.isLock() || !onlyTags.isEmpty() && !onlyTags.stream().anyMatch(tag -> modifierInstant.getModifierEntry().tags.contains(tag))) continue;
            this.removeModifierEntry(modifierInstant, removeAttribute);
        }
        return this;
    }

    public ModifierEntryHelper removeAllEntrySkinLock(boolean removeAttribute, List<TagKey<ModifierEntry>> onlyTags) {
        for (ModifierInstant modifierInstant : this.getModifierEntries()) {
            if (!onlyTags.isEmpty() && !onlyTags.stream().anyMatch(tag -> modifierInstant.getModifierEntry().tags.contains(tag))) continue;
            this.removeModifierEntry(modifierInstant, removeAttribute);
        }
        return this;
    }

    public ModifierEntryHelper removeAllEntry(boolean removeAttribute) {
        this.removeAllEntry(removeAttribute, List.of());
        return this;
    }

    public static int getLivingEntityEntryLevel(String entryID, LivingEntity e) {
        int level = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemBySlot = e.m_6844_(slot);
            if (itemBySlot.m_41619_() || CuriosUtil.isCuriosItem2(itemBySlot)) continue;
            ModifierEntryHelper modifierEntryHelper = new ModifierEntryHelper(itemBySlot);
            level += modifierEntryHelper.getModifierEntryLevel(entryID);
        }
        return level;
    }

    public static int getLivingEntitySubEntryLevel(String entryID, LivingEntity e) {
        int level = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemBySlot = e.m_6844_(slot);
            if (itemBySlot.m_41619_() || CuriosUtil.isCuriosItem2(itemBySlot)) continue;
            ModifierEntryHelper modifierEntryHelper = new ModifierEntryHelper(itemBySlot);
            level += modifierEntryHelper.getSubModifierEntryLevel(entryID);
        }
        return level;
    }

    public List<ModifierEntry> randomEntry(int rarity, String material, int refreshTime) {
        Map<ItemType, EquipmentSlot[]> typeEquipmentSlotMap = ModifierHandle.CommonEvent.typeSlotMap();
        WeightedUtil<String> weightedUtil = new WeightedUtil<String>(new HashMap());
        for (Map.Entry<ItemType, EquipmentSlot[]> entry : typeEquipmentSlotMap.entrySet()) {
            ItemType type2 = entry.getKey();
            if (!ModifierHandle.CommonEvent.isValidForType(this.itemStack, type2)) continue;
            weightedUtil.merge(new WeightedUtil<String>(ModifierHandle.modifierEntryMap.entrySet().stream().filter(e -> {
                if (((ModifierEntry)e.getValue()).weight == 0.0f) {
                    return false;
                }
                ModifierEntry modifier = (ModifierEntry)e.getValue();
                boolean hasWashItem = ModifierHandle.materialsList.stream().anyMatch(m -> m.ItemId.equals(material) && !m.OnlyHasWashEntry);
                List<String> onlyWashItems = ((ModifierItemSelector)modifier.getModifierItemSelector()).getOnlyWashItems();
                return !(!modifier.types.stream().map(ItemType::name).toList().contains(type2.name()) || !modifier.getModifierItemSelector().containItem(this.itemStack) || modifier.cantSelect || !modifier.Slots.isEmpty() || modifier.needFreshValue != 0.0f && !(modifier.needFreshValue <= (float)rarity) || !onlyWashItems.isEmpty() && !onlyWashItems.contains(material) && !hasWashItem);
            }).collect(Collectors.toMap(Map.Entry::getKey, e -> Float.valueOf(((ModifierEntry)e.getValue()).weight)))));
        }
        if (!weightedUtil.weights.isEmpty()) {
            weightedUtil.increaseWeightsByRarity(rarity);
            try {
                return ModifierSelector.selectEntriesOnly(weightedUtil, (int)refreshTime, (Function<String, ModifierEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomEntry$8(java.lang.String ), (Ljava/lang/String;)Lnet/exmo/exmodifier/content/modifier/ModifierEntry;)()).entries;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<ModifierEntry>();
    }

    public ModifierEntryHelper setModifierEntry(int index, ModifierInstant instant) {
        ListTag modifierEntriesNbt = this.getModifierEntriesNbt();
        modifierEntriesNbt.set(index, (Tag)instant.serializeNBT());
        this.getMainNbt().m_128365_(MES, (Tag)modifierEntriesNbt);
        return this;
    }

    public ModifierEntryHelper setModifierEntryLevel(String entryID, int level) {
        for (ModifierInstant modifierInstant : this.getModifierEntries()) {
            if (!modifierInstant.getModifierEntry().id.equals(entryID)) continue;
            modifierInstant.setLevel(level);
            return this;
        }
        return this;
    }

    public int getSubModifierEntryLevel(String entryID) {
        ListTag modifierEntriesNbt = this.getModifierEntriesNbt();
        for (int i = 0; i < modifierEntriesNbt.size(); ++i) {
            if (!modifierEntriesNbt.m_128728_(i).m_128461_(MEID).substring(2).equals(entryID.substring(2))) continue;
            return modifierEntriesNbt.m_128728_(i).m_128451_("Level");
        }
        return 0;
    }

    public int getModifierEntryLevel(String entryID) {
        ListTag modifierEntriesNbt = this.getModifierEntriesNbt();
        for (int i = 0; i < modifierEntriesNbt.size(); ++i) {
            if (!modifierEntriesNbt.m_128728_(i).m_128461_(MEID).equals(entryID)) continue;
            return modifierEntriesNbt.m_128728_(i).m_128451_("Level");
        }
        return 0;
    }

    public Optional<String> getModifierEntrySlot(String entryID) {
        ListTag modifierEntriesNbt = this.getModifierEntriesNbt();
        for (int i = 0; i < modifierEntriesNbt.size(); ++i) {
            if (!modifierEntriesNbt.m_128728_(i).m_128461_(MEID).equals(entryID)) continue;
            return Optional.of(modifierEntriesNbt.m_128728_(i).m_128461_(SLOT));
        }
        return Optional.empty();
    }

    public ModifierEntryHelper setModifierEntrySlot(String entryID, String slot) {
        ListTag modifierEntriesNbt = this.getModifierEntriesNbt();
        for (int i = 0; i < modifierEntriesNbt.size(); ++i) {
            if (!modifierEntriesNbt.m_128728_(i).m_128461_(MEID).equals(entryID)) continue;
            modifierEntriesNbt.m_128728_(i).m_128359_(SLOT, slot);
            return this;
        }
        return this;
    }

    public ModifierEntryHelper(ItemStack itemStack) {
        super(itemStack);
    }

    public int getModifierEntriesSize() {
        CompoundTag mainNbt = this.getMainNbt();
        if (!this.ValidMainNbt()) {
            return 0;
        }
        return mainNbt.m_128437_(MES, 10).size();
    }

    public boolean gatherModifierInstant(ModifierInstant modifierInstant) {
        List<ModifierInstant> modifierEntries = this.getModifierEntries();
        AtomicInteger level = new AtomicInteger(modifierInstant.getLevel());
        ArrayList toRemove = new ArrayList();
        modifierEntries.forEach(x -> {
            if (x.getModifierEntry().id.equals(modifierInstant.getModifierEntry().id)) {
                level.set(modifierInstant.getLevel() + x.getLevel());
                toRemove.add(x);
            }
        });
        if (level.get() == modifierInstant.getLevel()) {
            return false;
        }
        for (ModifierInstant re : toRemove) {
            this.removeModifierEntryUnLock(re, true);
        }
        this.addModifierEntry(modifierInstant.setLevel(level.get()), true, false);
        return level.get() != modifierInstant.getLevel();
    }

    public ListTag getModifierEntriesNbt() {
        return this.getMainNbt().m_128437_(MES, 10);
    }

    public List<ModifierInstant> getModifierEntries() {
        CompoundTag tag;
        ArrayList<ModifierInstant> modifierEntries = new ArrayList<ModifierInstant>();
        if (this.ValidMainNbt() && (tag = this.getMainNbt()).m_128441_(MES)) {
            ListTag modifiersList = tag.m_128437_(MES, 10);
            for (int i = 0; i < modifiersList.size(); ++i) {
                CompoundTag tag1 = modifiersList.m_128728_(i);
                ModifierEntry modifierEntry = ModifierHandle.modifierEntryMap.get(tag1.m_128461_(MEID));
                if (modifierEntry == null) continue;
                int level = 1;
                String slot = "";
                if (tag1.m_128441_("Level")) {
                    level = tag1.m_128451_("Level");
                }
                if (tag1.m_128441_(SLOT)) {
                    slot = tag1.m_128461_(SLOT);
                }
                CompoundTag tag2 = tag1.m_6426_();
                tag2.m_128473_("Level");
                tag2.m_128473_(SLOT);
                tag2.m_128473_(MEID);
                modifierEntries.add(new ModifierInstant(modifierEntry, level).setData(tag2).setSlot(slot).setLock(tag1.m_128441_("islock") && tag1.m_128471_("islock")));
            }
        }
        return modifierEntries;
    }

    public List<ModifierEntry> getModifierEntriesB() {
        ArrayList<ModifierEntry> modifierEntries = new ArrayList<ModifierEntry>();
        for (ModifierInstant modifierInstant : this.getModifierEntries()) {
            modifierEntries.add(modifierInstant.getModifierEntry());
        }
        return modifierEntries;
    }

    public ModifierEntryHelper addModifierEntry(ModifierInstant modifierInstant, boolean addAttribute, boolean gather, ModifierInstant oldInstant) {
        this.createNbt();
        if (!this.ValidMainNbt()) {
            this.createMainNbt();
        }
        this.createModifierEntryNbt();
        if (gather && this.gatherModifierInstant(modifierInstant)) {
            return this;
        }
        CompoundTag tag1 = new CompoundTag();
        tag1.m_128359_(MEID, modifierInstant.getModifierEntry().id);
        if (modifierInstant.isItemQualityLock()) {
            tag1.m_128379_("ItemQualityLock", true);
        }
        if (modifierInstant.isLock()) {
            tag1.m_128379_("islock", true);
        }
        tag1.m_128405_("Level", modifierInstant.getLevel());
        if (modifierInstant.getSlot().isPresent()) {
            tag1.m_128359_(SLOT, modifierInstant.getSlot().get());
        }
        ListTag modifiersList = this.getModifierEntriesNbt();
        modifiersList.add((Object)tag1);
        if (addAttribute) {
            List<ModifierAttriGether> addTo = ModifierHandle.CommonEvent.selectModifierAttributes(modifierInstant.getModifierEntry());
            if (CuriosUtil.isCuriosItem2(this.itemStack)) {
                ModifierHandle.CommonEvent.applyModifiersCurios(this.itemStack, addTo, CuriosUtil.getSlotsFromItemstack(this.itemStack), oldInstant);
            } else {
                ModifierHandle.CommonEvent.applyModifiers(this.itemStack, addTo, this.getEquipmentSlot(this.itemStack), modifierInstant, oldInstant);
            }
        }
        return this;
    }

    public ModifierEntryHelper addModifierEntry(ModifierInstant modifierInstant, boolean addAttribute, boolean gather) {
        this.addModifierEntry(modifierInstant, addAttribute, gather, null);
        return this;
    }

    public ModifierEntryHelper removeModifierEntryLevel(ModifierInstant modifierInstant, boolean removeAttribute) {
        int old_modifier_level = this.getModifierEntryLevel(modifierInstant.getModifierEntry().id);
        if (old_modifier_level > modifierInstant.getLevel()) {
            return this.setModifierEntryLevel(modifierInstant.getModifierEntry().id, old_modifier_level - modifierInstant.getLevel());
        }
        return this.removeModifierEntry(modifierInstant, removeAttribute);
    }

    public ModifierEntryHelper removeModifierEntry(ModifierInstant modifierInstant, boolean removeAttribute) {
        this.createNbt();
        if (!this.ValidMainNbt()) {
            return this;
        }
        ListTag modifiersList = this.getModifierEntriesNbt();
        for (int i = modifiersList.size() - 1; i >= 0; --i) {
            CompoundTag tag1 = modifiersList.m_128728_(i);
            if (!tag1.m_128461_(MEID).equals(modifierInstant.getModifierEntry().id) || tag1.m_128471_("CantRemove") && tag1.m_128471_("itemQualityLock")) continue;
            modifiersList.remove(i);
        }
        if (removeAttribute) {
            if (CuriosUtil.isCuriosItem2(this.itemStack)) {
                for (ModifierAttriGether modifierAttriGether : modifierInstant.getModifierEntry().attriGether) {
                    if (modifierAttriGether.attribute == null) continue;
                    CuriosUtil.removeAttributeModifierAffix(this.itemStack, ExUtil.getAttributeID(modifierAttriGether.attribute).toString(), modifierAttriGether.modifier.getName());
                }
            }
            for (ModifierAttriGether modifierAttriGether : modifierInstant.getModifierEntry().attriGether) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ItemAttrUtil.removeAttributeModifierNoAmout(this.itemStack, modifierAttriGether.attribute, modifierAttriGether.modifier, slot);
                }
            }
        }
        return this;
    }

    public ModifierEntryHelper removeModifierEntryUnLock(ModifierInstant modifierInstant, boolean removeAttribute) {
        this.createNbt();
        if (!this.ValidMainNbt()) {
            return this;
        }
        ListTag modifiersList = this.getModifierEntriesNbt();
        for (int i = 0; i < modifiersList.size(); ++i) {
            CompoundTag tag1 = modifiersList.m_128728_(i);
            if (!tag1.m_128461_(MEID).equals(modifierInstant.getModifierEntry().id)) continue;
            modifiersList.remove(i);
            break;
        }
        if (removeAttribute) {
            for (ModifierAttriGether modifierAttriGether : modifierInstant.getModifierEntry().attriGether) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ItemAttrUtil.removeAttributeModifierNoAmout(this.itemStack, modifierAttriGether.attribute, modifierAttriGether.modifier, slot);
                }
            }
        }
        return this;
    }

    public static ModifierEntry getEntry(String entryName) {
        return ModifierHandle.modifierEntryMap.get(entryName);
    }

    public static List<ModifierAttriGether> getEntryAttriGether(ModifierEntry entry) {
        return entry.attriGether;
    }

    public static List<ModifierAttriGether> getEntryAttriGether(String entryID) {
        return ModifierEntryHelper.getEntry((String)entryID).attriGether;
    }

    private static /* synthetic */ ModifierEntry lambda$randomEntry$8(String key) {
        return ModifierHandle.modifierEntryMap.get(key);
    }

    public static class oldFunc {
        @Deprecated(since="0.033", forRemoval=true)
        public static int getItemStackEntryCount_old(ItemStack stack) {
            if (stack.m_41783_() == null) {
                return 0;
            }
            int i = 0;
            while (!stack.m_41783_().m_128461_("exmodifier_armor_modifier_applied" + i).isEmpty()) {
                ++i;
            }
            return i;
        }

        @Deprecated(since="0.033", forRemoval=true)
        public static List<ModifierEntry> getEntrysFromItemStack_old(ItemStack stack) {
            ArrayList<ModifierEntry> modifierEntries = new ArrayList<ModifierEntry>();
            if (stack.m_41783_() == null) {
                return modifierEntries;
            }
            for (ModifierEntry modifierAttriGether : ModifierHandle.modifierEntryMap.values().stream().filter(Objects::nonNull).toList()) {
                String id;
                int i = 0;
                while (!(id = stack.m_41783_().m_128461_("exmodifier_armor_modifier_applied" + i)).isEmpty()) {
                    if (id.equals(modifierAttriGether.getId())) {
                        modifierEntries.add(modifierAttriGether);
                    }
                    ++i;
                }
            }
            return modifierEntries;
        }

        @Deprecated(since="0.033", forRemoval=true)
        public static void clearEntry_old(ItemStack stack) {
            if (stack.m_41783_() == null) {
                return;
            }
            if (stack.m_41783_().m_128451_("exmodifier_armor_modifier_applied") == 0) {
                return;
            }
            List<String> curiosType = CuriosUtil.getSlotsFromItemstack(stack);
            List<ModifierEntry> hasAttriGether = oldFunc.getEntrysFromItemStack_old(stack);
            for (int i = 0; i < hasAttriGether.size(); ++i) {
                ModifierEntry modifierAttriGether = hasAttriGether.get(i);
                for (ModifierAttriGether modifierAttriGether1 : modifierAttriGether.attriGether) {
                    List<ItemType> type2;
                    EquipmentSlot slot = modifierAttriGether1.slot;
                    if (modifierAttriGether1.IsAutoEquipmentSlot && !(type2 = ModifierEntry.getType(stack)).isEmpty()) {
                        slot = ModifierEntry.TypeToEquipmentSlot(type2.get(0));
                    }
                    if (curiosType.isEmpty()) {
                        ItemAttrUtil.removeAttributeModifierNoAmout(stack, modifierAttriGether1.getAttribute(), modifierAttriGether1.getModifier(), slot);
                    } else {
                        for (String curioType : curiosType) {
                            if (!ForgeRegistries.ATTRIBUTES.containsValue((Object)modifierAttriGether1.getAttribute()) || ExUtil.getAttributeID(modifierAttriGether1.getAttribute()) == null) continue;
                            CuriosUtil.removeAttributeModifierAffix(stack, ExUtil.getAttributeID(modifierAttriGether1.getAttribute()).toString(), modifierAttriGether1.getModifier().getName());
                        }
                    }
                    stack.m_41784_().m_128473_("exmodifier_armor_modifier_applied" + i);
                }
            }
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                Multimap attributeModifiers = stack.m_41638_(equipmentSlot);
                if (!attributeModifiers.isEmpty()) continue;
                attributeModifiers.clear();
            }
        }
    }

    public static class refreshContent {
        public static ItemStack applyRefreshEffect(Player player, ItemStack inputItem, ItemStack washItem) {
            if (inputItem.m_41619_() || washItem.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack result = inputItem;
                boolean effectApplied = false;
                for (WashingMaterials material : ModifierHandle.materialsList) {
                    if (!material.item.equals(washItem.m_41720_()) || washItem.m_41613_() < material.NeedCount || !refreshContent.checkMaterialConditions(result, material)) continue;
                    ModifierEntryHelper modifierHelper = ModifierEntryHelper.of(result);
                    refreshContent.processExistingEntries(modifierHelper, material.getKeepEntries());
                    int finalRarity = refreshContent.calculateFinalRarity(material);
                    refreshContent.applyNewEntries(player, result, material, finalRarity);
                    refreshContent.processItemLevels(result, material);
                    washItem.m_41774_(material.NeedCount);
                    effectApplied = refreshContent.handleRefreshEvents(player, inputItem, washItem, result, material);
                    break;
                }
                if (!effectApplied && washItem.m_41720_() instanceof EntryItem) {
                    effectApplied = refreshContent.handleEntryItem(player, result, washItem);
                }
                PlayerRefreshScreenOverMessageMessage message1 = effectApplied ? new PlayerRefreshScreenOverMessageMessage(ItemStack.f_41583_, (Component)Component.m_237115_((String)"gui.exmodifier.refresh_success")) : new PlayerRefreshScreenOverMessageMessage(ItemStack.f_41583_, (Component)Component.m_237115_((String)"gui.exmodifier.refresh_fail"));
                Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)message1);
                return effectApplied ? refreshContent.cleanupTags(result) : ItemStack.f_41583_;
            }
            return ItemStack.f_41583_;
        }

        private static boolean checkMaterialConditions(ItemStack item, WashingMaterials material) {
            if (!material.OnlyTypes.isEmpty() && !ModifierEntry.containItemTypes(item, material.OnlyTypes)) {
                return false;
            }
            if (material.OnlyItems != null && !material.OnlyItems.contains(ExUtil.getItemID(item))) {
                return false;
            }
            return material.OnlyTags == null || material.containTag(item);
        }

        private static void processExistingEntries(ModifierEntryHelper helper, int keepEntries) {
            if (keepEntries == 0) {
                helper.removeAllEntry(true, List.of(ModifierEntry.defaultTag));
            } else {
                List<ModifierInstant> entries = helper.getModifierEntries();
                for (int i = entries.size() - 1; i >= keepEntries; --i) {
                    helper.removeModifierEntry(entries.get(i), true);
                }
            }
        }

        private static int calculateFinalRarity(WashingMaterials material) {
            if (material.MinRandomTime <= 0 || material.MaxRandomTime <= 0) {
                return material.rarity;
            }
            return material.rarity + new Random().nextInt(material.MaxRandomTime - material.MinRandomTime) + material.MinRandomTime;
        }

        private static void applyNewEntries(Player player, ItemStack result, WashingMaterials material, int rarity) {
            if (material.additionEntry > 0) {
                if (CuriosUtil.isCuriosItem2(result)) {
                    ModifierHandle.CommonEvent.RandomEntryCurios(result, rarity, material.additionEntry, material.ItemId);
                } else {
                    ModifierHandle.CommonEvent.RandomEntry(result, rarity, material.additionEntry, material.ItemId, material.getKeepEntries());
                }
                if (!player.m_9236_().f_46443_) {
                    MinecraftForge.EVENT_BUS.post((Event)new ExRefreshEvent(player, material.additionEntry, rarity, material.ItemId));
                }
            }
        }

        private static void processItemLevels(ItemStack result, WashingMaterials material) {
            if (material.randomLevelSystemCount != 0) {
                ItemLevelHandle.ItemLevelRefresh(result, material.randomLevelSystemCount, 1, material.ItemId);
            }
        }

        private static boolean handleRefreshEvents(Player player, ItemStack input, ItemStack washItem, ItemStack result, WashingMaterials material) {
            ExOnTableRefreshEntriesEvent event = new ExOnTableRefreshEntriesEvent(material, input, washItem, result);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }

        private static boolean handleEntryItem(Player player, ItemStack result, ItemStack washItem) {
            if (!RefreshMenu.compareItemType(result, washItem)) {
                return false;
            }
            ModifierEntryHelper helper = ModifierEntryHelper.of(result);
            ModifierEntry entry = ((EntryItem)washItem.m_41720_()).getModifierEntry(washItem);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (helper.getModifierEntriesSize() >= Config.canAddEntry) {
                    PlayerRefreshScreenOverMessageMessage message1 = new PlayerRefreshScreenOverMessageMessage(ItemStack.f_41583_, (Component)Component.m_237115_((String)"gui.exmodifier.refresh_fail_limit"));
                    Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)message1);
                    return false;
                }
            }
            if (helper.getModifierEntryLevel(entry.id) >= entry.maxLevel) {
                return false;
            }
            CompoundTag tag = result.m_41784_();
            int entryCount = tag.m_128451_("entryitem_add");
            if (entryCount >= Config.canAddEntry) {
                tag.m_128379_("can_add_max", true);
                return true;
            }
            helper.addModifierEntry(new ModifierInstant(entry, EntryItem.getModifierLevel(washItem)), true, true);
            tag.m_128405_("entryitem_add", entryCount + 1);
            washItem.m_41774_(1);
            return true;
        }

        private static ItemStack cleanupTags(ItemStack result) {
            CompoundTag tag = result.m_41784_();
            tag.m_128473_("modifier_refresh");
            tag.m_128473_("entry_item_add");
            tag.m_128473_("modifier_refresh_rarity");
            tag.m_128473_("random_level_system_count");
            tag.m_128473_("NeedCount");
            tag.m_128473_("wash_item");
            tag.m_128473_("keepEntries");
            tag.m_128473_("modifier_refresh_add");
            tag.m_128473_("UNKNOWN");
            return result;
        }
    }
}

