/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.level;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.event.parameter.EventParameter;
import net.exmo.exmodifier.content.helper.ItemInfo;
import net.exmo.exmodifier.content.helper.ItemLevelHelper;
import net.exmo.exmodifier.content.level.ItemLevel;
import net.exmo.exmodifier.content.level.ItemLevelInstant;
import net.exmo.exmodifier.content.level.LevelAttriGether;
import net.exmo.exmodifier.content.modifier.MoConfig;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.content.type.ExType;
import net.exmo.exmodifier.content.type.ExTypeHandle;
import net.exmo.exmodifier.content.type.ItemType;
import net.exmo.exmodifier.events.ExItemUpEvent;
import net.exmo.exmodifier.events.ExLevelRegistryEvent;
import net.exmo.exmodifier.util.DynamicExpressionEvaluator;
import net.exmo.exmodifier.util.ExAttributeModifier;
import net.exmo.exmodifier.util.ExConfigHandle;
import net.exmo.exmodifier.util.ItemAttrUtil;
import net.exmo.exmodifier.util.WeightedUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemLevelHandle {
    public static List<MoConfig> Foundlvconfigs = new ArrayList<MoConfig>();
    public static final Path LEVEL_CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("exmo/ItemLevel");
    public static Map<String, ItemLevel> ItemLevels = new HashMap<String, ItemLevel>();

    public static void RegistryItemLevel(ItemLevel itemLevel) {
        ItemLevels.put(itemLevel.getId(), itemLevel);
        Exmodifier.LOGGER.debug("Registry ItemLevel: " + itemLevel.id);
    }

    public static void contaiff(ItemStack stack, int rarity, int refreshnumber, List<ItemType> type2) {
        Exmodifier.LOGGER.debug("ItemLevelRefresh: " + stack.m_41778_() + " " + String.valueOf(type2));
        WeightedUtil<String> weightedUtil = new WeightedUtil<String>(Map.of());
        for (ItemType type1 : type2) {
            weightedUtil.merge(new WeightedUtil<String>(ItemLevels.entrySet().stream().filter(e -> Objects.equals(((ItemLevel)e.getValue()).type.name(), type1.name())).filter(e -> ((ItemLevel)e.getValue()).getOnlyItemIds().isEmpty() || ((ItemLevel)e.getValue()).getOnlyItemIds().contains(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString())).filter(e -> ((ItemLevel)e.getValue()).getOnlyItemTags().isEmpty() || ((ItemLevel)e.getValue()).containTag(stack)).filter(e -> ((ItemLevel)e.getValue()).UnlessItemTags.isEmpty() || ((ItemLevel)e.getValue()).unContainTag(stack)).filter(e -> ((ItemLevel)e.getValue()).getOnlyWashItems().isEmpty() || ((ItemLevel)e.getValue()).getOnlyWashItems().contains(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString())).collect(Collectors.toMap(Map.Entry::getKey, e -> Float.valueOf(((ItemLevel)e.getValue()).getWeight())))));
        }
        if (!weightedUtil.weights.isEmpty()) {
            Exmodifier.LOGGER.debug("RandomLevelEntry: " + String.valueOf(type2));
            weightedUtil.increaseWeightsByRarity(rarity);
            ItemLevelHandle.ItemLevelRefresh2(stack, weightedUtil, refreshnumber);
            Exmodifier.LOGGER.debug("RandomLevel: " + String.valueOf(type2) + " " + stack.m_41778_());
        }
    }

    public static void ItemLevelRefresh(ItemStack stack, int rarity, int refreshnumber, String washItem) {
        if (stack.m_41783_() == null) {
            return;
        }
        if (ItemLevelHelper.of(stack).getItemLevelsSize() > 0) {
            return;
        }
        boolean find = false;
        ArrayList<ItemType> typeList = new ArrayList<ItemType>();
        for (ItemType type2 : ExTypeHandle.itemTypes.values().stream().filter(e -> e != ExType.UNKNOWN.get()).filter(e -> e != ExType.ALL.get()).toList()) {
            if (!ModifierEntry.containItemType(stack, type2)) continue;
            typeList.add(type2);
            find = true;
        }
        ItemLevelHandle.contaiff(stack, rarity, refreshnumber, typeList);
        if (!find) {
            ItemLevelHandle.contaiff(stack, rarity, refreshnumber, Collections.singletonList(ExType.ALL.get()));
            Exmodifier.LOGGER.debug("ItemLevelRefresh: No Type And refresh ALL TYPE");
        }
    }

    public static void ItemAddXpAuto(LivingEntity entity, List<EventParameter<?>> eventParameters, String eventname) {
        if (entity == null) {
            return;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = entity.m_6844_(slot);
            if (stack.m_41619_()) continue;
            ItemLevelHandle.ItemAddXp(entity, stack, eventParameters, eventname);
        }
    }

    public static void ItemAddXp(LivingEntity entity, ItemStack stack, List<EventParameter<?>> params, String eventName) {
        Exmodifier.LOGGER.debug("ItemLevelUp0: " + String.valueOf(stack.serializeNBT()));
        if (stack.m_41783_() == null) {
            return;
        }
        for (ItemLevelInstant il : ItemLevelHelper.of(stack).getItemLevelInstants()) {
            if (il == null || il.itemLevel == null || !eventName.equalsIgnoreCase(il.itemLevel.getUpEvent())) continue;
            new ItemInfo(stack).getItemLevelHelper().ItemAddXpM(stack, params, il, entity);
        }
    }

    public static double generateLevelNeedXp(ItemLevel itemLevel, int level) {
        DynamicExpressionEvaluator evaluator = new DynamicExpressionEvaluator();
        evaluator.setVariable("level", level);
        evaluator.setVariable("lv", level);
        return evaluator.evaluate(itemLevel.getLevelExpression());
    }

    public static List<Component> genItemLevelInfo(ItemStack stack) {
        List<ItemLevelInstant> itemLevels = new ItemLevelHelper(stack).getItemLevelInstants();
        ArrayList<Component> components = new ArrayList<Component>();
        for (ItemLevelInstant itemLevel : itemLevels) {
            components.addAll(ItemLevelHandle.getLevelItemLevelInfo(stack, itemLevel));
        }
        return components;
    }

    public static List<Component> getLevelItemLevelInfo(ItemStack stack, ItemLevelInstant itemLevelInstant) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (itemLevelInstant == null) {
            return components;
        }
        if (itemLevelInstant.itemLevel == null) {
            return components;
        }
        int levelItemLevel = itemLevelInstant.level;
        MutableComponent translatable = Component.m_237115_((String)("modifier.level." + itemLevelInstant.itemLevel.id));
        if (Screen.m_96638_()) {
            translatable.m_6270_(Style.f_131099_.m_131157_(ChatFormatting.UNDERLINE));
            components.add((Component)translatable);
            String levelInfo = String.format("%s %s %s", " ", levelItemLevel + " / ", itemLevelInstant.maxLevel + " ");
            components.add((Component)Component.m_237115_((String)"modifier.level").m_7220_((Component)Component.m_237113_((String)levelInfo)).m_130940_(ChatFormatting.AQUA));
            String xpInfo = String.format("%s %s %s", " ", (int)itemLevelInstant.xp + " / ", (int)itemLevelInstant.needXp + " ");
            components.add((Component)Component.m_237115_((String)"modifier.xp").m_7220_((Component)Component.m_237113_((String)xpInfo)).m_130940_(ChatFormatting.GREEN));
            if (itemLevelInstant.level > 0) {
                ArrayList<LevelAttriGether> _setval2 = new ArrayList<LevelAttriGether>(itemLevelInstant.itemLevel.attriGethers);
                for (LevelAttriGether ita : _setval2) {
                    for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                        for (AttributeModifier modifier : stack.m_41638_(equipmentSlot).values()) {
                            if (!modifier.m_22214_().equals(ita.getModifier().getName())) continue;
                            ita.modifier = ExAttributeModifier.fromModifier(modifier);
                        }
                    }
                    components.add((Component)Component.m_237115_((String)"modifier.attri.\u00a6").m_7220_((Component)ita.generateTooltipBase()));
                }
            }
        } else {
            components.add((Component)translatable.m_130940_(ChatFormatting.GOLD).m_130946_(" ").m_130946_("" + levelItemLevel));
        }
        return components;
    }

    private static void ItemLevelRefresh2(ItemStack stack, WeightedUtil<String> weightedUtil, int refreshnumber) {
        int numAddedModifiers = 0;
        ArrayList<ItemLevel> foundItemLevels = new ArrayList<ItemLevel>();
        if (weightedUtil.weights.size() < refreshnumber) {
            refreshnumber = weightedUtil.weights.size();
        }
        while (numAddedModifiers < refreshnumber) {
            ItemLevel itemLevel = ItemLevels.get(weightedUtil.selectRandomKeyBasedOnWeights());
            if (foundItemLevels.contains(itemLevel)) continue;
            Exmodifier.LOGGER.debug("add level entry: " + itemLevel.id);
            foundItemLevels.add(itemLevel);
            ItemLevelHelper.of(stack).addItemLevelInstant(ItemLevelInstant.of(itemLevel));
            ++numAddedModifiers;
        }
    }

    private static void processItemLevel(MoConfig moconfig, Map.Entry<String, JsonElement> entry, List<ItemLevel> entries) {
        JsonElement itemElement = entry.getValue();
        if (!itemElement.isJsonObject()) {
            return;
        }
        JsonObject itemObject = itemElement.getAsJsonObject();
        ItemLevel itemLevel = new ItemLevel();
        itemLevel.setType(itemObject.has("type") ? ModifierEntry.StringToType(itemObject.get("type").getAsString()) : moconfig.type);
        itemLevel.setId(itemLevel.getType().name().substring(0, 2) + entry.getKey());
        if (!moconfig.CuriosType.isEmpty()) {
            itemLevel.curiosType = moconfig.CuriosType;
        }
        if (itemLevel.type.toString().toUpperCase().startsWith("CURIOS")) {
            itemLevel.isCuriosEntry = true;
            if (itemObject.has("curiosType")) {
                itemLevel.curiosType = itemObject.get("curiosType").getAsString();
            } else if (moconfig.CuriosType.isEmpty()) {
                itemLevel.curiosType = "ALL";
            }
        }
        itemLevel.setDefaultLevel(itemObject.has("DefaultLevel") ? itemObject.get("DefaultLevel").getAsInt() : 0);
        itemLevel.setMaxLevel(itemObject.has("MaxLevel") ? itemObject.get("MaxLevel").getAsInt() : 0);
        if (itemObject.has("UpEvent")) {
            itemLevel.setUpEvent(itemObject.get("UpEvent").getAsString());
        }
        if (itemObject.has("LevelExpression")) {
            itemLevel.setLevelExpression(itemObject.get("LevelExpression").getAsString());
        }
        if (itemObject.has("XpAddValue")) {
            itemLevel.setXpAddValue(itemObject.get("XpAddValue").getAsString());
        }
        if (itemObject.has("XpAddExpression")) {
            itemLevel.setXpAddExpression(itemObject.get("XpAddExpression").getAsString());
        }
        itemLevel.needFreshValue = itemObject.has("needFreshValue") ? itemObject.get("needFreshValue").getAsFloat() : 0.0f;
        boolean bl = itemLevel.cantSelect = itemObject.has("cantSelect") && itemObject.get("cantSelect").getAsBoolean();
        if (itemObject.has("weight")) {
            itemLevel.setWeight(itemObject.get("weight").getAsFloat());
        }
        if (itemObject.has("OnlyWashItems")) {
            JsonArray OnlyItems = itemObject.get("OnlyWashItems").getAsJsonArray();
            OnlyItems.forEach(item -> itemLevel.OnlyWashItems.add(item.getAsString()));
        }
        if (itemObject.has("OnlyItems")) {
            itemLevel.setOnlyItemIds(new ArrayList<String>());
            for (JsonElement itemId : itemObject.get("OnlyItems").getAsJsonArray()) {
                itemLevel.getOnlyItemIds().add(itemId.getAsString());
            }
        }
        if (itemObject.has("UnlessItemIds")) {
            itemLevel.setUnlessItemIds(new ArrayList<String>());
            for (JsonElement itemId : itemObject.get("UnlessItemIds").getAsJsonArray()) {
                itemLevel.getUnlessItemIds().add(itemId.getAsString());
            }
        }
        if (itemObject.has("UnlessItemTags")) {
            itemLevel.setUnlessItemTags(new ArrayList<String>());
            for (JsonElement itemId : itemObject.get("UnlessItemTags").getAsJsonArray()) {
                itemLevel.getUnlessItemTags().add(itemId.getAsString());
            }
        }
        if (itemObject.has("OnlyItemTags")) {
            itemLevel.setOnlyItemTags(new ArrayList<String>());
            for (JsonElement itemTag : itemObject.get("OnlyItemTags").getAsJsonArray()) {
                itemLevel.getOnlyItemTags().add(itemTag.getAsString());
            }
        }
        if (itemObject.has("attrGethers")) {
            ItemLevelHandle.processAttrGethers(moconfig, itemLevel, itemObject.getAsJsonObject("attrGethers"));
        }
    }

    public static void processAttrGethers(MoConfig moconfig, ItemLevel itemLevel, JsonObject attrGethers) {
        int index = 0;
        for (Map.Entry attrGetherEntry : attrGethers.entrySet()) {
            try {
                ItemLevelHandle.processAttrGether(moconfig, itemLevel, attrGetherEntry, index);
                ++index;
            }
            catch (Exception e) {
                Exmodifier.LOGGER.error("Error processing attrGether: " + (String)attrGetherEntry.getKey(), e);
            }
        }
    }

    public static void processAttrGether(MoConfig moconfig, ItemLevel itemLevel, Map.Entry<String, JsonElement> attrGetherEntry, int index) throws Exception {
        Object modifierName;
        JsonObject attrGetherObj = attrGetherEntry.getValue().getAsJsonObject();
        Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attrGetherEntry.getKey()));
        double attrValue = attrGetherObj.has("value") ? attrGetherObj.get("value").getAsDouble() : 0.0;
        AttributeModifier.Operation operation = attrGetherObj.has("operation") ? ExConfigHandle.getOperation(attrGetherObj.get("operation").getAsString()) : AttributeModifier.Operation.ADDITION;
        EquipmentSlot slot = ModifierHandle.getEquipmentSlot(attrGetherObj);
        Object object = modifierName = attrGetherObj.has("modifierName") ? attrGetherObj.get("modifierName").getAsString() : itemLevel.id + index;
        if (attrGetherObj.has("id")) {
            attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attrGetherObj.get("id").getAsString()));
        }
        if (attrGetherObj.has("autoName") && attrGetherObj.has("autoName") && attrGetherObj.get("autoName").getAsBoolean()) {
            modifierName = itemLevel.id + index;
        }
        ExAttributeModifier modifier = new ExAttributeModifier((String)modifierName, attrValue, operation);
        LevelAttriGether attrGether = new LevelAttriGether(attribute, modifier, slot);
        if (attrGetherObj.has("minValue")) {
            attrGether.minValue = attrGetherObj.get("minValue").getAsDouble();
        }
        attrGether.maxValue = attrGetherObj.has("maxValue") ? attrGetherObj.get("maxValue").getAsDouble() : attrGether.minValue;
        attrGether.reserveDouble = attrGetherObj.has("reserveDouble") ? attrGetherObj.get("reserveDouble").getAsInt() : 0;
        HashMap<Double, Float> simpleWeight = new HashMap<Double, Float>();
        ArrayList mayValues = new ArrayList();
        ArrayList mayValuesKey = new ArrayList();
        if (attrGetherObj.has("mayValues")) {
            JsonArray mayValuesArray = attrGetherObj.get("mayValues").getAsJsonArray();
            mayValuesArray.forEach(mayValue -> mayValues.add(mayValue.getAsDouble()));
        }
        if (attrGetherObj.has("mayValuesWeight")) {
            JsonArray mayValuesKeyArray = attrGetherObj.get("mayValuesWeight").getAsJsonArray();
            mayValuesKeyArray.forEach(mayValueKey -> mayValuesKey.add(Float.valueOf(mayValueKey.getAsFloat())));
        }
        for (int i = 0; i < mayValues.size(); ++i) {
            Float value = (Float)mayValuesKey.get(i);
            if (value == null) {
                value = Float.valueOf(0.0f);
            }
            simpleWeight.put((Double)mayValues.get(i), value);
        }
        if (!simpleWeight.isEmpty()) {
            attrGether.simpleWeight = simpleWeight;
        }
        attrGether.IsAutoEquipmentSlot = attrGetherObj.has("isAutoEquipmentSlot") && attrGetherObj.get("isAutoEquipmentSlot").getAsBoolean();
        attrGether.hasUUID = attrGetherObj.has("uuid");
        if (!attrGether.IsAutoEquipmentSlot && attrGetherObj.has("slot")) {
            if (!attrGetherObj.get("slot").getAsString().equals("auto")) {
                attrGether.slot = EquipmentSlot.valueOf((String)attrGetherObj.get("slot").getAsString());
            } else {
                attrGether.IsAutoEquipmentSlot = true;
            }
        }
        if (attrGetherObj.has("weight")) {
            attrGether.weight = attrGetherObj.get("weight").getAsFloat();
        }
        if (attrGetherObj.has("isRandom")) {
            attrGether.isRandom = attrGetherObj.get("isRandom").getAsBoolean();
        }
        if (attrGetherObj.has("Expression")) {
            attrGether.Expression = attrGetherObj.get("Expression").getAsString();
        }
        Exmodifier.LOGGER.debug("Attribute: " + String.valueOf(attribute) + " key: " + attrGetherEntry.getKey());
        itemLevel.attriGethers.add(attrGether);
        ItemLevelHandle.RegistryItemLevel(itemLevel);
    }

    public static void processLevelMoConfigEntries(MoConfig moconfig) throws FileNotFoundException {
        ArrayList<ItemLevel> entries = new ArrayList<ItemLevel>();
        for (Map.Entry<String, JsonElement> entry2 : moconfig.readEntrys()) {
            try {
                ItemLevelHandle.processItemLevel(moconfig, entry2, entries);
            }
            catch (Exception e) {
                Exmodifier.LOGGER.error("Error processing Item Level: " + entry2.getKey(), e);
            }
        }
        WeightedUtil<String> weightedUtil = new WeightedUtil<String>(entries.stream().collect(Collectors.toMap(ItemLevel::getId, ItemLevel::getWeight)));
        entries.forEach(entry -> {
            ItemLevelHandle.RegistryItemLevel(entry);
            Exmodifier.LOGGER.debug(entry.id + " \u51fa\u73b0\u6982\u7387 " + weightedUtil.getProbability(entry.id) * 100.0f + "%");
        });
        ExLevelRegistryEvent event = new ExLevelRegistryEvent(entries);
        MinecraftForge.EVENT_BUS.post((Event)event);
        Exmodifier.LOGGER.debug("ReadConfig Over: Type: " + String.valueOf(moconfig.type) + " Path: " + String.valueOf(moconfig.configFile) + " entries: " + entries.size());
    }

    @Mod.EventBusSubscriber
    public static class CommonEvent {
        @SubscribeEvent
        public static void AtUp(ExItemUpEvent event) {
            ItemStack stack = event.stack;
            if (stack.m_41783_() == null) {
                return;
            }
            List<LevelAttriGether> attriGethers = event.LevelId.itemLevel.attriGethers;
            for (int i = 0; i < attriGethers.size(); ++i) {
                DynamicExpressionEvaluator dynamicExpressionEvaluator = new DynamicExpressionEvaluator();
                LevelAttriGether attriGether = attriGethers.get(i);
                List<EquipmentSlot> slot = Collections.singletonList(attriGether.slot);
                if (attriGether.IsAutoEquipmentSlot) {
                    Item item = stack.m_41720_();
                    if (item instanceof ArmorItem) {
                        ArmorItem armorItem = (ArmorItem)item;
                        slot = Collections.singletonList(armorItem.m_40402_());
                    } else {
                        List<ItemType> type2 = ModifierEntry.getType(stack);
                        if (!type2.isEmpty()) {
                            ArrayList<EquipmentSlot> slot1 = new ArrayList<EquipmentSlot>();
                            for (ItemType itemType : type2) {
                                slot1.addAll(Arrays.stream(itemType.getEquipmentSlot()).toList());
                            }
                            slot = slot1;
                        }
                    }
                }
                for (EquipmentSlot equipmentSlot : slot) {
                    ItemAttrUtil.removeAttributeModifierNoAmout(stack, attriGether.getAttribute(), attriGether.getModifier(), equipmentSlot);
                    dynamicExpressionEvaluator.setVariable("level", event.nowLevel);
                    double amount = dynamicExpressionEvaluator.evaluate(attriGether.Expression);
                    ItemAttrUtil.addItemAttributeModifier2(stack, attriGether.attribute, attriGether.getModifier().setAmount(amount), equipmentSlot);
                }
            }
            LivingEntity livingEntity = event.entity;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_213846_((Component)Component.m_237115_((String)("modifier.level." + event.LevelId.itemLevel.id)).m_130946_(" ").m_7220_(stack.m_41611_()).m_130946_(" \u00a7r").m_7220_((Component)Component.m_237110_((String)"modifier.level.up", (Object[])new Object[]{event.beforeLevel, event.nowLevel, event.nowLevel - event.beforeLevel})));
                player.m_9236_().m_5594_(null, new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_()), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.player.levelup")), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

