/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.modifier;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.util.TooltipUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class EntryItem
extends Item {
    public EntryItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public ModifierEntry getModifierEntry(ItemStack stack) {
        return ModifierHandle.modifierEntryMap.get(stack.m_41784_().m_128461_("modifier_id"));
    }

    public static String getModifierID(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return "";
        }
        return stack.m_41783_().m_128461_("modifier_id");
    }

    public static int getModifierLevel(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return 1;
        }
        return stack.m_41783_().m_128451_("modifier_level");
    }

    public static double getModifierChance(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return 0.0;
        }
        return stack.m_41783_().m_128459_("modifier_possibility") * 100.0;
    }

    public Component m_7626_(ItemStack stack) {
        ModifierEntry modifierEntry = this.getModifierEntry(stack);
        if (modifierEntry != null) {
            return Component.m_237115_((String)modifierEntry.getDescriptionId());
        }
        return super.m_7626_(stack);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class CommonEvent {
        public static final DecimalFormat df = new DecimalFormat("#.####");

        @SubscribeEvent
        public static void tooltip(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            if (stack.m_41783_() == null) {
                return;
            }
            if (stack.m_41720_() instanceof EntryItem && !event.getToolTip().isEmpty()) {
                ArrayList<Object> lc = new ArrayList<Object>();
                String modifierId = EntryItem.getModifierID(stack);
                ModifierEntry modifierEntry = ModifierHandle.modifierEntryMap.get(modifierId);
                if (modifierEntry == null) {
                    lc.add(Component.m_237115_((String)"modifier.entry.unknown_modifier"));
                    return;
                }
                if (modifierId.length() <= 2) {
                    return;
                }
                lc.add(Component.m_237115_((String)modifierEntry.getDescriptionId()));
                if (!Screen.m_96638_()) {
                    ListTag types = stack.m_41783_().m_128437_("modifier_types", 8);
                    double possibility = stack.m_41783_().m_128459_("modifier_possibility") * 100.0;
                    lc.add(Component.m_237115_((String)"modifier.entry.possibility").m_130946_(df.format(possibility)).m_130946_("%"));
                    lc.add(Component.m_237115_((String)"modifier.entry.level").m_130946_(String.valueOf(EntryItem.getModifierLevel(stack))));
                    lc.add(Component.m_237115_((String)"modifier.entry.maxlevel").m_130946_(String.valueOf(modifierEntry.maxLevel)));
                    if (!modifierEntry.localDescription.isEmpty()) {
                        lc.add(Component.m_237115_((String)"modifier.entry.desc"));
                        lc.addAll(TooltipUtil.sprit(Component.m_237115_((String)modifierEntry.localDescription)));
                    }
                    if (!modifierEntry.Slots.isEmpty()) {
                        if (modifierEntry.Slots.size() == 1) {
                            lc.add(Component.m_237115_((String)"modifier.entry.slot").m_7220_((Component)Component.m_237115_((String)("modifier.slot." + modifierEntry.Slots.get(0)))));
                        } else {
                            for (String slot : modifierEntry.Slots) {
                                lc.add(Component.m_237113_((String)" \u00a77\u00a6 \u00a7r").m_7220_((Component)Component.m_237115_((String)("modifier.slot." + slot))));
                            }
                        }
                    }
                    if (types.size() > 1) {
                        lc.add(Component.m_237115_((String)"modifier.entry.type"));
                        for (Tag type2 : types) {
                            lc.add(Component.m_237113_((String)" \u00a77\u00a6 \u00a7r").m_7220_((Component)Component.m_237115_((String)"modifier.entry.type").m_130946_(type2.m_7916_())));
                        }
                    } else if (!types.isEmpty()) {
                        lc.add(Component.m_237115_((String)"modifier.entry.type").m_130946_(types.get(0).m_7916_()));
                    }
                    lc.add(Component.m_237113_((String)" "));
                    lc.add(Component.m_237115_((String)"modifier.entry.look_more_shift"));
                } else if (modifierEntry == null) {
                    lc.add(Component.m_237115_((String)"modifier.entry.unknown_modifier"));
                } else {
                    lc.addAll(modifierEntry.GenerateItemTooltip());
                }
                List ToRemove = event.getToolTip();
                event.getToolTip().removeAll(ToRemove);
                event.getToolTip().addAll(lc);
            }
        }
    }
}

