/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.modifier;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.util.ExAttributeModifier;
import net.exmo.exmodifier.util.ExConfigHandle;
import net.exmo.exmodifier.util.ExUtil;
import net.exmo.exmodifier.util.exSerialize.ExSerialize;
import net.exmo.exmodifier.util.gether.AttriGether;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class ModifierAttriGether
extends AttriGether {
    public static ExSerialize<ModifierAttriGether> ExSer = ExSerialize.create(ModifierAttriGether::new).addFloatField("weight", e -> Float.valueOf(e.weight), (e, v) -> {
        e.weight = v.floatValue();
    }).addBooleanField("isRandom", e -> e.isRandom, (e, v) -> {
        e.isRandom = v;
    }).addBooleanField("hasUUID", e -> e.hasUUID, (e, v) -> {
        e.hasUUID = v;
    }).addDoubleField("minValue", e -> e.minValue, (e, v) -> {
        e.minValue = v;
    }).addDoubleField("maxValue", e -> e.maxValue, (e, v) -> {
        e.maxValue = v;
    }).addStringField("Expression", e -> e.Expression, (e, v) -> {
        e.Expression = v;
    }).addStringListField("OnlyItems", e -> e.OnlyItems, (e, v) -> {
        e.OnlyItems = v;
    }).addStringListField("OnlySlots", e -> e.OnlySlots, (e, v) -> {
        e.OnlySlots = v;
    }).addJsonObjectList("simpleWeight", e -> e.simpleWeight.entrySet().stream().map(entry -> {
        JsonObject obj = new JsonObject();
        obj.addProperty("key", (Number)entry.getKey());
        obj.addProperty("value", (Number)entry.getValue());
        return obj;
    }).collect(Collectors.toList()), (e, list) -> {
        e.simpleWeight = list.stream().collect(Collectors.toMap(obj -> obj.get("key").getAsDouble(), obj -> Float.valueOf(obj.get("value").getAsFloat())));
    }).addResourceLocationField("attribute", e -> ResourceLocation.m_135820_((String)ExUtil.getAttributeID(e.attribute)), (e, v) -> {
        e.attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(v);
    }).addStringField("slot", e -> e.slot != null ? e.slot.m_20751_() : "", (e, v) -> {
        e.slot = EquipmentSlot.m_20747_((String)v);
    }).addBooleanField("IsAutoEquipmentSlot", e -> e.IsAutoEquipmentSlot, (e, v) -> {
        e.IsAutoEquipmentSlot = v;
    }).addJsonObjectField("modifier", e -> {
        JsonObject obj = new JsonObject();
        obj.addProperty("name", e.modifier.getName());
        obj.addProperty("amount", (Number)e.modifier.getAmount());
        obj.addProperty("operation", (Number)e.modifier.getOperation().m_22235_());
        return obj;
    }, (e, json) -> {
        String name = json.get("name").getAsString();
        double amount = json.get("amount").getAsDouble();
        AttributeModifier.Operation operation = AttributeModifier.Operation.m_22236_((int)json.get("operation").getAsInt());
        e.modifier = new ExAttributeModifier(name, amount, operation);
    });
    public float weight = 0.0f;
    public boolean isRandom = false;
    public int reserveDouble = 3;
    public boolean hasUUID = false;
    public double minValue = 0.0;
    public double maxValue = 0.0;
    public Map<Double, Float> simpleWeight = new HashMap<Double, Float>();
    public String Expression = "";
    public List<String> OnlyItems = new ArrayList<String>();
    public List<String> OnlySlots = new ArrayList<String>();

    public ModifierAttriGether() {
        super(null, null);
    }

    public ModifierAttriGether setExpression(String expression) {
        this.Expression = expression;
        return this;
    }

    public ModifierAttriGether copy() {
        ModifierAttriGether attriGether = new ModifierAttriGether(this.attribute, this.modifier, this.slot);
        attriGether.weight = this.weight;
        attriGether.isRandom = this.isRandom;
        attriGether.reserveDouble = this.reserveDouble;
        attriGether.hasUUID = this.hasUUID;
        attriGether.minValue = this.minValue;
        attriGether.maxValue = this.maxValue;
        attriGether.simpleWeight = this.simpleWeight;
        attriGether.Expression = this.Expression;
        attriGether.OnlyItems = this.OnlyItems;
        attriGether.OnlySlots = this.OnlySlots;
        return attriGether;
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("weight", this.weight);
        tag.m_128379_("isRandom", this.isRandom);
        tag.m_128405_("reserveDouble", this.reserveDouble);
        tag.m_128379_("hasUUID", this.hasUUID);
        tag.m_128379_("IsAutoEquipmentSlot", this.IsAutoEquipmentSlot);
        tag.m_128347_("minValue", this.minValue);
        tag.m_128347_("maxValue", this.maxValue);
        tag.m_128359_("Expression", this.Expression);
        ListTag onlyItemsTag = new ListTag();
        for (String string : this.OnlyItems) {
            onlyItemsTag.add((Object)StringTag.m_129297_((String)string));
        }
        tag.m_128365_("OnlyItems", (Tag)onlyItemsTag);
        ListTag onlySlotsTag = new ListTag();
        for (String slot : this.OnlySlots) {
            onlySlotsTag.add((Object)StringTag.m_129297_((String)slot));
        }
        tag.m_128365_("OnlySlots", (Tag)onlySlotsTag);
        ListTag listTag = new ListTag();
        for (Map.Entry<Double, Float> entry : this.simpleWeight.entrySet()) {
            CompoundTag weightEntry = new CompoundTag();
            weightEntry.m_128347_("key", entry.getKey().doubleValue());
            weightEntry.m_128350_("value", entry.getValue().floatValue());
            listTag.add((Object)weightEntry);
        }
        tag.m_128365_("simpleWeight", (Tag)listTag);
        tag.m_128391_(this.toNBT1());
        return tag;
    }

    public static ModifierAttriGether fromNBT(CompoundTag tag) {
        AttriGether attriGether1 = AttriGether.fromNBT1(tag);
        ModifierAttriGether attriGether = new ModifierAttriGether(attriGether1.attribute, attriGether1.modifier, attriGether1.slot);
        attriGether.weight = tag.m_128457_("weight");
        attriGether.isRandom = tag.m_128471_("isRandom");
        attriGether.reserveDouble = tag.m_128451_("reserveDouble");
        attriGether.hasUUID = tag.m_128471_("hasUUID");
        attriGether.minValue = tag.m_128459_("minValue");
        attriGether.maxValue = tag.m_128459_("maxValue");
        attriGether.Expression = tag.m_128461_("Expression");
        attriGether.IsAutoEquipmentSlot = tag.m_128471_("IsAutoEquipmentSlot");
        ListTag onlyItemsTag = tag.m_128437_("OnlyItems", 8);
        for (int i = 0; i < onlyItemsTag.size(); ++i) {
            attriGether.OnlyItems.add(onlyItemsTag.m_128778_(i));
        }
        ListTag onlySlotsTag = tag.m_128437_("OnlySlots", 8);
        for (int i = 0; i < onlySlotsTag.size(); ++i) {
            attriGether.OnlySlots.add(onlySlotsTag.m_128778_(i));
        }
        ListTag simpleWeightTag = tag.m_128437_("simpleWeight", 10);
        for (int i = 0; i < simpleWeightTag.size(); ++i) {
            CompoundTag weightEntry = simpleWeightTag.m_128728_(i);
            double key = weightEntry.m_128459_("key");
            float value = weightEntry.m_128457_("value");
            attriGether.simpleWeight.put(key, Float.valueOf(value));
        }
        return attriGether;
    }

    public String toString() {
        return "ModifierAttriGether{weight=" + this.weight + ", isRandom=" + this.isRandom + ", hasUUID=" + this.hasUUID + ", OnlyItems=" + String.valueOf(this.OnlyItems) + ", OnlySlots=" + String.valueOf(this.OnlySlots) + ", slot=" + String.valueOf(this.slot) + ", IsAutoEquipmentSlot=" + this.IsAutoEquipmentSlot + ", attribute=" + String.valueOf(this.attribute) + ", modifier=" + String.valueOf(this.modifier) + "}";
    }

    public List<String> getOnlyItems() {
        return this.OnlyItems;
    }

    public List<String> getOnlySlots() {
        return this.OnlySlots;
    }

    public ModifierAttriGether(Attribute attribute, ExAttributeModifier modifier, EquipmentSlot slot) {
        super(attribute, modifier, slot);
    }

    public ModifierAttriGether(Attribute attribute, ExAttributeModifier modifier) {
        super(attribute, modifier);
    }

    public static List<ModifierAttriGether> GenerateModifierAttriGethers(String autokey, JsonObject obj) {
        int index = 0;
        ArrayList<ModifierAttriGether> attriGethers = new ArrayList<ModifierAttriGether>();
        for (Map.Entry attrGetherEntry : obj.entrySet()) {
            try {
                attriGethers.add(ModifierAttriGether.processAttrGether(autokey, attrGetherEntry, index));
                ++index;
            }
            catch (Exception e) {
                Exmodifier.LOGGER.Logger.error("Error processing attrGether: " + (String)attrGetherEntry.getKey(), (Throwable)e);
            }
        }
        return attriGethers;
    }

    private static ModifierAttriGether processAttrGether(String autokey, Map.Entry<String, JsonElement> attrGetherEntry, int index) {
        JsonObject attrGetherObj = attrGetherEntry.getValue().getAsJsonObject();
        Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attrGetherEntry.getKey()));
        double attrValue = attrGetherObj.get("value").getAsDouble();
        AttributeModifier.Operation operation = ExConfigHandle.getOperation(attrGetherObj.get("operation").getAsString());
        EquipmentSlot slot = ModifierHandle.getEquipmentSlot(attrGetherObj);
        Object modifierName = attrGetherObj.has("modifierName") ? attrGetherObj.get("modifierName").getAsString() : autokey + index;
        boolean autoName = false;
        if (attrGetherObj.has("autoName") && attrGetherObj.has("autoName") && attrGetherObj.get("autoName").getAsBoolean()) {
            modifierName = autokey + index;
            autoName = true;
        }
        ExAttributeModifier modifier = new ExAttributeModifier((String)modifierName, attrValue, operation);
        ModifierAttriGether attrGether = new ModifierAttriGether(attribute, modifier, slot);
        attrGether.IsAutoEquipmentSlot = attrGetherObj.has("isAutoEquipmentSlot") && attrGetherObj.get("isAutoEquipmentSlot").getAsBoolean();
        attrGether.hasUUID = attrGetherObj.has("uuid");
        if (!attrGether.IsAutoEquipmentSlot && attrGetherObj.has("slot")) {
            if (!attrGetherObj.get("slot").getAsString().equals("auto")) {
                attrGether.slot = EquipmentSlot.valueOf((String)attrGetherObj.get("slot").getAsString());
            } else {
                attrGether.IsAutoEquipmentSlot = true;
            }
        }
        if (attrGetherObj.has("weight")) {
            attrGether.weight = attrGetherObj.get("weight").getAsFloat();
        }
        if (attrGetherObj.has("isRandom")) {
            attrGether.isRandom = attrGetherObj.get("isRandom").getAsBoolean();
        }
        Exmodifier.LOGGER.debug("Attribute: " + String.valueOf(attribute) + " key: " + attrGetherEntry.getKey());
        return attrGether;
    }

    public MutableComponent GenerateTooltip(boolean canSeeWeight) {
        if (canSeeWeight) {
            return this.generateTooltipBase().m_7220_((Component)Component.m_237115_((String)"exmodifier.tooltip.weight")).m_7220_((Component)Component.m_237113_((String)("\u00a79" + this.weight)));
        }
        return this.generateTooltipBase();
    }

    public Float getWeight() {
        return Float.valueOf(this.weight);
    }
}

