/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.modifier;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.exmo.exmodifier.content.modifier.EntryItem;
import net.exmo.exmodifier.content.modifier.ModifierAttriGether;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.content.modifier.ModifierInstant;
import net.exmo.exmodifier.content.selected.ModifierItemSelector;
import net.exmo.exmodifier.content.specialEffects.SpecialEffect;
import net.exmo.exmodifier.content.suit.ExSuit;
import net.exmo.exmodifier.content.suit.ExSuitHandle;
import net.exmo.exmodifier.content.type.ExType;
import net.exmo.exmodifier.content.type.ExTypeHandle;
import net.exmo.exmodifier.content.type.ItemType;
import net.exmo.exmodifier.util.ExAttributeModifier;
import net.exmo.exmodifier.util.ExUtil;
import net.exmo.exmodifier.util.ItemAttrUtil;
import net.exmo.exmodifier.util.SelectorClass;
import net.exmo.exmodifier.util.WeightedUtil;
import net.exmo.exmodifier.util.exSerialize.ExSerClass;
import net.exmo.exmodifier.util.exSerialize.ExSerialize;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public class ModifierEntry
implements SelectorClass<ModifierItemSelector<ModifierEntry>>,
ExSerClass<ModifierEntry> {
    public static ExSerialize<ModifierEntry> ExSer = ExSerialize.create(ModifierEntry::new).addStringListField("types", e -> e.types.stream().map(ItemType::name).toList(), (modifierEntry, strings) -> {
        modifierEntry.types = strings.stream().map(ModifierEntry::StringToType).toList();
    }).addStringField("id", e -> e.id, (modifierEntry, s) -> {
        modifierEntry.id = s;
    }).addStringField("type", (modifierEntry, s) -> modifierEntry.types.add(ModifierEntry.StringToType(s))).onlyRead().addBooleanField("cantSelect", e -> e.cantSelect, (modifierEntry, aBoolean) -> {
        modifierEntry.cantSelect = aBoolean;
    }).addBooleanField("isRandom", e -> e.isRandom, (modifierEntry, aBoolean) -> {
        modifierEntry.isRandom = aBoolean;
    }).addStringField("icon", e -> e.icon, (modifierEntry, s) -> {
        modifierEntry.icon = s;
    }).addStringListField("slots", e -> e.Slots, (modifierEntry, strings) -> {
        modifierEntry.Slots = strings;
    }).addStringListField("specialTags", e -> e.specialTags, (modifierEntry, strings) -> {
        modifierEntry.specialTags = strings;
    }).addStringField("localDescription", e -> e.localDescription, (modifierEntry, s) -> {
        modifierEntry.localDescription = s;
    }).addIntField("maxLevel", e -> e.maxLevel, (modifierEntry, integer) -> {
        modifierEntry.maxLevel = integer;
    }).addBooleanField("displayNameInItemName", e -> e.displayNameInItemName, (modifierEntry, aBoolean) -> {
        modifierEntry.displayNameInItemName = aBoolean;
    }).addStringField("curiosType", e -> e.curiosType, (modifierEntry, s) -> {
        modifierEntry.curiosType = s;
    }).addBooleanField("OnlyHasThisEntry", e -> e.OnlyHasThisEntry, (modifierEntry, aBoolean) -> {
        modifierEntry.OnlyHasThisEntry = aBoolean;
    }).addFloatField("needFreshValue", e -> Float.valueOf(e.needFreshValue), (modifierEntry, aFloat) -> {
        modifierEntry.needFreshValue = aFloat.floatValue();
    }).addFloatField("weight", e -> Float.valueOf(e.weight), (modifierEntry, aFloat) -> {
        modifierEntry.weight = aFloat.floatValue();
    }).addStringListField("tags", e -> e.tags.stream().map(TagKey::f_203868_).map(ResourceLocation::toString).toList(), (modifierEntry, strings) -> {
        modifierEntry.tags = strings.stream().map(e -> ExUtil.createOrGetModifierTagKey(new ResourceLocation(e))).toList();
    }).addStringField("Expression", e -> e.Expression, (modifierEntry, s) -> {
        modifierEntry.Expression = s;
    }).addSubclass(modifierEntry -> modifierEntry.modifierItemSelector, (modifierEntry, modifierItemSelector) -> {
        modifierEntry.modifierItemSelector = (ModifierItemSelector)modifierItemSelector;
    }, ModifierItemSelector.ExSer).addJsonObjectList("attriGethers", modifierEntry -> ModifierAttriGether.ExSer.toJson(modifierEntry.attriGether).asList().stream().map(JsonElement::getAsJsonObject).toList(), (modifierEntry, jsonObjects) -> {
        modifierEntry.attriGether = jsonObjects.stream().flatMap(jsonObject -> ModifierAttriGether.ExSer.fromJson((JsonObject)jsonObject).stream()).toList();
    }).addJsonObjectList("attriGethers", modifierEntry -> ModifierAttriGether.ExSer.toJson(modifierEntry.attriGether).asList().stream().map(JsonElement::getAsJsonObject).toList(), (modifierEntry, jsonObjects) -> {
        modifierEntry.attriGether = jsonObjects.stream().flatMap(jsonObject -> ModifierAttriGether.ExSer.fromJson((JsonObject)jsonObject).stream()).toList();
    }).onlyRead();
    public static final ResourceKey<Registry<ModifierEntry>> MODIFIER_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.m_214293_((String)"exmodifier", (String)"modifier_entry"));
    public static final TagKey<ModifierEntry> defaultTag = TagKey.m_203882_(MODIFIER_KEY, (ResourceLocation)new ResourceLocation("exmodifier", "refresh_default"));
    public Map<String, JsonObject> specialTagSetting = new HashMap<String, JsonObject>();
    public float weight;
    public boolean cantSelect = false;
    public boolean isRandom = true;
    public String icon = "";
    public String source = "";
    public List<String> entityTypes = new ArrayList<String>();
    public List<TagKey<ModifierEntry>> tags = new ArrayList<TagKey<ModifierEntry>>();
    public boolean OnlyHasThisEntry = false;
    public String localDescription = "";
    public int maxLevel = 1;
    public int iconSize = 0;
    public List<String> Slots = new ArrayList<String>();
    public List<ItemType> types = new ArrayList<ItemType>();
    public boolean isCuriosEntry = false;
    public float needFreshValue = 0.0f;
    public String curiosType = "";
    public boolean displayNameInItemName = false;
    public String group = "exmodifier_tab";
    public String id;
    public String Expression = "";
    public Pair<Integer, Integer> randomLevel;
    public List<String> exsuits = new ArrayList<String>();
    public int RandomNum = 0;
    public ModifierItemSelector<ModifierEntry> modifierItemSelector = new ModifierItemSelector();
    public List<ModifierAttriGether> attriGether = new ArrayList<ModifierAttriGether>();
    public List<String> specialTags = new ArrayList<String>();
    public boolean autoId = false;

    public JsonObject getSpecialTagSetting(String id) {
        return this.specialTagSetting.get(id);
    }

    public JsonObject getSpecialTagSetting(SpecialEffect specialEffect) {
        return this.specialTagSetting.get(specialEffect.id());
    }

    public Optional<JsonElement> getSpecialTagSetting(SpecialEffect specialEffect, String s) {
        return Optional.ofNullable(this.specialTagSetting.get(specialEffect.id()).get(s));
    }

    public Optional<JsonElement> getSpecialTagSetting(String id, String s) {
        return Optional.ofNullable(this.specialTagSetting.get(id).get(s));
    }

    public float getSpecialTagSettingFloatOrDefault(String id, String s, float defaultValue) {
        JsonObject jsonObject = this.specialTagSetting.get(id);
        if (jsonObject == null) {
            return defaultValue;
        }
        Optional<JsonElement> jsonElement = Optional.ofNullable(jsonObject.get(s));
        return jsonElement.map(JsonElement::getAsFloat).orElse(Float.valueOf(defaultValue)).floatValue();
    }

    public int getSpecialTagSettingFloatOrDefault(String id, String s, int defaultValue) {
        JsonObject jsonObject = this.specialTagSetting.get(id);
        if (jsonObject == null) {
            return defaultValue;
        }
        Optional<JsonElement> jsonElement = Optional.ofNullable(jsonObject.get(s));
        return jsonElement.map(JsonElement::getAsInt).orElse(defaultValue);
    }

    public double getSpecialTagSettingDoubleOrDefault(String id, String s, double defaultValue) {
        JsonObject jsonObject = this.specialTagSetting.get(id);
        if (jsonObject == null) {
            return defaultValue;
        }
        Optional<JsonElement> jsonElement = Optional.ofNullable(jsonObject.get(s));
        return jsonElement.map(JsonElement::getAsDouble).orElse(defaultValue);
    }

    public String getSpecialTagSettingStringOrDefault(String id, String s, String defaultValue) {
        JsonObject jsonObject = this.specialTagSetting.get(id);
        if (jsonObject == null) {
            return defaultValue;
        }
        Optional<JsonElement> jsonElement = Optional.ofNullable(jsonObject.get(s));
        return jsonElement.map(JsonElement::getAsString).orElse(defaultValue);
    }

    public ModifierEntry(String id) {
        this.id = id;
    }

    public ModifierEntry() {
    }

    @Override
    public ModifierItemSelector<ModifierEntry> getModifierItemSelector() {
        return this.modifierItemSelector;
    }

    public boolean containItemType(ItemType type2) {
        return this.types.stream().map(ItemType::name).toList().contains(type2.name());
    }

    public ModifierInstant toInstant() {
        return ModifierInstant.of(this);
    }

    public ModifierInstant toInstant(int level) {
        return ModifierInstant.of(this, level);
    }

    public static boolean containItemTypes(ItemStack stack, List<ItemType> types) {
        for (ItemType type2 : types) {
            if (!type2.compare(stack)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ModifierEntry{setting=" + String.valueOf(this.specialTagSetting) + ", weight=" + this.weight + ", cantSelect=" + this.cantSelect + ", isRandom=" + this.isRandom + ", icon='" + this.icon + "', source='" + this.source + "', entityTypes=" + String.valueOf(this.entityTypes) + ", tags=" + String.valueOf(this.tags) + ", OnlyHasThisEntry=" + this.OnlyHasThisEntry + ", localDescription='" + this.localDescription + "', maxLevel=" + this.maxLevel + ", Slots=" + String.valueOf(this.Slots) + ", types=" + String.valueOf(this.types) + ", isCuriosEntry=" + this.isCuriosEntry + ", needFreshValue=" + this.needFreshValue + ", curiosType='" + this.curiosType + "', displayNameInItemName=" + this.displayNameInItemName + ", id='" + this.id + "', Expression='" + this.Expression + "', RandomNum=" + this.RandomNum + ", modifierItemSelector=" + String.valueOf(this.modifierItemSelector) + ", attriGether=" + String.valueOf(this.attriGether) + ", specialTags=" + String.valueOf(this.specialTags) + "}";
    }

    public String getDescriptionId() {
        return this.autoId ? "modifier.entry." + this.id.substring(2) : "modifier.entry." + this.id;
    }

    public static String getDescriptionId(String id) {
        return "modifier.entry." + id;
    }

    public static String getAutoDescriptionId(String id) {
        return "modifier.entry." + id.substring(2);
    }

    public static boolean containItemType(ItemStack stack, ItemType type2) {
        return type2.compare(stack);
    }

    public static List<Component> GenerateTooltip(List<ModifierAttriGether> attriGethers, ItemStack itemStack) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        for (ModifierAttriGether modifierAttriGether : attriGethers) {
            ExAttributeModifier attributemodifier = modifierAttriGether.getModifier();
            Attribute attribute = modifierAttriGether.getAttribute();
            if (attribute == null || attributemodifier == null || !ItemAttrUtil.hasAttributeModifierCompoundTagNoAmount(itemStack, attribute, attributemodifier, modifierAttriGether.slot)) continue;
            double d0 = attributemodifier.getAmount();
            boolean flag = false;
            String percent = "";
            double d1 = attributemodifier.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL && !ModifierHandle.percentAtr.contains(ExUtil.getAttributeID(attribute).toString()) ? (attribute.equals(Attributes.f_22278_) ? d0 * 10.0 : d0) : d0 * 100.0;
            String amouta2 = "";
            if (ModifierHandle.percentAtr.contains(ExUtil.getAttributeID(attribute).toString())) {
                percent = "%";
                DecimalFormat df = new DecimalFormat("#.####");
                amouta2 = df.format(attributemodifier.getAmount() * 100.0);
                if (modifierAttriGether.attribute.m_22087_().length() >= 4 && (ExUtil.getAttributeID(attribute).toString().startsWith("twtp") || ExUtil.getAttributeID(attribute).toString().startsWith("isfix"))) {
                    amouta2 = df.format(attributemodifier.getAmount());
                }
            }
            if (flag) {
                tooltips.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + attributemodifier.getOperation().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)attribute.m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN));
                continue;
            }
            if (d0 > 0.0) {
                if (percent.equals("%")) {
                    tooltips.add((Component)Component.m_237115_((String)"add").m_130946_(amouta2).m_130946_(percent).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)attribute.m_22087_())).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                tooltips.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier.getOperation().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE));
                continue;
            }
            if (!(d0 < 0.0)) continue;
            d1 *= -1.0;
            if (percent.equals("%")) {
                tooltips.add((Component)Component.m_237115_((String)"subtract").m_130946_(amouta2).m_130946_(percent).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)attribute.m_22087_())).m_130940_(ChatFormatting.RED));
                continue;
            }
            tooltips.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.getOperation().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.RED));
        }
        return tooltips;
    }

    public static EquipmentSlot TypeToEquipmentSlot(ItemType type2) {
        if (type2.equals(ExType.HAND.get()) || type2.equals(ExType.MAINHAND.get()) || type2.equals(ExType.BOW.get()) || type2.equals(ExType.ATTACKABLE.get()) || type2.equals(ExType.AXE.get())) {
            return EquipmentSlot.MAINHAND;
        }
        if (type2.equals(ExType.OFFHAND.get()) || type2.equals(ExType.SHIELD.get())) {
            return EquipmentSlot.OFFHAND;
        }
        if (type2.equals(ExType.CHESTPLATE.get())) {
            return EquipmentSlot.CHEST;
        }
        if (type2.equals(ExType.LEGGINGS.get())) {
            return EquipmentSlot.LEGS;
        }
        if (type2.equals(ExType.HELMET.get())) {
            return EquipmentSlot.HEAD;
        }
        if (type2.equals(ExType.BOOTS.get())) {
            return EquipmentSlot.FEET;
        }
        return null;
    }

    public static ItemType StringToType(String type2) {
        if (type2.toLowerCase().startsWith("curios")) {
            return ExType.CURIOS.get();
        }
        for (ItemType v : ExTypeHandle.itemTypes.values()) {
            if (!v.name().equalsIgnoreCase(type2)) continue;
            return v;
        }
        return ExType.UNKNOWN.get();
    }

    public static List<ItemType> getType(ItemStack stack) {
        ArrayList<ItemType> types = new ArrayList<ItemType>();
        for (ItemType v : ExTypeHandle.itemTypes.values()) {
            if (!v.compare(stack)) continue;
            types.add(v);
        }
        return types;
    }

    public static ItemType findTypeFormEntry(ModifierEntry modifierEntry) {
        for (ItemType type1 : ExTypeHandle.itemTypes.values()) {
            if (!type1.toString().substring(0, 2).equals(modifierEntry.id.substring(0, 2))) continue;
            return type1;
        }
        return ExType.UNKNOWN.get();
    }

    public float getWeight() {
        return this.weight;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getResId() {
        return ResourceLocation.m_135843_((String)this.getId()) ? new ResourceLocation(this.getId()) : new ResourceLocation("exmodifier", this.getId());
    }

    public boolean hasSpecialEffect(SpecialEffect specialEffect) {
        return this.specialTags.contains(specialEffect.id());
    }

    public boolean hasSpecialEffect(String specialEffect) {
        return this.specialTags.contains(specialEffect);
    }

    public List<Component> GenerateItemTooltip() {
        List<String> onlyItems;
        List<String> onlyTags;
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"modifier.entry.id").m_130946_(this.id));
        list.add((Component)Component.m_237115_((String)"modifier.entry.weight").m_130946_(String.valueOf(this.weight)));
        if (this.cantSelect) {
            list.add((Component)Component.m_237115_((String)"modifier.entry.cant_select"));
        }
        if (this.OnlyHasThisEntry) {
            list.add((Component)Component.m_237115_((String)"modifier.entry.only_has_this_entry"));
        }
        if (this.needFreshValue != 0.0f) {
            list.add((Component)Component.m_237115_((String)"modifier.entry.need_fresh_value").m_130946_(String.valueOf(this.needFreshValue)));
        }
        if (!(onlyTags = this.getModifierItemSelector().getOnlyTags()).isEmpty()) {
            list.add((Component)Component.m_237115_((String)"modifier.entry.only_tags").m_130946_(String.join((CharSequence)",", onlyTags)));
        }
        if (!(onlyItems = this.getModifierItemSelector().getOnlyItems()).isEmpty()) {
            list.add((Component)Component.m_237115_((String)"modifier.entry.only_items").m_130946_(String.join((CharSequence)",", onlyItems)));
        }
        if (this.isRandom && this.RandomNum != 0) {
            list.add((Component)Component.m_237115_((String)"modifier.entry.is_random").m_130946_(String.valueOf(this.RandomNum)));
        }
        list.add((Component)Component.m_237115_((String)"modifier.entry.attribute_gather"));
        WeightedUtil<String> weightUtil = new WeightedUtil<String>(this.attriGether.stream().collect(Collectors.toMap(k -> k.getModifier().getName(), ModifierAttriGether::getWeight, (oldValue, newValue) -> newValue)));
        for (ModifierAttriGether attriGether1 : this.attriGether) {
            list.add((Component)Component.m_237113_((String)" \u00a77\u00a6 \u00a7r").m_7220_((Component)attriGether1.GenerateTooltip(this.isRandom)).m_130946_((String)(this.isRandom ? " \u00a79(" + EntryItem.CommonEvent.df.format(weightUtil.getProbability(attriGether1.getModifier().getName()) * 100.0f) + "%)" : "")));
        }
        boolean hasSuit = false;
        for (ExSuit exSuit2 : ExSuitHandle.LoadExSuit.values().stream().filter(exSuit -> this.exsuits.contains(exSuit.id)).toList()) {
            if (!exSuit2.visible) continue;
            if (!hasSuit) {
                list.add((Component)Component.m_237115_((String)"modifier.entry.suit"));
                hasSuit = true;
            }
            list.add((Component)Component.m_237113_((String)" \u00a77\u00a6 \u00a7r").m_7220_((Component)Component.m_237115_((String)("modifier.entry.suit." + exSuit2.id))));
        }
        if (this.types.size() > 1) {
            list.add((Component)Component.m_237115_((String)"modifier.entry.type"));
            for (ItemType itemType : this.types) {
                list.add((Component)Component.m_237113_((String)" \u00a77\u00a6 \u00a7r").m_130946_(itemType.name()));
            }
        } else if (!this.types.isEmpty()) {
            list.add((Component)Component.m_237115_((String)"modifier.entry.type").m_130946_(this.types.get(0).name()));
        }
        if (this.tags.size() > 1) {
            list.add((Component)Component.m_237115_((String)"modifier.entry.tag"));
            for (TagKey tagKey : this.tags) {
                list.add((Component)Component.m_237113_((String)" \u00a77\u00a6 \u00a7r").m_130946_(tagKey.toString()));
            }
        } else if (!this.tags.isEmpty()) {
            list.add((Component)Component.m_237115_((String)"modifier.entry.tag").m_130946_(this.tags.get(0).toString()));
        }
        list.add((Component)Component.m_237115_((String)"modifier.entry.source").m_130946_(this.source));
        return list;
    }

    public boolean hasDefaultTag() {
        return this.tags.stream().anyMatch(tagKey -> tagKey.toString().equals(defaultTag.toString()));
    }

    @Override
    public ExSerialize<ModifierEntry> getExSerialize() {
        return ExSer;
    }
}

