/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.modifier;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.exmo.exmodifier.content.modifier.ModifierAttriGether;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.selected.ModifierItemSelector;
import net.exmo.exmodifier.content.type.ExType;
import net.exmo.exmodifier.content.type.ExTypeHandle;
import net.exmo.exmodifier.content.type.ItemType;
import net.exmo.exmodifier.util.ExUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class ModifierEntryDataBuilder {
    private final ModifierEntry entry;

    public ModifierEntryDataBuilder() {
        this.entry = new ModifierEntry();
    }

    public ModifierEntryDataBuilder(ModifierEntry entry) {
        this.entry = entry;
    }

    public ModifierEntryDataBuilder setWeight(float weight) {
        this.entry.weight = weight;
        return this;
    }

    public ModifierEntryDataBuilder setCantSelect(boolean cantSelect) {
        this.entry.cantSelect = cantSelect;
        return this;
    }

    public ModifierEntryDataBuilder setIsRandom(boolean isRandom) {
        this.entry.isRandom = isRandom;
        return this;
    }

    public ModifierEntryDataBuilder setIcon(String icon) {
        this.entry.icon = icon;
        return this;
    }

    public ModifierEntryDataBuilder setEntityTypes(List<String> entityTypes) {
        this.entry.entityTypes = entityTypes;
        return this;
    }

    public ModifierEntryDataBuilder setSpecialTagSetting(Map<String, JsonObject> setting) {
        this.entry.specialTagSetting = setting;
        return this;
    }

    public ModifierEntryDataBuilder setSource(String source) {
        this.entry.source = source;
        return this;
    }

    public ModifierEntryDataBuilder setOnlyHasThisEntry(boolean OnlyHasThisEntry) {
        this.entry.OnlyHasThisEntry = OnlyHasThisEntry;
        return this;
    }

    public ModifierEntryDataBuilder setTags(List<TagKey<ModifierEntry>> tags) {
        this.entry.tags = tags;
        return this;
    }

    public ModifierEntryDataBuilder addTag(TagKey<ModifierEntry> tag) {
        this.entry.tags.add(tag);
        return this;
    }

    public ModifierEntryDataBuilder setLocalDescription(String localDescription) {
        this.entry.localDescription = localDescription;
        return this;
    }

    public ModifierEntryDataBuilder setMaxLevel(int maxLevel) {
        this.entry.maxLevel = maxLevel;
        return this;
    }

    public ModifierEntryDataBuilder setAutoId(boolean autoId) {
        this.entry.autoId = autoId;
        return this;
    }

    public ModifierEntryDataBuilder setType(List<ItemType> type2) {
        this.entry.types = type2;
        return this;
    }

    public ModifierEntryDataBuilder setSlots(List<String> slots) {
        this.entry.Slots = slots;
        return this;
    }

    public ModifierEntryDataBuilder setSpecialTags(List<String> specialTags) {
        this.entry.specialTags.addAll(specialTags);
        return this;
    }

    public ModifierEntryDataBuilder setIsCuriosEntry(boolean isCuriosEntry) {
        this.entry.isCuriosEntry = isCuriosEntry;
        return this;
    }

    public ModifierEntryDataBuilder setIconSize(int iconSize) {
        this.entry.iconSize = iconSize;
        return this;
    }

    public ModifierEntryDataBuilder setDisplayNameInItemName(boolean displayNameInItemName) {
        this.entry.displayNameInItemName = displayNameInItemName;
        return this;
    }

    public ModifierEntryDataBuilder setNeedFreshValue(float needFreshValue) {
        this.entry.needFreshValue = needFreshValue;
        return this;
    }

    public ModifierEntryDataBuilder setExsuit(List<String> strings) {
        this.entry.exsuits = strings;
        return this;
    }

    public ModifierEntryDataBuilder setCuriosType(String curiosType) {
        this.entry.curiosType = curiosType;
        return this;
    }

    public ModifierEntryDataBuilder setGroup(String group) {
        this.entry.group = group;
        return this;
    }

    public ModifierEntryDataBuilder setRandomLevel(Pair<Integer, Integer> randomLevel) {
        this.entry.randomLevel = randomLevel;
        return this;
    }

    public ModifierEntryDataBuilder setOnlyTags(List<String> onlyTags) {
        this.entry.getModifierItemSelector().setOnlyTags(onlyTags);
        return this;
    }

    public ModifierEntryDataBuilder setOnlyItems(List<String> onlyItems) {
        this.entry.getModifierItemSelector().setOnlyItems(onlyItems);
        return this;
    }

    public ModifierEntryDataBuilder setOnlyWashItems(List<String> onlyWashItems) {
        ((ModifierItemSelector)this.entry.getModifierItemSelector()).addOnlyWashItems(onlyWashItems);
        return this;
    }

    public ModifierEntryDataBuilder setId(String id) {
        this.entry.id = id;
        return this;
    }

    public ModifierEntryDataBuilder setExpression(String expression) {
        this.entry.Expression = expression;
        return this;
    }

    public ModifierEntryDataBuilder setRandomNum(int randomNum) {
        this.entry.RandomNum = randomNum;
        return this;
    }

    public ModifierEntryDataBuilder setAttriGether(List<ModifierAttriGether> attriGether) {
        this.entry.attriGether.addAll(attriGether);
        return this;
    }

    public ModifierEntry build() {
        return this.entry;
    }

    /*
     * WARNING - void declaration
     */
    public JsonElement toJson() {
        List<String> list;
        List<String> onlyItems;
        List<String> tags;
        List<String> onlyTags;
        JsonObject json = new JsonObject();
        if (this.entry.weight != 1.0f) {
            json.addProperty("weight", (Number)Float.valueOf(this.entry.weight));
        }
        if (this.entry.cantSelect) {
            json.addProperty("cantSelect", Boolean.valueOf(true));
        }
        if (!this.entry.isRandom) {
            json.addProperty("isRandom", Boolean.valueOf(false));
        }
        if (this.entry.OnlyHasThisEntry) {
            json.addProperty("OnlyHasThisEntry", Boolean.valueOf(true));
        }
        if (this.entry.localDescription != null && !this.entry.localDescription.isEmpty()) {
            json.addProperty("localDescription", this.entry.localDescription);
        }
        if (this.entry.maxLevel != 1) {
            json.addProperty("maxLevel", (Number)this.entry.maxLevel);
        }
        if (this.entry.iconSize != 0) {
            json.addProperty("iconSize", (Number)this.entry.iconSize);
        }
        if (this.entry.curiosType != null && !this.entry.curiosType.isEmpty()) {
            json.addProperty("curiosType", this.entry.curiosType);
        }
        if (this.entry.isCuriosEntry) {
            json.addProperty("isCuriosEntry", Boolean.valueOf(true));
        }
        if (this.entry.displayNameInItemName) {
            json.addProperty("displayNameInItemName", Boolean.valueOf(true));
        }
        if (this.entry.autoId) {
            json.addProperty("autoId", Boolean.valueOf(true));
        }
        if (this.entry.needFreshValue != 0.0f) {
            json.addProperty("needFreshValue", (Number)Float.valueOf(this.entry.needFreshValue));
        }
        if (!Objects.equals(this.entry.group, "exmodifier_tab")) {
            json.addProperty("group", this.entry.group);
        }
        if (!this.entry.specialTags.isEmpty()) {
            JsonArray specialTagsArray = new JsonArray();
            for (String string : this.entry.specialTags) {
                specialTagsArray.add((JsonElement)new JsonPrimitive(string));
            }
            json.add("specialTags", (JsonElement)specialTagsArray);
        }
        if (!this.entry.specialTagSetting.isEmpty()) {
            JsonArray specialTagSettingArray = new JsonArray();
            this.entry.specialTagSetting.forEach((tag, jsonObject) -> specialTagSettingArray.add((JsonElement)jsonObject));
            json.add("specialTagSetting", (JsonElement)specialTagSettingArray);
        }
        if (!this.entry.tags.isEmpty()) {
            JsonArray tagsArray = new JsonArray();
            for (TagKey tagKey : this.entry.tags) {
                String string = tagKey.f_203868_().toString();
                tagsArray.add((JsonElement)new JsonPrimitive(string));
            }
            json.add("tags", (JsonElement)tagsArray);
        }
        if (!this.entry.types.contains(ExType.UNKNOWN.get())) {
            JsonArray typesArray = new JsonArray();
            for (ItemType itemType : this.entry.types) {
                typesArray.add((JsonElement)new JsonPrimitive(itemType.name()));
            }
            json.add("types", (JsonElement)typesArray);
        }
        if (!(onlyTags = this.entry.getModifierItemSelector().getOnlyTags()).isEmpty()) {
            JsonArray onlyTagsArray = new JsonArray();
            for (String string : onlyTags) {
                onlyTagsArray.add((JsonElement)new JsonPrimitive(string));
            }
            json.add("OnlyTags", (JsonElement)onlyTagsArray);
        }
        if (!(tags = this.entry.exsuits).isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (String string : tags) {
                jsonArray.add((JsonElement)new JsonPrimitive(string));
            }
            json.add("exsuits", (JsonElement)jsonArray);
        }
        if (!(tags = this.entry.getModifierItemSelector().getOnlyTags()).isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (String string : tags) {
                jsonArray.add((JsonElement)new JsonPrimitive(string));
            }
            json.add("entityTypes", (JsonElement)jsonArray);
        }
        if (!(onlyItems = this.entry.getModifierItemSelector().getOnlyItems()).isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (String string : onlyItems) {
                jsonArray.add((JsonElement)new JsonPrimitive(string));
            }
            json.add("OnlyItems", (JsonElement)jsonArray);
        }
        if (!(list = ((ModifierItemSelector)this.entry.getModifierItemSelector()).getOnlyWashItems()).isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (String item : list) {
                jsonArray.add((JsonElement)new JsonPrimitive(item));
            }
            json.add("OnlyWashItems", (JsonElement)jsonArray);
        }
        if (this.entry.randomLevel != null) {
            json.addProperty("randomLevel1", (Number)this.entry.randomLevel.getFirst());
            json.addProperty("randomLevel2", (Number)this.entry.randomLevel.getSecond());
        }
        if (this.entry.id != null && !this.entry.id.isEmpty()) {
            json.addProperty("id", this.entry.id.substring(2));
        }
        if (this.entry.Expression != null && !this.entry.Expression.isEmpty()) {
            json.addProperty("Expression", this.entry.Expression);
        }
        if (this.entry.icon != null && !this.entry.icon.isEmpty()) {
            json.addProperty("icon", this.entry.icon);
        }
        if (this.entry.RandomNum != 0) {
            json.addProperty("RandomNum", (Number)this.entry.RandomNum);
        }
        if (!this.entry.attriGether.isEmpty()) {
            void var6_38;
            JsonArray jsonArray = new JsonArray();
            boolean bl = false;
            while (var6_38 < this.entry.attriGether.size()) {
                ModifierAttriGether attriGether = this.entry.attriGether.get((int)var6_38);
                JsonObject attriGetherJson = new JsonObject();
                attriGetherJson.addProperty("id", ExUtil.getAttributeID(attriGether.getAttribute()).toString());
                if (attriGether.weight != 0.0f) {
                    attriGetherJson.addProperty("weight", (Number)Float.valueOf(attriGether.weight));
                }
                if (attriGether.getModifier().getAmount() != 0.0) {
                    attriGetherJson.addProperty("value", (Number)attriGether.getModifier().getAmount());
                }
                if (attriGether.slot != null && !attriGether.slot.equals((Object)EquipmentSlot.MAINHAND)) {
                    attriGetherJson.addProperty("slot", attriGether.slot.name());
                }
                if (attriGether.getModifier().getOperation() != null && !attriGether.getModifier().getOperation().equals((Object)AttributeModifier.Operation.ADDITION)) {
                    attriGetherJson.addProperty("operation", attriGether.getModifier().getOperation().name());
                }
                if (attriGether.minValue != 0.0) {
                    attriGetherJson.addProperty("minValue", (Number)attriGether.minValue);
                }
                if (attriGether.maxValue != attriGether.minValue) {
                    attriGetherJson.addProperty("maxValue", (Number)attriGether.maxValue);
                }
                if (attriGether.reserveDouble != 1) {
                    attriGetherJson.addProperty("reserveDouble", (Number)attriGether.reserveDouble);
                }
                if (attriGether.Expression != null && !attriGether.Expression.isEmpty()) {
                    attriGetherJson.addProperty("ValueExpression", attriGether.Expression);
                }
                if (attriGether.simpleWeight != null && !attriGether.simpleWeight.isEmpty()) {
                    JsonObject simpleWeightObj = new JsonObject();
                    for (Map.Entry<Double, Float> entry : attriGether.simpleWeight.entrySet()) {
                        simpleWeightObj.addProperty(entry.getKey().toString(), (Number)entry.getValue());
                    }
                    attriGetherJson.add("mayValues", (JsonElement)new JsonArray());
                    attriGetherJson.add("mayValuesWeight", (JsonElement)new JsonArray());
                    Iterator<Object> iterator = attriGether.simpleWeight.keySet().iterator();
                    while (iterator.hasNext()) {
                        double value = (Double)iterator.next();
                        attriGetherJson.getAsJsonArray("mayValues").add((Number)value);
                    }
                    iterator = attriGether.simpleWeight.values().iterator();
                    while (iterator.hasNext()) {
                        float weight = ((Float)iterator.next()).floatValue();
                        attriGetherJson.getAsJsonArray("mayValuesWeight").add((Number)Float.valueOf(weight));
                    }
                }
                if (attriGether.IsAutoEquipmentSlot) {
                    attriGetherJson.addProperty("isAutoEquipmentSlot", Boolean.valueOf(true));
                }
                if (attriGether.hasUUID) {
                    attriGetherJson.addProperty("hasUUID", Boolean.valueOf(attriGether.hasUUID));
                }
                if (attriGether.isRandom) {
                    attriGetherJson.addProperty("isRandom", Boolean.valueOf(attriGether.isRandom));
                }
                attriGetherJson.addProperty("modifierName", attriGether.getModifier().getName());
                attriGetherJson.addProperty("attribute", attriGether.attribute.m_22087_());
                jsonArray.add((JsonElement)attriGetherJson);
                ++var6_38;
            }
            json.add("attriGethers", (JsonElement)jsonArray);
        } else {
            json.add("attriGethers", (JsonElement)new JsonArray());
        }
        return json;
    }

    private ListTag createStringListTag(List<String> strings) {
        ListTag listTag = new ListTag();
        for (String str : strings) {
            listTag.add((Object)StringTag.m_129297_((String)str));
        }
        return listTag;
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("weight", this.entry.weight);
        tag.m_128379_("cantSelect", this.entry.cantSelect);
        tag.m_128379_("isRandom", this.entry.isRandom);
        tag.m_128379_("OnlyHasThisEntry", this.entry.OnlyHasThisEntry);
        tag.m_128359_("localDescription", this.entry.localDescription);
        tag.m_128359_("icon", this.entry.icon);
        tag.m_128405_("maxLevel", this.entry.maxLevel);
        tag.m_128405_("iconSize", this.entry.iconSize);
        tag.m_128359_("curiosType", this.entry.curiosType);
        tag.m_128379_("isCuriosEntry", this.entry.isCuriosEntry);
        tag.m_128379_("displayNameInItemName", this.entry.displayNameInItemName);
        tag.m_128350_("needFreshValue", this.entry.needFreshValue);
        tag.m_128379_("autoId", this.entry.autoId);
        if (this.entry.randomLevel != null) {
            tag.m_128405_("randomLevel1", ((Integer)this.entry.randomLevel.getFirst()).intValue());
            tag.m_128405_("randomLevel2", ((Integer)this.entry.randomLevel.getSecond()).intValue());
        }
        tag.m_128359_("group", this.entry.group);
        tag.m_128365_("specialTags", (Tag)this.createStringListTag(this.entry.specialTags));
        ArrayList<String> specialTagSettingStrings = new ArrayList<String>();
        for (Map.Entry<String, JsonObject> entry : this.entry.specialTagSetting.entrySet()) {
            specialTagSettingStrings.add(entry.getKey() + ":::" + entry.getValue().toString());
        }
        tag.m_128365_("specialTagSetting", (Tag)this.createStringListTag(specialTagSettingStrings));
        tag.m_128365_("slotsTags", (Tag)this.createStringListTag(this.entry.Slots));
        tag.m_128365_("tags", (Tag)this.createStringListTag(this.entry.tags.stream().map(tagKey -> tagKey.f_203868_().toString()).toList()));
        tag.m_128365_("OnlyTags", (Tag)this.createStringListTag(this.entry.getModifierItemSelector().getOnlyTags()));
        tag.m_128365_("exsuits", (Tag)this.createStringListTag(this.entry.exsuits));
        tag.m_128365_("types", (Tag)this.createStringListTag(this.entry.types.stream().map(ItemType::name).toList()));
        tag.m_128365_("OnlyItems", (Tag)this.createStringListTag(this.entry.getModifierItemSelector().getOnlyItems()));
        tag.m_128365_("OnlyWashItems", (Tag)this.createStringListTag(((ModifierItemSelector)this.entry.getModifierItemSelector()).getOnlyWashItems()));
        tag.m_128359_("id", this.entry.id);
        tag.m_128359_("Expression", this.entry.Expression);
        tag.m_128405_("RandomNum", this.entry.RandomNum);
        ListTag attriGetherTag = new ListTag();
        for (ModifierAttriGether attriGether : this.entry.attriGether) {
            attriGetherTag.add((Object)attriGether.toNBT());
        }
        tag.m_128365_("attriGether", (Tag)attriGetherTag);
        return tag;
    }

    public static ModifierEntryDataBuilder fromNBT(CompoundTag tag) {
        int i;
        ModifierEntryDataBuilder builder = new ModifierEntryDataBuilder();
        builder.setWeight(tag.m_128457_("weight"));
        builder.setCantSelect(tag.m_128471_("cantSelect"));
        builder.setIsRandom(tag.m_128471_("isRandom"));
        builder.setOnlyHasThisEntry(tag.m_128471_("OnlyHasThisEntry"));
        builder.setLocalDescription(tag.m_128461_("localDescription"));
        builder.setMaxLevel(tag.m_128451_("maxLevel"));
        builder.setCuriosType(tag.m_128461_("curiosType"));
        builder.setIsCuriosEntry(tag.m_128471_("isCuriosEntry"));
        builder.setIconSize(tag.m_128451_("iconSize"));
        builder.setNeedFreshValue(tag.m_128457_("needFreshValue"));
        builder.setDisplayNameInItemName(tag.m_128471_("displayNameInItemName"));
        builder.setIcon(tag.m_128461_("icon"));
        builder.setSource(tag.m_128461_("source"));
        builder.setAutoId(tag.m_128471_("autoId"));
        builder.setGroup(tag.m_128461_("group"));
        int randomLevel2 = tag.m_128451_("randomLevel2");
        int randomLevel1 = tag.m_128451_("randomLevel1");
        if (randomLevel1 != 0 && randomLevel2 != 0) {
            builder.setRandomLevel((Pair<Integer, Integer>)Pair.of((Object)randomLevel1, (Object)randomLevel2));
        }
        ListTag specialTagsTag = tag.m_128437_("specialTags", 8);
        ArrayList<String> specialTags = new ArrayList<String>();
        for (int i2 = 0; i2 < specialTagsTag.size(); ++i2) {
            specialTags.add(specialTagsTag.m_128778_(i2));
        }
        builder.setSpecialTags(specialTags);
        ListTag entityTypesTag = tag.m_128437_("entityTypes", 8);
        ArrayList<String> entityTypesTags = new ArrayList<String>();
        for (i = 0; i < entityTypesTag.size(); ++i) {
            entityTypesTags.add(entityTypesTag.m_128778_(i));
        }
        builder.setEntityTypes(entityTypesTags);
        ListTag typesTag = tag.m_128437_("types", 8);
        ArrayList<ItemType> types = new ArrayList<ItemType>();
        for (i = 0; i < typesTag.size(); ++i) {
            types.add(ExTypeHandle.itemTypes.get(typesTag.m_128778_(i)));
        }
        builder.setType(types);
        ListTag tags = tag.m_128437_("tags", 8);
        for (Tag value : tags) {
            builder.addTag(ExUtil.createOrGetModifierTagKey(ResourceLocation.m_135820_((String)value.m_7916_())));
        }
        ListTag onlyTagsTag = tag.m_128437_("OnlyTags", 8);
        ArrayList<String> onlyTags = new ArrayList<String>();
        for (int i3 = 0; i3 < onlyTagsTag.size(); ++i3) {
            onlyTags.add(onlyTagsTag.m_128778_(i3));
        }
        builder.setOnlyTags(onlyTags);
        ListTag onlyItemsTag = tag.m_128437_("OnlyItems", 8);
        ArrayList<String> onlyItems = new ArrayList<String>();
        for (int i4 = 0; i4 < onlyItemsTag.size(); ++i4) {
            onlyItems.add(onlyItemsTag.m_128778_(i4));
        }
        builder.setOnlyItems(onlyItems);
        ListTag slotsTags = tag.m_128437_("slotsTags", 8);
        ArrayList<String> slots = new ArrayList<String>();
        for (int i5 = 0; i5 < slotsTags.size(); ++i5) {
            slots.add(slotsTags.m_128778_(i5));
        }
        builder.setSlots(slots);
        ListTag onlyWashItemsTag = tag.m_128437_("OnlyWashItems", 8);
        ArrayList<String> onlyWashItems = new ArrayList<String>();
        for (int i6 = 0; i6 < onlyWashItemsTag.size(); ++i6) {
            onlyWashItems.add(onlyWashItemsTag.m_128778_(i6));
        }
        builder.setOnlyWashItems(onlyWashItems);
        ListTag exSuitsTag = tag.m_128437_("exsuits", 8);
        ArrayList<String> exSuits = new ArrayList<String>();
        for (int i7 = 0; i7 < exSuitsTag.size(); ++i7) {
            exSuits.add(exSuitsTag.m_128778_(i7));
        }
        builder.setExsuit(exSuits);
        builder.setId(tag.m_128461_("id"));
        builder.setExpression(tag.m_128461_("Expression"));
        builder.setRandomNum(tag.m_128451_("RandomNum"));
        ListTag specialTagSettingTag = tag.m_128437_("specialTagSetting", 8);
        HashMap<String, JsonObject> specialTagSetting = new HashMap<String, JsonObject>();
        for (int i8 = 0; i8 < specialTagSettingTag.size(); ++i8) {
            String[] parts = specialTagSettingTag.m_128778_(i8).split(":::", 2);
            if (parts.length != 2) continue;
            try {
                specialTagSetting.put(parts[0], (JsonObject)new Gson().fromJson(parts[1], JsonObject.class));
                continue;
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        builder.setSpecialTagSetting(specialTagSetting);
        ListTag attriGetherTag = tag.m_128437_("attriGether", 10);
        for (int i9 = 0; i9 < attriGetherTag.size(); ++i9) {
            CompoundTag attriGetherTagCompound = attriGetherTag.m_128728_(i9);
            builder.setAttriGether(List.of(ModifierAttriGether.fromNBT(attriGetherTagCompound)));
        }
        return builder;
    }
}

