/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.modifier;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.modifier.ModifierEntryDataBuilder;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;

public abstract class ModifierEntryDataProvider
implements DataProvider {
    private String MODID = "exmodifier";
    private final DataGenerator generator;
    private final ExistingFileHelper existingFileHelper;
    private final Map<String, ModifierEntryDataBuilder> map = new HashMap<String, ModifierEntryDataBuilder>();
    public Path path;

    public ModifierEntryDataProvider(DataGenerator generator, ExistingFileHelper existingFileHelper, String modid) {
        this.generator = generator;
        this.MODID = modid;
        this.existingFileHelper = existingFileHelper;
        this.path = Path.of(PackType.SERVER_DATA.m_10305_() + "/" + this.MODID + "/modifier_entries", new String[0]);
    }

    public abstract void add(Map<String, ModifierEntryDataBuilder> var1);

    public CompletableFuture<?> read(CachedOutput cache) {
        Path folder = this.generator.getPackOutput().m_245114_().resolve(this.path);
        ArrayList list = new ArrayList();
        ArrayList entries = new ArrayList();
        try {
            Files.walk(folder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).forEach(path -> list.add(CompletableFuture.runAsync(() -> {
                try {
                    String content = new String(Files.readAllBytes(path));
                    JsonObject jsonObject = JsonParser.parseString((String)content).getAsJsonObject();
                    ModifierHandle.processModifierEntry(jsonObject.toString(), entries);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            })));
            for (ModifierEntry entry : entries) {
                ModifierHandle.RegisterModifierEntry(entry);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.read(cache);
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        Path folder = this.generator.getPackOutput().m_245114_().resolve(this.path);
        this.add(this.map);
        ArrayList list = new ArrayList();
        this.map.forEach((k, v) -> {
            JsonElement elem = v.toJson();
            if (elem != null) {
                Path path = folder.resolve(k + ".json");
                list.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)elem, (Path)path));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "Modifier Entry Data Provider";
    }

    public abstract void gatherData(GatherDataEvent var1);
}

