/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.modifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.exmo.exmodifier.Config;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.client.LanguageLoader;
import net.exmo.exmodifier.content.element.DefaultEntityElement;
import net.exmo.exmodifier.content.element.DefaultItemElement;
import net.exmo.exmodifier.content.element.ExElement;
import net.exmo.exmodifier.content.element.ExElementHandle;
import net.exmo.exmodifier.content.helper.ItemInfo;
import net.exmo.exmodifier.content.helper.ModifierEntryHelper;
import net.exmo.exmodifier.content.level.ItemLevelHandle;
import net.exmo.exmodifier.content.modifier.MoConfig;
import net.exmo.exmodifier.content.modifier.ModifierAttriGether;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.modifier.ModifierInstant;
import net.exmo.exmodifier.content.modifier.WashingMaterials;
import net.exmo.exmodifier.content.quality.ItemQualityHandle;
import net.exmo.exmodifier.content.resources.ZipHandle;
import net.exmo.exmodifier.content.selected.BaseItemSelected;
import net.exmo.exmodifier.content.suit.ExSuit;
import net.exmo.exmodifier.content.suit.ExSuitHandle;
import net.exmo.exmodifier.content.type.ExType;
import net.exmo.exmodifier.content.type.ExTypeHandle;
import net.exmo.exmodifier.content.type.ItemType;
import net.exmo.exmodifier.events.ExAddEntryAttrigetherEvent;
import net.exmo.exmodifier.events.ExAddEntryAttrigethersEvent;
import net.exmo.exmodifier.events.ExApplyEntryAttrigetherEvent;
import net.exmo.exmodifier.events.ExEntryRegistryEvent;
import net.exmo.exmodifier.events.ExEntryTooltipEvent;
import net.exmo.exmodifier.events.ExItemDefaultEntry;
import net.exmo.exmodifier.events.ExModifierPercentAttr;
import net.exmo.exmodifier.network.ExModifiervaV;
import net.exmo.exmodifier.network.sync.defaultEntityElement.ClearDefaultItemElementMessage;
import net.exmo.exmodifier.network.sync.defaultEntityElement.SyncDefaultItemElementMessage;
import net.exmo.exmodifier.network.sync.defaultItemElement.ClearDefaultEntityElementMessage;
import net.exmo.exmodifier.network.sync.defaultItemElement.SyncDefaultEntityElementMessage;
import net.exmo.exmodifier.network.sync.element.ClearElementMessage;
import net.exmo.exmodifier.network.sync.element.SyncElementMessage;
import net.exmo.exmodifier.network.sync.lang.LangMessage;
import net.exmo.exmodifier.network.sync.modifier.ClearModifierEntryMessage;
import net.exmo.exmodifier.network.sync.modifier.SyncModifierEntryMessage;
import net.exmo.exmodifier.network.sync.suit.ClearExSuitMessage;
import net.exmo.exmodifier.network.sync.suit.SyncExSuitMessage;
import net.exmo.exmodifier.util.CuriosUtil;
import net.exmo.exmodifier.util.DynamicExpressionEvaluator;
import net.exmo.exmodifier.util.ExAttributeModifier;
import net.exmo.exmodifier.util.ExConfig;
import net.exmo.exmodifier.util.ExConfigHandle;
import net.exmo.exmodifier.util.ExUtil;
import net.exmo.exmodifier.util.ItemAttrUtil;
import net.exmo.exmodifier.util.ItemSelector;
import net.exmo.exmodifier.util.StringToIntConverter;
import net.exmo.exmodifier.util.TooltipUtil;
import net.exmo.exmodifier.util.WeightedUtil;
import net.exmo.exmodifier.util.gether.AttrGether;
import net.exmo.exmodifier.util.gether.AttrSimpleGether;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModifierHandle {
    public static List<String> percentAtr = new ArrayList<String>();
    private static DecimalFormat df;
    public static boolean hasHelmetConfig;
    public static boolean hasChestConfig;
    public static boolean hasLeggingsConfig;
    public static boolean hasBootsConfig;
    public static boolean hasSwordConfig;
    public static final Path WashingMaterialsConfigPath;
    public static final Path ItemsDefaultEntryConfigPath;
    public static Path ConfigPath;
    public static List<MoConfig> Foundmoconfigs;
    public static List<WashingMaterials> materialsList;
    public static Map<String, ModifierEntry> modifierEntryMap;
    public static Map<String, List<String>> EEMatchQueue;
    public static List<String> cantWashItemIds;
    public static Map<ItemSelector, List<ModifierInstant>> itemsDefaultEntry;
    public static List<String> onlyCanRefreshPointEntryItemIds;

    public static ModifierEntry findModifierEntry(String id) {
        return modifierEntryMap.get(id);
    }

    public static void sendModifierEntryToClient(ModifierEntry modifierEntry, ServerPlayer player) {
        Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncModifierEntryMessage(modifierEntry));
    }

    public static void sendElementToClient(ExElement e, ServerPlayer player) {
        if (!((Boolean)Config.ELEMENT_SYSTEM.get()).booleanValue()) {
            return;
        }
        Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncElementMessage(e));
    }

    public static void sendDefaultEntityElementToClient(DefaultEntityElement e, ServerPlayer player) {
        Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncDefaultEntityElementMessage(e));
    }

    public static void sendLangMessageToClient(LangMessage.LangMessageHandler e, ServerPlayer player) {
        Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new LangMessage(e));
    }

    public static void sendDefaultItemElementToClient(DefaultItemElement e, ServerPlayer player) {
        Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncDefaultItemElementMessage(e));
    }

    public static void sendExSuitToClient(ExSuit e, ServerPlayer player) {
        Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncExSuitMessage(e));
    }

    public static void sendClearDataToClient(ServerPlayer player) {
        Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClearModifierEntryMessage());
        Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClearElementMessage());
        Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClearDefaultEntityElementMessage());
        Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClearDefaultItemElementMessage());
        Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClearExSuitMessage());
    }

    public static void sendModifierEntryToAllClient(ModifierEntry modifierEntry) {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        for (ServerPlayer player : currentServer.m_6846_().m_11314_()) {
            Exmodifier.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncModifierEntryMessage(modifierEntry));
        }
    }

    public static void sendClearDataToAllClient() {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        for (ServerPlayer player : currentServer.m_6846_().m_11314_()) {
            ModifierHandle.sendClearDataToClient(player);
        }
    }

    public static List<ItemSelector> getItemSelector(ItemStack stack) {
        return itemsDefaultEntry.keySet().stream().filter(entry -> entry.compare(stack)).toList();
    }

    @Nullable
    public static ChatFormatting getChatFormattingFromString(String string) {
        char colorCode = '-';
        HashSet<Character> excludedFormats = new HashSet<Character>(Arrays.asList(Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('r')));
        for (int i = 0; i < string.length() - 1; ++i) {
            boolean isColor;
            char codeChar;
            if (string.charAt(i) != '\u00a7' || excludedFormats.contains(Character.valueOf(codeChar = Character.toLowerCase(string.charAt(i + 1))))) continue;
            boolean bl = isColor = codeChar >= '0' && codeChar <= '9' || codeChar >= 'a' && codeChar <= 'f';
            if (!isColor) continue;
            colorCode = codeChar;
            break;
        }
        ChatFormatting byCode = ChatFormatting.m_126645_((char)colorCode);
        return byCode;
    }

    public static void registerWashingMaterials(WashingMaterials washingMaterials) {
        if (materialsList.stream().anyMatch(e -> e.ItemId.contains(washingMaterials.ItemId))) {
            Exmodifier.LOGGER.info("WashingMaterials:" + washingMaterials.ItemId + "already exits");
        } else {
            materialsList.add(washingMaterials);
            Exmodifier.LOGGER.info("RegisterWashingMaterials:" + washingMaterials.ItemId);
        }
    }

    public static void RegisterModifierEntry(ModifierEntry modifierEntry) {
        List<ItemType> type2 = modifierEntry.types;
        if (!hasBootsConfig && type2.contains(ExType.BOOTS.get())) {
            hasBootsConfig = true;
        }
        if (!hasLeggingsConfig && type2.contains(ExType.LEGGINGS.get())) {
            hasLeggingsConfig = true;
        }
        if (!hasChestConfig && type2.contains(ExType.CHESTPLATE.get())) {
            hasChestConfig = true;
        }
        if (!hasHelmetConfig && type2.contains(ExType.HELMET.get())) {
            hasHelmetConfig = true;
        }
        if (!hasSwordConfig && type2.contains(ExType.SWORD.get())) {
            hasSwordConfig = true;
        }
        String id = modifierEntry.id;
        modifierEntryMap.put(id, modifierEntry);
        BaseItemSelected.IDS.put(StringToIntConverter.stringToInt(id), modifierEntry);
        Exmodifier.LOGGER.debug("RegisterModifierEntry: Type:" + String.valueOf(type2) + " Target:" + id);
    }

    public static void EEMatchQueueHandle() {
        EEMatchQueue.forEach((k, v) -> {
            ModifierEntry modifierEntry1 = modifierEntryMap.get(k);
            modifierEntry1.exsuits.addAll((Collection<String>)v);
        });
        EEMatchQueue = new HashMap<String, List<String>>();
    }

    public static void readConfig() {
        long startTime = System.nanoTime();
        try {
            Iterator<MoConfig> washingMaterialsConfig;
            if (Files.exists(WashingMaterialsConfigPath, new LinkOption[0])) {
                washingMaterialsConfig = new MoConfig(WashingMaterialsConfigPath);
                ArrayList washingMaterials = new ArrayList();
                for (Map.Entry<String, JsonElement> entry : ((ExConfig)((Object)washingMaterialsConfig)).readEntrys()) {
                    ModifierHandle.processWashingMaterialEntry(entry, washingMaterials);
                }
                washingMaterials.forEach(ModifierHandle::registerWashingMaterials);
            }
            if (Files.exists(ItemsDefaultEntryConfigPath, new LinkOption[0])) {
                washingMaterialsConfig = new MoConfig(ItemsDefaultEntryConfigPath);
                for (Map.Entry entry : ((ExConfig)((Object)washingMaterialsConfig)).readEntrys()) {
                    ModifierHandle.processItemsDefaultEntryEntry(entry);
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new ExItemDefaultEntry());
            Foundmoconfigs = ExConfigHandle.listFiles(ConfigPath);
            for (MoConfig moconfig : Foundmoconfigs) {
                ModifierHandle.processEntryMoConfigEntries(moconfig);
            }
            ItemLevelHandle.Foundlvconfigs = ExConfigHandle.listFiles(ItemLevelHandle.LEVEL_CONFIG_PATH);
            for (MoConfig moconfig : ItemLevelHandle.Foundlvconfigs) {
                ItemLevelHandle.processLevelMoConfigEntries(moconfig);
            }
            long endTime = System.nanoTime();
            long l = endTime - startTime;
            Exmodifier.LOGGER.debug("ReadConfig Over Modifier time: " + l / 1000000L + " ms");
            Exmodifier.LOGGER.debug("ReadConfig Over Modifier config count: " + Foundmoconfigs.size());
            Exmodifier.LOGGER.debug("ReadConfig Over Modifier modifier count: " + modifierEntryMap.size());
        }
        catch (IOException e) {
            Exmodifier.LOGGER.error("Error reading configuration files", e);
        }
        catch (Exception e) {
            Exmodifier.LOGGER.error("Unexpected error during configuration reading", e);
        }
    }

    public static void readConfigFromZipFile(ZipFile zipFile, ZipHandle.ZipFunction zipFunction) {
        long startTime = System.nanoTime();
        try {
            String ElementPath;
            ZipEntry element;
            ExTypeHandle.FoundTypeConfigs = ExConfigHandle.listFilesFromZipFile(zipFile, ExTypeHandle.ConfigPath.getFileName());
            for (MoConfig moconfig : ExTypeHandle.FoundTypeConfigs) {
                ExTypeHandle.processItemTypes(moconfig);
            }
            String WashingConfigFilePath = WashingMaterialsConfigPath.getFileName().toString();
            ZipEntry wash = zipFile.getEntry(WashingConfigFilePath);
            if (wash != null) {
                MoConfig washingMaterialsConfig = new MoConfig(Path.of(zipFile.getName(), WashingConfigFilePath), zipFile.getInputStream(wash));
                ArrayList<WashingMaterials> list = new ArrayList<WashingMaterials>();
                for (Map.Entry<String, JsonElement> entry : washingMaterialsConfig.readEntrys()) {
                    ModifierHandle.processWashingMaterialEntry(entry, list);
                }
                list.forEach(ModifierHandle::registerWashingMaterials);
            }
            Foundmoconfigs = ExConfigHandle.listFilesFromZipFile(zipFile, ConfigPath.getFileName());
            for (MoConfig moconfig : Foundmoconfigs) {
                ModifierHandle.processEntryMoConfigEntries(moconfig);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ExItemDefaultEntry());
            String ItemsDefaultEntryFilePath = ItemsDefaultEntryConfigPath.getFileName().toString();
            ZipEntry item = zipFile.getEntry(ItemsDefaultEntryFilePath);
            if (item != null) {
                MoConfig washingMaterialsConfig = new MoConfig(Path.of(zipFile.getName(), ItemsDefaultEntryFilePath), zipFile.getInputStream(item));
                Set<Map.Entry<String, JsonElement>> entries = washingMaterialsConfig.readEntrys();
                zipFunction.defaultEntry().add(() -> {
                    for (Map.Entry entry : entries) {
                        ModifierHandle.processItemsDefaultEntryEntry(entry);
                    }
                });
            }
            if ((element = zipFile.getEntry(ElementPath = ExElementHandle.ElementConfigPath.getFileName().toString())) != null) {
                MoConfig ElementConfig = new MoConfig(Path.of(zipFile.getName(), ElementPath), zipFile.getInputStream(element));
                ExElementHandle.processMoConfigEntries(ElementConfig);
            }
            ItemLevelHandle.Foundlvconfigs = ExConfigHandle.listFilesFromZipFile(zipFile, ItemLevelHandle.LEVEL_CONFIG_PATH.getFileName());
            for (MoConfig moConfig : ItemLevelHandle.Foundlvconfigs) {
                ItemLevelHandle.processLevelMoConfigEntries(moConfig);
            }
            List<MoConfig> foundlvconfigs = ItemLevelHandle.Foundlvconfigs = ExConfigHandle.listFilesFromZipFile(zipFile, ExSuitHandle.ConfigPath.getFileName());
            zipFunction.suit().add(() -> {
                try {
                    for (MoConfig moconfig : foundlvconfigs) {
                        ExSuitHandle.processMoConfigEntries(moconfig);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            ItemLevelHandle.Foundlvconfigs = ExConfigHandle.listFilesFromZipFile(zipFile, ItemQualityHandle.ItemsQualityConfigPath.getFileName());
            for (MoConfig moconfig : ItemLevelHandle.Foundlvconfigs) {
                ItemQualityHandle.processMoConfigEntries(moconfig);
            }
            ItemLevelHandle.Foundlvconfigs = ExConfigHandle.listFilesFromZipFile(zipFile, ItemQualityHandle.ItemsDefaultQualityConfigPath.getFileName());
            for (MoConfig moconfig : ItemLevelHandle.Foundlvconfigs) {
                ItemQualityHandle.processMoConfigEntries2(moconfig);
            }
            List<MoConfig> list = ItemLevelHandle.Foundlvconfigs = ExConfigHandle.listFilesFromZipFile(zipFile, ExElementHandle.DefaultElementConfigPath.getFileName());
            zipFunction.elementDefault().add(() -> {
                for (MoConfig moconfig : foundlvconfigs1) {
                    try {
                        ExElementHandle.processMoConfigEntries2(moconfig);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            List<MoConfig> foundlvconfigs2 = ItemLevelHandle.Foundlvconfigs = ExConfigHandle.listFilesFromZipFile(zipFile, ExElementHandle.DefaultEntityElementConfigPath.getFileName());
            zipFunction.elementDefault().add(() -> {
                try {
                    for (MoConfig moconfig : foundlvconfigs2) {
                        ExElementHandle.processMoConfigEntries3(moconfig);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            for (MoConfig moconfig : ExConfigHandle.listFilesFromZipFile(zipFile, LanguageLoader.LANGUAGES_FILE_PATH.getFileName())) {
                String string = moconfig.configFile.getFileName().toString();
                String languageCode = string.substring(0, string.length() - 5);
                Map<String, String> collect = moconfig.jsonObject.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((JsonElement)e.getValue()).getAsString()));
                LanguageLoader.putLanguage(languageCode, collect);
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            Exmodifier.LOGGER.debug("ReadConfig Over Modifier time: " + duration / 1000000L + " ms");
            Exmodifier.LOGGER.debug("ReadConfig Over Modifier config count: " + Foundmoconfigs.size());
            Exmodifier.LOGGER.debug("ReadConfig Over Modifier modifier count: " + modifierEntryMap.size());
        }
        catch (IOException e2) {
            Exmodifier.LOGGER.error("Error reading configuration files", e2);
        }
        catch (Exception e3) {
            Exmodifier.LOGGER.error("Unexpected error during configuration reading", e3);
        }
    }

    private static void processItemsDefaultEntryEntry(Map.Entry<String, JsonElement> entry) {
        if (!entry.getValue().isJsonObject()) {
            return;
        }
        try {
            JsonObject jsonObject = entry.getValue().getAsJsonObject();
            ArrayList<oshi.util.tuples.Pair> entries = new ArrayList<oshi.util.tuples.Pair>();
            for (Object item : jsonObject.get("entries").getAsJsonArray()) {
                JsonObject asJsonObject = item.getAsJsonObject();
                int level = asJsonObject.has("level") ? asJsonObject.get("level").getAsInt() : 1;
                entries.add(new oshi.util.tuples.Pair((Object)asJsonObject.get("id").getAsString(), (Object)level));
            }
            ArrayList<ModifierInstant> modifierEntries = new ArrayList<ModifierInstant>();
            for (oshi.util.tuples.Pair entryA : entries) {
                ModifierEntry modifierEntry = modifierEntryMap.get(entryA.getA());
                if (modifierEntry == null) continue;
                modifierEntries.add(modifierEntry.toInstant((Integer)entryA.getB()));
            }
            ItemSelector itemSelector = null;
            if (jsonObject.has("itemSelector")) {
                itemSelector = ItemSelector.EX_SERIALIZE.fromJsonSingle(jsonObject.get("itemSelector").getAsJsonObject());
            }
            if (itemSelector != null) {
                itemsDefaultEntry.put(itemSelector, modifierEntries);
            }
            Exmodifier.LOGGER.debug("Add ItemsDefaultEntry:" + entry.getKey() + " To ModifierEntry:" + String.valueOf(modifierEntries));
        }
        catch (Exception e) {
            Exmodifier.LOGGER.error("Error reading ItemsDefaultEntry config file", e);
        }
    }

    public static void processWashingMaterialEntry(Map.Entry<String, JsonElement> entry, List<WashingMaterials> materialsList1) {
        if (!entry.getValue().isJsonObject()) {
            return;
        }
        try {
            JsonArray OnlyItems;
            JsonObject jsonObject = entry.getValue().getAsJsonObject();
            WashingMaterials materials = new WashingMaterials(entry.getKey(), jsonObject.get("additionEntry").getAsInt(), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.getKey())), jsonObject.get("rarity").getAsInt());
            if (jsonObject.has("OnlyHasWashEntry") && jsonObject.get("OnlyHasWashEntry").getAsBoolean()) {
                materials.OnlyHasWashEntry = true;
            }
            if (jsonObject.has("MinRandomTime")) {
                materials.MinRandomTime = jsonObject.get("MinRandomTime").getAsInt();
            }
            if (jsonObject.has("randomLevelSystemCount")) {
                materials.randomLevelSystemCount = jsonObject.get("randomLevelSystemCount").getAsInt();
            }
            if (jsonObject.has("keepEntries")) {
                materials.setKeepEntries(jsonObject.get("keepEntries").getAsInt());
            }
            if (jsonObject.has("CostExp")) {
                materials.CostExp = jsonObject.get("CostExp").getAsDouble();
            }
            if (jsonObject.has("NeedCount")) {
                materials.NeedCount = jsonObject.get("NeedCount").getAsInt();
            }
            if (jsonObject.has("OnlyItems")) {
                OnlyItems = jsonObject.get("OnlyItems").getAsJsonArray();
                OnlyItems.forEach(item -> materials.OnlyItems.add(item.getAsString()));
            }
            if (jsonObject.has("OnlyTypes")) {
                OnlyItems = jsonObject.get("OnlyTypes").getAsJsonArray();
                OnlyItems.forEach(item -> materials.OnlyTypes.add(ExTypeHandle.itemTypes.get(item.getAsString())));
            }
            if (jsonObject.has("OnlyTags")) {
                OnlyItems = jsonObject.get("OnlyTags").getAsJsonArray();
                OnlyItems.forEach(item -> materials.OnlyTags.add(item.getAsString()));
            }
            materialsList1.add(materials);
            Exmodifier.LOGGER.debug("WashingMaterials: " + materials.ItemId + " additionEntry: " + materials.additionEntry + " rarity: " + materials.rarity);
        }
        catch (Exception e) {
            Exmodifier.LOGGER.error("Error processing WashingMaterial entry: " + entry.getKey(), e);
        }
    }

    private static void processEntryMoConfigEntries(MoConfig moconfig) throws FileNotFoundException {
        ArrayList<ModifierEntry> entries = new ArrayList<ModifierEntry>();
        for (Map.Entry<String, JsonElement> entry2 : moconfig.readEntrys()) {
            try {
                ModifierHandle.processModifierEntry(moconfig, entry2.getKey(), entry2.getValue(), entries);
            }
            catch (Exception e) {
                Exmodifier.LOGGER.error("Error processing modifier entry: " + entry2.getKey(), e);
            }
        }
        ExEntryRegistryEvent event = new ExEntryRegistryEvent(entries);
        MinecraftForge.EVENT_BUS.post((Event)event);
        WeightedUtil<String> weightedUtil = new WeightedUtil<String>(event.entries.stream().collect(Collectors.toMap(ModifierEntry::getId, ModifierEntry::getWeight)));
        event.entries.forEach(entry -> {
            ModifierHandle.RegisterModifierEntry(entry);
            Exmodifier.LOGGER.debug(entry.id + " \u51fa\u73b0\u6982\u7387 " + weightedUtil.getProbability(entry.id) * 100.0f + "%");
        });
        Exmodifier.LOGGER.debug("ReadConfig Over: Type: " + String.valueOf(moconfig.type) + " Path: " + String.valueOf(moconfig.configFile) + " entries: " + entries.size());
    }

    public static void processModifierEntry(String read, List<ModifierEntry> entries) {
        try {
            JsonObject jsonObject = JsonParser.parseString((String)read).getAsJsonObject();
            MoConfig moconfig = new MoConfig(Path.of("", new String[0]));
            moconfig.jsonObject = jsonObject;
            if (jsonObject.has("isList") && jsonObject.get("isList").getAsBoolean()) {
                JsonElement group;
                if (moconfig.readSetting("type") != null) {
                    moconfig.type = ModifierEntry.StringToType(moconfig.readSetting("type").getAsString());
                }
                moconfig.group = (group = moconfig.readSetting("group")) != null ? group.getAsString() : "exmodifier_tab";
                JsonElement autoTypeId = moconfig.readSetting("autoTypeId");
                if (autoTypeId != null) {
                    moconfig.autoTypeId = autoTypeId.getAsBoolean();
                }
                if (moconfig.type == ExType.CURIOS.get() && moconfig.readSetting("type").getAsString().length() > 6) {
                    moconfig.CuriosType = moconfig.readSetting("type").getAsString().substring(7);
                }
                for (Map.Entry entry : jsonObject.entrySet()) {
                    try {
                        ModifierHandle.processModifierEntry(moconfig, (String)entry.getKey(), (JsonElement)entry.getValue(), entries);
                    }
                    catch (Exception e) {
                        Exmodifier.LOGGER.error("Error processing modifier entry: " + (String)entry.getKey(), e);
                    }
                }
                return;
            }
            moconfig.type = ModifierEntry.StringToType(jsonObject.get("type").getAsString());
            moconfig.group = jsonObject.get("group").getAsString();
            moconfig.autoTypeId = jsonObject.get("autoTypeId").getAsBoolean();
            ModifierHandle.processModifierEntry(moconfig, jsonObject.get("id").getAsString(), (JsonElement)jsonObject, entries);
        }
        catch (Exception e) {
            Exmodifier.LOGGER.error("Error processing modifier entry", e);
        }
    }

    private static void processModifierEntry(MoConfig moconfig, String key, JsonElement itemElement, List<ModifierEntry> entries) {
        JsonArray OnlyItems;
        boolean autoTypeId;
        if (!itemElement.isJsonObject()) {
            return;
        }
        JsonObject itemObject = itemElement.getAsJsonObject();
        ModifierEntry modifierEntry = new ModifierEntry();
        if (!moconfig.CuriosType.isEmpty()) {
            modifierEntry.curiosType = moconfig.CuriosType;
        }
        ArrayList<ItemType> types = new ArrayList<ItemType>();
        if (itemObject.has("types")) {
            JsonArray typesArray = itemObject.get("types").getAsJsonArray();
            for (JsonElement typeElement : typesArray) {
                types.add(ModifierEntry.StringToType(typeElement.getAsString()));
            }
        } else if (itemObject.has("type")) {
            types.add(ModifierEntry.StringToType(itemObject.get("type").getAsString()));
        } else {
            types.add(moconfig.type);
        }
        if (itemObject.has("displayNameInItemName")) {
            modifierEntry.displayNameInItemName = itemObject.get("displayNameInItemName").getAsBoolean();
        }
        if (itemObject.has("randomLevel")) {
            JsonArray randomLevel = itemObject.get("randomLevel").getAsJsonArray();
            modifierEntry.randomLevel = new Pair((Object)randomLevel.get(0).getAsInt(), (Object)randomLevel.get(1).getAsInt());
        }
        if (types.contains(ExType.CURIOS.get())) {
            modifierEntry.isCuriosEntry = true;
            if (itemObject.has("curiosType")) {
                modifierEntry.curiosType = itemObject.get("curiosType").getAsString();
            } else if (moconfig.CuriosType.isEmpty()) {
                modifierEntry.curiosType = "ALL";
            }
        }
        StringBuilder affString = new StringBuilder();
        for (ItemType type2 : types) {
            affString.append(type2.name(), 0, 2);
        }
        modifierEntry.types = types;
        boolean bl = autoTypeId = itemObject.has("autoTypeId") ? itemObject.get("autoTypeId").getAsBoolean() : moconfig.autoTypeId;
        if (autoTypeId) {
            modifierEntry.autoId = true;
        }
        modifierEntry.id = autoTypeId ? String.valueOf(affString) + key : key;
        modifierEntry.isRandom = itemObject.has("isRandom") && itemObject.get("isRandom").getAsBoolean();
        modifierEntry.OnlyHasThisEntry = itemObject.has("OnlyHasThisEntry") && itemObject.get("OnlyHasThisEntry").getAsBoolean();
        modifierEntry.RandomNum = itemObject.has("RandomNum") ? itemObject.get("RandomNum").getAsInt() : 0;
        modifierEntry.maxLevel = itemObject.has("maxLevel") ? itemObject.get("maxLevel").getAsInt() : 1;
        modifierEntry.iconSize = itemObject.has("iconSize") ? itemObject.get("iconSize").getAsInt() : 0;
        modifierEntry.weight = itemObject.has("weight") ? itemObject.get("weight").getAsFloat() : 1.0f;
        modifierEntry.needFreshValue = itemObject.has("needFreshValue") ? itemObject.get("needFreshValue").getAsFloat() : 0.0f;
        modifierEntry.cantSelect = itemObject.has("cantSelect") && itemObject.get("cantSelect").getAsBoolean();
        modifierEntry.localDescription = itemObject.has("localDescription") ? itemObject.get("localDescription").getAsString() : "";
        modifierEntry.icon = itemObject.has("icon") ? itemObject.get("icon").getAsString() : "";
        String string = modifierEntry.source = itemObject.has("source") ? itemObject.get("source").getAsString() : moconfig.getSource();
        modifierEntry.group = itemObject.has("group") ? itemObject.get("group").getAsString() : (!moconfig.group.isEmpty() ? moconfig.group : "exmodifier_tab");
        if (itemObject.has("exsuit")) {
            ArrayList<String> exss = new ArrayList<String>();
            for (JsonElement exsuit : itemObject.get("exsuit").getAsJsonArray()) {
                exss.add(exsuit.getAsString());
            }
            if (EEMatchQueue.containsKey(modifierEntry.id)) {
                EEMatchQueue.get(modifierEntry.id).addAll(exss);
            } else {
                EEMatchQueue.put(modifierEntry.id, exss);
            }
        }
        if (!modifierEntry.isRandom) {
            modifierEntry.RandomNum = 0;
        }
        Exmodifier.LOGGER.debug(modifierEntry.id + " weight " + modifierEntry.weight);
        if (itemObject.has("OnlyItems")) {
            OnlyItems = itemObject.get("OnlyItems").getAsJsonArray();
            OnlyItems.forEach(item -> modifierEntry.modifierItemSelector.addOnlyWashItem(item.getAsString()));
        }
        if (itemObject.has("entityTypes")) {
            OnlyItems = itemObject.get("entityTypes").getAsJsonArray();
            OnlyItems.forEach(item -> modifierEntry.entityTypes.add(item.getAsString()));
        }
        modifierEntry.Slots = new ArrayList<String>();
        if (itemObject.has("slots")) {
            OnlyItems = itemObject.get("slots").getAsJsonArray();
            OnlyItems.forEach(item -> modifierEntry.Slots.add(item.getAsString()));
        }
        if (itemObject.has("specialTags")) {
            OnlyItems = itemObject.get("specialTags").getAsJsonArray();
            OnlyItems.forEach(item -> {
                if (item.isJsonObject()) {
                    JsonObject asJsonObject = item.getAsJsonObject();
                    String asString = asJsonObject.get("id").getAsString();
                    modifierEntry.specialTags.add(asString);
                    modifierEntry.specialTagSetting.put(asString, asJsonObject);
                } else {
                    modifierEntry.specialTags.add(item.getAsString());
                }
            });
        }
        if (itemObject.has("tags")) {
            OnlyItems = itemObject.get("tags").getAsJsonArray();
            OnlyItems.forEach(item -> modifierEntry.tags.add(ExUtil.createOrGetModifierTagKey(new ResourceLocation(item.getAsString()))));
        }
        modifierEntry.tags.add(ModifierEntry.defaultTag);
        if (itemObject.has("OnlyTags")) {
            OnlyItems = itemObject.get("OnlyTags").getAsJsonArray();
            OnlyItems.forEach(item -> modifierEntry.modifierItemSelector.addOnlyTag(item.getAsString()));
        }
        if (itemObject.has("OnlyWashItems")) {
            OnlyItems = itemObject.get("OnlyWashItems").getAsJsonArray();
            OnlyItems.forEach(item -> modifierEntry.modifierItemSelector.addOnlyWashItem(item.getAsString()));
        }
        if (itemObject.has("UnlessItemIds")) {
            for (JsonElement itemId : itemObject.get("UnlessItemIds").getAsJsonArray()) {
                modifierEntry.modifierItemSelector.addUnlessItemId(itemId.getAsString());
            }
        }
        if (itemObject.has("UnlessItemTags")) {
            for (JsonElement itemId : itemObject.get("UnlessItemTags").getAsJsonArray()) {
                modifierEntry.modifierItemSelector.addUnlessItemTag(itemId.getAsString());
            }
        }
        if (itemObject.has("attrGethers")) {
            ModifierHandle.processAttrGethers(moconfig, modifierEntry, itemObject.get("attrGethers"));
        }
        if (itemObject.has("attriGethers")) {
            ModifierHandle.processAttriGethers(moconfig, modifierEntry, itemObject.get("attriGethers"));
        }
        Exmodifier.LOGGER.debug("ReadConfig: Type: " + String.valueOf(moconfig.type) + " Path: " + String.valueOf(moconfig.configFile) + " Id: " + key + " attrGethers: " + modifierEntry.attriGether.size());
        entries.add(modifierEntry);
    }

    public static void processAttrGethers(MoConfig moconfig, ModifierEntry modifierEntry, JsonElement attrGethers) {
        JsonObject attrGethersObject = attrGethers.getAsJsonObject();
        int index = 0;
        for (Map.Entry attrGetherEntry : attrGethersObject.entrySet()) {
            try {
                ModifierHandle.processAttrGether(moconfig, modifierEntry, (String)attrGetherEntry.getKey(), (JsonElement)attrGetherEntry.getValue(), index);
                ++index;
            }
            catch (Exception e) {
                Exmodifier.LOGGER.error("Error processing attrGether: " + (String)attrGetherEntry.getKey(), e);
            }
        }
    }

    public static void processAttriGethers(MoConfig moconfig, ModifierEntry modifierEntry, JsonElement attrGethers) {
        JsonArray attrGethersArray = attrGethers.getAsJsonArray();
        int index = 0;
        for (JsonElement attrGetherElement : attrGethersArray) {
            try {
                ModifierHandle.processAttrGether(moconfig, modifierEntry, attrGetherElement.getAsJsonObject().get("id").getAsString(), attrGetherElement, index);
                ++index;
            }
            catch (Exception e) {
                Exmodifier.LOGGER.error("Error processing attrGether at index " + index, e);
            }
        }
    }

    private static void processAttrGether(MoConfig moconfig, ModifierEntry modifierEntry, String key, JsonElement attrGetherEntry, int index) {
        Object modifierName;
        JsonObject attrGetherObj = attrGetherEntry.getAsJsonObject();
        Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(key));
        double attrValue = attrGetherObj.has("value") ? attrGetherObj.get("value").getAsDouble() : 0.0;
        AttributeModifier.Operation operation = attrGetherObj.has("operation") ? ExConfigHandle.getOperation(attrGetherObj.get("operation").getAsString()) : AttributeModifier.Operation.ADDITION;
        EquipmentSlot slot = ModifierHandle.getEquipmentSlot(attrGetherObj);
        Object object = modifierName = attrGetherObj.has("modifierName") ? attrGetherObj.get("modifierName").getAsString() : modifierEntry.id + index;
        if (attrGetherObj.has("id")) {
            attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attrGetherObj.get("id").getAsString()));
        }
        if (attrGetherObj.has("autoName") && attrGetherObj.has("autoName") && attrGetherObj.get("autoName").getAsBoolean()) {
            modifierName = modifierEntry.id + index;
        }
        ExAttributeModifier modifier = new ExAttributeModifier((String)modifierName, attrValue, operation);
        ModifierAttriGether attrGether = new ModifierAttriGether(attribute, modifier, slot);
        if (attrGetherObj.has("minValue")) {
            attrGether.minValue = attrGetherObj.get("minValue").getAsDouble();
        }
        attrGether.Expression = attrGetherObj.has("ValueExpression") ? attrGetherObj.get("ValueExpression").getAsString() : "";
        attrGether.maxValue = attrGetherObj.has("maxValue") ? attrGetherObj.get("maxValue").getAsDouble() : attrGether.minValue;
        attrGether.reserveDouble = attrGetherObj.has("reserveDouble") ? attrGetherObj.get("reserveDouble").getAsInt() : 3;
        HashMap<Double, Float> simpleWeight = new HashMap<Double, Float>();
        ArrayList mayValues = new ArrayList();
        ArrayList mayValuesKey = new ArrayList();
        if (attrGetherObj.has("mayValues")) {
            JsonArray mayValuesArray = attrGetherObj.get("mayValues").getAsJsonArray();
            mayValuesArray.forEach(mayValue -> mayValues.add(mayValue.getAsDouble()));
        }
        if (attrGetherObj.has("mayValuesWeight")) {
            JsonArray mayValuesKeyArray = attrGetherObj.get("mayValuesWeight").getAsJsonArray();
            mayValuesKeyArray.forEach(mayValueKey -> mayValuesKey.add(Float.valueOf(mayValueKey.getAsFloat())));
        }
        for (int i = 0; i < mayValues.size(); ++i) {
            Float value = (Float)mayValuesKey.get(i);
            if (value == null) {
                value = Float.valueOf(0.0f);
            }
            simpleWeight.put((Double)mayValues.get(i), value);
        }
        if (!simpleWeight.isEmpty()) {
            attrGether.simpleWeight = simpleWeight;
        }
        attrGether.IsAutoEquipmentSlot = attrGetherObj.has("isAutoEquipmentSlot") && attrGetherObj.get("isAutoEquipmentSlot").getAsBoolean();
        attrGether.hasUUID = attrGetherObj.has("uuid");
        if (!attrGether.IsAutoEquipmentSlot && attrGetherObj.has("slot")) {
            if (!attrGetherObj.get("slot").getAsString().equals("auto")) {
                attrGether.slot = EquipmentSlot.valueOf((String)attrGetherObj.get("slot").getAsString());
            } else {
                attrGether.IsAutoEquipmentSlot = true;
            }
        }
        if (attrGetherObj.has("weight")) {
            attrGether.weight = attrGetherObj.get("weight").getAsFloat();
        }
        if (attrGetherObj.has("isRandom")) {
            attrGether.isRandom = attrGetherObj.get("isRandom").getAsBoolean();
        }
        Exmodifier.LOGGER.debug("Attribute: " + String.valueOf(attribute) + " key: " + key);
        modifierEntry.attriGether.add(attrGether);
    }

    public static UUID getUUID(JsonObject attrGetherObj) {
        if (attrGetherObj.has("autoUUID") && attrGetherObj.get("autoUUID").getAsBoolean()) {
            return ExConfigHandle.autoUUid(ExConfigHandle.autoUUID);
        }
        if (attrGetherObj.has("uuid") && !attrGetherObj.get("uuid").getAsString().isEmpty()) {
            return UUID.fromString(attrGetherObj.get("uuid").getAsString());
        }
        return ExConfigHandle.autoUUid(ExConfigHandle.autoUUID);
    }

    public static UUID getUUID(JsonObject attrGetherObj, ModifierEntry modifierEntry) {
        return UUID.nameUUIDFromBytes(modifierEntry.id.getBytes());
    }

    public static UUID getUUID(JsonObject attrGetherObj, ExSuit exSuit) {
        return UUID.nameUUIDFromBytes(exSuit.id.getBytes());
    }

    public static EquipmentSlot getEquipmentSlot(JsonObject attrGetherObj) {
        String slotStr;
        if (attrGetherObj.has("slot") && !(slotStr = attrGetherObj.get("slot").getAsString()).equals("auto")) {
            return ExConfigHandle.getEquipmentSlot(slotStr);
        }
        return null;
    }

    static {
        ExModifierPercentAttr event = new ExModifierPercentAttr(List.of("twtp:mianshan", "isfix:magic_restore", "twtp:alldamage", "twtp:axedamage"));
        MinecraftForge.EVENT_BUS.post((Event)event);
        percentAtr = event.attrs;
        df = new DecimalFormat("#.#####");
        hasHelmetConfig = false;
        hasChestConfig = false;
        hasLeggingsConfig = false;
        hasBootsConfig = false;
        hasSwordConfig = false;
        WashingMaterialsConfigPath = FMLPaths.CONFIGDIR.get().resolve("exmo/WashingMaterials.json");
        ItemsDefaultEntryConfigPath = FMLPaths.CONFIGDIR.get().resolve("exmo/ItemsDefaultEntry.json");
        ConfigPath = FMLPaths.CONFIGDIR.get().resolve("exmo/modifier");
        Foundmoconfigs = new ArrayList<MoConfig>();
        materialsList = new ArrayList<WashingMaterials>();
        modifierEntryMap = new HashMap<String, ModifierEntry>();
        EEMatchQueue = new HashMap<String, List<String>>();
        cantWashItemIds = new ArrayList<String>();
        itemsDefaultEntry = new HashMap<ItemSelector, List<ModifierInstant>>();
        onlyCanRefreshPointEntryItemIds = new ArrayList<String>();
    }

    @Mod.EventBusSubscriber
    public static class CommonEvent {
        public static List<Component> GenSuitInfo(Player player, ModifierEntry modifierEntry) {
            if (player == null) {
                return null;
            }
            ArrayList<Component> tooltips = new ArrayList<Component>();
            List<ExSuit> list = ExSuitHandle.LoadExSuit.entrySet().stream().filter(e -> modifierEntry.exsuits.contains(e.getKey())).map(Map.Entry::getValue).toList();
            if (!list.isEmpty()) {
                ExModifiervaV.PlayerVariables pv = (ExModifiervaV.PlayerVariables)player.getCapability(ExModifiervaV.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new ExModifiervaV.PlayerVariables());
                if (!Config.compact_tooltip) {
                    tooltips.add((Component)Component.m_237115_((String)"modifier.entry.suit"));
                }
                for (ExSuit suit : list) {
                    if (!suit.visible) continue;
                    Integer integer = pv.SuitsNum.getOrDefault(suit.id, 0);
                    tooltips.add((Component)Component.m_237115_((String)("modifier.entry.suit." + suit.id)).m_7220_((Component)Component.m_237113_((String)("\u00a76(" + integer + "/" + suit.getMaxLevel() + ")"))));
                    if (suit.LocalDescription.isEmpty()) continue;
                    tooltips.addAll(TooltipUtil.sprit(Component.m_237115_((String)suit.LocalDescription)));
                }
            }
            return tooltips;
        }

        public static List<Component> generateEntryTooltip(ModifierInstant modifierEntryInstant, Player player, ItemStack itemStack, boolean skinFold) {
            boolean foldFlag;
            ArrayList<Component> tooltips = new ArrayList<Component>();
            ModifierEntry modifierEntry = modifierEntryInstant.getModifierEntry();
            int level = modifierEntryInstant.getLevel();
            String id = modifierEntry.getId();
            if (player == null) {
                return tooltips;
            }
            boolean bl = foldFlag = !Config.entryFold || Screen.m_96638_();
            if (id.length() >= 2) {
                MutableComponent translatable = Component.m_237115_((String)modifierEntry.getDescriptionId());
                if (Config.entryUnderLine && foldFlag) {
                    translatable = Component.m_237113_((String)"\u00a7n").m_7220_((Component)translatable);
                }
                if (Config.compact_tooltip) {
                    if (level > 1) {
                        translatable.m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237115_((String)("enchantment.level." + level))).m_130940_(ChatFormatting.GOLD);
                    }
                    tooltips.add((Component)translatable);
                } else {
                    if (level > 1) {
                        translatable.m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237115_((String)("enchantment.level." + level))).m_130940_(ChatFormatting.GOLD);
                    }
                    tooltips.add((Component)translatable.m_130946_("\u00a7r:"));
                }
                if (!modifierEntry.localDescription.isEmpty()) {
                    tooltips.addAll(TooltipUtil.sprit(Component.m_237115_((String)modifierEntry.localDescription)));
                }
                if (foldFlag || skinFold) {
                    tooltips.addAll(CommonEvent.GenSuitInfo(player, modifierEntry));
                    for (ModifierAttriGether modifierAttriGether : modifierEntry.attriGether) {
                        ChatFormatting byCode;
                        String string;
                        MutableComponent translatable1;
                        MutableComponent component;
                        double d0;
                        boolean b;
                        ExAttributeModifier attributemodifier = modifierAttriGether.getModifier();
                        Attribute attribute = modifierAttriGether.getAttribute();
                        if (attribute == null || attributemodifier == null) continue;
                        boolean isCurios = CuriosUtil.isCuriosItem2(itemStack);
                        List<AttrGether> attributeModifiersAffix = CuriosUtil.getAttributeModifiersAffix(itemStack);
                        boolean bl2 = b = isCurios && attributeModifiersAffix.stream().noneMatch(attriGether -> attriGether.attributeModifier.m_22214_().equals(attributemodifier.getName()));
                        if (b && !ItemAttrUtil.hasAttributeModifierCompoundTagNoAmount(itemStack, attribute, attributemodifier, modifierAttriGether.slot)) continue;
                        double d = d0 = isCurios ? attributeModifiersAffix.stream().filter((Predicate<AttrGether>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$generateEntryTooltip$2(net.exmo.exmodifier.util.ExAttributeModifier net.exmo.exmodifier.util.gether.AttrGether ), (Lnet/exmo/exmodifier/util/gether/AttrGether;)Z)((ExAttributeModifier)attributemodifier)).findFirst().get().attributeModifier.m_22218_() : ItemAttrUtil.getAmountFromAttributeName(itemStack, attribute, attributemodifier.getName());
                        if (modifierAttriGether.Expression != null && !modifierAttriGether.Expression.isEmpty()) {
                            DynamicExpressionEvaluator evaluator = new DynamicExpressionEvaluator();
                            evaluator.setVariable("level", level);
                            d0 = evaluator.evaluate(modifierAttriGether.Expression);
                        }
                        boolean flag = false;
                        String percent = "";
                        String attributeID = ExUtil.getAttributeID(attribute);
                        double d1 = attributemodifier.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL && !percentAtr.contains(attributeID) ? (attribute.equals(Attributes.f_22278_) ? d0 * 10.0 : d0) : d0 * 100.0;
                        String amouta2 = "";
                        if (percentAtr.contains(attributeID)) {
                            percent = "%";
                            DecimalFormat df = new DecimalFormat("#.####");
                            amouta2 = df.format(attributemodifier.getAmount() * 100.0);
                            if (modifierAttriGether.attribute.m_22087_().length() >= 4 && (attributeID.startsWith("twtp") || ExUtil.getAttributeID(attribute).toString().startsWith("isfix"))) {
                                amouta2 = df.format(attributemodifier.getAmount());
                            }
                        }
                        if (flag) {
                            tooltips.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + attributemodifier.getOperation().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)attribute.m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN));
                            continue;
                        }
                        if (d0 > 0.0) {
                            if (percent.equals("%")) {
                                tooltips.add((Component)Component.m_237115_((String)"add").m_130946_(amouta2).m_130946_(percent).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)attribute.m_22087_())).m_130940_(ChatFormatting.BLUE));
                                continue;
                            }
                            component = Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier.getOperation().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)attribute.m_22087_())});
                            if (Config.entryColor) {
                                translatable1 = Component.m_237115_((String)modifierEntry.getDescriptionId());
                                string = translatable1.getString();
                                byCode = ModifierHandle.getChatFormattingFromString(string);
                                if (byCode != null && byCode.m_126664_()) {
                                    component.m_130940_(byCode);
                                }
                                if (byCode == null) {
                                    component.m_130940_(ChatFormatting.WHITE);
                                }
                            }
                            tooltips.add((Component)component);
                            continue;
                        }
                        if (!(d0 < 0.0)) continue;
                        d1 *= -1.0;
                        if (percent.equals("%")) {
                            tooltips.add((Component)Component.m_237115_((String)"subtract").m_130946_(amouta2).m_130946_(percent).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)attribute.m_22087_())).m_130940_(ChatFormatting.RED));
                            continue;
                        }
                        component = Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.getOperation().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.RED);
                        if (Config.entryColor) {
                            translatable1 = Component.m_237115_((String)modifierEntry.getDescriptionId());
                            string = translatable1.getString();
                            byCode = ModifierHandle.getChatFormattingFromString(string);
                            if (byCode != null && byCode.m_126664_()) {
                                component.m_130940_(byCode);
                            }
                            if (byCode == null) {
                                component.m_130940_(ChatFormatting.WHITE);
                            }
                        }
                        tooltips.add((Component)component);
                    }
                }
            }
            ExEntryTooltipEvent event = new ExEntryTooltipEvent(modifierEntry, player, itemStack, tooltips);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getTooltip();
        }

        public static void RandomEntryCurios(ItemStack stack, WeightedUtil<String> weightedUtil, List<String> slots, int refreshments) {
            int numAddedModifiers = 0;
            ArrayList finalAttriGethers = new ArrayList();
            ArrayList<ModifierEntry> modifierEntries = new ArrayList<ModifierEntry>();
            if (weightedUtil.weights.size() < refreshments) {
                refreshments = weightedUtil.weights.size();
            }
            while (numAddedModifiers < refreshments) {
                ModifierEntry modifierEntry = modifierEntryMap.get(weightedUtil.selectRandomKeyBasedOnWeights());
                if (modifierEntries.contains(modifierEntry)) continue;
                if (modifierEntry.id != null) {
                    Exmodifier.LOGGER.debug("add entry: " + modifierEntry.id);
                }
                modifierEntries.add(modifierEntry);
                if (modifierEntry == null) {
                    Exmodifier.LOGGER.debug("exElement is null");
                    return;
                }
                weightedUtil.removeKey(modifierEntry.id);
                Exmodifier.LOGGER.debug("add entry start: " + modifierEntry.id);
                ++numAddedModifiers;
                Exmodifier.LOGGER.debug("add entry ing: " + modifierEntry.id);
                ModifierEntryHelper.of(stack).addModifierEntry(ModifierInstant.of(modifierEntry), true, true);
            }
        }

        public static void RandomEntry(ItemStack stack, WeightedUtil<String> weightedUtil, EquipmentSlot[] slot, int refreshments) {
            int numAddedModifiers = 0;
            ArrayList<ModifierEntry> modifierEntries = new ArrayList<ModifierEntry>();
            if (weightedUtil.weights.size() < refreshments) {
                refreshments = weightedUtil.weights.size();
            }
            while (numAddedModifiers < refreshments) {
                ModifierEntry modifierEntry = modifierEntryMap.get(weightedUtil.selectRandomKeyBasedOnWeights());
                if (modifierEntries.contains(modifierEntry)) continue;
                if (modifierEntry == null) {
                    Exmodifier.LOGGER.debug("exElement is null");
                    continue;
                }
                Exmodifier.LOGGER.debug("add entry: " + modifierEntry.id);
                modifierEntries.add(modifierEntry);
                ArrayList<ModifierAttriGether> finalAttriGethers = new ArrayList<ModifierAttriGether>();
                Exmodifier.LOGGER.debug("add entry start: " + modifierEntry.id);
                weightedUtil.removeKey(modifierEntry.id);
                ItemInfo itemInfo = new ItemInfo(stack);
                int level = 1;
                if (modifierEntry.randomLevel != null) {
                    level = Exmodifier.random.nextInt((Integer)modifierEntry.randomLevel.getFirst(), (Integer)modifierEntry.randomLevel.getSecond());
                }
                ModifierInstant modifierInstant = new ModifierInstant(modifierEntry, level);
                itemInfo.getModifierEntryHelper().addModifierEntry(modifierInstant, false, true);
                ++numAddedModifiers;
                Exmodifier.LOGGER.debug("add entry ing: " + modifierEntry.id);
                List<ModifierAttriGether> attriGethers = CommonEvent.selectModifierAttributes(modifierEntry);
                ExAddEntryAttrigethersEvent event = new ExAddEntryAttrigethersEvent(stack, weightedUtil, slot, refreshments, attriGethers, modifierEntry, modifierEntries);
                MinecraftForge.EVENT_BUS.post((Event)event);
                finalAttriGethers.addAll(event.attriGether);
                if (modifierEntry.OnlyHasThisEntry) {
                    finalAttriGethers = new ArrayList<ModifierAttriGether>(event.attriGether);
                    for (int i = numAddedModifiers; i < refreshments; ++i) {
                        stack.m_41784_().m_128359_("exmodifier_armor_modifier_applied" + i, "");
                    }
                    stack.m_41784_().m_128359_("exmodifier_armor_modifier_applied", modifierEntry.id);
                    CommonEvent.applyModifiers(stack, finalAttriGethers, slot, modifierInstant);
                    break;
                }
                CommonEvent.applyModifiers(stack, finalAttriGethers, slot, modifierInstant);
            }
        }

        public static void RandomEntry(ItemStack stack, int rarity, int refreshnumber, String washItem, int keepEntries) {
            CompoundTag tag = stack.m_41783_();
            if (tag == null || ModifierEntryHelper.of(stack).getModifierEntriesSize() > 0 && keepEntries == 0) {
                return;
            }
            tag.m_128473_("wash_item");
            tag.m_128473_("modifier_refresh_rarity");
            tag.m_128473_("modifier_refresh_add");
            tag.m_128473_("modifier_refresh");
            tag.m_128473_("keepEntries");
            Map<ItemType, EquipmentSlot[]> typeEquipmentSlotMap = CommonEvent.typeSlotMap();
            WeightedUtil<String> weightedUtil = new WeightedUtil<String>(new HashMap());
            HashSet<EquipmentSlot> slotSet = new HashSet<EquipmentSlot>();
            ArrayList<ItemType> types = new ArrayList<ItemType>();
            for (Map.Entry<ItemType, EquipmentSlot[]> entry : typeEquipmentSlotMap.entrySet()) {
                ItemType type2 = entry.getKey();
                if (!CommonEvent.isValidForType(stack, type2)) continue;
                types.add(type2);
                slotSet.addAll(Arrays.asList(entry.getValue()));
                weightedUtil.merge(new WeightedUtil<String>(modifierEntryMap.entrySet().stream().filter(e -> {
                    if (((ModifierEntry)e.getValue()).weight == 0.0f) {
                        return false;
                    }
                    ModifierEntry modifier = (ModifierEntry)e.getValue();
                    AtomicBoolean only = new AtomicBoolean(false);
                    boolean hasWashItem = materialsList.stream().anyMatch(m -> {
                        if (m.ItemId.equals(washItem)) {
                            if (m.OnlyHasWashEntry) {
                                only.set(true);
                            }
                            return true;
                        }
                        return false;
                    });
                    boolean washPd = false;
                    if (modifier.modifierItemSelector.getOnlyWashItems().isEmpty()) {
                        if (!only.get()) {
                            washPd = true;
                        }
                    } else if (modifier.modifierItemSelector.getOnlyWashItems().contains(washItem)) {
                        washPd = true;
                    }
                    return !ModifierEntryHelper.of(stack).getModifierEntriesB().contains(modifier) && modifier.containItemType(type2) && modifier.hasDefaultTag() && modifier.modifierItemSelector.containItem(stack) && !modifier.cantSelect && modifier.Slots.isEmpty() && (modifier.needFreshValue == 0.0f || modifier.needFreshValue <= (float)rarity) && washPd;
                }).collect(Collectors.toMap(Map.Entry::getKey, e -> Float.valueOf(((ModifierEntry)e.getValue()).weight)))));
            }
            if (!weightedUtil.weights.isEmpty()) {
                weightedUtil.increaseWeightsByRarity(rarity);
                if (types.contains(ExType.ARMOR.get())) {
                    Item item = stack.m_41720_();
                    if (item instanceof ArmorItem) {
                        slotSet = new HashSet<EquipmentSlot>(List.of(((ArmorItem)item).m_40402_()));
                    } else {
                        stack.getEquipmentSlot();
                    }
                }
                try {
                    CommonEvent.RandomEntry(stack, weightedUtil, slotSet.toArray(new EquipmentSlot[0]), refreshnumber);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static Map<ItemType, EquipmentSlot[]> typeSlotMap() {
            HashMap<ItemType, EquipmentSlot[]> a = new HashMap<ItemType, EquipmentSlot[]>(Map.of(ExType.HELMET.get(), new EquipmentSlot[]{EquipmentSlot.HEAD}, ExType.CHESTPLATE.get(), new EquipmentSlot[]{EquipmentSlot.CHEST}, ExType.BOOTS.get(), new EquipmentSlot[]{EquipmentSlot.FEET}, ExType.LEGGINGS.get(), new EquipmentSlot[]{EquipmentSlot.LEGS}, ExType.ARMOR.get(), new EquipmentSlot[]{EquipmentSlot.CHEST}, ExType.SHIELD.get(), new EquipmentSlot[]{EquipmentSlot.OFFHAND}, ExType.BOW.get(), new EquipmentSlot[]{EquipmentSlot.MAINHAND}, ExType.SWORD.get(), new EquipmentSlot[]{EquipmentSlot.MAINHAND}, ExType.ATTACKABLE.get(), new EquipmentSlot[]{EquipmentSlot.MAINHAND}, ExType.AXE.get(), new EquipmentSlot[]{EquipmentSlot.MAINHAND}));
            a.put(ExType.CROSSBOW.get(), new EquipmentSlot[]{EquipmentSlot.MAINHAND});
            a.put(ExType.PICKAXE.get(), new EquipmentSlot[]{EquipmentSlot.MAINHAND});
            a.put(ExType.UNKNOWN.get(), new EquipmentSlot[]{EquipmentSlot.MAINHAND});
            for (ItemType itemType : ExTypeHandle.itemTypes.values()) {
                a.put(itemType, itemType.getEquipmentSlot());
            }
            return a;
        }

        public static List<ModifierAttriGether> selectModifierAttributes(ModifierEntry modifierEntry) {
            ArrayList<ModifierAttriGether> attriGethers = new ArrayList<ModifierAttriGether>();
            if (modifierEntry.RandomNum > 0) {
                int remainingRandoms = modifierEntry.RandomNum;
                HashMap<String, ModifierAttriGether> toRandom = new HashMap<String, ModifierAttriGether>();
                for (int i = 0; i < modifierEntry.attriGether.size(); ++i) {
                    ModifierAttriGether attriGether2 = modifierEntry.attriGether.get(i);
                    if (!(attriGether2.weight > 0.0f)) continue;
                    toRandom.put(String.valueOf(i), attriGether2);
                }
                ArrayList<ModifierAttriGether> firstAdd = new ArrayList<ModifierAttriGether>();
                for (int i = 0; i < modifierEntry.attriGether.size(); ++i) {
                    ModifierAttriGether attriGether3 = modifierEntry.attriGether.get(i);
                    if (attriGether3.weight != 0.0f) continue;
                    firstAdd.add(attriGether3);
                }
                attriGethers.addAll(firstAdd);
                remainingRandoms -= firstAdd.size();
                HashMap wemap = new HashMap();
                toRandom.forEach((key, value) -> wemap.put(key, Float.valueOf(value.weight)));
                WeightedUtil weightedUtil = new WeightedUtil(wemap);
                while (remainingRandoms > 0) {
                    String selectedKey = (String)weightedUtil.selectRandomKeyBasedOnWeights();
                    ModifierAttriGether selectedAttriGether = (ModifierAttriGether)toRandom.get(selectedKey);
                    if (attriGethers.contains(selectedAttriGether)) continue;
                    if (selectedAttriGether != null && selectedAttriGether.getAttribute() != null) {
                        ExAddEntryAttrigetherEvent event = new ExAddEntryAttrigetherEvent(modifierEntry, selectedAttriGether);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        attriGethers.add(event.selectedAttriGether);
                        Exmodifier.LOGGER.debug("add Random entry: " + event.selectedAttriGether.getAttribute().m_22087_());
                    }
                    --remainingRandoms;
                }
            } else {
                attriGethers.addAll(modifierEntry.attriGether.stream().filter(attriGether -> !attriGether.isRandom).toList());
            }
            return attriGethers;
        }

        public static void applyModifiersCurios(ItemStack stack, List<ModifierAttriGether> attriGethers, List<String> CuriosSlots, ModifierInstant oldHelper) {
            for (ModifierAttriGether attriGether : attriGethers) {
                attriGether.modifier = new ExAttributeModifier(attriGether.modifier.getName(), attriGether.modifier.getAmount(), attriGether.modifier.getOperation());
                if (ForgeRegistries.ATTRIBUTES.containsValue((Object)attriGether.attribute)) {
                    ExApplyEntryAttrigetherEvent event = new ExApplyEntryAttrigetherEvent(stack, new ModifierAttriGether(attriGether.attribute, attriGether.modifier), true, null).setOldInstant(oldHelper);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    CuriosUtil.addAttributeModifierAffix(stack, new AttrSimpleGether(event.attriGether.attribute, event.attriGether.getModifier()));
                    continue;
                }
                Exmodifier.LOGGER.debug("attribute is not exists");
            }
        }

        public static void applyModifiers(ItemStack stack, List<ModifierAttriGether> attriGethers, EquipmentSlot[] slot, ModifierInstant modifierInstant, ModifierInstant oldHelper) {
            for (ModifierAttriGether attriGether : attriGethers) {
                EquipmentSlot[] equipmentSlotArray;
                if (attriGether.IsAutoEquipmentSlot) {
                    equipmentSlotArray = slot;
                } else {
                    EquipmentSlot[] equipmentSlotArray2 = new EquipmentSlot[1];
                    equipmentSlotArray = equipmentSlotArray2;
                    equipmentSlotArray2[0] = attriGether.slot;
                }
                EquipmentSlot[] applicableSlot = equipmentSlotArray;
                if (ForgeRegistries.ATTRIBUTES.containsValue((Object)attriGether.attribute)) {
                    attriGether.modifier = ExAttributeModifier.fromModifier(new AttributeModifier(UUID.nameUUIDFromBytes((attriGether.modifier.getName() + stack.m_41720_().m_5524_()).getBytes()), attriGether.modifier.getName(), attriGether.modifier.getAmount(), attriGether.modifier.getOperation()));
                    ExApplyEntryAttrigetherEvent event = new ExApplyEntryAttrigetherEvent(stack, attriGether, applicableSlot, modifierInstant).setOldInstant(oldHelper);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    ItemAttrUtil.addItemAttributeModifier(event.stack, event.attriGether.attribute, event.attriGether.modifier, event.slot);
                    continue;
                }
                Exmodifier.LOGGER.debug("attribute is not exists");
            }
        }

        public static void applyModifiers(ItemStack stack, List<ModifierAttriGether> attriGethers, EquipmentSlot[] slot, ModifierInstant modifierInstant) {
            CommonEvent.applyModifiers(stack, attriGethers, slot, modifierInstant, null);
        }

        public static void RandomEntryCurios(ItemStack stack, int rarity, int refreshnumber, String washItem) {
            if (stack.m_41783_() != null && ModifierEntryHelper.of(stack).getModifierEntriesSize() > 0) {
                return;
            }
            if (stack.m_41783_() != null) {
                stack.m_41783_().m_128473_("wash_item");
                stack.m_41783_().m_128473_("modifier_refresh_rarity");
                stack.m_41783_().m_128473_("modifier_refresh_add");
                stack.m_41783_().m_128473_("modifier_refresh");
            }
            List<String> curiosType = CuriosUtil.getSlotsFromItemstack(stack);
            WeightedUtil<String> weightedUtil = new WeightedUtil<String>(modifierEntryMap.entrySet().stream().filter(e -> {
                ModifierEntry modifier = (ModifierEntry)e.getValue();
                AtomicBoolean only = new AtomicBoolean(false);
                boolean hasWashItem = materialsList.stream().anyMatch(m -> {
                    if (m.ItemId.equals(washItem)) {
                        if (m.OnlyHasWashEntry) {
                            only.set(true);
                        }
                        return true;
                    }
                    return false;
                });
                boolean washPd = false;
                if (modifier.modifierItemSelector.getOnlyWashItems().isEmpty()) {
                    if (!only.get()) {
                        washPd = true;
                    }
                } else if (modifier.modifierItemSelector.getOnlyWashItems().contains(washItem)) {
                    washPd = true;
                }
                return !(!modifier.types.contains(ExType.CURIOS.get()) || !curiosType.contains(modifier.curiosType) && !"ALL".equals(modifier.curiosType) || !modifier.modifierItemSelector.containItem(stack) || !modifier.hasDefaultTag() || modifier.cantSelect || !modifier.Slots.isEmpty() || modifier.needFreshValue != 0.0f && !(modifier.needFreshValue <= (float)rarity) || !washPd);
            }).collect(Collectors.toMap(Map.Entry::getKey, e -> Float.valueOf(((ModifierEntry)e.getValue()).weight + 1.0f))));
            CommonEvent.RandomEntryCurios(stack, weightedUtil, curiosType, refreshnumber);
        }

        public static boolean isValidForType(ItemStack stack, ItemType type2) {
            return type2.compare(stack);
        }

        private static /* synthetic */ boolean lambda$generateEntryTooltip$2(ExAttributeModifier attributemodifier, AttrGether attrGether) {
            return attrGether.attributeModifier.m_22214_().equals(attributemodifier.getName());
        }
    }
}

