/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.modifier;

import java.util.Optional;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.minecraft.nbt.CompoundTag;

public class ModifierInstant {
    private ModifierEntry modifierEntry;
    private int level;
    private String slot;
    private boolean lock = false;
    private boolean itemQualityLock;
    private CompoundTag data;

    public static ModifierInstant of(ModifierEntry modifierEntry, int level, CompoundTag data) {
        return new ModifierInstant(modifierEntry, level).setData(data);
    }

    public static ModifierInstant of(ModifierEntry modifierEntry) {
        return new ModifierInstant(modifierEntry);
    }

    public static ModifierInstant of(ModifierEntry modifierEntry, int level) {
        return new ModifierInstant(modifierEntry, level);
    }

    public ModifierInstant(ModifierEntry modifierEntry, int level) {
        this.modifierEntry = modifierEntry;
        this.level = level;
    }

    public ModifierInstant lock() {
        this.lock = true;
        return this;
    }

    public ModifierInstant unlock() {
        this.lock = false;
        return this;
    }

    public ModifierInstant setLock(boolean lock) {
        this.lock = lock;
        return this;
    }

    public boolean isLock() {
        return this.lock;
    }

    public ModifierInstant(ModifierEntry modifierEntry) {
        this.modifierEntry = modifierEntry;
        this.level = 1;
    }

    public ModifierInstant itemQualityLock() {
        this.setItemQualityLock(true);
        return this;
    }

    public ModifierEntry getModifierEntry() {
        return this.modifierEntry;
    }

    public void setModifierEntry(ModifierEntry modifierEntry) {
        this.modifierEntry = modifierEntry;
    }

    public int getLevel() {
        return this.level;
    }

    public ModifierInstant setLevel(int level) {
        this.level = level;
        return this;
    }

    public CompoundTag getData() {
        return this.data;
    }

    public ModifierInstant setData(CompoundTag data) {
        this.data = data;
        return this;
    }

    public ModifierInstant setSlot(String slot) {
        if (slot.isEmpty()) {
            return this;
        }
        this.slot = slot;
        return this;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("EntryID", this.modifierEntry.id);
        tag.m_128405_("Level", this.level);
        tag.m_128391_(this.data);
        return tag;
    }

    public boolean isItemQualityLock() {
        return this.itemQualityLock;
    }

    public ModifierInstant setItemQualityLock(boolean itemQualityLock) {
        this.itemQualityLock = itemQualityLock;
        return this;
    }

    public Optional<String> getSlot() {
        return Optional.ofNullable(this.slot);
    }
}

