/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.modifier.menu;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.exmo.exmodifier.Config;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.helper.ModifierEntryHelper;
import net.exmo.exmodifier.content.modifier.EntryItem;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.content.modifier.WashingMaterials;
import net.exmo.exmodifier.content.modifier.menu.RefreshMenuPlus;
import net.exmo.exmodifier.content.refine.RefineHelper;
import net.exmo.exmodifier.content.type.ExType;
import net.exmo.exmodifier.network.RefineItemMessage;
import net.exmo.exmodifier.network.RefreshItemMessage;
import net.exmo.exmodifier.util.ExUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ItemDecoratorHandler;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class RefreshMenuScreenPlus
extends AbstractContainerScreen<RefreshMenuPlus>
implements ContainerListener {
    private final List<Page> pages = new ArrayList<Page>();
    private int currentPage = 0;
    private final Player player;
    public ItemStack selectedItemStack = ItemStack.f_41583_;
    public ItemStack selectedRefreshItem = ItemStack.f_41583_;
    public int manageSlot = 0;
    public ItemListViewer itemListViewer;
    public Map<Integer, InfoWidget> infoWeiget;
    private float scrollOffset;
    private boolean isScrolling;
    private static final ResourceLocation SLOT_ICON = new ResourceLocation("exmodifier", "textures/gui/slot_icon_0.png");
    private static final ResourceLocation SLOT_ICON_2 = new ResourceLocation("exmodifier", "textures/gui/slot_icon_2.png");
    private static final ResourceLocation SLOT_ICON_2_1 = new ResourceLocation("exmodifier", "textures/gui/slot_icon_2_1.png");
    private static final ResourceLocation SLOT_ICON_1 = new ResourceLocation("exmodifier", "textures/gui/slot_icon_1.png");
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("exmodifier", "textures/gui/backround.png");
    private static final ResourceLocation WIDGETS_TEXTURE_2 = new ResourceLocation("exmodifier", "textures/gui/backround_2.png");
    private static final ResourceLocation WIDGETS_TEXTURE_W = new ResourceLocation("exmodifier", "textures/gui/backround_w.png");
    private static final ResourceLocation WIDGETS_TEXTURE_W2 = new ResourceLocation("exmodifier", "textures/gui/backround_w2.png");
    private static final ResourceLocation SIMPLE_BUTTON_TEXTURE = new ResourceLocation("exmodifier", "textures/gui/simple_button.png");
    private static final ResourceLocation SIMPLE_BUTTON_TEXTURE_OVER = new ResourceLocation("exmodifier", "textures/gui/simple_button_over.png");
    private static final int ITEM_SLOT_SIZE = 20;
    private final Map<GuiEventListener, Float> hoverProgress = new HashMap<GuiEventListener, Float>();
    private static final ResourceLocation MENU_TEXTURE = new ResourceLocation("exmodifier", "textures/gui/background3.png");
    private static final Map<Long, Map.Entry<Component, ItemStack>> overlayMap = new HashMap<Long, Map.Entry<Component, ItemStack>>();
    public List<ToRenderTooltip> toRenderTooltipList = new ArrayList<ToRenderTooltip>();
    public TextListWidget textList = new TextListWidget(List.of(), 0, 0, 0, 0);

    void initPages() {
        this.addPage("\u91cd\u94f8", screen -> {
            screen.m_142416_((GuiEventListener)new ImageWidget(80, this.f_97736_ - 20, this.f_96543_ - 160, this.f_97727_, MENU_TEXTURE));
            screen.m_142416_((GuiEventListener)new RefreshWidget(100, this.f_97736_ + 20, this.f_96543_ / 3, this.f_97727_ - 60, MENU_TEXTURE));
            this.itemListViewer = new ItemListViewer(this.manageSlot == 0 ? RefreshMenuScreenPlus.filterItems((List<ItemStack>)this.player.m_150109_().f_35974_) : this.filterItems2((List<ItemStack>)this.player.m_150109_().f_35974_), 120 + this.f_96543_ / 3, this.f_97736_ + 20, this.f_96543_ - 160 - this.f_96543_ / 3 - 40 - 20, this.f_97727_ - 60);
            this.itemListViewer.setShowSearchBox(false);
            this.itemListViewer.setSearchBackground(WIDGETS_TEXTURE_W, Integer.MIN_VALUE);
            this.textList = new TextListWidget(List.of(), 174, this.f_97736_ + 40, this.f_96543_ / 3 - 82, 45);
            if (!this.selectedItemStack.m_41619_()) {
                this.textList.entries = this.getTextEntries();
                this.textList.calculateLayout();
            }
            this.m_142416_((GuiEventListener)this.textList);
            this.m_142416_((GuiEventListener)this.itemListViewer);
        });
        if (Config.refine_system) {
            this.addPage("\u7cbe\u70bc", screen -> {
                screen.m_142416_((GuiEventListener)new ImageWidget(80, this.f_97736_ - 20, this.f_96543_ - 160, this.f_97727_, MENU_TEXTURE));
                screen.m_142416_((GuiEventListener)new RefreshWidget(100, this.f_97736_ + 20, this.f_96543_ / 3, this.f_97727_ - 60, MENU_TEXTURE));
                this.itemListViewer = new ItemListViewer(this.manageSlot == 0 ? RefreshMenuScreenPlus.filterItems((List<ItemStack>)this.player.m_150109_().f_35974_) : this.filterItems3((List<ItemStack>)this.player.m_150109_().f_35974_), 120 + this.f_96543_ / 3, this.f_97736_ + 20, this.f_96543_ - 160 - this.f_96543_ / 3 - 40 - 20, this.f_97727_ - 60);
                this.itemListViewer.setShowSearchBox(false);
                this.itemListViewer.setSearchBackground(WIDGETS_TEXTURE_W, Integer.MIN_VALUE);
                this.textList = new TextListWidget(List.of(), 174, this.f_97736_ + 40, this.f_96543_ / 3 - 82, 45);
                if (!this.selectedItemStack.m_41619_()) {
                    this.textList.entries = this.getTextEntries();
                    this.textList.calculateLayout();
                }
                this.m_142416_((GuiEventListener)this.itemListViewer);
            });
        }
    }

    @NotNull
    public List<TextListWidget.Entry> getTextEntries() {
        List<TextListWidget.Entry> textEntries = ModifierEntryHelper.of(this.selectedItemStack).getModifierEntries().stream().map(entry -> {
            MutableComponent translatable = Component.m_237115_((String)entry.getModifierEntry().getDescriptionId());
            if (entry.getLevel() > 1) {
                translatable.m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237115_((String)("enchantment.level." + entry.getLevel()))).m_130940_(ChatFormatting.GOLD);
            }
            return new TextListWidget.Entry((Component)translatable, ModifierHandle.CommonEvent.generateEntryTooltip(entry, this.player, this.selectedItemStack, true));
        }).collect(Collectors.toList());
        return textEntries;
    }

    public RefreshMenuScreenPlus(RefreshMenuPlus p_97874_, Inventory p_97875_, Component p_97876_) {
        super((AbstractContainerMenu)p_97874_, p_97875_, p_97876_);
        this.player = p_97875_.f_35978_;
        this.f_97727_ = 250;
        this.f_97726_ = 400;
        overlayMap.clear();
    }

    public void addPage(String title, Consumer<RefreshMenuScreenPlus> contentInitializer) {
        this.pages.add(new Page((Component)Component.m_237115_((String)title), contentInitializer));
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        float newOffset = (float)((double)this.scrollOffset - delta * 0.1);
        this.scrollOffset = Mth.m_14036_((float)newOffset, (float)0.0f, (float)1.0f);
        this.textList.m_6050_(mouseX, mouseY, delta);
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            float delta = (float)(dragY / (double)(this.itemListViewer.visibleRowsY * 20));
            this.scrollOffset = Mth.m_14036_((float)(this.scrollOffset + delta), (float)0.0f, (float)1.0f);
            this.textList.m_7979_(mouseX, mouseY, button, dragX, dragY);
            return true;
        }
        return false;
    }

    public static List<ItemStack> filterItems(List<ItemStack> items) {
        return items.stream().filter(item -> !item.m_41619_() && !ModifierEntry.getType(item).stream().filter(e -> e != ExType.ALL.get()).toList().isEmpty()).toList();
    }

    public List<ItemStack> filterItems2(List<ItemStack> items) {
        return items.stream().filter(item -> item != this.selectedItemStack && !item.m_41619_() && ModifierHandle.materialsList.stream().anyMatch(entry -> entry.ItemId.equals(ExUtil.getItemID(item))) || item.m_41720_() instanceof EntryItem && ModifierHandle.modifierEntryMap.containsKey(EntryItem.getModifierID(item))).toList();
    }

    public List<ItemStack> filterItems3(List<ItemStack> items) {
        return items.stream().filter(item -> !item.m_41619_() && item != this.selectedItemStack && RefineHelper.of(item).canRefine(this.selectedItemStack)).toList();
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.pages.clear();
        this.initPages();
        int rightMargin = 80;
        for (int i = 0; i < this.pages.size(); ++i) {
            int pageIndex = i;
            TabButton tabButton = new TabButton(rightMargin, this.f_97736_ + 2 + i * 30, 20, 20, this.pages.get(i).title(), b -> this.switchPage(pageIndex));
            this.m_142416_((GuiEventListener)tabButton);
        }
        if (!this.pages.isEmpty()) {
            this.pages.get(this.currentPage).contentInitializer().accept(this);
        }
    }

    private void switchPage(int newPage) {
        this.currentPage = newPage;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    public static void addOverlay(long time, Component content, ItemStack item) {
        overlayMap.put(time, Map.entry(content, item));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_7286_(guiGraphics, partialTick, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        HashMap<Long, Map.Entry> toRemove = new HashMap<Long, Map.Entry>();
        overlayMap.forEach((k, v) -> {
            if (System.currentTimeMillis() - k > 3200L) {
                toRemove.put((Long)k, (Map.Entry)v);
            }
        });
        toRemove.forEach((k, v) -> overlayMap.remove(k));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 2000.0f);
        AtomicInteger line = new AtomicInteger();
        overlayMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            ItemStack itemStack = (ItemStack)((Map.Entry)entry.getValue()).getValue();
            Component content = (Component)((Map.Entry)entry.getValue()).getKey();
            float p281752 = 1.0f - (float)(System.currentTimeMillis() - (Long)entry.getKey()) / 3200.0f;
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, p281752);
            int n = this.f_96543_ / 2;
            int n2 = this.f_96544_ / 5;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280653_(this.f_96547_, content, n, n2 + (9 + 2) * line.get(), 0xFFFFFF);
            if (!itemStack.m_41619_()) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(0.2f, 0.2f, 0.2f);
                int n3 = (this.f_96543_ / 2 - 10) * 5;
                int n4 = this.f_96544_ / 5;
                Objects.requireNonNull(this.f_96547_);
                guiGraphics.m_280480_(itemStack, n3, (n4 + (9 + 2) * line.get()) * 5);
                guiGraphics.m_280168_().m_85849_();
            }
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            line.getAndIncrement();
        });
        guiGraphics.m_280168_().m_85849_();
        for (Renderable renderable : this.f_169369_) {
            if (renderable == null) continue;
            renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        this.f_97734_ = null;
        this.toRenderTooltipList.forEach(toRenderTooltip -> toRenderTooltip.runnable.run());
        this.toRenderTooltipList.clear();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)i, (float)j, 0.0f);
        this.m_280003_(guiGraphics, mouseX, mouseY);
        for (GuiEventListener widget : this.m_6702_()) {
            if (!(widget instanceof TabButton)) continue;
            TabButton button = (TabButton)widget;
            float progress = this.hoverProgress.getOrDefault((Object)button, Float.valueOf(0.0f)).floatValue();
            boolean isHovered = button.m_5953_(mouseX, mouseY);
            progress = Mth.m_14036_((float)(progress + (isHovered ? 0.1f : -0.1f)), (float)0.0f, (float)1.0f);
            this.hoverProgress.put((GuiEventListener)button, Float.valueOf(progress));
            button.setExpandProgress(progress);
        }
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.enableDepthTest();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float v, int i, int i1) {
    }

    protected void m_280003_(GuiGraphics p_281635_, int p_282681_, int p_283686_) {
    }

    protected void m_280072_(GuiGraphics p_283594_, int p_282171_, int p_281909_) {
        super.m_280072_(p_283594_, p_282171_, p_281909_);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void m_7934_(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
    }

    public void m_142153_(AbstractContainerMenu abstractContainerMenu, int i, int i1) {
    }

    public boolean m_5953_(double x, double y) {
        this.textList.m_5953_(x, y);
        return super.m_5953_(x, y);
    }

    public boolean m_6348_(double p_97812_, double p_97813_, int p_97814_) {
        this.textList.m_6348_(p_97812_, p_97813_, p_97814_);
        return super.m_6348_(p_97812_, p_97813_, p_97814_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_97750_) {
        this.textList.m_6375_(mouseX, mouseY, p_97750_);
        if (this.itemListViewer != null && this.itemListViewer.contextMenu != null && this.itemListViewer.contextMenu.isMouseOver(mouseX, mouseY)) {
            this.itemListViewer.contextMenu.clickContextMenuButton(mouseX, mouseY);
        }
        if (this.itemListViewer != null && this.itemListViewer.contextMenu != null && !this.itemListViewer.contextMenu.isMouseOver(mouseX, mouseY)) {
            this.itemListViewer.contextMenu = null;
        }
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!(guiEventListener instanceof RefreshWidget)) continue;
            RefreshWidget refreshWidget = (RefreshWidget)guiEventListener;
            refreshWidget.m_6375_(mouseX, mouseY, p_97750_);
        }
        if (this.itemListViewer != null) {
            for (GuiEventListener guiEventListener : this.itemListViewer.m_6702_()) {
                if (!(guiEventListener instanceof ItemListViewer.ActionButton)) continue;
                ItemListViewer.ActionButton actionButton = (ItemListViewer.ActionButton)guiEventListener;
                if (!guiEventListener.m_6375_(mouseX, mouseY, p_97750_)) continue;
                actionButton.m_5691_();
                return true;
            }
        }
        if (this.clickActionM(mouseX, mouseY, p_97750_, this.m_6702_())) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, p_97750_);
    }

    private boolean clickActionM(double mouseX, double mouseY, int p_97750_, List<? extends GuiEventListener> children) {
        for (GuiEventListener guiEventListener : children) {
            if (!(guiEventListener instanceof AbstractButton) || !guiEventListener.m_6375_(mouseX, mouseY, p_97750_)) continue;
            this.m_7522_(guiEventListener);
            if (p_97750_ == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return false;
    }

    public class TextListWidget
    extends AbstractContainerEventHandler
    implements Renderable,
    NarratableEntry {
        private static final int ENTRY_SPACING = 2;
        private static final int SCROLLBAR_WIDTH = 6;
        private static final int HIGHLIGHT_COLOR = -2139062144;
        private static final int BACKGROUND_COLOR = Integer.MIN_VALUE;
        public List<Entry> entries;
        private final List<Integer> entryHeights = new ArrayList<Integer>();
        private final Rectangle bounds;
        private int scrollOffset;
        private boolean isScrolling;
        private int totalContentHeight;
        private int visibleItemCount;
        private int selectedIndex = -1;
        private int hoveredIndex = -1;

        public TextListWidget(List<Entry> entries, int x, int y, int width, int height) {
            this.entries = new ArrayList<Entry>(entries);
            this.bounds = new Rectangle(x, y, width, height);
            this.calculateLayout();
        }

        public void calculateLayout() {
            this.entryHeights.clear();
            this.totalContentHeight = 0;
            for (Entry entry : this.entries) {
                int height = RefreshMenuScreenPlus.this.f_96547_.m_239133_((FormattedText)entry.text, this.getContentWidth()) + 2;
                this.entryHeights.add(height);
                this.totalContentHeight += height;
            }
            this.visibleItemCount = this.calculateVisibleItemCount();
        }

        private int getContentWidth() {
            return this.bounds.width - 6 - 4;
        }

        private int calculateVisibleItemCount() {
            int count = 0;
            int currentHeight = 0;
            for (Integer h : this.entryHeights) {
                if (currentHeight + h > this.bounds.height) break;
                currentHeight += h.intValue();
                ++count;
            }
            return Math.max(count, 1);
        }

        private void enableScissor(float x0, float y0, float x1, float y1) {
            Window window = Minecraft.m_91087_().m_91268_();
            int screenHeight = window.m_85444_();
            int scissorX = (int)((double)x0 * window.m_85449_());
            int scissorY = (int)((double)screenHeight - (double)y1 * window.m_85449_());
            int scissorWidth = (int)((double)(x1 - x0) * window.m_85449_());
            int scissorHeight = (int)((double)(y1 - y0) * window.m_85449_());
            RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280168_().m_85836_();
            try {
                this.renderBackground(guiGraphics);
                this.enableScissor(this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height);
                this.renderEntries(guiGraphics, mouseX, mouseY);
                RenderSystem.disableScissor();
                this.renderScrollBar(guiGraphics);
            }
            finally {
                guiGraphics.m_280168_().m_85849_();
            }
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }

        private void setupClipRegion(GuiGraphics guiGraphics) {
            guiGraphics.m_280588_(this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height);
        }

        private void renderBackground(GuiGraphics guiGraphics) {
            guiGraphics.m_280509_(this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, Integer.MIN_VALUE);
        }

        private void renderEntries(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            int renderY = this.bounds.y - this.scrollOffset;
            this.hoveredIndex = -1;
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry entry = this.entries.get(i);
                int entryHeight = this.entryHeights.get(i);
                if (renderY + entryHeight < this.bounds.y) {
                    renderY += entryHeight;
                    continue;
                }
                if (renderY > this.bounds.y + this.bounds.height) break;
                if (i == this.selectedIndex) {
                    this.renderEntryHighlight(guiGraphics, renderY, entryHeight);
                }
                guiGraphics.m_280554_(RefreshMenuScreenPlus.this.f_96547_, (FormattedText)entry.text, this.bounds.x + 2, renderY + 1, this.getContentWidth(), 0xFFFFFF);
                if (this.isMouseOverEntry(mouseX, mouseY, renderY, entryHeight)) {
                    this.hoveredIndex = i;
                }
                renderY += entryHeight;
            }
        }

        private void renderEntryHighlight(GuiGraphics guiGraphics, int yPos, int height) {
            guiGraphics.m_280509_(this.bounds.x + 1, yPos, this.bounds.x + this.bounds.width - 6 - 1, yPos + height, -2139062144);
        }

        private void renderScrollBar(GuiGraphics guiGraphics) {
            if (this.totalContentHeight <= this.bounds.height) {
                int fullBarHeight = this.bounds.height;
                int fullBarY = this.bounds.y;
                guiGraphics.m_280509_(this.bounds.x + this.bounds.width - 6, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, 0x40000000);
                guiGraphics.m_280509_(this.bounds.x + this.bounds.width - 6, fullBarY, this.bounds.x + this.bounds.width, fullBarY + fullBarHeight, -2139062144);
                return;
            }
            int scrollHeight = (int)((float)this.bounds.height / (float)this.totalContentHeight * (float)this.bounds.height);
            scrollHeight = Mth.m_14045_((int)scrollHeight, (int)10, (int)this.bounds.height);
            int scrollY = this.bounds.y + (int)((float)this.scrollOffset / (float)this.totalContentHeight * (float)this.bounds.height);
            scrollY = Mth.m_14045_((int)scrollY, (int)this.bounds.y, (int)(this.bounds.y + this.bounds.height - scrollHeight));
            guiGraphics.m_280509_(this.bounds.x + this.bounds.width - 6, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, 0x40000000);
            guiGraphics.m_280509_(this.bounds.x + this.bounds.width - 6, scrollY, this.bounds.x + this.bounds.width, scrollY + scrollHeight, -2139062144);
        }

        private void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.hoveredIndex != -1 && this.entries.get((int)this.hoveredIndex).tooltips != null) {
                RefreshMenuScreenPlus.this.toRenderTooltipList.add(new ToRenderTooltip(() -> guiGraphics.m_280677_(RefreshMenuScreenPlus.this.f_96547_, this.entries.get((int)this.hoveredIndex).tooltips, ItemStack.f_41583_.m_150921_(), mouseX, mouseY)));
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!this.m_5953_(mouseX, mouseY)) {
                return false;
            }
            if (this.isMouseOverScrollBar(mouseX)) {
                this.isScrolling = true;
                return true;
            }
            this.selectedIndex = this.getEntryAtPosition(mouseX, mouseY);
            return this.selectedIndex != -1;
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            if (this.m_5953_(mouseX, mouseY)) {
                this.scrollOffset = Mth.m_14045_((int)(this.scrollOffset - (delta > 0.0 ? 20 : -20)), (int)0, (int)Math.max(this.totalContentHeight - this.bounds.height, 0));
                return true;
            }
            return false;
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (this.isScrolling) {
                double ratio = (mouseY - (double)this.bounds.y) / (double)this.bounds.height;
                this.scrollOffset = (int)Mth.m_14008_((double)(ratio * (double)this.totalContentHeight), (double)0.0, (double)(this.totalContentHeight - this.bounds.height));
                return true;
            }
            return false;
        }

        private boolean isMouseOverEntry(double mouseX, double mouseY, int entryY, int entryHeight) {
            return mouseX >= (double)this.bounds.x && mouseX <= (double)(this.bounds.x + this.bounds.width - 6) && mouseY >= (double)entryY && mouseY <= (double)(entryY + entryHeight);
        }

        private int getEntryAtPosition(double mouseX, double mouseY) {
            if (!this.m_5953_(mouseX, mouseY)) {
                return -1;
            }
            int contentY = (int)(mouseY - (double)this.bounds.y) + this.scrollOffset;
            int accumulatedHeight = 0;
            for (int i = 0; i < this.entries.size(); ++i) {
                int entryHeight = this.entryHeights.get(i);
                if (contentY >= accumulatedHeight && contentY < accumulatedHeight + entryHeight) {
                    return i;
                }
                accumulatedHeight += entryHeight;
            }
            return -1;
        }

        private boolean isMouseOverScrollBar(double mouseX) {
            return mouseX >= (double)(this.bounds.x + this.bounds.width - 6) && mouseX <= (double)(this.bounds.x + this.bounds.width);
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return this.bounds.contains(mouseX, mouseY);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of();
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.HOVERED;
        }

        public void m_142291_(NarrationElementOutput output) {
        }

        public static class Entry {
            private final Component text;
            private final List<Component> tooltips;

            public Entry(Component text, List<Component> tooltips) {
                this.text = text;
                this.tooltips = tooltips;
            }
        }
    }

    private record Page(Component title, Consumer<RefreshMenuScreenPlus> contentInitializer) {
    }

    public class ItemListViewer
    extends AbstractContainerEventHandler
    implements Renderable,
    NarratableEntry {
        public List<ItemStack> items;
        private final int x;
        private int y;
        private final int width;
        private final int totalSlotsPerPage;
        private final int visibleRowsY;
        private final int visibleRowsX;
        private int selected = -1;
        private ContextMenu contextMenu;
        private boolean showSearchBox = false;
        private EditBox searchBox;
        private ResourceLocation searchBackground = WIDGETS_TEXTURE;
        private int searchBgColor = -1442840576;
        private final List<ItemStack> originalItems;
        private final int originalY;

        public ItemListViewer(List<ItemStack> items, int x, int y, int width, int height) {
            this.originalItems = new ArrayList<ItemStack>(items);
            this.items = new ArrayList<ItemStack>(items);
            this.x = x;
            this.originalY = this.y = y;
            this.visibleRowsY = (height - (this.showSearchBox ? 25 : 0)) / 20;
            this.visibleRowsX = width / 20;
            this.width = width;
            this.totalSlotsPerPage = this.visibleRowsX * this.visibleRowsY;
            this.searchBox = new EditBox(RefreshMenuScreenPlus.this.f_96547_, x + width - 125, y + 5, 120, 18, (Component)Component.m_237115_((String)"gui.exmodifier.search"));
            this.searchBox.m_94199_(32);
            this.searchBox.m_94182_(false);
            this.searchBox.m_94194_(false);
            this.searchBox.m_94151_(text -> this.filterItems());
        }

        private String removeColorCodes(String text) {
            return text.replaceAll("\u00a7[0-9A-FK-ORa-fk-or]", "");
        }

        private void filterItems() {
            String query = this.searchBox.m_94155_().toLowerCase().trim();
            this.items = this.originalItems.stream().filter(stack -> !stack.m_41619_()).filter(stack -> {
                String name = stack.m_41786_().getString().toLowerCase();
                String cleanText = this.removeColorCodes(name);
                if (cleanText.contains(query.toLowerCase())) {
                    return true;
                }
                return stack.m_204131_().anyMatch(tag -> tag.f_203868_().toString().toLowerCase().contains(query.toLowerCase()));
            }).collect(Collectors.toList());
        }

        public void setShowSearchBox(boolean show) {
            this.showSearchBox = show;
            this.searchBox.m_94194_(show);
            if (show) {
                this.searchBox.m_93692_(true);
                this.searchBox.m_94144_("");
            }
        }

        public void setSearchBackground(ResourceLocation texture, int color) {
            this.searchBackground = texture;
            this.searchBgColor = color;
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int index;
            if (this.showSearchBox) {
                this.renderSearchBox(guiGraphics, mouseX, mouseY, partialTick);
            }
            guiGraphics.m_280163_(WIDGETS_TEXTURE, this.x, this.y, 0.0f, 0.0f, this.visibleRowsX * 20 + 10, this.visibleRowsY * 20 + 10, this.visibleRowsX * 20 + 10, this.visibleRowsY * 20 + 10);
            TooltipToRender tooltipToRender = null;
            int startIndex = (int)(RefreshMenuScreenPlus.this.scrollOffset * (float)(this.items.size() - this.totalSlotsPerPage));
            startIndex = Math.max(0, startIndex);
            for (int i = 0; i < this.totalSlotsPerPage && (index = startIndex + i) < this.items.size(); ++i) {
                int col = i % this.visibleRowsX;
                int slotX = this.x + 5 + col * 20;
                int row = i / this.visibleRowsX;
                int slotY = this.y + 5 + row * 20;
                boolean isHovered = this.isMouseOverSlot(mouseX, mouseY, slotX, slotY);
                if (isHovered) {
                    guiGraphics.m_280163_(SLOT_ICON_2_1, slotX, slotY, 0.0f, 0.0f, 20, 20, 20, 20);
                } else {
                    guiGraphics.m_280163_(SLOT_ICON_2, slotX, slotY, 0.0f, 0.0f, 20, 20, 20, 20);
                }
                ItemStack stack = this.items.get(index);
                guiGraphics.m_280480_(stack, slotX + 2, slotY + 2);
                guiGraphics.m_280370_(RefreshMenuScreenPlus.this.f_96547_, stack, slotX + 2, slotY + 2);
                if (!isHovered || this.contextMenu != null && !this.contextMenu.buttons.isEmpty()) continue;
                guiGraphics.m_285978_(RenderType.m_286086_(), slotX, slotY, slotX + 20, slotY + 20, -2130706433, -2130706433, 20);
                tooltipToRender = new TooltipToRender(RefreshMenuScreenPlus.this.f_96547_, stack, slotX, slotY);
            }
            if (tooltipToRender != null) {
                guiGraphics.m_280153_(RefreshMenuScreenPlus.this.f_96547_, tooltipToRender.itemStack(), mouseX, mouseY);
            }
            this.renderContextMenu(guiGraphics, mouseX, mouseY);
        }

        private void renderItemCount(GuiGraphics guiGraphics, ItemStack stack, int slotX, int slotY) {
            int count = stack.m_41613_();
            if (count > 1) {
                String countText = String.valueOf(count);
                int textX = slotX + 16 - RefreshMenuScreenPlus.this.f_96547_.m_92895_(countText) - 1;
                int textY = slotY + 16 - 8;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
                guiGraphics.m_280056_(RefreshMenuScreenPlus.this.f_96547_, countText, textX, textY, 0xFFFFFF, false);
                guiGraphics.m_280168_().m_85849_();
            }
        }

        private void renderContextMenu(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.contextMenu != null) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 600.0f);
                this.contextMenu.render(guiGraphics, mouseX, mouseY, 0.0f);
                guiGraphics.m_280168_().m_85849_();
            }
        }

        private void renderSearchBox(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.searchBox.m_252865_(this.x + this.width - 125);
            this.searchBox.m_253211_(this.originalY + 30);
            guiGraphics.m_280024_(this.x + this.width - 130, this.originalY + 2, this.x + this.width - 10, this.originalY + 22, this.searchBgColor, this.searchBgColor);
            guiGraphics.m_280163_(this.searchBackground, this.x + this.width - 130, this.originalY + 2, 0.0f, 0.0f, 120, 20, 120, 20);
            this.searchBox.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        private boolean isMouseOverSlot(int mouseX, int mouseY, int slotX, int slotY) {
            return mouseX >= slotX && mouseX <= slotX + 20 && mouseY >= slotY && mouseY <= slotY + 20;
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            ArrayList<ActionButton> children = new ArrayList<ActionButton>();
            if (this.contextMenu != null) {
                children.addAll(this.contextMenu.buttons);
            }
            if (this.showSearchBox) {
                children.add((ActionButton)this.searchBox);
            }
            return children;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            int index;
            if (this.showSearchBox && this.searchBox.m_5953_(mouseX, mouseY)) {
                this.contextMenu = null;
                this.searchBox.m_6375_(mouseX, mouseY, button);
            }
            int startIndex = (int)(RefreshMenuScreenPlus.this.scrollOffset * (float)(this.items.size() - this.totalSlotsPerPage));
            startIndex = Math.max(0, startIndex);
            for (int i = 0; i < this.totalSlotsPerPage && (index = startIndex + i) < this.items.size(); ++i) {
                int col = i % this.visibleRowsX;
                int slotX = this.x + 5 + col * 20;
                int row = i / this.visibleRowsX;
                int slotY = this.y + 5 + row * 20;
                if (!this.isMouseOverSlot((int)mouseX, (int)mouseY, slotX, slotY)) continue;
                this.selected = index;
                this.showContextMenu((int)mouseX, (int)mouseY);
                return true;
            }
            return false;
        }

        @NotNull
        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        private void showContextMenu(int x, int y) {
            this.contextMenu = new ContextMenu(x, y, Arrays.asList(new ActionButton("gui.exmodifier.refresh_menu.selected", b -> {
                this.putItem();
                this.contextMenu = null;
            }), new ActionButton("gui.exmodifier.refresh_menu.look", b -> {})));
        }

        private void putItem() {
            if (RefreshMenuScreenPlus.this.manageSlot == 0) {
                RefreshMenuScreenPlus.this.selectedItemStack = this.items.get(this.selected);
                if (!RefreshMenuScreenPlus.this.selectedItemStack.m_41619_()) {
                    RefreshMenuScreenPlus.this.textList.entries = RefreshMenuScreenPlus.this.getTextEntries();
                    RefreshMenuScreenPlus.this.textList.calculateLayout();
                }
            }
            if (RefreshMenuScreenPlus.this.manageSlot == 1) {
                RefreshMenuScreenPlus.this.selectedRefreshItem = this.items.get(this.selected);
            }
        }

        @NotNull
        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.HOVERED;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }

        private class ContextMenu {
            private final List<ActionButton> buttons;
            private final int x;
            private final int y;

            public ContextMenu(int x, int y, List<ActionButton> buttons) {
                this.buttons = buttons;
                this.x = x;
                this.y = y;
                for (int i = 0; i < buttons.size(); ++i) {
                    buttons.get(i).m_264152_(x, y + i * 20);
                }
            }

            public void clickContextMenuButton(double x, double y) {
                for (ActionButton button : this.buttons) {
                    if (!button.m_5953_(x, y)) continue;
                    button.m_5691_();
                    break;
                }
            }

            public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.m_280163_(WIDGETS_TEXTURE, this.x, this.y, 0.0f, 0.0f, 80, this.buttons.size() * 21, 80, this.buttons.size() * 21);
                this.buttons.forEach(btn -> btn.m_88315_(guiGraphics, mouseX, mouseY, partialTick));
            }

            public boolean isMouseOver(double mouseX, double mouseY) {
                return mouseX >= (double)this.x && mouseX <= (double)(this.x + 100) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.buttons.size() * 22);
            }
        }

        record TooltipToRender(Font font, ItemStack itemStack, int x, int y) {
        }

        public static class ActionButton
        extends Button {
            public ActionButton(String text, Button.OnPress onPress) {
                super(ActionButton.m_253074_((Component)Component.m_237115_((String)text), (Button.OnPress)onPress).m_253046_(80, 20).m_252778_(supplier -> Component.m_237119_()));
            }

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                if (this.m_198029_()) {
                    guiGraphics.m_280163_(SIMPLE_BUTTON_TEXTURE_OVER, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
                } else {
                    guiGraphics.m_280163_(SIMPLE_BUTTON_TEXTURE, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
                }
                guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, 0xFFFFFF);
            }
        }
    }

    private class TabButton
    extends Button {
        private float expandProgress;
        private final int baseX;

        public TabButton(int rightX, int y, int width, int height, Component message, Button.OnPress onPress) {
            super(rightX - 20, y, 20, height, message, onPress, f_252438_);
            this.expandProgress = 0.0f;
            this.baseX = rightX;
        }

        void setExpandProgress(float progress) {
            this.expandProgress = progress;
            this.m_93674_((int)Mth.m_14179_((float)progress, (float)20.0f, (float)80.0f));
            this.m_252865_(this.baseX - this.m_5711_());
        }

        public int getColor() {
            if (this.expandProgress > 0.0f) {
                return Color.lightGray.getRGB();
            }
            if (RefreshMenuScreenPlus.this.currentPage == this.getIndex() + 1) {
                return Color.gray.getRGB();
            }
            return Color.DARK_GRAY.getRGB();
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.f_93619_, this.getColor());
            int textWidth = RefreshMenuScreenPlus.this.f_96547_.m_92852_((FormattedText)this.m_6035_());
            float textAlpha = Mth.m_14036_((float)(this.expandProgress * 3.0f), (float)0.0f, (float)1.0f);
            int textX = this.m_252754_() + (this.m_5711_() - textWidth) / 2;
            int textY = this.m_252907_() + (this.f_93619_ - 8) / 2;
            guiGraphics.m_280614_(RefreshMenuScreenPlus.this.f_96547_, this.m_6035_(), textX, textY, 0xFFFFFF | (int)(textAlpha * 255.0f) << 24, false);
        }

        private int getIndex() {
            return (this.m_252907_() - (this.f_93619_ / 2 - RefreshMenuScreenPlus.this.pages.size() * 15)) / 30;
        }
    }

    private class RefreshWidget
    extends AbstractContainerEventHandler
    implements Renderable,
    NarratableEntry {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final ResourceLocation menuTexture;
        private final ExSlotButton itemButton;
        private final ExSlotButton refreshButton;
        private final ExSlotButton infoButton;
        private final ExSlotButton materialButton;

        public int findSlotMatchingItemS(ItemStack stack, Inventory inventory) {
            for (int i = 0; i < inventory.f_35974_.size(); ++i) {
                ItemStack itemStack = (ItemStack)inventory.f_35974_.get(i);
                if (itemStack == RefreshMenuScreenPlus.this.selectedRefreshItem || itemStack.m_41619_() || itemStack.m_41613_() != stack.m_41613_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack)) continue;
                return i;
            }
            return -1;
        }

        public int findSlotMatchingItemM(ItemStack stack, Inventory inventory) {
            for (int i = 0; i < inventory.f_35974_.size(); ++i) {
                ItemStack itemStack = (ItemStack)inventory.f_35974_.get(i);
                if (itemStack == RefreshMenuScreenPlus.this.selectedItemStack || itemStack.m_41619_() || itemStack.m_41613_() != stack.m_41613_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack)) continue;
                return i;
            }
            return -1;
        }

        public RefreshWidget(int x, int y, int w, int h, ResourceLocation menuTexture) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.menuTexture = menuTexture;
            int baseButtonSize = 16;
            int scaledSize = baseButtonSize * 4;
            this.itemButton = new ExSlotButton(x + 2, y + 2, scaledSize, scaledSize, WIDGETS_TEXTURE, WIDGETS_TEXTURE_2, scaledSize, scaledSize, 0, () -> {
                RefreshMenuScreenPlus.this.manageSlot = 0;
                RefreshMenuScreenPlus.this.itemListViewer.items = RefreshMenuScreenPlus.filterItems((List<ItemStack>)RefreshMenuScreenPlus.this.getMinecraft().f_91074_.m_150109_().f_35974_);
            }){

                public void m_88315_(GuiGraphics gg, int p_93658_, int p_93659_, float p_93660_) {
                    ItemStack selectedItemStack1;
                    if (this.f_93622_ && !(selectedItemStack1 = RefreshMenuScreenPlus.this.selectedItemStack).m_41619_()) {
                        RefreshMenuScreenPlus.this.toRenderTooltipList.add(new ToRenderTooltip(() -> {
                            gg.m_280168_().m_85836_();
                            gg.m_280168_().m_252880_(0.0f, 0.0f, 2100.0f);
                            gg.m_280153_(RefreshMenuScreenPlus.this.f_96547_, selectedItemStack1, p_93658_, p_93659_);
                            gg.m_280168_().m_85849_();
                        }));
                    }
                    super.m_88315_(gg, p_93658_, p_93659_, p_93660_);
                }
            };
            int baseButtonSize2Y = 24;
            int baseButtonSize2X = (w - 45) / 2;
            this.refreshButton = new ExSlotButton(x + 20, y + h - baseButtonSize2Y - 16, baseButtonSize2X, baseButtonSize2Y, WIDGETS_TEXTURE_W, WIDGETS_TEXTURE_W2, baseButtonSize2X, baseButtonSize2Y, -1, () -> {
                if (RefreshMenuScreenPlus.this.currentPage == 0) {
                    RefreshItemMessage msg = new RefreshItemMessage(this.findSlotMatchingItemM(RefreshMenuScreenPlus.this.selectedRefreshItem, RefreshMenuScreenPlus.this.player.m_150109_()), this.findSlotMatchingItemS(RefreshMenuScreenPlus.this.selectedItemStack, RefreshMenuScreenPlus.this.player.m_150109_()));
                    Exmodifier.PACKET_HANDLER.sendToServer((Object)msg);
                } else if (RefreshMenuScreenPlus.this.currentPage == 1) {
                    RefineItemMessage msg = new RefineItemMessage(this.findSlotMatchingItemM(RefreshMenuScreenPlus.this.selectedRefreshItem, RefreshMenuScreenPlus.this.player.m_150109_()), this.findSlotMatchingItemS(RefreshMenuScreenPlus.this.selectedItemStack, RefreshMenuScreenPlus.this.player.m_150109_()));
                    Exmodifier.PACKET_HANDLER.sendToServer((Object)msg);
                }
            }).setComponent((Component)(RefreshMenuScreenPlus.this.currentPage == 1 ? Component.m_237115_((String)"gui.exmodifier.refresh_2") : Component.m_237115_((String)"gui.exmodifier.refresh_0")));
            this.infoButton = new ExSlotButton(x + 20 + baseButtonSize2X + 5, y + h - baseButtonSize2Y - 16, baseButtonSize2X, baseButtonSize2Y, WIDGETS_TEXTURE_W, WIDGETS_TEXTURE_W2, baseButtonSize2X, baseButtonSize2Y, -1, () -> {}).setComponent((Component)(RefreshMenuScreenPlus.this.currentPage == 1 ? Component.m_237115_((String)"gui.exmodifier.refresh_3") : Component.m_237115_((String)"gui.exmodifier.refresh_1")));
            int materialBtnWidth = this.width - 40;
            int materialBtnHeight = 40;
            this.materialButton = new ExSlotButton(x + 20, y + scaledSize + 24, materialBtnWidth, materialBtnHeight, WIDGETS_TEXTURE_W, WIDGETS_TEXTURE_W2, materialBtnWidth, materialBtnHeight, 1, () -> {
                RefreshMenuScreenPlus.this.manageSlot = 1;
                if (RefreshMenuScreenPlus.this.currentPage == 0) {
                    RefreshMenuScreenPlus.this.itemListViewer.items = RefreshMenuScreenPlus.this.filterItems2((List<ItemStack>)RefreshMenuScreenPlus.this.getMinecraft().f_91074_.m_150109_().f_35974_);
                } else if (RefreshMenuScreenPlus.this.currentPage == 1) {
                    RefreshMenuScreenPlus.this.itemListViewer.items = RefreshMenuScreenPlus.this.filterItems3((List<ItemStack>)RefreshMenuScreenPlus.this.getMinecraft().f_91074_.m_150109_().f_35974_);
                }
            });
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280163_(this.menuTexture, this.x, this.y, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            this.itemButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.materialButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.refreshButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.infoButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.renderSelectedItem(guiGraphics);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(-5.0f, 0.0f, 0.0f);
            this.renderMaterialSlot(guiGraphics);
            guiGraphics.m_280168_().m_85849_();
        }

        private void renderSelectedItem(GuiGraphics guiGraphics) {
            if (!RefreshMenuScreenPlus.this.selectedItemStack.m_41619_()) {
                guiGraphics.m_280168_().m_85836_();
                try {
                    guiGraphics.m_280168_().m_252880_(2.0f, 2.0f, 2.0f);
                    guiGraphics.m_280168_().m_85841_(4.0f, 4.0f, 0.0f);
                    guiGraphics.m_280480_(RefreshMenuScreenPlus.this.selectedItemStack, this.x / 4, this.y / 4);
                    guiGraphics.m_280370_(RefreshMenuScreenPlus.this.f_96547_, RefreshMenuScreenPlus.this.selectedItemStack, this.x / 4, this.y / 4);
                }
                finally {
                    guiGraphics.m_280168_().m_85849_();
                }
            }
            this.renderItemLabel(guiGraphics, RefreshMenuScreenPlus.this.selectedItemStack);
        }

        private void renderItemLabel(GuiGraphics guiGraphics, ItemStack stack) {
            Component refineTooltip;
            MutableComponent text = stack.m_41619_() ? Component.m_237115_((String)"gui.exmodifier.refresh_empty") : stack.m_41786_();
            int maxWidth = (int)((double)(this.width - 64 - 12) / 1.75);
            FormattedText trimmed = RefreshMenuScreenPlus.this.f_96547_.m_92854_((FormattedText)text, maxWidth);
            MutableComponent displayText = Component.m_237113_((String)trimmed.getString()).m_130948_(text.m_7383_());
            if (RefreshMenuScreenPlus.this.f_96547_.m_92852_((FormattedText)text) > maxWidth) {
                displayText = Component.m_237119_().m_7220_((Component)displayText).m_7220_((Component)Component.m_237113_((String)"...").m_130948_(Style.f_131099_));
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(1.75f, 1.75f, 0.0f);
            guiGraphics.m_280614_(RefreshMenuScreenPlus.this.f_96547_, (Component)displayText, (int)((double)(this.x + 64 + 10) / 1.75), (int)((double)(this.y + 2) / 1.75), 0xFFFFFF, false);
            guiGraphics.m_280168_().m_85849_();
            if (RefreshMenuScreenPlus.this.currentPage == 1 && !RefreshMenuScreenPlus.this.selectedItemStack.m_41619_() && (refineTooltip = RefineHelper.of(RefreshMenuScreenPlus.this.selectedItemStack).getRefineTooltip(true)) != null) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 15.0f, 0.0f);
                guiGraphics.m_280168_().m_85841_(1.5f, 1.5f, 0.0f);
                guiGraphics.m_280614_(RefreshMenuScreenPlus.this.f_96547_, refineTooltip, (int)((double)(this.x + 64 + 10) / 1.5), (int)((double)(this.y + 2) / 1.5), Color.YELLOW.getRGB(), false);
                guiGraphics.m_280168_().m_85849_();
            }
        }

        private void renderMaterialSlot(GuiGraphics guiGraphics) {
            if (RefreshMenuScreenPlus.this.selectedRefreshItem.m_41619_()) {
                MutableComponent text = Component.m_237115_((String)("gui.exmodifier.refresh.select_" + (RefreshMenuScreenPlus.this.manageSlot == 1 ? 0 : 1) + RefreshMenuScreenPlus.this.currentPage));
                int textWidth = RefreshMenuScreenPlus.this.f_96547_.m_92852_((FormattedText)text);
                int centerX = this.materialButton.m_252754_() + (this.materialButton.m_5711_() - textWidth) / 2 + 6;
                int centerY = this.materialButton.m_252907_() + (this.materialButton.m_93694_() - 8) / 2;
                guiGraphics.m_280430_(RefreshMenuScreenPlus.this.f_96547_, (Component)text, centerX, centerY, 0xFFFFFF);
            } else {
                this.renderItemInSlot(guiGraphics, RefreshMenuScreenPlus.this.selectedRefreshItem, this.materialButton.m_252754_(), this.materialButton.m_252907_(), this.materialButton.m_5711_(), this.materialButton.m_93694_());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renderItemInSlot(GuiGraphics guiGraphics, ItemStack stack, int x, int y, int width, int height) {
            guiGraphics.m_280168_().m_85836_();
            try {
                float scale = 1.5f;
                guiGraphics.m_280168_().m_85841_(scale, scale, 0.0f);
                int itemX = (int)((float)(x + (width - 16) / 2) / scale);
                int itemY = (int)((float)(y + (height - 16) / 2) / scale);
                guiGraphics.m_280163_(SLOT_ICON_1, itemX - 2, itemY - 2, 0.0f, 0.0f, 20, 20, 20, 20);
                guiGraphics.m_280480_(stack, itemX, itemY);
                int count = stack.m_41613_();
                if (count != 1) {
                    Optional<WashingMaterials> first = ModifierHandle.materialsList.stream().filter(m -> m.ItemId.equals(ExUtil.getItemID(stack))).findFirst();
                    boolean present = first.isPresent();
                    int needCount = present ? first.get().NeedCount : 1;
                    Object s = "";
                    s = needCount > count ? "\u00a74" + count + "/" + needCount : "\u00a7a" + count + "/" + needCount;
                    guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
                    guiGraphics.m_280056_(RefreshMenuScreenPlus.this.f_96547_, (String)s, itemX + 19 - 2 - RefreshMenuScreenPlus.this.f_96547_.m_92895_((String)s), itemY + 6 + 3, 0xFFFFFF, true);
                }
                this.renderItemDecorationsWithoutCount(guiGraphics, RefreshMenuScreenPlus.this.f_96547_, RefreshMenuScreenPlus.this.selectedRefreshItem, this.materialButton.m_252754_(), this.materialButton.m_252907_());
            }
            finally {
                guiGraphics.m_280168_().m_85849_();
            }
        }

        public void renderItemDecorationsWithoutCount(GuiGraphics guiGraphics, Font p_282005_, ItemStack p_283349_, int p_282641_, int p_282146_) {
            if (!p_283349_.m_41619_()) {
                float f;
                guiGraphics.m_280168_().m_85836_();
                if (p_283349_.m_150947_()) {
                    int l = p_283349_.m_150948_();
                    int i = p_283349_.m_150949_();
                    int j = p_282641_ + 2;
                    int k = p_282146_ + 13;
                    guiGraphics.m_285944_(RenderType.m_286086_(), j, k, j + 13, k + 2, -16777216);
                    guiGraphics.m_285944_(RenderType.m_286086_(), j, k, j + l, k + 1, i | 0xFF000000);
                }
                Minecraft minecraft1 = RefreshMenuScreenPlus.this.f_96541_;
                LocalPlayer localplayer = minecraft1.f_91074_;
                float f2 = f = localplayer == null ? 0.0f : localplayer.m_36335_().m_41521_(p_283349_.m_41720_(), minecraft1.m_91296_());
                if (f > 0.0f) {
                    int i1 = p_282146_ + Mth.m_14143_((float)(16.0f * (1.0f - f)));
                    int j1 = i1 + Mth.m_14167_((float)(16.0f * f));
                    guiGraphics.m_285944_(RenderType.m_286086_(), p_282641_, i1, p_282641_ + 16, j1, Integer.MAX_VALUE);
                }
                guiGraphics.m_280168_().m_85849_();
                ItemDecoratorHandler.of((ItemStack)p_283349_).render(guiGraphics, p_282005_, p_283349_, p_282641_, p_282146_);
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.itemButton, this.materialButton, this.refreshButton, this.infoButton);
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.HOVERED;
        }

        public void m_142291_(NarrationElementOutput output) {
            output.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237115_((String)"gui.exmodifier.refresh.widget"));
        }
    }

    public record ToRenderTooltip(Runnable runnable) {
    }

    public class InfoWidget
    extends AbstractContainerEventHandler
    implements Renderable,
    NarratableEntry {
        private List<Component> textList;
        private int width;
        private int height;
        private int x;
        private int y;
        private ResourceLocation resourceLocation;
        private boolean isShowed = false;
        private ItemListViewer.ActionButton enterButton;

        public InfoWidget(int width, int height, int x, int y, ResourceLocation resourceLocation) {
            this.width = width;
            this.height = height;
            this.x = x;
            this.y = y;
            this.resourceLocation = resourceLocation;
            this.enterButton = new ItemListViewer.ActionButton("gui.exmodifier.refresh_menu.enter", b -> {
                if (this.isShowed) {
                    this.isShowed = false;
                }
            });
        }

        public void m_88315_(GuiGraphics gg, int mx, int my, float pts) {
            if (this.isShowed) {
                gg.m_280163_(this.resourceLocation, this.x, this.y, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.enterButton);
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }

    private class ExSlotButton
    extends AbstractButton {
        private final ResourceLocation normalTexture;
        private final ResourceLocation pressTexture;
        private final int textureWidth;
        private final int textureHeight;
        private final int slotIndex;
        private final Runnable onPress;

        public ExSlotButton(int x, int y, int width, int height, ResourceLocation normalTexture, ResourceLocation pressTexture, int textureWidth, int textureHeight, int slotIndex, Runnable onPress) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.normalTexture = normalTexture;
            this.pressTexture = pressTexture;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.slotIndex = slotIndex;
            this.onPress = onPress;
        }

        private ExSlotButton setComponent(Component component) {
            this.m_93666_(component);
            return this;
        }

        public void m_5691_() {
            this.onPress.run();
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280163_(RefreshMenuScreenPlus.this.manageSlot == this.slotIndex ? this.pressTexture : this.normalTexture, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.textureWidth, this.textureHeight);
            int textX = this.m_252754_() + (this.f_93618_ - RefreshMenuScreenPlus.this.f_96547_.m_92852_((FormattedText)this.m_6035_())) / 2;
            int textY = this.m_252907_() + (this.f_93619_ - 8) / 2;
            guiGraphics.m_280430_(RefreshMenuScreenPlus.this.f_96547_, this.m_6035_(), textX, textY, 0xFFFFFF);
            if (this.m_274382_()) {
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 0x20FFFFFF);
            }
        }

        protected void m_168797_(NarrationElementOutput output) {
            output.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237115_((String)("narration.exmodifier.button.slot_" + this.slotIndex)));
        }
    }
}

