/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.quality;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.exmo.exmodifier.Exmodifier;
import net.exmo.exmodifier.content.helper.ItemQualityHelper;
import net.exmo.exmodifier.content.modifier.MoConfig;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.modifier.ModifierHandle;
import net.exmo.exmodifier.content.quality.ItemQuality;
import net.exmo.exmodifier.content.type.ExType;
import net.exmo.exmodifier.content.type.ExTypeHandle;
import net.exmo.exmodifier.content.type.ItemType;
import net.exmo.exmodifier.util.ExConfigHandle;
import net.exmo.exmodifier.util.ItemSelector;
import net.exmo.exmodifier.util.WeightedUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemQualityHandle {
    public static Map<String, ItemQuality> itemQualityMap = new HashMap<String, ItemQuality>();
    public static Map<ItemSelector, ItemQuality> itemDefaultQualityMap = new HashMap<ItemSelector, ItemQuality>();
    public static final Path ItemsQualityConfigPath = FMLPaths.CONFIGDIR.get().resolve("exmo/quality/");
    public static final Path ItemsDefaultQualityConfigPath = FMLPaths.CONFIGDIR.get().resolve("exmo/defaultQuality/");
    public static List<MoConfig> FoundQualityConfigs = new ArrayList<MoConfig>();
    public static List<MoConfig> FoundDefaultQualityConfigs = new ArrayList<MoConfig>();

    public static void register(String id, ItemQuality itemQuality) {
        itemQualityMap.put(id, itemQuality);
        Exmodifier.LOGGER.debug("Register ItemQuality: " + id);
    }

    public static List<ItemSelector> getItemSelector(ItemStack stack) {
        return itemDefaultQualityMap.keySet().stream().filter(entry -> entry.compare(stack)).toList();
    }

    public static void init() throws IOException {
        if (Files.exists(ItemsQualityConfigPath, new LinkOption[0])) {
            long startTime = System.nanoTime();
            FoundQualityConfigs = ExConfigHandle.listFiles(ItemsQualityConfigPath);
            for (MoConfig moconfig : FoundQualityConfigs) {
                ItemQualityHandle.processMoConfigEntries(moconfig);
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            Exmodifier.LOGGER.debug("ReadConfig Quality Over time: " + duration / 1000000L + " ms");
        }
    }

    public static void init2() throws IOException {
        if (Files.exists(ItemsDefaultQualityConfigPath, new LinkOption[0])) {
            long startTime = System.nanoTime();
            FoundDefaultQualityConfigs = ExConfigHandle.listFiles(ItemsDefaultQualityConfigPath);
            for (MoConfig moconfig : FoundDefaultQualityConfigs) {
                ItemQualityHandle.processMoConfigEntries2(moconfig);
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            Exmodifier.LOGGER.debug("ReadConfig DefaultQuality Over time: " + duration / 1000000L + " ms");
        }
    }

    public static void processMoConfigEntries(MoConfig moconfig) throws FileNotFoundException {
        if (moconfig.readEntrys().isEmpty()) {
            Exmodifier.LOGGER.info("No Quality Config Found :" + String.valueOf(moconfig.configFile));
            return;
        }
        for (Map.Entry<String, JsonElement> entry : moconfig.readEntrys()) {
            ItemQualityHandle.processItemsQualityConfigEntry(entry);
        }
    }

    public static void processMoConfigEntries2(MoConfig moconfig) throws FileNotFoundException {
        if (moconfig.readEntrys().isEmpty()) {
            Exmodifier.LOGGER.info("No Default Quality Config Found :" + String.valueOf(moconfig.configFile));
            return;
        }
        for (Map.Entry<String, JsonElement> entry : moconfig.readEntrys()) {
            ItemQualityHandle.processItemsDefaultQualityConfigEntry(entry);
        }
    }

    public static void contaiff(ItemStack stack, int rarity, int refreshnumber, ItemType type2) {
        Exmodifier.LOGGER.debug("itemQualityRefresh: " + stack.m_41778_() + " " + String.valueOf(type2));
        WeightedUtil<String> weightedUtil = new WeightedUtil<String>(itemQualityMap.entrySet().stream().filter(e -> ((ItemQuality)e.getValue()).type == type2).filter(e -> ((ItemQuality)e.getValue()).getOnlyItemIds().isEmpty() || ((ItemQuality)e.getValue()).getOnlyItemIds().contains(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString())).filter(e -> ((ItemQuality)e.getValue()).getOnlyItemTags().isEmpty() || ((ItemQuality)e.getValue()).containTag(stack)).filter(e -> ((ItemQuality)e.getValue()).getOnlyWashItems().isEmpty() || ((ItemQuality)e.getValue()).getOnlyWashItems().contains(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString())).collect(Collectors.toMap(Map.Entry::getKey, e -> Float.valueOf(((ItemQuality)e.getValue()).getWeight()))));
        if (!weightedUtil.weights.isEmpty()) {
            Exmodifier.LOGGER.debug("RandomLevelEntry: " + String.valueOf(type2));
            weightedUtil.increaseWeightsByRarity(rarity);
            ItemQualityHandle.itemQualityRefresh2(stack, weightedUtil, refreshnumber);
            Exmodifier.LOGGER.debug("RandomLevel: " + String.valueOf(type2) + " " + stack.m_41778_());
        }
    }

    public static void itemQualityRefresh2(ItemStack stack, WeightedUtil<String> weightedUtil, int refreshnumber) {
        int numAddedModifiers = 0;
        ArrayList<ItemQuality> foundItemLevels = new ArrayList<ItemQuality>();
        if (weightedUtil.weights.size() < refreshnumber) {
            refreshnumber = weightedUtil.weights.size();
        }
        while (numAddedModifiers < refreshnumber) {
            ItemQuality itemQuality = itemQualityMap.get(weightedUtil.selectRandomKeyBasedOnWeights());
            if (foundItemLevels.contains(itemQuality)) continue;
            Exmodifier.LOGGER.debug("add QualityEntry: " + itemQuality.Id);
            foundItemLevels.add(itemQuality);
            ItemQualityHelper.of(stack).addQualityEntry(itemQuality, true, true);
            ++numAddedModifiers;
        }
    }

    public static void ItemQualityRefresh(ItemStack stack, int rarity, int refreshnumber, String washItem) {
        if (stack.m_41783_() == null) {
            return;
        }
        ItemQualityHelper.of(stack);
        if (ItemQualityHelper.of(stack).getQualityEntriesSize() > 0) {
            return;
        }
        boolean find = false;
        for (ItemType a : ExTypeHandle.itemTypes.values().stream().filter(e -> e != ExType.UNKNOWN.get()).filter(e -> e != ExType.ALL.get()).toList()) {
            if (!ModifierEntry.containItemType(stack, a)) continue;
            ItemQualityHandle.contaiff(stack, rarity, refreshnumber, a);
            find = true;
            break;
        }
        if (!find) {
            ItemQualityHandle.contaiff(stack, rarity, refreshnumber, ExType.ALL.get());
            Exmodifier.LOGGER.debug("ItemQualityRefresh: No Type And refresh ALL TYPE");
        }
    }

    private static void processItemsQualityConfigEntry(Map.Entry<String, JsonElement> entry) {
        if (!entry.getValue().isJsonObject()) {
            return;
        }
        try {
            JsonObject jsonObject = entry.getValue().getAsJsonObject();
            int rarity = jsonObject.has("rarity") ? jsonObject.get("rarity").getAsInt() : 0;
            int maxRefine = jsonObject.has("maxRefine") ? jsonObject.get("maxRefine").getAsInt() : 0;
            float growValue = jsonObject.has("growValue") ? jsonObject.get("growValue").getAsFloat() : 0.0f;
            float addRefreshValue = jsonObject.has("addRefreshValue") ? jsonObject.get("addRefreshValue").getAsFloat() : 0.0f;
            String id = entry.getKey();
            String LocalDescription = jsonObject.has("LocalDescription") ? jsonObject.get("LocalDescription").getAsString() : "";
            ArrayList<String> items = new ArrayList<String>();
            ArrayList<ModifierEntry> modifierEntries = new ArrayList<ModifierEntry>();
            ArrayList<String> materials = new ArrayList<String>();
            if (jsonObject.has("items")) {
                for (JsonElement item : jsonObject.get("items").getAsJsonArray()) {
                    items.add(item.getAsString());
                }
            }
            if (jsonObject.has("materials")) {
                for (JsonElement material : jsonObject.get("materials").getAsJsonArray()) {
                    materials.add(material.getAsString());
                }
            }
            if (jsonObject.has("ModifierEntries")) {
                for (JsonElement modifier : jsonObject.get("ModifierEntries").getAsJsonArray()) {
                    modifierEntries.add(ModifierHandle.modifierEntryMap.get(modifier.getAsString()));
                }
            }
            ItemQuality itemQuality = new ItemQuality(rarity, id);
            itemQuality.items = items;
            itemQuality.entries = modifierEntries;
            itemQuality.growValue = growValue;
            itemQuality.addRefreshValue = addRefreshValue;
            itemQuality.Max_Refine = maxRefine;
            itemQuality.setShowInHeadTooltip(jsonObject.has("showInHeadTooltip") && jsonObject.get("showInHeadTooltip").getAsBoolean());
            itemQuality.ShowModifierComponent = !jsonObject.has("ShowModifierComponent") || jsonObject.get("ShowModifierComponent").getAsBoolean();
            itemQuality.refineNeedSameStar = !jsonObject.has("refineNeedSameStar") || jsonObject.get("refineNeedSameStar").getAsBoolean();
            itemQuality.cantRemoveEntry = jsonObject.has("cantRemoveEntry") && jsonObject.get("cantRemoveEntry").getAsBoolean();
            itemQuality.LocalDescription = LocalDescription;
            itemQuality.autoRefresh = jsonObject.has("autoRefresh") && jsonObject.get("autoRefresh").getAsBoolean();
            itemQuality.isRandom = !jsonObject.has("isRandom") || jsonObject.get("isRandom").getAsBoolean();
            itemQuality.materials = materials;
            ItemQualityHandle.register(id, itemQuality);
            Exmodifier.LOGGER.debug("Add ItemsQuality: " + id);
        }
        catch (Exception e) {
            Exmodifier.LOGGER.error("Error reading ItemsDefaultEntry config file", e);
        }
    }

    private static void processItemsDefaultQualityConfigEntry(Map.Entry<String, JsonElement> entry) {
        if (!entry.getValue().isJsonObject()) {
            return;
        }
        try {
            JsonObject jsonObject = entry.getValue().getAsJsonObject();
            ItemQuality itemQuality = itemQualityMap.get(entry.getKey());
            if (jsonObject.has("id")) {
                itemQuality = itemQualityMap.get(jsonObject.get("id").getAsString());
            }
            ItemSelector itemSelector = null;
            if (jsonObject.has("itemSelector")) {
                itemSelector = ItemSelector.EX_SERIALIZE.fromJsonSingle(jsonObject.get("itemSelector").getAsJsonObject());
            }
            if (itemSelector != null) {
                itemDefaultQualityMap.put(itemSelector, itemQuality);
            }
            Exmodifier.LOGGER.debug("Add ItemsDefaultQuality: " + itemQuality.Id);
        }
        catch (Exception e) {
            Exmodifier.LOGGER.error("Error reading ItemsDefaultEntry config file", e);
        }
    }

    public static class CommonEvent {
    }
}

