/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.exmodifier.content.refine;

import java.text.DecimalFormat;
import java.util.List;
import net.exmo.exmodifier.Config;
import net.exmo.exmodifier.content.helper.ExHelper;
import net.exmo.exmodifier.content.helper.ItemQualityHelper;
import net.exmo.exmodifier.content.modifier.ModifierEntry;
import net.exmo.exmodifier.content.quality.ItemQuality;
import net.exmo.exmodifier.content.type.ItemType;
import net.exmo.exmodifier.events.ExCanRefineEvent;
import net.exmo.exmodifier.events.ExRefineMaxCountEvent;
import net.exmo.exmodifier.util.ExAttributeModifier;
import net.exmo.exmodifier.util.ItemAttrUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class RefineHelper
extends ExHelper {
    public RefineHelper(ItemStack itemStack) {
        super(itemStack);
    }

    public static RefineHelper of(ItemStack item) {
        return new RefineHelper(item);
    }

    public boolean validKey() {
        return this.ValidMainNbt() && this.getMainNbt().m_128441_("refine");
    }

    public int getRefineLevel() {
        if (this.validKey()) {
            return this.getMainNbt().m_128451_("refine");
        }
        return 0;
    }

    public int getRefineMaxLevel() {
        ItemQualityHelper itemQualityHelper = new ItemQualityHelper(this.itemStack);
        int maxCount = Config.max_refine;
        if (!itemQualityHelper.getQualityEntries().isEmpty()) {
            for (ItemQuality itemQuality : itemQualityHelper.getQualityEntries()) {
                if (itemQuality == null) continue;
                maxCount = Math.max(maxCount, itemQuality.Max_Refine);
            }
        }
        ExRefineMaxCountEvent exRefineMaxCountEvent = new ExRefineMaxCountEvent(maxCount, this.itemStack, this, itemQualityHelper);
        MinecraftForge.EVENT_BUS.post((Event)exRefineMaxCountEvent);
        return exRefineMaxCountEvent.getMaxCount();
    }

    public boolean canRefine(ItemStack stack) {
        boolean canRefine = stack.m_41720_() == this.itemStack.m_41720_();
        ExCanRefineEvent exCanRefineEvent = new ExCanRefineEvent(this.itemStack, stack, canRefine, this);
        MinecraftForge.EVENT_BUS.post((Event)exCanRefineEvent);
        List<ItemQuality> qualityEntries = ItemQualityHelper.of(stack).getQualityEntries();
        if ((!qualityEntries.isEmpty() && qualityEntries.stream().anyMatch(itemQuality -> itemQuality.refineNeedSameStar) || Config.refine_system) && Config.refine_need_same_star && RefineHelper.of(stack).getRefineLevel() != this.getRefineLevel()) {
            exCanRefineEvent.canRefine = false;
        }
        return exCanRefineEvent.canRefine && this.getRefineLevel() < this.getRefineMaxLevel();
    }

    public ExAttributeModifier getRefineModifier(int add) {
        ItemQualityHelper itemQualityHelper = new ItemQualityHelper(this.itemStack);
        float amount = itemQualityHelper.getQualityEntries().stream().map(e -> Float.valueOf(e.growValue)).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
        return new ExAttributeModifier("exmodifier_refine", amount == 0.0f ? Config.refine_effect * (double)add : (double)amount, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    public RefineHelper addRefine(boolean addAttribute, int add) {
        if (this.ValidMainNbt()) {
            int refine = this.getMainNbt().m_128451_("refine");
            EquipmentSlot[][] equipmentSlotArray = (EquipmentSlot[][])ModifierEntry.getType(this.itemStack).stream().map(ItemType::equipmentSlot).toArray(x$0 -> new EquipmentSlot[x$0][]);
            int n = equipmentSlotArray.length;
            for (int i = 0; i < n; ++i) {
                EquipmentSlot[] slot;
                for (EquipmentSlot slot1 : slot = equipmentSlotArray[i]) {
                    Attribute attribute = RefineHelper.getAttribute();
                    ItemAttrUtil.removeAttributeModifierNoAmout(this.itemStack, attribute, this.getRefineModifier(0), slot1);
                    if (add <= 0) continue;
                    ItemAttrUtil.addItemAttributeModifier2(this.itemStack, attribute, this.getRefineModifier(add + refine), slot1);
                }
            }
            this.getMainNbt().m_128405_("refine", refine + add);
        }
        return this;
    }

    private static Attribute getAttribute() {
        return (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)Config.refine_attribute));
    }

    public RefineHelper removeRefine(boolean removeAttribute, int remove) {
        if (this.validKey()) {
            int refine = this.getMainNbt().m_128451_("refine");
            EquipmentSlot[] equipmentSlot = this.getEquipmentSlot(this.itemStack);
            int add = refine - remove;
            for (EquipmentSlot slot : equipmentSlot) {
                ItemAttrUtil.removeAttributeModifierNoAmout(this.itemStack, RefineHelper.getAttribute(), this.getRefineModifier(remove), slot);
                if (add <= 0) continue;
                ItemAttrUtil.addItemAttributeModifier2(this.itemStack, RefineHelper.getAttribute(), this.getRefineModifier(add), slot);
            }
            this.getMainNbt().m_128405_("refine", add);
        }
        return this;
    }

    public RefineHelper setRefine(int refine) {
        if (this.ValidMainNbt()) {
            EquipmentSlot[] equipmentSlot;
            for (EquipmentSlot slot : equipmentSlot = this.getEquipmentSlot(this.itemStack)) {
                ItemAttrUtil.removeAttributeModifierNoAmout(this.itemStack, RefineHelper.getAttribute(), this.getRefineModifier(0), slot);
            }
            if (refine > 0) {
                for (EquipmentSlot slot : equipmentSlot) {
                    ItemAttrUtil.addItemAttributeModifier2(this.itemStack, RefineHelper.getAttribute(), this.getRefineModifier(refine), slot);
                }
            }
            this.getMainNbt().m_128405_("refine", refine);
        }
        return this;
    }

    public Component getRefineTooltip(boolean forceDisplay) {
        if (this.validKey()) {
            int i;
            int refine = this.getMainNbt().m_128451_("refine");
            if (this.getRefineMaxLevel() > 10) {
                MutableComponent mutableComponent = Component.m_237115_((String)"exmodifier.refine.tooltip.star.on").m_7220_((Component)Component.m_237113_((String)("X" + this.getRefineLevel()))).m_130940_(ChatFormatting.GOLD);
                mutableComponent.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"exmodifier.refine.tooltip.star.off").m_7220_((Component)Component.m_237113_((String)("X" + (this.getRefineMaxLevel() - this.getRefineLevel())))).m_130940_(ChatFormatting.GOLD));
                return mutableComponent;
            }
            int refineMaxLevel = this.getRefineMaxLevel();
            MutableComponent toReturn = Component.m_237119_();
            for (i = 0; i < refine; ++i) {
                toReturn.m_7220_((Component)Component.m_237115_((String)"exmodifier.refine.tooltip.star.on"));
            }
            for (i = refine; i < refineMaxLevel; ++i) {
                toReturn.m_7220_((Component)Component.m_237115_((String)"exmodifier.refine.tooltip.star.off"));
            }
            return toReturn.m_130940_(ChatFormatting.GOLD);
        }
        if (this.ValidMainNbt() && (Config.alaways_display_modifier_name_under_item_name || forceDisplay)) {
            if (this.getRefineMaxLevel() > 10) {
                return Component.m_237115_((String)"exmodifier.refine.tooltip.star.off").m_7220_((Component)Component.m_237113_((String)("X" + this.getRefineMaxLevel()))).m_130940_(ChatFormatting.GOLD);
            }
            MutableComponent toReturn = Component.m_237119_();
            for (int i = 0; i < this.getRefineMaxLevel(); ++i) {
                toReturn.m_7220_((Component)Component.m_237115_((String)"exmodifier.refine.tooltip.star.off"));
            }
            return toReturn.m_130940_(ChatFormatting.GOLD);
        }
        return null;
    }

    public Component getStarUpComponent() {
        if (this.getRefineLevel() > 0) {
            ExAttributeModifier exmodifierRefine1 = ItemAttrUtil.getAttributeModifierFromNamed("exmodifier_refine", this.itemStack);
            if (exmodifierRefine1 == null) {
                return null;
            }
            double exmodifierRefine = exmodifierRefine1.getAmount() * 100.0;
            DecimalFormat df = new DecimalFormat("0.###");
            String formattedValue = df.format(exmodifierRefine);
            return Component.m_237115_((String)"exmodifier.refine.tooltip.star.up").m_7220_((Component)Component.m_237113_((String)(formattedValue + "%"))).m_7220_((Component)Component.m_237115_((String)RefineHelper.getAttribute().m_22087_())).m_130940_(ChatFormatting.YELLOW);
        }
        return null;
    }
}

